/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import kafka.restore.MessageEmitter;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaUnfreezeRequest;
import kafka.restore.messages.KafkaValidateLogRangeResponse;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;

public class ForceRestoreEventSentToPartitionRestoredTransition
extends AbstractTransition {
    public ForceRestoreEventSentToPartitionRestoredTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.FORCE_RESTORE_EVENT_SENT;
    }

    @Override
    public State getTargetState() {
        return State.PARTITION_RESTORED;
    }

    @Override
    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof KafkaValidateLogRangeResponse)) {
            return false;
        }
        KafkaValidateLogRangeResponse response = (KafkaValidateLogRangeResponse)event.getData("message_response");
        KafkaUnfreezeRequest request = new KafkaUnfreezeRequest(0, response.getTopic(), response.getPartition(), (NodeConfig)fsm.getMetadata("partition_leader"));
        LOGGER.debug(String.format("[%s-%d]: %s handled the event, %s in queue", response.getTopic(), response.getPartition(), this.getName(), request.name()));
        this.messageEmitter.submitRequest(request);
        return true;
    }
}

