/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.server.FetchConnectionsMode$;
import kafka.server.FetchConnectionsMode$Combined$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.TopicConfigSyncIncludeValidator$;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.ServerConfigs;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkConfig$ {
    public static final ClusterLinkConfig$ MODULE$ = new ClusterLinkConfig$();
    private static final String LinkModeProp = "link.mode";
    private static final String LinkModeDoc = new StringBuilder(121).append("Mode that indicates if this cluster is configured to be the source or destination of the cluster link.").append(" Valid values are ").append(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ClusterLinkConfig.LinkMode.values()), (Function1 & Serializable)x$14 -> x$14.name(), ClassTag$.MODULE$.apply(String.class))).append(".").toString();
    private static final String ConnectionModeProp = "connection.mode";
    private static final String ConnectionModeDoc = new StringBuilder(490).append("Connection mode that indicates if outbound connections are established by this cluster for").append(" the cluster link. Valid values are ").append(ConnectionMode$.MODULE$.values().map((Function1 & Serializable)x$15 -> ((ConnectionMode)x$15).name())).append(". By default, destination cluster creates").append(" outbound connections and source cluster accepts inbound connections. Connection and security configuration should be").append(" provided for the cluster that establishes outbound connections. Security configuration to establish local connections").append(" should also be provided with prefix 'local.' for source clusters with connection mode ").append(ConnectionMode$Outbound$.MODULE$.name()).append(".").toString();
    private static final String LocalPrefix = "local.";
    private static final String LocalListenerNameProp = "local.listener.name";
    private static final String LocalListenerNameDoc = new StringBuilder(383).append("Name of the local listener on the source cluster used for local cluster link connection requests.").append(" Cluster link connections are added to this listener if '").append(MODULE$.LinkModeProp()).append("=").append(ClusterLinkConfig.LinkMode.SOURCE.name()).append("' and '").append(MODULE$.ConnectionModeProp()).append("=").append(ConnectionMode$Outbound$.MODULE$.name()).append("'.").append(" Security configuration options for creating local connections on this listener should be configured with the prefix '").append(MODULE$.LocalPrefix()).append("'.").append(" By default, the listener on which the source link was created will be used as the local listener.").toString();
    private static final String ReverseConnectionSetupTimeoutMsProp = "reverse.connection.setup.timeout.ms";
    private static final String ReverseConnectionSetupTimeoutMsDoc = "Timeout in milliseconds to wait for response of reverse connection requests for source initiated links. This limits the amount of time before a retry when brokers fail or are restarted.";
    private static final String RemoteLinkConnectionModeProp = "remote.link.connection.mode";
    private static final String RemoteLinkConnectionModeDoc = "Connection mode used by the remote link of a bi-directional link";
    private static final String FetcherThreadPoolModeProp = "fetcher.thread.pool.mode";
    private static final String FetcherThreadPoolModeDoc = new StringBuilder(98).append(KafkaConfig$.MODULE$.ClusterLinkFetcherThreadPoolModeDoc()).append(" If the property is not configured at link level then the broker property `").append(KafkaConfig$.MODULE$.ClusterLinkFetcherThreadPoolModeProp()).append("` will be used instead.").toString();
    private static final String NumClusterLinkFetchersProp = "num.cluster.link.fetchers";
    private static final String NumClusterLinkFetchersDoc = new StringBuilder(315).append("Number of fetchers used to replicate messages from source brokers in cluster links.").append(" This is the maximum number of connections between each broker pair. If '").append(MODULE$.FetcherThreadPoolModeProp()).append("=").append(ClusterLinkConfig.FetcherThreadPoolMode.LINK).append("',").append(" this is the maximum number of fetcher threads for the link, if '").append(MODULE$.FetcherThreadPoolModeProp()).append("=").append(ClusterLinkConfig.FetcherThreadPoolMode.ENDPOINT).append("',").append(" this is the maximum number of fetcher threads for connections between each broker pair.").toString();
    private static final String RetryTimeoutMsProp = "cluster.link.retry.timeout.ms";
    private static final String RetryTimeoutMsDoc = "The number of milliseconds after which failures are no longer retried and partitions are marked as failed. If the source topic is deleted and recreated within this timeout, the link may contain records from the old as well as the new topic.";
    private static final String ClusterLinkPausedProp = "cluster.link.paused";
    private static final String ClusterLinkPausedDoc = "Whether all activity over the cluster link is paused.";
    private static final String ClusterLinkPrefixProp = "cluster.link.prefix";
    private static final String ClusterLinkPrefixDoc = "The prefix value that will be applied to the name of the resources created by the cluster link. Some examples are mirror topic name and consumer group id. Topics that begin with '_confluent' will not be mirrored.";
    private static final String ConsumerOffsetSyncEnableProp = "consumer.offset.sync.enable";
    private static final String ConsumerOffsetSyncEnableDoc = "Whether or not to migrate consumer offsets from the source cluster.";
    private static final String ConsumerGroupPrefixEnableProp = "consumer.group.prefix.enable";
    private static final String ConsumerGroupPrefixEnableDoc = "Whether to apply the cluster link prefix to consumer groups.";
    private static final String ConsumerOffsetSyncMsProp = "consumer.offset.sync.ms";
    private static final String ConsumerOffsetSyncMsDoc = "How often to sync consumer offsets.";
    private static final String ConsumerOffsetGroupFiltersProp = "consumer.offset.group.filters";
    private static final String ConsumerOffsetGroupFiltersDoc = "JSON to denote the list of consumer groups to be migrated.";
    private static final String AclSyncEnableProp = "acl.sync.enable";
    private static final String AclSyncEnableDoc = "Whether or not to migrate ACLs";
    private static final String AclFiltersProp = "acl.filters";
    private static final String AclFiltersDoc = "JSON to denote the list of ACLs to be migrated.";
    private static final String AclSyncMsProp = "acl.sync.ms";
    private static final String AclSyncMsDoc = "How often to refresh the ACLs.";
    private static final String TopicConfigSyncIncludeProp = "topic.config.sync.include";
    private static final String TopicConfigSyncIncludeDoc = "The list of topic configs to sync from the source topic.";
    private static final String TopicConfigSyncMsProp = "topic.config.sync.ms";
    private static final String TopicConfigSyncMsDoc = "How often to refresh the topic configs.";
    private static final String AutoMirroringEnableProp = "auto.create.mirror.topics.enable";
    private static final String AutoMirroringEnableDoc = "Whether or not to automatically create mirror topics";
    private static final String TopicFiltersProp = "auto.create.mirror.topics.filters";
    private static final String TopicFiltersDoc = "JSON to denote the list of source topics to automatically create mirror topics from";
    private static final String MirrorStartOffsetSpecProp = "mirror.start.offset.spec";
    private static final String MirrorStartOffsetSpecDoc = "Start offset spec that determines the offset from which mirroring starts for new topics. The value may be \"earliest\", \"latest\" or a timestamp in ISO8601 format \"YYYY-MM-DDTHH:mm:SS.sss\". By default, mirroring starts from the earliest available offset.";
    private static final String MaxMessageSizeProp = "max.message.size";
    private static final String MaxMessageSizeDoc = "The largest record batch size allowed by Kafka (after compression if compression is enabled). If this is increased and there are consumers older than 0.10.2, the consumers' fetch size must also be increased so that they can fetch record batches this large. In the latest message format version, records are always grouped into batches for efficiency. In previous message format versions, uncompressed records are not grouped into batches and this limit only applies to a single record in that case. The setting on the cluster link defines the largest record batch size that may be replicated from the source cluster. If larger records are found on a source partition, the mirror topic will be moved to failed state. Note that the maximum configured for the source topic is not applied during cluster link replication, but the setting is sync'ed to the mirror topic to ensure that the same config applies after failover. Default value is unlimited.";
    private static final String AvailabilityCheckMsProp = "availability.check.ms";
    private static final String AvailabilityCheckMsDoc = "How often to send a request to source cluster to check source cluster availability.";
    private static final String AvailabilityCheckConsecutiveFailureThresholdProp = "availability.check.consecutive.failure.threshold";
    private static final String AvailabilityCheckConsecutiveFailureThresholdDoc = "The upper-bound of the consecutive failures beyond which the availability checker will report the link as unavailable.";
    private static final String LinkFetcherFlowControlProp = "link.fetcher.flow.control";
    private static final String LinkFetcherFlowControlDoc = "The flow control approach used by cluster linking fetcher";
    private static final String LinkFetcherMaxLaggingPartitionsProp = "link.fetcher.max.lagging.partitions";
    private static final String LinkFetcherMaxLaggingPartitionsDoc = "Maximum number of lagging partitions. The limit is enforced periodically by the fetcher. If set to -1, the limit is not enforced.";
    private static final String LinkFetcherLaggingPartitionMsProp = "link.fetcher.lagging.partition.ms";
    private static final String LinkFetcherLaggingPartitionMsDoc = "When a partition last caught up time is more than this time, the partition is considered a lagging partition.";
    private static final String LinkFetcherEnforceMaxLaggingPartitionMsProp = "link.fetcher.enforce.max.lagging.partitions.ms";
    private static final String LinkFetcherEnforceMaxLaggingPartitionMsDoc = "The periodic interval where link fetcher will run periodic tasks like enforcing the limit on number of lagging partitions.";
    private static final String LinkFetcherDegradedPartitionMonitorMsProp = "link.fetcher.degraded.partition.monitor.ms";
    private static final String LinkFetcherDegradedPartitionMonitorMsDoc = "The periodic interval at which link fetcher verifies the status of degraded partitions.";
    private static final String ClientsMaxIdleMsProp = "clients.max.idle.ms";
    private static final String ClientsMaxIdleMsDoc = "The interval in milliseconds after which idle cluster link clients and associated threads are closed.";
    private static final String LinkFetcherAutoTuneEnableProp = "link.fetcher.auto.tune.num.fetchers.enable";
    private static final String LinkFetcherAutoTuneEnableDoc = "If true, enable auto tuning number of cluster link fetchers.";
    private static final String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp = "link.fetcher.auto.tune.decrease.throughput.threshold.bytes";
    private static final String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc = "If the cluster link throughput is below this value and there is no lagging partition, auto tuning will reduce the number of cluster link fetchers";
    private static final String LinkFetcherAutoTuneIncreaseThroughputPercentageProp = "link.fetcher.auto.tune.increase.throughput.percentage";
    private static final String LinkFetcherAutoTuneIncreaseThroughputPercentageDoc = "After increasing the number of cluster link fetchers, auto tuning expects the throughput to increase at least this percentage before further increases the number of cluster link fetchers.";
    private static final String LinkFetcherAutoTuneMaxConnectionPercentageProp = "link.fetcher.auto.tune.max.connection.percentage";
    private static final String LinkFetcherAutoTuneMaxConnectionPercentageDoc = "When the active number of cluster link connections exceeds this percentage of maximum allowed cluster link connections, auto tuning will stop increasing the number of cluster link fetchers.";
    private static final String ReplicaSocketReceiveBufferBytesDoc = "The socket receive buffer size for cluster linking connections. The receive buffer size will be limited by a defined maximum value. If set to -1, the kernel will auto tune the receive buffer size up to a defined maximum value.";
    private static final String BootstrapServersOverrideProp = "bootstrap.servers.override";
    private static final String BootstrapServersOverrideDoc = "A list of overridden bootstrap servers to use for establishing the initial connection to the Kafka cluster if present instead of bootstrap.servers provided by the customer.";
    private static final String AllowTruncationBelowHWMProp = "allow.truncation.below.high.watermark";
    private static final String AllowTruncationBelowHWMDoc = "If true, allow cluster link to truncate the mirror topic partitions below high watermark.";
    private static final Set<String> ReplicationProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.AllowTruncationBelowHWMProp(), MODULE$.NumClusterLinkFetchersProp(), MODULE$.FetcherThreadPoolModeProp(), MODULE$.RetryTimeoutMsProp(), MODULE$.LinkFetcherFlowControlProp(), MODULE$.LinkFetcherMaxLaggingPartitionsProp(), MODULE$.LinkFetcherLaggingPartitionMsProp(), MODULE$.MaxMessageSizeProp(), "replica.socket.timeout.ms", "replica.socket.receive.buffer.bytes", "replica.fetch.max.bytes", "replica.fetch.wait.max.ms", "replica.fetch.backoff.ms", "confluent.replica.fetch.backoff.max.ms", "replica.fetch.min.bytes", "replica.fetch.response.max.bytes", "confluent.replica.fetch.connections.mode"}));
    private static final int MaxMessageSizeUnlimited = Integer.MAX_VALUE;
    private static final Set<String> PeriodicTaskProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.ConsumerOffsetSyncEnableProp(), MODULE$.ConsumerOffsetSyncMsProp(), MODULE$.ConsumerOffsetGroupFiltersProp(), MODULE$.AclSyncEnableProp(), MODULE$.AclFiltersProp(), MODULE$.AclSyncMsProp(), MODULE$.TopicConfigSyncMsProp(), MODULE$.AutoMirroringEnableProp(), MODULE$.TopicFiltersProp(), MODULE$.AvailabilityCheckMsProp(), MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), MODULE$.LinkFetcherEnforceMaxLaggingPartitionMsProp(), MODULE$.LinkFetcherDegradedPartitionMonitorMsProp(), MODULE$.ClientsMaxIdleMsProp(), MODULE$.LinkFetcherAutoTuneEnableProp(), MODULE$.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp(), MODULE$.LinkFetcherAutoTuneIncreaseThroughputPercentageProp(), MODULE$.LinkFetcherAutoTuneMaxConnectionPercentageProp()}));
    private static final Set<String> NonReconfigurableProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.LinkModeProp(), MODULE$.ConnectionModeProp(), MODULE$.ClusterLinkPrefixProp(), MODULE$.ConsumerGroupPrefixEnableProp(), MODULE$.RemoteLinkConnectionModeProp()}));
    private static final Set<String> SslKeystoreConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.keystore.password", "ssl.key.password", "ssl.keystore.type", "ssl.keystore.certificate.chain", "ssl.keystore.key"}));
    private static final Set<String> SslTruststoreConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.truststore.location", "ssl.truststore.password", "ssl.truststore.type", "ssl.truststore.certificates"}));
    private static final Set<String> ProviderConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.provider", "security.providers"}));
    private static final Set<String> kafka$server$link$ClusterLinkConfig$$RetentionConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.ms", "retention.bytes"}));
    private static final ConfigDef configDef = MODULE$.createClusterLinkConfigDef();

    public String LinkModeProp() {
        return LinkModeProp;
    }

    public String LinkModeDoc() {
        return LinkModeDoc;
    }

    public String ConnectionModeProp() {
        return ConnectionModeProp;
    }

    public String ConnectionModeDoc() {
        return ConnectionModeDoc;
    }

    public String LocalPrefix() {
        return LocalPrefix;
    }

    public String LocalListenerNameProp() {
        return LocalListenerNameProp;
    }

    public String LocalListenerNameDoc() {
        return LocalListenerNameDoc;
    }

    public String ReverseConnectionSetupTimeoutMsProp() {
        return ReverseConnectionSetupTimeoutMsProp;
    }

    public String ReverseConnectionSetupTimeoutMsDoc() {
        return ReverseConnectionSetupTimeoutMsDoc;
    }

    public String RemoteLinkConnectionModeProp() {
        return RemoteLinkConnectionModeProp;
    }

    public String RemoteLinkConnectionModeDoc() {
        return RemoteLinkConnectionModeDoc;
    }

    public String FetcherThreadPoolModeProp() {
        return FetcherThreadPoolModeProp;
    }

    public String FetcherThreadPoolModeDoc() {
        return FetcherThreadPoolModeDoc;
    }

    public String NumClusterLinkFetchersProp() {
        return NumClusterLinkFetchersProp;
    }

    public String NumClusterLinkFetchersDoc() {
        return NumClusterLinkFetchersDoc;
    }

    public String RetryTimeoutMsProp() {
        return RetryTimeoutMsProp;
    }

    public String RetryTimeoutMsDoc() {
        return RetryTimeoutMsDoc;
    }

    public String ClusterLinkPausedProp() {
        return ClusterLinkPausedProp;
    }

    public String ClusterLinkPausedDoc() {
        return ClusterLinkPausedDoc;
    }

    public String ClusterLinkPrefixProp() {
        return ClusterLinkPrefixProp;
    }

    public String ClusterLinkPrefixDoc() {
        return ClusterLinkPrefixDoc;
    }

    public String ConsumerOffsetSyncEnableProp() {
        return ConsumerOffsetSyncEnableProp;
    }

    public String ConsumerOffsetSyncEnableDoc() {
        return ConsumerOffsetSyncEnableDoc;
    }

    public String ConsumerGroupPrefixEnableProp() {
        return ConsumerGroupPrefixEnableProp;
    }

    public String ConsumerGroupPrefixEnableDoc() {
        return ConsumerGroupPrefixEnableDoc;
    }

    public String ConsumerOffsetSyncMsProp() {
        return ConsumerOffsetSyncMsProp;
    }

    public String ConsumerOffsetSyncMsDoc() {
        return ConsumerOffsetSyncMsDoc;
    }

    public String ConsumerOffsetGroupFiltersProp() {
        return ConsumerOffsetGroupFiltersProp;
    }

    public String ConsumerOffsetGroupFiltersDoc() {
        return ConsumerOffsetGroupFiltersDoc;
    }

    public String AclSyncEnableProp() {
        return AclSyncEnableProp;
    }

    public String AclSyncEnableDoc() {
        return AclSyncEnableDoc;
    }

    public String AclFiltersProp() {
        return AclFiltersProp;
    }

    public String AclFiltersDoc() {
        return AclFiltersDoc;
    }

    public String AclSyncMsProp() {
        return AclSyncMsProp;
    }

    public String AclSyncMsDoc() {
        return AclSyncMsDoc;
    }

    public String TopicConfigSyncIncludeProp() {
        return TopicConfigSyncIncludeProp;
    }

    public String TopicConfigSyncIncludeDoc() {
        return TopicConfigSyncIncludeDoc;
    }

    public String TopicConfigSyncMsProp() {
        return TopicConfigSyncMsProp;
    }

    public String TopicConfigSyncMsDoc() {
        return TopicConfigSyncMsDoc;
    }

    public String AutoMirroringEnableProp() {
        return AutoMirroringEnableProp;
    }

    public String AutoMirroringEnableDoc() {
        return AutoMirroringEnableDoc;
    }

    public String TopicFiltersProp() {
        return TopicFiltersProp;
    }

    public String TopicFiltersDoc() {
        return TopicFiltersDoc;
    }

    public String MirrorStartOffsetSpecProp() {
        return MirrorStartOffsetSpecProp;
    }

    public String MirrorStartOffsetSpecDoc() {
        return MirrorStartOffsetSpecDoc;
    }

    public String MaxMessageSizeProp() {
        return MaxMessageSizeProp;
    }

    public String MaxMessageSizeDoc() {
        return MaxMessageSizeDoc;
    }

    public String AvailabilityCheckMsProp() {
        return AvailabilityCheckMsProp;
    }

    public String AvailabilityCheckMsDoc() {
        return AvailabilityCheckMsDoc;
    }

    public String AvailabilityCheckConsecutiveFailureThresholdProp() {
        return AvailabilityCheckConsecutiveFailureThresholdProp;
    }

    public String AvailabilityCheckConsecutiveFailureThresholdDoc() {
        return AvailabilityCheckConsecutiveFailureThresholdDoc;
    }

    public String LinkFetcherFlowControlProp() {
        return LinkFetcherFlowControlProp;
    }

    public String LinkFetcherFlowControlDoc() {
        return LinkFetcherFlowControlDoc;
    }

    public String LinkFetcherMaxLaggingPartitionsProp() {
        return LinkFetcherMaxLaggingPartitionsProp;
    }

    public String LinkFetcherMaxLaggingPartitionsDoc() {
        return LinkFetcherMaxLaggingPartitionsDoc;
    }

    public String LinkFetcherLaggingPartitionMsProp() {
        return LinkFetcherLaggingPartitionMsProp;
    }

    public String LinkFetcherLaggingPartitionMsDoc() {
        return LinkFetcherLaggingPartitionMsDoc;
    }

    public String LinkFetcherEnforceMaxLaggingPartitionMsProp() {
        return LinkFetcherEnforceMaxLaggingPartitionMsProp;
    }

    public String LinkFetcherEnforceMaxLaggingPartitionMsDoc() {
        return LinkFetcherEnforceMaxLaggingPartitionMsDoc;
    }

    public String LinkFetcherDegradedPartitionMonitorMsProp() {
        return LinkFetcherDegradedPartitionMonitorMsProp;
    }

    public String LinkFetcherDegradedPartitionMonitorMsDoc() {
        return LinkFetcherDegradedPartitionMonitorMsDoc;
    }

    public String ClientsMaxIdleMsProp() {
        return ClientsMaxIdleMsProp;
    }

    public String ClientsMaxIdleMsDoc() {
        return ClientsMaxIdleMsDoc;
    }

    public String LinkFetcherAutoTuneEnableProp() {
        return LinkFetcherAutoTuneEnableProp;
    }

    public String LinkFetcherAutoTuneEnableDoc() {
        return LinkFetcherAutoTuneEnableDoc;
    }

    public String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp() {
        return LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp;
    }

    public String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc() {
        return LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc;
    }

    public String LinkFetcherAutoTuneIncreaseThroughputPercentageProp() {
        return LinkFetcherAutoTuneIncreaseThroughputPercentageProp;
    }

    public String LinkFetcherAutoTuneIncreaseThroughputPercentageDoc() {
        return LinkFetcherAutoTuneIncreaseThroughputPercentageDoc;
    }

    public String LinkFetcherAutoTuneMaxConnectionPercentageProp() {
        return LinkFetcherAutoTuneMaxConnectionPercentageProp;
    }

    public String LinkFetcherAutoTuneMaxConnectionPercentageDoc() {
        return LinkFetcherAutoTuneMaxConnectionPercentageDoc;
    }

    public String ReplicaSocketReceiveBufferBytesDoc() {
        return ReplicaSocketReceiveBufferBytesDoc;
    }

    public String BootstrapServersOverrideProp() {
        return BootstrapServersOverrideProp;
    }

    public String BootstrapServersOverrideDoc() {
        return BootstrapServersOverrideDoc;
    }

    public String AllowTruncationBelowHWMProp() {
        return AllowTruncationBelowHWMProp;
    }

    public String AllowTruncationBelowHWMDoc() {
        return AllowTruncationBelowHWMDoc;
    }

    public Set<String> ReplicationProps() {
        return ReplicationProps;
    }

    public int MaxMessageSizeUnlimited() {
        return MaxMessageSizeUnlimited;
    }

    public Set<String> PeriodicTaskProps() {
        return PeriodicTaskProps;
    }

    public Set<String> NonReconfigurableProps() {
        return NonReconfigurableProps;
    }

    public Set<String> SslKeystoreConfigs() {
        return SslKeystoreConfigs;
    }

    public Set<String> SslTruststoreConfigs() {
        return SslTruststoreConfigs;
    }

    public Set<String> ProviderConfigs() {
        return ProviderConfigs;
    }

    public Set<String> kafka$server$link$ClusterLinkConfig$$RetentionConfigs() {
        return kafka$server$link$ClusterLinkConfig$$RetentionConfigs;
    }

    public boolean needsConnectionResetOnUpdate(String configName) {
        return !this.configKeys().contains((Object)configName) || configName.startsWith(this.LocalPrefix()) || configName.equals("security.protocol") || configName.startsWith("ssl.") || configName.startsWith("sasl.");
    }

    public void main(String[] args) {
        Predef$.MODULE$.println((Object)this.configDef().toHtml());
    }

    public ConfigDef configDef() {
        return configDef;
    }

    private ConfigDef createClusterLinkConfigDef() {
        ConfigDef configDef = new ConfigDef().define(this.LinkModeProp(), ConfigDef.Type.STRING, (Object)ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault().name(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ClusterLinkConfig.LinkMode.values()), (Function1 & Serializable)x$16 -> x$16.name(), ClassTag$.MODULE$.apply(String.class))), ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.LOW, this.LinkModeDoc()).define(this.ConnectionModeProp(), ConfigDef.Type.STRING, null, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])((IterableOnceOps)((SeqOps)ConnectionMode$.MODULE$.values().map((Function1 & Serializable)x$17 -> ((ConnectionMode)x$17).name())).$colon$plus(null)).toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.LOW, this.ConnectionModeDoc()).define(this.LocalListenerNameProp(), ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, this.LocalListenerNameDoc()).define(this.ReverseConnectionSetupTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReverseConnectionSetupTimeoutMs()), (ConfigDef.Validator)ConfigDef.Range.between((Number)Predef$.MODULE$.int2Integer(1000), (Number)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE)), ConfigDef.Importance.LOW, this.ReverseConnectionSetupTimeoutMsDoc()).define(this.NumClusterLinkFetchersProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.NumClusterLinkFetchers()), ConfigDef.Importance.LOW, this.NumClusterLinkFetchersDoc()).define(this.FetcherThreadPoolModeProp(), ConfigDef.Type.STRING, (Object)ClusterLinkConfigDefaults$.MODULE$.FetcherThreadPoolModeDefault().name(), ConfigDef.Importance.LOW, this.FetcherThreadPoolModeDoc()).define(this.ClusterLinkPausedProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.ClusterLinkPausedDoc()).define(this.ClusterLinkPrefixProp(), ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, this.ClusterLinkPrefixDoc()).define(this.ConsumerOffsetSyncEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.ConsumerOffsetSyncEnableDoc()).define(this.ConsumerGroupPrefixEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfigDefaults$.MODULE$.ConsumerGroupPrefixEnableDefault()), ConfigDef.Importance.LOW, this.ConsumerGroupPrefixEnableDoc()).define(this.ConsumerOffsetSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.OffsetSyncMsDefault()), ConfigDef.Importance.LOW, this.ConsumerOffsetSyncMsDoc()).define(this.ConsumerOffsetGroupFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)ClusterLinkFilterJson$.MODULE$.GROUP_VALIDATOR(), ConfigDef.Importance.LOW, this.ConsumerOffsetGroupFiltersDoc()).define(this.RetryTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.RetryTimeoutMs()), ConfigDef.Importance.MEDIUM, this.RetryTimeoutMsDoc()).define(this.AclSyncEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.AclSyncEnableDoc()).define(this.AclFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)AclJson$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, this.AclFiltersDoc()).define(this.AclSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AclSyncMsDefault()), ConfigDef.Importance.LOW, this.AclSyncMsDoc()).define(this.TopicConfigSyncIncludeProp(), ConfigDef.Type.LIST, ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault(), TopicConfigSyncIncludeValidator$.MODULE$.ConfigDefValidator(), ConfigDef.Importance.LOW, this.TopicConfigSyncIncludeDoc()).define(this.TopicConfigSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncMsDefault()), ConfigDef.Importance.LOW, this.TopicConfigSyncMsDoc()).define(this.AutoMirroringEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.AutoMirroringEnableDoc()).define(this.TopicFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)ClusterLinkFilterJson$.MODULE$.TOPIC_VALIDATOR(), ConfigDef.Importance.LOW, this.TopicFiltersDoc()).define(this.MirrorStartOffsetSpecProp(), ConfigDef.Type.STRING, (Object)ClusterLinkConfigDefaults$.MODULE$.MirrorStartOffsetSpec(), ConfigDef.Importance.LOW, this.MirrorStartOffsetSpecDoc()).define(this.MaxMessageSizeProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)this.MaxMessageSizeUnlimited()), ConfigDef.Importance.LOW, this.MaxMessageSizeDoc()).define(this.AvailabilityCheckMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckMsDefault()), ConfigDef.Importance.LOW, this.AvailabilityCheckMsDoc()).define(this.AvailabilityCheckConsecutiveFailureThresholdProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdDefault()), ConfigDef.Importance.LOW, this.AvailabilityCheckConsecutiveFailureThresholdProp()).define("bootstrap.servers", ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)new ConfigDef.NonNullValidator(), ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").defineInternal(this.BootstrapServersOverrideProp(), ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, this.BootstrapServersOverrideDoc()).define("client.dns.lookup", ConfigDef.Type.STRING, (Object)ClientDnsLookup.USE_ALL_DNS_IPS.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()}), ConfigDef.Importance.MEDIUM, "Controls how the client uses DNS lookups. If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established. After a disconnection, the next IP is used. Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however). If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names. After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).define("replica.socket.timeout.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)30000), ConfigDef.Importance.LOW, "replica.socket.timeout.ms").define("request.timeout.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)30000), ConfigDef.Importance.LOW, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").define("connections.max.idle.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.ConnectionsMaxIdleMs()), ConfigDef.Importance.LOW, "Idle connections timeout: the server socket processor threads close the connections that idle more than this").define("socket.connection.setup.timeout.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ServerConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS), ConfigDef.Importance.LOW, "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>socket.connection.setup.timeout.max.ms</code> value.").define("socket.connection.setup.timeout.max.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ServerConfigs.SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS), ConfigDef.Importance.LOW, "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>socket.connection.setup.timeout.max.ms</code> value.").define("replica.socket.receive.buffer.bytes", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaSocketReceiveBufferBytes()), ConfigDef.Importance.LOW, this.ReplicaSocketReceiveBufferBytesDoc()).define("replica.fetch.max.bytes", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchMaxBytes()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The number of bytes of messages to attempt to fetch for each partition. This is not an absolute maximum, if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).").define("replica.fetch.wait.max.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)500), ConfigDef.Importance.LOW, "The maximum wait time for each fetcher request issued by follower replicas. This value should always be less than the replica.lag.time.max.ms at all times to prevent frequent shrinking of ISR for low throughput topics").define("replica.fetch.backoff.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1000), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The base amount of time to wait when fetch partition error occurs. The backoff increases exponentially for each consecutive failure up to replica.fetch.backoff.ms").define("confluent.replica.fetch.backoff.max.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1000), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, "The maximum amount of time in milliseconds to wait when fetch partition fails repeatedly. If provided, the backoff will increase exponentially for each consecutive failure, up to this maximum.").define("replica.fetch.min.bytes", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.LOW, "Minimum bytes expected for each fetch response. If not enough bytes, wait up to <code>replica.fetch.wait.max.ms</code> (broker config).").define("replica.fetch.response.max.bytes", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchResponseMaxBytes()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "Maximum bytes expected for the entire fetch response. Records are fetched in batches, and if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. As such, this is not an absolute maximum. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).").define("retry.backoff.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.RetryBackoffMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios. This value is the initial backoff value and will increase exponentially for each failed request, up to the <code>retry.backoff.max.ms</code> value.").define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.ReconnectBackoffMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>reconnect.backoff.max.ms</code> value.").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.ReconnectBackoffMaxMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.").define("metadata.max.age.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.MetadataMaxAgeMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.").define("default.api.timeout.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.DefaultApiTimeoutMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "Specifies the timeout (in milliseconds) for client APIs. This configuration is used as the default timeout for all client operations that do not specify a <code>timeout</code> parameter.").define(this.LinkFetcherMaxLaggingPartitionsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherMaxLaggingPartitions()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(-1)), ConfigDef.Importance.LOW, this.LinkFetcherMaxLaggingPartitionsDoc()).define(this.LinkFetcherLaggingPartitionMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherLaggingPartitionMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherLaggingPartitionMsDoc()).define(this.LinkFetcherEnforceMaxLaggingPartitionMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherEnforceMaxLaggingPartitionMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherEnforceMaxLaggingPartitionMsDoc()).define(this.AllowTruncationBelowHWMProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfigDefaults$.MODULE$.AllowTruncationBelowHWM()), ConfigDef.Importance.LOW, this.AllowTruncationBelowHWMDoc()).defineInternal(this.LinkFetcherDegradedPartitionMonitorMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherDegradedPartitionMonitorMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherDegradedPartitionMonitorMsDoc()).defineInternal(this.LinkFetcherFlowControlProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherFlowControl()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(-2)), ConfigDef.Importance.LOW, this.LinkFetcherFlowControlDoc()).defineInternal(this.RemoteLinkConnectionModeProp(), ConfigDef.Type.STRING, null, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])((IterableOnceOps)((SeqOps)ConnectionMode$.MODULE$.values().map((Function1 & Serializable)x$18 -> ((ConnectionMode)x$18).name())).$colon$plus(null)).toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.LOW, this.RemoteLinkConnectionModeDoc()).defineInternal("confluent.replica.fetch.connections.mode", ConfigDef.Type.STRING, (Object)FetchConnectionsMode$Combined$.MODULE$.value(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])FetchConnectionsMode$.MODULE$.validValues()), ConfigDef.Importance.LOW, "Mode of how replicas are distributed among fetcher threads. <code>combined</code>: replicas will be added to default fetcher threads and no extra in-sync fetcher threads will be created. Fetch request connections will have combined in-sync and out-of-sync replicas.<code>isolated</code>: replicas will be added to default fetcher threads initially. When a replica becomes in-sync, it will be migrated to a new in-sync fetcher thread thus not blocked by out-of-sync replicas in a fetch request.").defineInternal(this.ClientsMaxIdleMsProp(), ConfigDef.Type.LONG, (Object)ClusterLinkConfigDefaults$.MODULE$.ClientsMaxIdleMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.LOW, this.ClientsMaxIdleMsDoc()).defineInternal(this.LinkFetcherAutoTuneEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneEnable()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneEnableDoc()).defineInternal(this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneDecreaseThroughputThresholdBytes()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc()).defineInternal(this.LinkFetcherAutoTuneIncreaseThroughputPercentageProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneIncreaseThroughputPercentage()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneIncreaseThroughputPercentageDoc()).defineInternal(this.LinkFetcherAutoTuneMaxConnectionPercentageProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneMaxConnectionPercentage()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneMaxConnectionPercentageDoc()).withClientSslSupport().withClientSaslSupport();
        return this.addLocalClientSecurityConfigs(configDef);
    }

    private ConfigDef addLocalClientSecurityConfigs(ConfigDef configDef) {
        String localDoc = new StringBuilder(133).append("This security configuration with '").append(this.LocalPrefix()).append("' prefix is applied to clients connecting ").append("locally to the source cluster of a source initiated link.").toString();
        ObjectRef newConfigDef = ObjectRef.create((Object)configDef.define(new StringBuilder(17).append(this.LocalPrefix()).append("security.protocol").toString(), ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, new StringBuilder(0).append(CommonClientConfigs.SECURITY_PROTOCOL_DOC).append(localDoc).toString()));
        new ConfigDef().withClientSslSupport().withClientSaslSupport().configKeys().forEach((name, key) -> {
            newConfigDef$1.elem = ((ConfigDef)newConfigDef$1.elem).define(new StringBuilder(0).append(MODULE$.LocalPrefix()).append((String)name).toString(), key.type, key.defaultValue, key.validator, key.importance, new StringBuilder(1).append(key.documentation).append(" ").append(localDoc).toString(), key.group, key.orderInGroup, key.width, key.displayName, key.dependents, key.recommender);
        });
        return (ConfigDef)newConfigDef.elem;
    }

    public Seq<String> configNames() {
        return (Seq)CollectionConverters$.MODULE$.SetHasAsScala(this.configDef().names()).asScala().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Map<String, ConfigDef.ConfigKey> configKeys() {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.configDef().configKeys()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<ConfigDef.Type> configType(String name) {
        return Option$.MODULE$.apply(this.configDef().configKeys().get(name)).map((Function1 & Serializable)x$19 -> x$19.type);
    }

    public ConfigDef configDefCopy() {
        return new ConfigDef(this.configDef());
    }

    public ClusterLinkConfig create(java.util.Map<?, ?> props, Option<KafkaConfig> brokerConfig, boolean validate) {
        try {
            Properties properties;
            ClusterLinkConfig.LinkMode linkMode = (ClusterLinkConfig.LinkMode)Option$.MODULE$.apply(props.get(this.LinkModeProp())).map((Function1 & Serializable)m -> ClusterLinkConfig.LinkMode.fromString((String)m.toString())).getOrElse((Function0 & Serializable)() -> ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault());
            ConnectionMode connectionMode = props.containsKey(this.ConnectionModeProp()) ? ConnectionMode$.MODULE$.fromString(props.get(this.ConnectionModeProp()).toString()) : this.defaultConnectionMode(linkMode);
            ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
            if (connectionMode != null && connectionMode.equals(connectionMode$Inbound$) && linkMode.mayActAsDestination()) {
                Properties newProps = new Properties();
                props.forEach((k, v) -> newProps.setProperty(k.toString(), v.toString()));
                newProps.setProperty("bootstrap.servers", "localhost:0");
                properties = newProps;
            } else {
                properties = props;
            }
            Properties configProps = properties;
            return new ClusterLinkConfig(configProps, brokerConfig, validate);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            throw invalidConfigurationException;
        }
        catch (ConfigException e) {
            throw new InvalidConfigurationException(new StringBuilder(30).append("Invalid cluster link configs: ").append((Object)e).toString());
        }
        catch (Exception e) {
            throw new InvalidConfigurationException(new StringBuilder(30).append("Invalid cluster link configs: ").append(e).toString(), (Throwable)e);
        }
    }

    public boolean create$default$3() {
        return true;
    }

    public ClusterLinkConfig configsWithOverrides(ClusterLinkConfig clusterLinkConfig, java.util.Map<String, Object> configOverrides) {
        java.util.Map originalsCopy = clusterLinkConfig.originals();
        originalsCopy.putAll(configOverrides);
        return new ClusterLinkConfig(originalsCopy, clusterLinkConfig.brokerConfig(), false);
    }

    public void kafka$server$link$ClusterLinkConfig$$validateClusterLinkPrefix(String clusterLinkPrefix) {
        int maxLength = 12;
        if (clusterLinkPrefix.length() > maxLength) {
            throw new InvalidConfigurationException(new StringBuilder(57).append("Cluster link prefix exceeds maximum size of '").append(maxLength).append("' characters").toString());
        }
        if (!Topic.containsValidPattern((String)clusterLinkPrefix)) {
            throw new InvalidConfigurationException(new StringBuilder(67).append("Cluster link prefix '").append(clusterLinkPrefix).append("' is illegal, valid characters: [a-zA-Z0-9._-]").toString());
        }
    }

    public ConnectionMode defaultConnectionMode(ClusterLinkConfig.LinkMode linkMode) {
        if (linkMode.mayActAsDestination()) {
            return ConnectionMode$Outbound$.MODULE$;
        }
        return ConnectionMode$Inbound$.MODULE$;
    }

    private ClusterLinkConfig.LinkMode clusterLinkMode(java.util.Map<String, String> configs) {
        return (ClusterLinkConfig.LinkMode)Option$.MODULE$.apply((Object)configs.get(this.LinkModeProp())).map((Function1 & Serializable)x$1 -> ClusterLinkConfig.LinkMode.fromString((String)x$1)).getOrElse((Function0 & Serializable)() -> ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault());
    }

    public ConnectionMode clusterLinkConnectionMode(java.util.Map<String, String> configs) {
        return (ConnectionMode)Option$.MODULE$.apply((Object)configs.get(this.ConnectionModeProp())).map((Function1 & Serializable)mode -> ConnectionMode$.MODULE$.fromString((String)mode)).getOrElse((Function0 & Serializable)() -> MODULE$.defaultConnectionMode(MODULE$.clusterLinkMode(configs)));
    }

    public OffsetSpec offsetSpecFromString(String offsetSpecValue) {
        if (offsetSpecValue == null || offsetSpecValue.equalsIgnoreCase("earliest")) {
            return new OffsetSpec.EarliestSpec();
        }
        if (offsetSpecValue.equalsIgnoreCase("latest")) {
            return new OffsetSpec.LatestSpec();
        }
        try {
            return OffsetSpec.forTimestamp((long)Utils.getDateTime((String)offsetSpecValue));
        }
        catch (Throwable e) {
            throw new InvalidConfigurationException(new StringBuilder(25).append("Invalid config value ").append(this.MirrorStartOffsetSpecProp()).append("=").append(offsetSpecValue).append(" : ").append(e).toString(), e);
        }
    }

    private ClusterLinkConfig$() {
    }
}

