/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.LinkRequestQuotaUsageType$Metadata$;
import kafka.server.link.ClusterLinkChannelContext;
import kafka.server.link.ClusterLinkClientType;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkDynamicLogger;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataThread$;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.FindCoordinatorResponseResult;
import kafka.server.link.MetadataListener;
import kafka.server.link.MetadataRefreshListener;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.message.DescribeClusterLinksResponseData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tMc\u0001B\u00181\u0001]B\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005b\u0001\t\u0015\r\u0011\"\u0001c\u0011!1\u0007A!A!\u0002\u0013\u0019\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011=\u0004!\u0011!Q\u0001\nAD\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\to\u0002\u0011\t\u0011)A\u0005q\"A1\u0010\u0001B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u0002\u0001\u0011\t\u0011)A\u0005\u0003\u0007Aq!!\u0004\u0001\t\u0003\ty\u0001C\u0005\u0002(\u0001\u0011\r\u0011\"\u0003\u0002*!A\u0011\u0011\u0007\u0001!\u0002\u0013\tY\u0003\u0003\u0006\u00024\u0001\u0011\r\u0011\"\u00011\u0003kA\u0001\"!\u0010\u0001A\u0003%\u0011q\u0007\u0005\n\u0003\u007f\u0001!\u0019!C\u0005\u0003\u0003B\u0001\"!\u0013\u0001A\u0003%\u00111\t\u0005\n\u0003\u0017\u0002!\u0019!C\u0005\u0003\u001bB\u0001\"!\u001a\u0001A\u0003%\u0011q\n\u0005\n\u0003O\u0002!\u0019!C\u0005\u0003SB\u0001\"a\u001d\u0001A\u0003%\u00111\u000e\u0005\f\u0003k\u0002\u0001\u0019!a\u0001\n\u0013\t9\bC\u0006\u0002\u0002\u0002\u0001\r\u00111A\u0005\n\u0005\r\u0005bCAH\u0001\u0001\u0007\t\u0011)Q\u0005\u0003sB1\"!'\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001c\"Y\u00111\u0015\u0001A\u0002\u0003\u0007I\u0011BAS\u0011-\tI\u000b\u0001a\u0001\u0002\u0003\u0006K!!(\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u0011\u0011\u0017\u0001\u0005B\u0005M\u0006bBA^\u0001\u0011\u0005\u0013q\u0016\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!a3\u0001\t\u0003\ti\rC\u0004\u0002R\u0002!\t\"a5\t\u000f\u0005e\u0007\u0001\"\u0011\u00020\"9\u00111\u001c\u0001\u0005\n\u0005=\u0006bBAo\u0001\u0011%\u0011q\u0016\u0005\b\u0003?\u0004A\u0011BAq\u0011\u001d\t\t\u0010\u0001C\u0005\u0003gDqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003\f\u0001!I!a,\b\u000f\t5\u0001\u0007#\u0001\u0003\u0010\u00191q\u0006\rE\u0001\u0005#Aq!!\u0004-\t\u0003\u0011I\u0002C\u0004\u0003\u001c1\"\tA!\b\u00033\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1UQJ,\u0017\r\u001a\u0006\u0003cI\nA\u0001\\5oW*\u00111\u0007N\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001q\u0011C\u0005CA\u001dC\u001b\u0005Q$BA\u001e=\u0003\u0011)H/\u001b7\u000b\u0005Mj$BA\u001b?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rS$AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\u0004\"!\u0012$\u000e\u0003AJ!a\u0012\u0019\u0003/5+G/\u00193bi\u0006\u0014VM\u001a:fg\"d\u0015n\u001d;f]\u0016\u0014\bCA%M\u001b\u0005Q%BA&5\u0003\u0015)H/\u001b7t\u0013\ti%JA\u0004M_\u001e<\u0017N\\4\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005A\u000bV\"\u0001\u001a\n\u0005I\u0013$aC&bM.\f7i\u001c8gS\u001e\f\u0011c\u00197vgR,'\u000fT5oW\u000e{gNZ5h!\t)U+\u0003\u0002Wa\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002#\r|gN\\3di&|g.T1oC\u001e,'\u000fE\u0002Z9zk\u0011A\u0017\u0006\u00027\u0006)1oY1mC&\u0011QL\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0015{\u0016B\u000111\u0005q\u0019E.^:uKJd\u0015N\\6D_:tWm\u0019;j_:l\u0015M\\1hKJ\f1c\u00197vgR,'\u000fT5oW6+G/\u00193bi\u0006,\u0012a\u0019\t\u0003\u000b\u0012L!!\u001a\u0019\u0003'\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1\u0002)\rdWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1!\u0003\u001diW\r\u001e:jGN\u0004\"![7\u000e\u0003)T!aZ6\u000b\u00051l\u0014AB2p[6|g.\u0003\u0002oU\n9Q*\u001a;sS\u000e\u001c\u0018aF:fY\u0016\u001cGo\u001c:NKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z!\t)\u0015/\u0003\u0002sa\t\u00113\t\\;ti\u0016\u0014H*\u001b8l'\u0016dWm\u0019;pe6+GO]5dgJ+w-[:uef\f!b\u00197jK:$H+\u001f9f!\t)U/\u0003\u0002wa\t)2\t\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;UsB,\u0017!B9v_R\f\u0007C\u0001)z\u0013\tQ(GA\fDYV\u001cH/\u001a:MS:\\'+Z9vKN$\u0018+^8uC\u0006I2\r\\;ti\u0016\u0014H*\u001b8l\u0007\"\fgN\\3m\u0007>tG/\u001a=u!\rIF, \t\u0003\u000bzL!a \u0019\u00033\rcWo\u001d;fe2Kgn[\"iC:tW\r\\\"p]R,\u0007\u0010^\u0001\u0005i&lW\r\u0005\u0003\u0002\u0006\u0005%QBAA\u0004\u0015\tY5.\u0003\u0003\u0002\f\u0005\u001d!\u0001\u0002+j[\u0016\fa\u0001P5oSRtDCFA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019#!\n\u0011\u0005\u0015\u0003\u0001\"\u0002(\r\u0001\u0004y\u0005\"B*\r\u0001\u0004!\u0006\"B,\r\u0001\u0004A\u0006\"B1\r\u0001\u0004\u0019\u0007\"B4\r\u0001\u0004A\u0007\"B8\r\u0001\u0004\u0001\b\"B:\r\u0001\u0004!\b\"B<\r\u0001\u0004A\b\"B>\r\u0001\u0004a\bbBA\u0001\u0019\u0001\u0007\u00111A\u0001\u000bY><7i\u001c8uKb$XCAA\u0016!\u0011\t)!!\f\n\t\u0005=\u0012q\u0001\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\n\u0011c\u00197vgR,'\u000fT5oW\u000ec\u0017.\u001a8u+\t\t9\u0004E\u0002F\u0003sI1!a\u000f1\u0005a\u0019E.^:uKJd\u0015N\\6OKR<xN]6DY&,g\u000e^\u0001\u0013G2,8\u000f^3s\u0019&t7n\u00117jK:$\b%A\u0007es:\fW.[2M_\u001e<WM]\u000b\u0003\u0003\u0007\u00022!RA#\u0013\r\t9\u0005\r\u0002\u0019\u00072,8\u000f^3s\u0019&t7\u000eR=oC6L7\rT8hO\u0016\u0014\u0018A\u00043z]\u0006l\u0017n\u0019'pO\u001e,'\u000fI\u0001\u0012[\u0016$\u0018\rZ1uC2K7\u000f^3oKJ\u001cXCAA(!\u0019\t\t&a\u0017\u0002`5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&A\u0004nkR\f'\r\\3\u000b\u0007\u0005e#,\u0001\u0006d_2dWm\u0019;j_:LA!!\u0018\u0002T\t1!)\u001e4gKJ\u00042!RA1\u0013\r\t\u0019\u0007\r\u0002\u0011\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ\f!#\\3uC\u0012\fG/\u0019'jgR,g.\u001a:tA\u0005!2m\\8sI&t\u0017\r^8s\u0019&\u001cH/\u001a8feN,\"!a\u001b\u0011\r\u0005E\u00131LA7!\r)\u0015qN\u0005\u0004\u0003c\u0002$aE\"p_J$\u0017N\\1u_Jd\u0015n\u001d;f]\u0016\u0014\u0018!F2p_J$\u0017N\\1u_Jd\u0015n\u001d;f]\u0016\u00148\u000fI\u0001\u0017GV\u0014(/\u001a8u\u001b\u0016$\u0018\rZ1uC\u000ecWo\u001d;feV\u0011\u0011\u0011\u0010\t\u0005\u0003w\ni(D\u0001l\u0013\r\tyh\u001b\u0002\b\u00072,8\u000f^3s\u0003i\u0019WO\u001d:f]RlU\r^1eCR\f7\t\\;ti\u0016\u0014x\fJ3r)\u0011\t))a#\u0011\u0007e\u000b9)C\u0002\u0002\nj\u0013A!\u00168ji\"I\u0011Q\u0012\r\u0002\u0002\u0003\u0007\u0011\u0011P\u0001\u0004q\u0012\n\u0014aF2veJ,g\u000e^'fi\u0006$\u0017\r^1DYV\u001cH/\u001a:!Q\rI\u00121\u0013\t\u00043\u0006U\u0015bAAL5\nAao\u001c7bi&dW-\u0001\ndkJ\u0014XM\u001c;D_>\u0014H-\u001b8bi>\u0014XCAAO!\u0011\tY(a(\n\u0007\u0005\u00056N\u0001\u0003O_\u0012,\u0017AF2veJ,g\u000e^\"p_J$\u0017N\\1u_J|F%Z9\u0015\t\u0005\u0015\u0015q\u0015\u0005\n\u0003\u001b[\u0012\u0011!a\u0001\u0003;\u000b1cY;se\u0016tGoQ8pe\u0012Lg.\u0019;pe\u0002B3\u0001HAJ\u0003\u0019!wnV8sWR\u0011\u0011QQ\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"!!.\u0011\u0007e\u000b9,C\u0002\u0002:j\u0013qAQ8pY\u0016\fg.A\u0007bo\u0006LGo\u00155vi\u0012|wO\\\u0001\fC\u0012$G*[:uK:,'\u000f\u0006\u0003\u0002\u0006\u0006\u0005\u0007bBAbA\u0001\u0007\u0011qL\u0001\tY&\u001cH/\u001a8fe\u00061\u0012\r\u001a3D_>\u0014H-\u001b8bi>\u0014H*[:uK:,'\u000f\u0006\u0003\u0002\u0006\u0006%\u0007bBAbC\u0001\u0007\u0011QN\u0001\u0016e\u0016lw\u000e^3MS:\\7i\\8sI&t\u0017\r^8s+\t\ty\r\u0005\u0003Z9\u0006u\u0015aE2sK\u0006$XMT3uo>\u00148n\u00117jK:$HCBA\u001c\u0003+\f9\u000eC\u0003TG\u0001\u0007A\u000bC\u0003bG\u0001\u00071-A\fp]6+G/\u00193bi\u0006\u0014V-];fgR,\u0006\u000fZ1uK\u0006!R.Y=cK\u001aKg\u000eZ\"p_J$\u0017N\\1u_J\fQ&\\1zE\u00164\u0015N\u001c3D_>\u0014H-\u001b8bi>\u0014Xk]5oO\u0012+7o\u0019:jE\u0016\u001cE.^:uKJd\u0015N\\6t\u0003i\u0019XM\u001c3GS:$7i\\8sI&t\u0017\r^8s%\u0016\fX/Z:u)\u0019\t))a9\u0002h\"9\u0011Q]\u0014A\u0002\u0005u\u0015\u0001\u00028pI\u0016Dq!!;(\u0001\u0004\tY/A\u0002o_^\u00042!WAw\u0013\r\tyO\u0017\u0002\u0005\u0019>tw-\u0001\u0010qe>\u001cWm]:GS:$7i\\8sI&t\u0017\r^8s%\u0016\u001c\bo\u001c8tKR!\u0011QQA{\u0011\u001d\t9\u0010\u000ba\u0001\u0003s\f\u0001B]3ta>t7/\u001a\t\u0005\u0003w\u0014\t!\u0004\u0002\u0002~*\u0019\u0011q`\u001f\u0002\u000f\rd\u0017.\u001a8ug&!!1AA\u007f\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\f!\u0005\u001d:pG\u0016\u001c8\u000fR3tGJL'-Z\"mkN$XM\u001d'j].\u0014Vm\u001d9p]N,G\u0003BAC\u0005\u0013Aq!a>*\u0001\u0004\tI0\u0001\u0010vg\u0016\u001cuN\u001c;s_2dWM]!t\u0019&t7nQ8pe\u0012Lg.\u0019;pe\u0006I2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uCRC'/Z1e!\t)EfE\u0002-\u0005'\u00012!\u0017B\u000b\u0013\r\u00119B\u0017\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t=\u0011!\b5b]\u0012dWMR5oI\u000e{wN\u001d3j]\u0006$xN\u001d*fgB|gn]3\u0015\u0011\t}!Q\u0005B \u0005\u0007\u00022!\u0012B\u0011\u0013\r\u0011\u0019\u0003\r\u0002\u001e\r&tGmQ8pe\u0012Lg.\u0019;peJ+7\u000f]8og\u0016\u0014Vm];mi\"9!q\u0005\u0018A\u0002\t%\u0012\u0001\u00037j].t\u0015-\\3\u0011\t\t-\"\u0011\b\b\u0005\u0005[\u0011)\u0004E\u0002\u00030ik!A!\r\u000b\u0007\tMb'\u0001\u0004=e>|GOP\u0005\u0004\u0005oQ\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003<\tu\"AB*ue&twMC\u0002\u00038iCaA!\u0011/\u0001\u0004A\u0015a\u00017pO\"9!Q\t\u0018A\u0002\t\u001d\u0013a\u00064j]\u0012\u001cun\u001c:eS:\fGo\u001c:SKN\u0004xN\\:f!\u0011\u0011IEa\u0014\u000e\u0005\t-#b\u0001B'W\u00069Q.Z:tC\u001e,\u0017\u0002\u0002B)\u0005\u0017\u00121DR5oI\u000e{wN\u001d3j]\u0006$xN\u001d*fgB|gn]3ECR\f\u0007")
public class ClusterLinkMetadataThread
extends ShutdownableThread
implements MetadataRefreshListener,
Logging {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkConfig clusterLinkConfig;
    private final Option<ClusterLinkConnectionManager> connectionManager;
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final Metrics metrics;
    private final ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry;
    private final ClusterLinkClientType clientType;
    private final ClusterLinkRequestQuota quota;
    private final Option<ClusterLinkChannelContext> clusterLinkChannelContext;
    private final Time time;
    private final LogContext logContext;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final ClusterLinkDynamicLogger dynamicLogger;
    private final Buffer<MetadataListener> metadataListeners;
    private final Buffer<CoordinatorListener> coordinatorListeners;
    private volatile Cluster currentMetadataCluster;
    private volatile Node currentCoordinator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static FindCoordinatorResponseResult handleFindCoordinatorResponse(String linkName, Logging log, FindCoordinatorResponseData findCoordinatorResponse) {
        return ClusterLinkMetadataThread$.MODULE$.handleFindCoordinatorResponse(linkName, log, findCoordinatorResponse);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkMetadata clusterLinkMetadata() {
        return this.clusterLinkMetadata;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private ClusterLinkDynamicLogger dynamicLogger() {
        return this.dynamicLogger;
    }

    private Buffer<MetadataListener> metadataListeners() {
        return this.metadataListeners;
    }

    private Buffer<CoordinatorListener> coordinatorListeners() {
        return this.coordinatorListeners;
    }

    private Cluster currentMetadataCluster() {
        return this.currentMetadataCluster;
    }

    private void currentMetadataCluster_$eq(Cluster x$1) {
        this.currentMetadataCluster = x$1;
    }

    private Node currentCoordinator() {
        return this.currentCoordinator;
    }

    private void currentCoordinator_$eq(Node x$1) {
        this.currentCoordinator = x$1;
    }

    public void doWork() {
        block8: {
            Option start = Option$.MODULE$.empty();
            try {
                try {
                    this.clusterLinkClient().networkClient().poll(Long.MAX_VALUE, this.time.milliseconds());
                    start = new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds()));
                    this.maybeFindCoordinator();
                    Cluster newMetadataCluster = this.clusterLinkMetadata().fetch();
                    if (newMetadataCluster != this.currentMetadataCluster()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Process cluster link metadata ").append(newMetadataCluster).toString());
                        this.metadataListeners().foreach((Function1 & Serializable)x$4 -> {
                            x$4.onNewMetadata(newMetadataCluster);
                            return BoxedUnit.UNIT;
                        });
                        this.currentMetadataCluster_$eq(newMetadataCluster);
                        this.currentCoordinator_$eq(null);
                        this.maybeFindCoordinator();
                        this.dynamicLogger().resetErrors();
                    } else {
                        this.clusterLinkMetadata().maybeThrowFatalException();
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof DisconnectException && !this.clusterLinkClient().networkClient().active()) break block8;
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        this.dynamicLogger().error("Failed to refresh metadata", exception);
                        this.metadataListeners().foreach((Function1 & Serializable)x$5 -> {
                            x$5.onMetadataFailure(exception);
                            return BoxedUnit.UNIT;
                        });
                        break block8;
                    }
                    throw throwable;
                }
            }
            finally {
                start.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)s -> $this.quota.record($this.time.nanoseconds() - s, LinkRequestQuotaUsageType$Metadata$.MODULE$));
            }
        }
    }

    public boolean initiateShutdown() {
        if (super.initiateShutdown()) {
            this.clusterLinkClient().initiateClose();
            return true;
        }
        return false;
    }

    public void awaitShutdown() {
        try {
            super.awaitShutdown();
        }
        catch (InterruptedException interruptedException) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Interrupted while awaiting metadata shutdown");
            super.awaitShutdown();
        }
        try {
            this.clusterLinkClient().close();
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to close metadata client after shutting down thread", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public void addListener(MetadataListener listener) {
        this.metadataListeners().$plus$eq((Object)listener);
    }

    public void addCoordinatorListener(CoordinatorListener listener) {
        this.coordinatorListeners().$plus$eq((Object)listener);
    }

    public Option<Node> remoteLinkCoordinator() {
        return Option$.MODULE$.apply((Object)this.currentCoordinator());
    }

    public ClusterLinkNetworkClient createNetworkClient(ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata) {
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(this.brokerConfig, clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)new Some((Object)clusterLinkMetadata), (Option<MetadataUpdater>)None$.MODULE$, this.metrics, this.selectorMetricsRegistry, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()), this.time, new StringBuilder(22).append("cluster-link-metadata-").append(clusterLinkMetadata.linkDescription()).toString(), this.clientType, this.clusterLinkChannelContext, this.logContext(), (AtomicReference)this.connectionManager.map((Function1 & Serializable)x$6 -> x$6.maxLogLevel()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.connectionManager.foreach((Function1 & Serializable)x$7 -> {
            x$7.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
            return BoxedUnit.UNIT;
        });
        return clusterLinkClient;
    }

    @Override
    public void onMetadataRequestUpdate() {
        this.clusterLinkClient().networkClient().wakeup();
    }

    private void maybeFindCoordinator() {
        long now = this.time.milliseconds();
        if (this.currentCoordinator() == null && this.coordinatorListeners().nonEmpty()) {
            Node node = this.clusterLinkClient().networkClient().leastLoadedNode(now).node();
            if (node != null && this.clusterLinkClient().networkClient().ready(node, now)) {
                this.sendFindCoordinatorRequest(node, now);
                return;
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> "No connection available to least loaded node for finding coordinator.");
            return;
        }
    }

    private void maybeFindCoordinatorUsingDescribeClusterLinks() {
        Node controller;
        Node node = controller = this.currentMetadataCluster() == null ? null : this.currentMetadataCluster().controller();
        if (controller != null && controller.id() >= 0) {
            if (this.clusterLinkClient().networkClient().ready(controller, this.time.milliseconds())) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Determine link coordinator using DescribeClusterLinks controllerId=").append(controller).toString());
                DescribeClusterLinksRequest.Builder requestBuilder = new DescribeClusterLinksRequest.Builder(Optional.of(Collections.singleton(this.clusterLinkMetadata().linkName())), false, false, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), ApiKeys.DESCRIBE_CLUSTER_LINKS.oldestVersion(), 3);
                long now = this.time.milliseconds();
                ClientRequest request = this.clusterLinkClient().networkClient().newClientRequest(controller.idString(), (AbstractRequest.Builder)requestBuilder, now, true, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), response -> this.processDescribeClusterLinkResponse(response));
                this.clusterLinkClient().networkClient().send(request, now);
                return;
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Controller connection not yet ready to send DescribeClusterLinks request");
            return;
        }
    }

    private void sendFindCoordinatorRequest(Node node, long now) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Determine link coordinator using FindCoordinator to node=").append(node).toString());
        FindCoordinatorRequestData data = new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.CLUSTER_LINK.id()).setCoordinatorKeys(Collections.singletonList(this.clusterLinkMetadata().linkName()));
        FindCoordinatorRequest.Builder builder = new FindCoordinatorRequest.Builder(data);
        ClientRequest request = this.clusterLinkClient().networkClient().newClientRequest(node.idString(), (AbstractRequest.Builder)builder, now, true, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), response -> this.processFindCoordinatorResponse(response));
        this.clusterLinkClient().networkClient().send(request, now);
    }

    private void processFindCoordinatorResponse(ClientResponse response) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Process FindCoordinator response ").append(response).toString());
        if (response.wasDisconnected()) {
            this.clusterLinkMetadata().requestUpdate();
            return;
        }
        FindCoordinatorResponseData findCoordinatorResponse = ((FindCoordinatorResponse)response.responseBody()).data();
        FindCoordinatorResponseResult result = ClusterLinkMetadataThread$.MODULE$.handleFindCoordinatorResponse(this.clusterLinkMetadata().linkName(), this, findCoordinatorResponse);
        Option<Node> option = result.coordinator();
        if (option instanceof Some) {
            Node coordinator = (Node)((Some)option).value();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Remote link coordinator is ").append(coordinator).toString());
            this.currentCoordinator_$eq(coordinator);
            this.coordinatorListeners().foreach((Function1 & Serializable)x$8 -> {
                x$8.onNewRemoteLinkCoordinator(coordinator);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (result.retry()) {
                this.maybeFindCoordinatorUsingDescribeClusterLinks();
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    private void processDescribeClusterLinkResponse(ClientResponse response) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Process DescribeClusterLinks response ").append(response).toString());
        if (response.wasDisconnected()) {
            this.clusterLinkMetadata().requestUpdate();
            return;
        }
        if (response.versionMismatch() != null || response.requestHeader().apiVersion() < 1) {
            this.useControllerAsLinkCoordinator();
            return;
        }
        DescribeClusterLinksResponseData describeResponse = ((DescribeClusterLinksResponse)response.responseBody()).data();
        if (describeResponse.errorCode() == Errors.NONE.code() && !describeResponse.entries().isEmpty()) {
            DescribeClusterLinksResponseData.EntryData entry = (DescribeClusterLinksResponseData.EntryData)describeResponse.entries().get(0);
            if (entry.linkCoordinatorId() != -1) {
                Node coordinator = new Node(entry.linkCoordinatorId(), entry.linkCoordinatorHost(), entry.linkCoordinatorPort());
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Remote link coordinator is ").append(coordinator).toString());
                this.currentCoordinator_$eq(coordinator);
                this.coordinatorListeners().foreach((Function1 & Serializable)x$9 -> {
                    x$9.onNewRemoteLinkCoordinator(coordinator);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (entry.linkState() == ClusterLinkDescription.LinkState.ACTIVE.getValue()) {
                this.useControllerAsLinkCoordinator();
                return;
            }
            return;
        }
        this.useControllerAsLinkCoordinator();
    }

    private void useControllerAsLinkCoordinator() {
        Node controller;
        Node node = controller = this.currentMetadataCluster() == null ? null : this.currentMetadataCluster().controller();
        if (controller != null && controller.id() != -1) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Cluster link coordinator not known, using controller ").append(controller).append(" instead").toString());
            this.currentCoordinator_$eq(controller);
            this.coordinatorListeners().foreach((Function1 & Serializable)x$10 -> {
                x$10.onNewRemoteLinkCoordinator(controller);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.clusterLinkMetadata().requestUpdate();
    }

    public ClusterLinkMetadataThread(KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, Option<ClusterLinkConnectionManager> connectionManager, ClusterLinkMetadata clusterLinkMetadata, Metrics metrics, ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry, ClusterLinkClientType clientType, ClusterLinkRequestQuota quota, Option<ClusterLinkChannelContext> clusterLinkChannelContext, Time time) {
        this.brokerConfig = brokerConfig;
        this.clusterLinkConfig = clusterLinkConfig;
        this.connectionManager = connectionManager;
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.metrics = metrics;
        this.selectorMetricsRegistry = selectorMetricsRegistry;
        this.clientType = clientType;
        this.quota = quota;
        this.clusterLinkChannelContext = clusterLinkChannelContext;
        this.time = time;
        super(new StringBuilder(13).append("LinkMetadata-").append(clusterLinkMetadata.linkDescription()).toString());
        this.logContext = new LogContext(new StringBuilder(29).append("[ClusterLinkMetadataClient ").append(clusterLinkMetadata.linkDescription()).append("] ").toString(), (AtomicReference)connectionManager.map((Function1 & Serializable)x$1 -> x$1.maxLogLevel()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.clusterLinkClient = this.createNetworkClient(clusterLinkConfig, clusterLinkMetadata);
        this.dynamicLogger = new ClusterLinkDynamicLogger(this, 10, 5, 10000);
        this.metadataListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.coordinatorListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        clusterLinkMetadata.setRefreshListener(this);
    }
}

