/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.SocketServer;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkChannelContext;
import kafka.server.link.ClusterLinkClientType$OutboundConnectionAdmin$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.LazyResource;
import kafka.server.link.RemoteNetworkClient;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r]f\u0001\u0002\"D\u0001)C\u0011\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u00171\t\u0011\u0005\u0004!\u0011!Q\u0001\n\tD\u0011\"\u001a\u0001\u0003\u0002\u0003\u0006IAZ:\t\u0011Q\u0004!\u0011!Q\u0001\nUD!\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0003\u0005\u000b\u00033\u0001!\u0011!Q\u0001\n\u0005m\u0001BCA\u0011\u0001\t\u0005\t\u0015!\u0003\u0002$!Q\u0011q\u0006\u0001\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005e\u0002A!A!\u0002\u0013\tY\u0004\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003\u0017B!\"!\u0015\u0001\u0005\u0003\u0005\u000b\u0011BA*\u0011)\tY\u0006\u0001B\u0001B\u0003%\u0011Q\f\u0005\u000b\u0003[\u0002!\u0011!Q\u0001\n\u0005=\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\n\u0003/\u0003!\u0019!C\u0005\u00033C\u0001\"a+\u0001A\u0003%\u00111\u0014\u0005\n\u0003[\u0003!\u0019!C\u0005\u0003_C\u0001\"!5\u0001A\u0003%\u0011\u0011\u0017\u0005\n\u0003'\u0004!\u0019!C\u0005\u0003_C\u0001\"!6\u0001A\u0003%\u0011\u0011\u0017\u0005\n\u0003/\u0004!\u0019!C\u0005\u00033D\u0001\"a:\u0001A\u0003%\u00111\u001c\u0005\f\u0003S\u0004\u0001\u0019!a\u0001\n\u0013\tY\u000fC\u0006\u0002v\u0002\u0001\r\u00111A\u0005\n\u0005]\bb\u0003B\u0002\u0001\u0001\u0007\t\u0011)Q\u0005\u0003[D1B!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0010!Y!q\u0003\u0001A\u0002\u0003\u0007I\u0011\u0002B\r\u0011-\u0011i\u0002\u0001a\u0001\u0002\u0003\u0006KA!\u0005\t\u0017\t\u0005\u0002\u00011AA\u0002\u0013%!1\u0005\u0005\f\u0005c\u0001\u0001\u0019!a\u0001\n\u0013\u0011\u0019\u0004C\u0006\u00038\u0001\u0001\r\u0011!Q!\n\t\u0015\u0002\"\u0003B\u001e\u0001\u0001\u0007I\u0011\u0002B\u001f\u0011%\u00119\u0005\u0001a\u0001\n\u0013\u0011I\u0005\u0003\u0005\u0003N\u0001\u0001\u000b\u0015\u0002B \u0011\u001d\u0011\t\u0006\u0001C!\u0005'B\u0001B!\u0016\u0001\t\u0003\u001a%q\u000b\u0005\b\u0005O\u0002A\u0011\tB*\u0011\u001d\u0011I\u0007\u0001C!\u0005WBqAa\"\u0001\t\u0003\u0012I\tC\u0004\u0003D\u0002!\tE!2\t\u000f\tm\u0007\u0001\"\u0003\u0003^\"9!1 \u0001\u0005\n\tu\bbBB\n\u0001\u0011%1Q\u0003\u0005\b\u0007;\u0001A\u0011IB\u0010\u0011\u001d\u0019Y\u0003\u0001C!\u0007[Aqaa\r\u0001\t\u0003\u0012\u0019\u0006C\u0004\u00046\u0001!IAa\u0015\t\u000f\r]\u0002\u0001\"\u0015\u0003T!91\u0011\b\u0001\u0005R\tM\u0003\u0002CB\u001e\u0001\u0011\u00051i!\u0010\t\u0011\r}\u0002\u0001\"\u0001D\u0007\u0003Bqaa\u0011\u0001\t\u0013\u0019)\u0005C\u0004\u0004L\u0001!Ia!\u0014\t\u000f\rU\u0003\u0001\"\u0003\u0003T!91Q\u000b\u0001\u0005\n\r]\u0003bBB.\u0001\u0011%!1\u000b\u0005\b\u0007;\u0002A\u0011\u0002B*\u0011\u001d\u0019y\u0006\u0001C\u0005\u0005'Bqa!\u0019\u0001\t\u0013\u0019\u0019\u0007C\u0004\u0004z\u0001!\tba\u001f\t\u0011\r\u0005\u0005\u0001\"\u0001D\u0007\u0007Cqa!$\u0001\t\u0003\u001ay\tC\u0004\u0004\u0012\u0002!\tea$\t\u000f\rM\u0005\u0001\"\u0011\u0004\u0016\n!3\t\\;ti\u0016\u0014H*\u001b8l\u001fV$(m\\;oI\u000e{gN\\3di&|g.T1oC\u001e,'O\u0003\u0002E\u000b\u0006!A.\u001b8l\u0015\t1u)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0011\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001L\u001fZ\u0003\"\u0001T'\u000e\u0003\rK!AT\"\u00039\rcWo\u001d;fe2Kgn[\"p]:,7\r^5p]6\u000bg.Y4feB\u0011\u0001k\u0015\b\u0003\u0019FK!AU\"\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/_\u0005\u0003)V\u0013\u0011dT;uE>,h\u000eZ\"p]:,7\r^5p]6\u000bg.Y4fe*\u0011!k\u0011\t\u0003\u0019^K!\u0001W\"\u0003'\r{wN\u001d3j]\u0006$xN\u001d'jgR,g.\u001a:\u0002\u00111Lgn\u001b#bi\u0006\u0004\"a\u00170\u000e\u0003qS!!X$\u0002\u0005i\\\u0017BA0]\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017BA-N\u00035Ig.\u001b;jC2\u001cuN\u001c4jOB\u0011AjY\u0005\u0003I\u000e\u0013\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003MawnY1m\u0019><\u0017nY1m\u00072,8\u000f^3s!\t9\u0007O\u0004\u0002i]B\u0011\u0011\u000e\\\u0007\u0002U*\u00111.S\u0001\u0007yI|w\u000e\u001e \u000b\u00035\fQa]2bY\u0006L!a\u001c7\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_2L!!Z'\u0002#\rd\u0017.\u001a8u\u0013:$XM]2faR|'\u000fE\u0002wofl\u0011\u0001\\\u0005\u0003q2\u0014aa\u00149uS>t\u0007c\u0001>\u0002\u00065\t1P\u0003\u0002}{\u000691\r\\5f]R\u001c(B\u0001%\u007f\u0015\ry\u0018\u0011A\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0011aA8sO&\u0019\u0011qA>\u0003#\rc\u0017.\u001a8u\u0013:$XM]2faR|'/A\u0004nKR\u0014\u0018nY:\u0011\u00071\u000bi!C\u0002\u0002\u0010\r\u0013!c\u00117vgR,'\u000fT5oW6+GO]5dg\u000692/\u001a7fGR|'/T3ue&\u001c7OU3hSN$(/\u001f\t\u0004\u0019\u0006U\u0011bAA\f\u0007\n\u00113\t\\;ti\u0016\u0014H*\u001b8l'\u0016dWm\u0019;pe6+GO]5dgJ+w-[:uef\fq\"\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\t\u0004\u0019\u0006u\u0011bAA\u0010\u0007\nQ2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006a1o\\2lKR\u001cVM\u001d<feB!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*\u001d\u000bqA\\3uo>\u00148.\u0003\u0003\u0002.\u0005\u001d\"\u0001D*pG.,GoU3sm\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007\u0003BA\u001a\u0003ki\u0011!R\u0005\u0004\u0003o)%aC&bM.\f7i\u001c8gS\u001e\f!b]3sm\u0016\u0014\u0018J\u001c4p!\u0011\ti$!\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n!\"Y;uQ>\u0014\u0018N_3s\u0015\t1U0\u0003\u0003\u0002H\u0005}\"\u0001F!vi\"|'/\u001b>feN+'O^3s\u0013:4w.A\u0003rk>$\u0018\r\u0005\u0003\u00024\u00055\u0013bAA(\u000b\n92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0001\u001aG2,8\u000f^3s\u0019&t7n\u00115b]:,GnQ8oi\u0016DH\u000f\u0005\u0003wo\u0006U\u0003c\u0001'\u0002X%\u0019\u0011\u0011L\"\u00033\rcWo\u001d;fe2Kgn[\"iC:tW\r\\\"p]R,\u0007\u0010^\u0001\u0005i&lW\r\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u000bU$\u0018\u000e\\:\u000b\u0007\u0005\u001dT0\u0001\u0004d_6lwN\\\u0005\u0005\u0003W\n\tG\u0001\u0003US6,\u0017\u0001G3oC\ndWMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8ogB\u0019a/!\u001d\n\u0007\u0005MDNA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)y\tI(a\u001f\u0002~\u0005}\u0014\u0011QAB\u0003\u000b\u000b9)!#\u0002\f\u00065\u0015qRAI\u0003'\u000b)\n\u0005\u0002M\u0001!)\u0011l\u0004a\u00015\")\u0011m\u0004a\u0001E\")Qm\u0004a\u0001M\")Ao\u0004a\u0001k\"9\u0011\u0011B\bA\u0002\u0005-\u0001bBA\t\u001f\u0001\u0007\u00111\u0003\u0005\b\u00033y\u0001\u0019AA\u000e\u0011\u001d\t\tc\u0004a\u0001\u0003GAq!a\f\u0010\u0001\u0004\t\t\u0004C\u0004\u0002:=\u0001\r!a\u000f\t\u000f\u0005%s\u00021\u0001\u0002L!9\u0011\u0011K\bA\u0002\u0005M\u0003bBA.\u001f\u0001\u0007\u0011Q\f\u0005\b\u0003[z\u0001\u0019AA8\u0003Q\u0019wN\u001c8fGRLwN\\+qI\u0006$X\rT8dWV\u0011\u00111\u0014\t\u0005\u0003;\u000b9+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0016\u0001\u00026bm\u0006LA!!+\u0002 \n1qJ\u00196fGR\fQcY8o]\u0016\u001cG/[8o+B$\u0017\r^3M_\u000e\\\u0007%A\u000bqKJ\u001c\u0018n\u001d;f]R\u001cuN\u001c8fGRLwN\\:\u0016\u0005\u0005E\u0006\u0003CAZ\u0003{\u000b\t-a2\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\tY,a)\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u007f\u000b)LA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u00042A^Ab\u0013\r\t)\r\u001c\u0002\u0004\u0013:$\b\u0003BAe\u0003\u001bl!!a3\u000b\t\u0005%\u0012QM\u0005\u0005\u0003\u001f\fYM\u0001\bSKZ,'o]3DQ\u0006tg.\u001a7\u0002-A,'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8og\u0002\n\u0001$Y2uSZ,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t\u0003e\t7\r^5wKJ+g/\u001a:tK\u000e{gN\\3di&|gn\u001d\u0011\u0002C1|7-\u00197SKZ,'o]3D_:tWm\u0019;j_:d\u0015n\u001d;f]\u0016\u0014X*\u00199\u0016\u0005\u0005m\u0007CBAo\u0003G4g-\u0004\u0002\u0002`*\u0019\u0011\u0011\u001d7\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002f\u0006}'aA'ba\u0006\u0011Cn\\2bYJ+g/\u001a:tK\u000e{gN\\3di&|g\u000eT5ti\u0016tWM]'ba\u0002\nA\u0003\\5oW2K7\u000f^3oKJ,e\u000e\u001a9pS:$XCAAw!\u0011\ty/!=\u000e\u0005\u0005\u0015\u0014\u0002BAz\u0003K\u0012\u0001\"\u00128ea>Lg\u000e^\u0001\u0019Y&t7\u000eT5ti\u0016tWM]#oIB|\u0017N\u001c;`I\u0015\fH\u0003BA}\u0003\u007f\u00042A^A~\u0013\r\ti\u0010\u001c\u0002\u0005+:LG\u000fC\u0005\u0003\u0002e\t\t\u00111\u0001\u0002n\u0006\u0019\u0001\u0010J\u0019\u0002+1Lgn\u001b'jgR,g.\u001a:F]\u0012\u0004x.\u001b8uA!\u001a!Da\u0002\u0011\u0007Y\u0014I!C\u0002\u0003\f1\u0014\u0001B^8mCRLG.Z\u0001\u0011Y&t7\u000eT5ti\u0016tWM\u001d(b[\u0016,\"A!\u0005\u0011\t\u0005%'1C\u0005\u0005\u0005+\tYM\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\u000bmS:\\G*[:uK:,'OT1nK~#S-\u001d\u000b\u0005\u0003s\u0014Y\u0002C\u0005\u0003\u0002q\t\t\u00111\u0001\u0003\u0012\u0005\tB.\u001b8l\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0011)\u0007u\u00119!\u0001\u0006m_\u000e\fG.\u00113nS:,\"A!\n\u0011\t\t\u001d\"QF\u0007\u0003\u0005SQ1Aa\u000b|\u0003\u0015\tG-\\5o\u0013\u0011\u0011yC!\u000b\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u0006qAn\\2bY\u0006#W.\u001b8`I\u0015\fH\u0003BA}\u0005kA\u0011B!\u0001 \u0003\u0003\u0005\rA!\n\u0002\u00171|7-\u00197BI6Lg\u000e\t\u0015\u0004A\t\u001d\u0011a\u0005:f[>$XMT3uo>\u00148n\u00117jK:$XC\u0001B !\u00111xO!\u0011\u0011\u00071\u0013\u0019%C\u0002\u0003F\r\u00131CU3n_R,g*\u001a;x_J\\7\t\\5f]R\fqC]3n_R,g*\u001a;x_J\\7\t\\5f]R|F%Z9\u0015\t\u0005e(1\n\u0005\n\u0005\u0003\u0011\u0013\u0011!a\u0001\u0005\u007f\tAC]3n_R,g*\u001a;x_J\\7\t\\5f]R\u0004\u0003fA\u0012\u0003\b\u000591\u000f^1siV\u0004HCAA}\u0003-\u0011XmY8oM&<WO]3\u0015\r\u0005e(\u0011\fB/\u0011\u0019\u0011Y&\na\u0001E\u0006Ia.Z<D_:4\u0017n\u001a\u0005\b\u0005?*\u0003\u0019\u0001B1\u0003-)\b\u000fZ1uK\u0012\\U-_:\u0011\u000b\u0005u'1\r4\n\t\t\u0015\u0014q\u001c\u0002\u0004'\u0016$\u0018\u0001D2m_N,7\t\\5f]R\u001c\u0018!E3oC\ndWm\u00117vgR,'\u000fT5oWR1\u0011\u0011 B7\u0005oBqAa\u001c(\u0001\u0004\u0011\t(A\u0007oKR<xN]6DY&,g\u000e\u001e\t\u0004\u0019\nM\u0014b\u0001B;\u0007\nA2\t\\;ti\u0016\u0014H*\u001b8l\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\t\u000f\u0005eq\u00051\u0001\u0003zA!ao\u001eB>!\u0011\u0011iHa!\u000e\u0005\t}$\u0002\u0002BA\u0005S\t\u0011\"\u001b8uKJt\u0017\r\\:\n\t\t\u0015%q\u0010\u0002\u0015\u0003\u0012l\u0017N\\'fi\u0006$\u0017\r^1NC:\fw-\u001a:\u00025%t\u0017\u000e^5bi\u0016\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\:\u0015\r\t-%\u0011\u0016B]!\u0019\u0011iIa&\u0003\u001e:!!q\u0012BJ\u001d\rI'\u0011S\u0005\u0002[&\u0019!Q\u00137\u0002\u000fA\f7m[1hK&!!\u0011\u0014BN\u0005\r\u0019V-\u001d\u0006\u0004\u0005+c\u0007CBAZ\u0005?\u0013\u0019+\u0003\u0003\u0003\"\u0006U&!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!\u0011Q\u0014BS\u0013\u0011\u00119+a(\u0003\tY{\u0017\u000e\u001a\u0005\b\u0005WC\u0003\u0019\u0001BW\u0003eIg.\u001b;jCR,7i\u001c8oK\u000e$\u0018n\u001c8SKF,Xm\u001d;\u0011\t\t=&QW\u0007\u0003\u0005cSAAa-\u0002f\u0005A!/Z9vKN$8/\u0003\u0003\u00038\nE&!I%oSRL\u0017\r^3SKZ,'o]3D_:tWm\u0019;j_:\u001c(+Z9vKN$\bb\u0002B^Q\u0001\u0007!QX\u0001\u000fe\u0016\fX/Z:u\u0007>tG/\u001a=u!\u0011\u0011yKa0\n\t\t\u0005'\u0011\u0017\u0002\u000f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0003MygNU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o)\u0019\tIPa2\u0003R\"9!\u0011Z\u0015A\u0002\t-\u0017aB2iC:tW\r\u001c\t\u0005\u0003\u0013\u0014i-\u0003\u0003\u0003P\u0006-'\u0001D&bM.\f7\t[1o]\u0016d\u0007b\u0002BjS\u0001\u0007!Q[\u0001\fe\u00164XM]:f\u001d>$W\r\u0005\u0003\u0002J\n]\u0017\u0002\u0002Bm\u0003\u0017\u00141BU3wKJ\u001cXMT8eK\u0006\trN\\\"p]:,7\r^5p]\u000ecwn]3\u0015\u0015\u0005e(q\u001cBq\u0005g\u00149\u0010C\u0004\u0003J*\u0002\rAa3\t\u000f\t\r(\u00061\u0001\u0003f\u0006I!/Z9vKN$\u0018\n\u001a\t\u0007\u0005O\u0014IO!<\u000e\u0005\u0005e\u0016\u0002\u0002Bv\u0003s\u0013\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u0003;\u0013y/\u0003\u0003\u0003r\u0006}%aB%oi\u0016<WM\u001d\u0005\b\u0005kT\u0003\u0019AAa\u00039\u0011X-\\8uK\n\u0013xn[3s\u0013\u0012DqA!?+\u0001\u0004\ty'\u0001\u000eva\u0012\fG/Z'fi\u0006$\u0017\r^1JMB+'o]5ti\u0016tG/\u0001\fg_J<\u0018M\u001d3U_N{WO]2f\u0005J|7.\u001a:t)\u0019\tIPa@\u0004\u0010!91\u0011A\u0016A\u0002\r\r\u0011a\u0003:fcV,7\u000f\u001e#bi\u0006\u0004Ba!\u0002\u0004\f5\u00111q\u0001\u0006\u0005\u0007\u0013\t)'A\u0004nKN\u001c\u0018mZ3\n\t\r51q\u0001\u0002&\u0013:LG/[1uKJ+g/\u001a:tK\u000e{gN\\3di&|gn\u001d*fcV,7\u000f\u001e#bi\u0006Dqa!\u0005,\u0001\u0004\u0011Y)A\u0004gkR,(/Z:\u00021\r\u0014X-\u0019;f%\u00164XM]:f\u0007>tg.Z2uS>t7\u000f\u0006\u0005\u0002z\u000e]1\u0011DB\u000e\u0011\u001d\u0019\t\u0001\fa\u0001\u0007\u0007AqAa/-\u0001\u0004\u0011i\fC\u0004\u0004\u00121\u0002\rAa#\u00025=tg*Z<SK6|G/\u001a'j].\u001cun\u001c:eS:\fGo\u001c:\u0015\t\u0005e8\u0011\u0005\u0005\b\u0007Gi\u0003\u0019AB\u0013\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u0011\t\u0005=8qE\u0005\u0005\u0007S\t)G\u0001\u0003O_\u0012,\u0017AE8o\u0007>tGO]8mY\u0016\u00148\t[1oO\u0016$B!!?\u00040!91\u0011\u0007\u0018A\u0002\u0005=\u0014\u0001C5t\u0003\u000e$\u0018N^3\u0002G=tG*\u001b8l\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>tG*Z1eKJ\u001c\u0005.\u00198hK\u0006iR.Y=cKB\u0013xnY3tg\u000e{wN\u001d3j]\u0006$xN]\"iC:<W-A\u000edY>\u001cXMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o\u0003\u0012l\u0017N\\\u0001\u001dGJ,\u0017\r^3SKZ,'o]3D_:tWm\u0019;j_:\fE-\\5o\u0003E\u0019'/Z1uKJ+Wn\u001c;f\u0003\u0012l\u0017N\u001c\u000b\u0003\u0005\u0003\n\u0001c\u0019:fCR,Gj\\2bY\u0006#W.\u001b8\u0015\u0005\t\u0015\u0012AE;qI\u0006$X\rT5oW2K7\u000f^3oKJ$B!!?\u0004H!11\u0011J\u001bA\u0002\t\faaY8oM&<\u0017\u0001\u0004:fm\u0016\u00148/\u00197ECR\fWCAB(!\u0011\u0019)a!\u0015\n\t\rM3q\u0001\u0002\u001d%\u00164XM]:f\u0007>tg.Z2uS>t'+Z9vKN$H)\u0019;b\u0003}i\u0017-\u001f2f\u0007J,\u0017\r^3QKJ\u001c\u0018n\u001d;f]R\u001cuN\u001c8fGRLwN\u001c\u000b\u0005\u0003s\u001cI\u0006C\u0004\u0004$a\u0002\ra!\n\u0002+I,\u0017/^3ti6+G/\u00193bi\u0006,\u0006\u000fZ1uK\u0006Q2\r\\8tKB+'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8og\u0006i2\r\\8tK\u0006\u001bG/\u001b<f%\u00164XM]:f\u0007>tg.Z2uS>t7/\u0001\tt_\u000e\\W\r^\"iC:tW\r\\&fsR!\u0011\u0011YB3\u0011\u001d\u00199\u0007\u0010a\u0001\u0007S\nQb]8dW\u0016$8\t[1o]\u0016d\u0007\u0003BB6\u0007kj!a!\u001c\u000b\t\r=4\u0011O\u0001\tG\"\fgN\\3mg*!11OAR\u0003\rq\u0017n\\\u0005\u0005\u0007o\u001aiGA\u0007T_\u000e\\W\r^\"iC:tW\r\\\u0001\u0014G2|7/\u001a*fm\u0016\u00148/Z\"iC:tW\r\u001c\u000b\u0005\u0003_\u001ai\bC\u0004\u0004\u0000u\u0002\r!a2\u0002\u001dI,g/\u001a:tK\u000eC\u0017M\u001c8fY\u0006qQ.\u001a;bI\u0006$\u0018\r\u00165sK\u0006$WCABC!\u00111xoa\"\u0011\u00071\u001bI)C\u0002\u0004\f\u000e\u0013\u0011d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006$\u0006N]3bI\u0006I\u0002/\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\u001cu.\u001e8u+\t\t\t-\u0001\fsKZ,'o]3D_:tWm\u0019;j_:\u001cu.\u001e8u\u00035a\u0017M_=SKN|WO]2fgV\u00111q\u0013\t\u0007\u0005\u001b\u00139j!'1\t\rm5Q\u0015\t\u0006\u0019\u000eu5\u0011U\u0005\u0004\u0007?\u001b%\u0001\u0004'buf\u0014Vm]8ve\u000e,\u0007\u0003BBR\u0007Kc\u0001\u0001B\u0006\u0004(\u0006\u000b\t\u0011!A\u0003\u0002\r%&aA0%cE!11VBY!\r18QV\u0005\u0004\u0007_c'a\u0002(pi\"Lgn\u001a\t\u0004m\u000eM\u0016bAB[Y\n\u0019\u0011I\\=")
public class ClusterLinkOutboundConnectionManager
extends ClusterLinkConnectionManager
implements ClusterLinkFactory.OutboundConnectionManager,
CoordinatorListener {
    private final ClusterLinkConfig initialConfig;
    private final Option<ClientInterceptor> clientInterceptor;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry;
    private final ClusterLinkMetadataManager metadataManager;
    private final SocketServer socketServer;
    private final KafkaConfig brokerConfig;
    private final AuthorizerServerInfo serverInfo;
    private final ClusterLinkRequestQuota quota;
    private final Option<ClusterLinkChannelContext> clusterLinkChannelContext;
    private final Time time;
    private final boolean enableReverseConnections;
    private final Object connectionUpdateLock;
    private final ConcurrentHashMap<Object, ReverseChannel> persistentConnections;
    private final ConcurrentHashMap<Object, ReverseChannel> activeReverseConnections;
    private final Map<String, String> localReverseConnectionListenerMap;
    private volatile Endpoint linkListenerEndpoint;
    private volatile ListenerName linkListenerName;
    private volatile ConfluentAdmin localAdmin;
    private volatile Option<RemoteNetworkClient> remoteNetworkClient;

    private Object connectionUpdateLock() {
        return this.connectionUpdateLock;
    }

    private ConcurrentHashMap<Object, ReverseChannel> persistentConnections() {
        return this.persistentConnections;
    }

    private ConcurrentHashMap<Object, ReverseChannel> activeReverseConnections() {
        return this.activeReverseConnections;
    }

    private Map<String, String> localReverseConnectionListenerMap() {
        return this.localReverseConnectionListenerMap;
    }

    private Endpoint linkListenerEndpoint() {
        return this.linkListenerEndpoint;
    }

    private void linkListenerEndpoint_$eq(Endpoint x$1) {
        this.linkListenerEndpoint = x$1;
    }

    private ListenerName linkListenerName() {
        return this.linkListenerName;
    }

    private void linkListenerName_$eq(ListenerName x$1) {
        this.linkListenerName = x$1;
    }

    private ConfluentAdmin localAdmin() {
        return this.localAdmin;
    }

    private void localAdmin_$eq(ConfluentAdmin x$1) {
        this.localAdmin = x$1;
    }

    private Option<RemoteNetworkClient> remoteNetworkClient() {
        return this.remoteNetworkClient;
    }

    private void remoteNetworkClient_$eq(Option<RemoteNetworkClient> x$1) {
        this.remoteNetworkClient = x$1;
    }

    @Override
    public void startup() {
        ConnectionMode connectionMode = this.initialConfig.connectionMode();
        ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
        if (connectionMode != null && connectionMode.equals(connectionMode$Inbound$)) {
            throw new IllegalStateException("Outbound connection manager created in inbound connection mode");
        }
        super.startup();
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        if (updatedKeys.contains((Object)ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
            this.updateLinkListener(this.currentConfig());
        }
        super.reconfigure(newConfig, updatedKeys);
        if (updatedKeys.exists((Function1 & Serializable)configName -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfig$.MODULE$.needsConnectionResetOnUpdate(configName)))) {
            this.closeActiveReverseConnections();
            return;
        }
    }

    @Override
    public void closeClients() {
        super.closeClients();
        this.closeActiveReverseConnections();
    }

    @Override
    public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
        KafkaClient kafkaClient = networkClient.networkClient();
        if (kafkaClient instanceof NetworkClient) {
            ((NetworkClient)kafkaClient).enableClusterLinkRequests(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
            return;
        }
    }

    public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Initiate or forward reverse connection request: ").append(initiateConnectionRequest).toString());
        this.ensureReverseConnectionsEnabled();
        InitiateReverseConnectionsRequestData connData = initiateConnectionRequest.data();
        List futures = (List)package$.MODULE$.List().fill(connData.entries().size(), (Function0 & Serializable)() -> new CompletableFuture());
        try {
            String string = connData.sourceClusterId();
            String string2 = super.localLogicalCluster();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new InvalidRequestException(new StringBuilder(67).append("Initiate reverse request for cluster ").append(connData.sourceClusterId()).append(" sent to wrong source cluster ").append(super.localLogicalCluster()).toString());
            }
            if (connData.forwardToBroker()) {
                this.forwardToSourceBrokers(connData, (Seq<CompletableFuture<Void>>)futures);
            } else {
                this.createReverseConnections(connData, requestContext, (Seq<CompletableFuture<Void>>)futures);
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failing reverse connection request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            futures.foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.completeExceptionally(e)));
        }
        return futures;
    }

    public void onReverseConnection(KafkaChannel channel2, ReverseNode reverseNode) {
        Optional requestId = reverseNode.requestId();
        int remoteBrokerId = reverseNode.remoteBrokerId();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Destination has successfully reversed channel ").append(channel2).append(" with requestId ").append(requestId).append(" remoteBrokerId ").append(remoteBrokerId).toString());
        this.ensureReverseConnectionsEnabled();
        if (!requestId.isPresent() && !this.isLinkCoordinator()) {
            String errorMessage = new StringBuilder(88).append("Discarding persistent reverse connection since broker ").append(this.brokerConfig.brokerId()).append(" is no longer the link coordinator").toString();
            this.debug((Function0<String>)(Function0 & Serializable)() -> errorMessage);
            throw new NotControllerException(errorMessage);
        }
        SocketChannel socketChannel = channel2.socketChannel();
        ReverseChannel reverseChannel = new ReverseChannel(channel2, reverseNode, channel -> this.onConnectionClose((KafkaChannel)channel, reverseNode.requestId(), reverseNode.remoteBrokerId(), true));
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.activeReverseConnections().put(BoxesRunTime.boxToInteger((int)System.identityHashCode(socketChannel)), reverseChannel);
            if (!requestId.isPresent()) {
                if (Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)remoteBrokerId))).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$onReverseConnection$4(x$5)))) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Ignoring persistent connection because a connection already exists for ").append(remoteBrokerId).toString());
                    throw new IllegalStateException(new StringBuilder(41).append("A persistent connection is available for ").append(remoteBrokerId).toString());
                }
                this.persistentConnections().put(BoxesRunTime.boxToInteger((int)remoteBrokerId), reverseChannel);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Created persistent connection to ").append(remoteBrokerId).append(", channel=").append(channel2).toString());
            }
        }
        this.metrics.reverseConnectionCreatedSensor().record();
        this.metrics.deprecatedReverseConnectionCreatedSensor().record();
        this.socketServer.reverseAndAdd(this.linkListenerName(), reverseChannel);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Added reverse connection ").append(channel2).append(" to source socket server, requestId=").append(requestId).toString());
    }

    private void onConnectionClose(KafkaChannel channel, Optional<Integer> requestId, int remoteBrokerId, boolean updateMetadataIfPersistent) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Reverse channel ").append(channel).append(" has been disconnected").toString());
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            boolean bl2;
            if (this.activeReverseConnections().remove(BoxesRunTime.boxToInteger((int)System.identityHashCode(channel.socketChannel()))) != null) {
                this.metrics.reverseConnectionClosedSensor().record();
                this.metrics.deprecatedReverseConnectionClosedSensor().record();
            }
            if (!requestId.isPresent() && this.persistentConnections().remove(BoxesRunTime.boxToInteger((int)remoteBrokerId)) != null) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Removed persistent connection for ").append(remoteBrokerId).append(" because channel ").append(channel.id()).append(" was closed").toString());
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        if (updateMetadataIfPersistent && bl) {
            this.requestMetadataUpdate();
            return;
        }
    }

    private void forwardToSourceBrokers(InitiateReverseConnectionsRequestData requestData, Seq<CompletableFuture<Void>> futures) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Forward initiate reverse connection request from source link coordinator to source brokers: ").append(requestData).toString());
        ConfluentAdmin admin = this.localAdmin();
        scala.collection.immutable.Map resultFutures = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
                CompletableFuture future = (CompletableFuture)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId())), (Object)future);
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().groupBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.sourceBrokerId())).foreach((Function1 & Serializable)x0$2 -> {
            ClusterLinkOutboundConnectionManager.$anonfun$forwardToSourceBrokers$4(this, requestData, admin, resultFutures, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void createReverseConnections(InitiateReverseConnectionsRequestData requestData, RequestContext requestContext, Seq<CompletableFuture<Void>> futures) {
        NetworkClient networkClient = ((RemoteNetworkClient)this.remoteNetworkClient().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Remote client connection manager not available");
        })).networkClient();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Create reverse connections from source brokers to destination brokers: ").append(requestData).toString());
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Object object;
                block5: {
                    InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
                    CompletableFuture future = (CompletableFuture)x0$1._2();
                    try {
                        if (entry.initiateRequestId() == -1 && Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)entry.targetBrokerId()))).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$createReverseConnections$4(x$7)))) {
                            object = BoxesRunTime.boxToBoolean((boolean)future.complete(null));
                            break block5;
                        }
                        if (entry.sourceBrokerId() == $this.brokerConfig.brokerId() || entry.sourceBrokerId() == -1) {
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Create reverse connection from source broker to destination broker: ").append(entry).toString());
                            ReverseNode reverseNode = networkClient.reverseConnectionManager().createReversibleConnection(entry.initiateRequestId(), entry.targetBrokerId(), requestContext$1.listenerName, requestContext$1.principal, requestContext$1.principalSerde, requestContext$1.authenticationContext, $this.time.milliseconds());
                            object = reverseNode.future().whenComplete((x0$2, x1$1) -> {
                                if (x1$1 != null) {
                                    $this.metrics.outboundReverseConnectionFailedSensor().record();
                                    $this.metrics.deprecatedSourceReverseConnectionFailedSensor().record();
                                    networkClient.requestClusterLinkMetadataUpdate();
                                    future.completeExceptionally((Throwable)x1$1);
                                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Failed to reverse connection for ").append(reverseNode).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> x1$1);
                                    return;
                                }
                                future.complete(x0$2);
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Completed connection reversal for ").append(reverseNode).toString());
                            });
                            break block5;
                        }
                        return BoxesRunTime.boxToBoolean((boolean)future.completeExceptionally(new InvalidRequestException(new StringBuilder(49).append("Incorrect source broker id, expected ").append($this.brokerConfig.brokerId()).append(", requested ").append(entry.sourceBrokerId()).toString())));
                    }
                    catch (Throwable e) {
                        future.completeExceptionally(e);
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Failed to reverse connection for request ").append(requestData).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            }
            throw new MatchError(null);
        });
    }

    @Override
    public void onNewRemoteLinkCoordinator(Node coordinator) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Process remote metadata: isLocalCoordinator=").append(this.isLinkCoordinator()).append(" remoteCoordinator=").append(coordinator).toString());
        if (!this.enableReverseConnections) {
            return;
        }
        this.maybeCreatePersistentConnection();
        this.updateActiveLinkCount();
    }

    @Override
    public void onControllerChange(boolean isActive) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Process local controller change, isActiveController=").append(isActive).toString());
        this.maybeProcessCoordinatorChange();
    }

    @Override
    public void onLinkMetadataPartitionLeaderChange() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Process metadata partition leader change");
        this.maybeProcessCoordinatorChange();
    }

    private void maybeProcessCoordinatorChange() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            boolean isCoordinator = this.isLinkCoordinator();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Process link coordinator change isLocalCoordinator=").append(isCoordinator).toString());
            if (this.enableReverseConnections) {
                if (!isCoordinator) {
                    this.closePersistentConnections();
                } else {
                    this.maybeCreatePersistentConnection();
                }
                return;
            }
            return;
        }
    }

    @Override
    public void closeReverseConnectionAdmin() {
        this.remoteNetworkClient().foreach((Function1 & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        if (this.localAdmin() != null) {
            this.localAdmin().close(Duration.ZERO);
            return;
        }
    }

    @Override
    public void createReverseConnectionAdmin() {
        if (!this.enableReverseConnections) {
            return;
        }
        this.localAdmin_$eq(this.createLocalAdmin());
        this.remoteNetworkClient_$eq((Option<RemoteNetworkClient>)new Some((Object)this.createRemoteAdmin()));
        this.maybeCreatePersistentConnection();
    }

    public RemoteNetworkClient createRemoteAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        ClusterLinkMetadata metadata = new ClusterLinkMetadata(this.brokerConfig, super.linkData().linkName(), super.linkData().linkId(), config.linkMode(), Predef$.MODULE$.Long2long(config.metadataRefreshBackoffMs()), Predef$.MODULE$.Long2long(config.metadataMaxAgeMs()));
        java.util.List addresses = ClientUtils.parseAndValidateAddresses(config.bootstrapServersToConnect(), (ClientDnsLookup)config.dnsLookup());
        metadata.bootstrap(addresses);
        ClusterLinkMetadataThread metadataRefreshThread = new ClusterLinkMetadataThread(this.brokerConfig, config, (Option<ClusterLinkConnectionManager>)None$.MODULE$, metadata, this.metrics.metrics(), this.selectorMetricsRegistry, ClusterLinkClientType$OutboundConnectionAdmin$.MODULE$, this.quota, this.clusterLinkChannelContext, this.time);
        metadataRefreshThread.addCoordinatorListener(this);
        metadataRefreshThread.start();
        NetworkClient networkClient = (NetworkClient)metadataRefreshThread.clusterLinkClient().networkClient();
        networkClient.enableClusterLinkReverseConnectionAdmin(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.reversalData(), (ReverseNode.ReverseCallback)this);
        return new RemoteNetworkClient(networkClient, metadataRefreshThread);
    }

    public ConfluentAdmin createLocalAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Creating local admin for reverse connections from source cluster on listener ").append(this.linkListenerEndpoint()).toString());
        java.util.Map<String, Object> adminConfigs = config.localLinkClientConfigs(this.brokerConfig, this.linkListenerEndpoint(), super.linkData().tenantPrefix().nonEmpty());
        adminConfigs.put("client.id", new StringBuilder(38).append("cluster-link-").append(super.linkData().linkName()).append("-local-source-conn-admin-").append(this.brokerConfig.brokerId()).toString());
        return (ConfluentAdmin)Admin.create(adminConfigs);
    }

    private void updateLinkListener(ClusterLinkConfig config) {
        this.linkListenerEndpoint_$eq(ClusterLinkUtils$.MODULE$.linkListenerEndpoint(super.linkData().tenantPrefix(), config, this.serverInfo, this.localReverseConnectionListenerMap()));
        this.linkListenerName_$eq(new ListenerName((String)this.linkListenerEndpoint().listenerName().orElseThrow(() -> new IllegalStateException("Listener name not set"))));
    }

    private ReverseConnectionRequestData reversalData() {
        Endpoint endpoint = this.linkListenerEndpoint();
        return new ReverseConnectionRequestData().setClusterLinkId(this.linkId()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Remote cluster id not known");
        })).setSourceClusterId(super.localLogicalCluster()).setSourceBrokerId(this.brokerConfig.brokerId()).setSourceHost(endpoint.host()).setSourcePort(endpoint.port());
    }

    private void maybeCreatePersistentConnection() {
        if (this.isLinkCoordinator()) {
            this.remoteNetworkClient().foreach((Function1 & Serializable)client -> {
                ClusterLinkOutboundConnectionManager.$anonfun$maybeCreatePersistentConnection$1(this, client);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void maybeCreatePersistentConnection(Node coordinator) {
        if (!Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)coordinator.id()))).exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$maybeCreatePersistentConnection$3(x$9)))) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Creating persistent connection to remote link coordinator ").append(coordinator).toString());
            InitiateReverseConnectionsRequestData requestData = new InitiateReverseConnectionsRequestData().setClusterLinkId(new Uuid(super.linkData().linkId().getMostSignificantBits(), super.linkData().linkId().getLeastSignificantBits())).setForwardToBroker(false).setTimeoutMs(Predef$.MODULE$.Integer2int(this.currentConfig().reverseConnectionSetupTimeoutMs())).setSourceClusterId(super.localLogicalCluster()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("Remote cluster id not known");
            })).setEntries(Collections.singletonList(new InitiateReverseConnectionsRequestData.EntryData().setInitiateRequestId(-1).setSourceBrokerId(this.brokerConfig.brokerId()).setTargetBrokerId(coordinator.id())));
            CompletableFuture future = new CompletableFuture();
            this.forwardToSourceBrokers(requestData, (Seq<CompletableFuture<Void>>)new .colon.colon(future, (List)Nil$.MODULE$));
            future.whenComplete((x0$1, x1$1) -> {
                if (x1$1 != null) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to create persistent reverse connection", (Function0<Throwable>)(Function0 & Serializable)() -> x1$1);
                    this.requestMetadataUpdate();
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Successfully created persistent connection to ").append(coordinator).append("  for ").append(requestData).toString());
            });
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Not creating persistent connection, remoteController=").append(coordinator).append(", persistentConnections=").append(this.persistentConnections()).toString());
    }

    private void requestMetadataUpdate() {
        if (this.isActive()) {
            try {
                this.remoteNetworkClient().foreach((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)ClusterLinkOutboundConnectionManager.$anonfun$requestMetadataUpdate$1(x$10)));
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to request metadata refresh", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
        }
    }

    private void closePersistentConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Closing persistent connections");
            ((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.persistentConnections()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$closePersistentConnections$2(this, x0$1)))).foreach((Function1 & Serializable)x0$2 -> {
                ClusterLinkOutboundConnectionManager.$anonfun$closePersistentConnections$3(this, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void closeActiveReverseConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Closing active reverse connections");
            ((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.activeReverseConnections()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$closeActiveReverseConnections$2(this, x0$1)))).foreach((Function1 & Serializable)x0$2 -> {
                ClusterLinkOutboundConnectionManager.$anonfun$closeActiveReverseConnections$3(this, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private int socketChannelKey(SocketChannel socketChannel) {
        return System.identityHashCode(socketChannel);
    }

    public boolean closeReverseChannel(ReverseChannel reverseChannel) {
        if (!reverseChannel.maybeClose()) {
            SocketChannel socketChannel = reverseChannel.socketChannel();
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(122).append("Runnable to close reverse channel '").append(reverseChannel).append("' not set. Channel may not have been added to SocketServer yet, closing socket channel.").toString());
                reverseChannel.socketChannel().close();
            }
            catch (Exception e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Failed to close socket channel ").append(socketChannel).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            }
            return true;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(83).append("Close initiated for reverse channel '").append(reverseChannel).append("', the channel will be closed by SocketServer.").toString());
        return false;
    }

    public Option<ClusterLinkMetadataThread> metadataThread() {
        return this.remoteNetworkClient().map((Function1 & Serializable)x$11 -> x$11.metadataRefreshThread());
    }

    @Override
    public int persistentConnectionCount() {
        return this.persistentConnections().size();
    }

    @Override
    public int reverseConnectionCount() {
        return this.activeReverseConnections().size();
    }

    public Seq<LazyResource<?>> lazyResources() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static final /* synthetic */ boolean $anonfun$onReverseConnection$4(ReverseChannel x$5) {
        return x$5.socketChannel().isConnected();
    }

    public static final /* synthetic */ boolean $anonfun$forwardToSourceBrokers$10(int brokerId$1, scala.collection.immutable.Map resultFutures$1, InitiateReverseConnectionsRequestData.EntryData entry) {
        NetworkException e = new NetworkException(new StringBuilder(39).append("Source broker with id ").append(brokerId$1).append(" is not available").toString());
        return ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId()))).completeExceptionally((Throwable)e);
    }

    public static final /* synthetic */ void $anonfun$forwardToSourceBrokers$4(ClusterLinkOutboundConnectionManager $this, InitiateReverseConnectionsRequestData requestData$1, ConfluentAdmin admin$1, scala.collection.immutable.Map resultFutures$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            int brokerId = x0$2._1$mcI$sp();
            Buffer entries = (Buffer)x0$2._2();
            if (brokerId == -1 || $this.brokerConfig.brokerId() == brokerId || $this.metadataManager.isBrokerOnline(brokerId)) {
                InitiateReverseConnectionsRequestData brokerRequest = new InitiateReverseConnectionsRequestData().setClusterLinkId(requestData$1.clusterLinkId()).setSourceClusterId(requestData$1.sourceClusterId()).setTargetClusterId(requestData$1.targetClusterId()).setForwardToBroker(false).setEntries(CollectionConverters$.MODULE$.BufferHasAsJava(entries).asJava());
                ConfluentAdminUtils.initiateReverseConnections((ConfluentAdmin)admin$1, (InitiateReverseConnectionsRequestData)brokerRequest, (Integer)Predef$.MODULE$.int2Integer(brokerId)).forEach((x0$3, x1$1) -> x1$1.whenComplete((x0$4, x1$2) -> {
                    if (x1$2 != null) {
                        ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x0$3)))).completeExceptionally((Throwable)x1$2);
                        $this.metrics.outboundReverseConnectionFailedSensor().record();
                        $this.metrics.deprecatedSourceReverseConnectionFailedSensor().record();
                        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Connection reversal request to local broker failed for requestId=").append(x0$3).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> x1$2);
                        return;
                    }
                    ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x0$3)))).complete(x0$4);
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Completed initiate reversal request for requestId=").append(x0$3).toString());
                }));
                return;
            }
            entries.foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$forwardToSourceBrokers$10(brokerId, resultFutures$1, entry)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createReverseConnections$4(ReverseChannel x$7) {
        return x$7.socketChannel().isConnected();
    }

    public static final /* synthetic */ void $anonfun$maybeCreatePersistentConnection$1(ClusterLinkOutboundConnectionManager $this, RemoteNetworkClient client) {
        Option<Node> option = client.metadataRefreshThread().remoteLinkCoordinator();
        if (option instanceof Some) {
            Node coordinator = (Node)((Some)option).value();
            $this.maybeCreatePersistentConnection(coordinator);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> "Remote coordinator not known, request metadata");
            $this.requestMetadataUpdate();
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$maybeCreatePersistentConnection$3(ReverseChannel x$9) {
        return x$9.socketChannel().isConnected();
    }

    public static final /* synthetic */ int $anonfun$requestMetadataUpdate$1(RemoteNetworkClient x$10) {
        return x$10.metadataRefreshThread().clusterLinkMetadata().requestUpdate();
    }

    public static final /* synthetic */ boolean $anonfun$closePersistentConnections$2(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$1._2();
            return $this.closeReverseChannel(reverseChannel);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$closePersistentConnections$3(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$2._2();
            $this.onConnectionClose(reverseChannel.channel(), reverseChannel.reverseNode().requestId(), reverseChannel.reverseNode().remoteBrokerId(), false);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeActiveReverseConnections$2(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$1._2();
            return $this.closeReverseChannel(reverseChannel);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$closeActiveReverseConnections$3(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$2._2();
            $this.onConnectionClose(reverseChannel.channel(), reverseChannel.reverseNode().requestId(), reverseChannel.reverseNode().remoteBrokerId(), false);
            return;
        }
        throw new MatchError(null);
    }

    public ClusterLinkOutboundConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, Option<ClientInterceptor> clientInterceptor, ClusterLinkMetrics metrics, ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry, ClusterLinkMetadataManager metadataManager, SocketServer socketServer, KafkaConfig brokerConfig, AuthorizerServerInfo serverInfo, ClusterLinkRequestQuota quota, Option<ClusterLinkChannelContext> clusterLinkChannelContext, Time time, boolean enableReverseConnections) {
        this.initialConfig = initialConfig;
        this.clientInterceptor = clientInterceptor;
        this.metrics = metrics;
        this.selectorMetricsRegistry = selectorMetricsRegistry;
        this.metadataManager = metadataManager;
        this.socketServer = socketServer;
        this.brokerConfig = brokerConfig;
        this.serverInfo = serverInfo;
        this.quota = quota;
        this.clusterLinkChannelContext = clusterLinkChannelContext;
        this.time = time;
        this.enableReverseConnections = enableReverseConnections;
        super(linkData, initialConfig, localLogicalCluster, metadataManager, metrics, brokerConfig);
        this.connectionUpdateLock = new Object();
        this.persistentConnections = new ConcurrentHashMap();
        this.activeReverseConnections = new ConcurrentHashMap();
        this.localReverseConnectionListenerMap = brokerConfig.clusterLinkLocalReverseConnectionListenerMap();
        this.remoteNetworkClient = None$.MODULE$;
        this.logIdent_$eq(new StringBuilder(48).append("[ClusterLinkOutboundConnectionManager-").append(super.linkData().linkName()).append("-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        if (enableReverseConnections) {
            this.updateLinkListener(initialConfig);
        }
    }
}

