/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkPreparePendingRestoreMirrorsTaskType$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.internals.OffsetForLeaderEpochOptions;
import org.apache.kafka.clients.admin.internals.OffsetForLeaderEpochResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r=a\u0001B\u001d;\u0001\u0005C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t1\u0002\u0011\t\u0011)A\u00053\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003^\u0011%\t\u0007A!A!\u0002\u0013\u0011w\u000eC\u0005q\u0001\t\u0005\t\u0015!\u0003rk\"Ia\u000f\u0001B\u0001B\u0003%qo\u001f\u0005\u0006{\u0002!\tA \u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0002C\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0002bCA\u0018\u0001\u0001\u0007\t\u0011)Q\u0005\u0003'A1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00024!Y\u00111\b\u0001A\u0002\u0003\u0007I\u0011BA\u001f\u0011-\t\t\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u000e\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0003\u0002CA+\u0001\u0001\u0006I!a\u0012\t\u0013\u0005]\u0003\u00011A\u0005\n\u0005e\u0003\"CA1\u0001\u0001\u0007I\u0011BA2\u0011!\t9\u0007\u0001Q!\n\u0005m\u0003\"CA5\u0001\u0001\u0007I\u0011BA-\u0011%\tY\u0007\u0001a\u0001\n\u0013\ti\u0007\u0003\u0005\u0002r\u0001\u0001\u000b\u0015BA.\u0011%\t\u0019\b\u0001a\u0001\n\u0013\tI\u0006C\u0005\u0002v\u0001\u0001\r\u0011\"\u0003\u0002x!A\u00111\u0010\u0001!B\u0013\tY\u0006C\u0005\u0002~\u0001\u0011\r\u0011\"\u0003\u0002\u0000!A\u0011q\u0011\u0001!\u0002\u0013\t\t\tC\u0005\u0002\n\u0002\u0011\r\u0011\"\u0003\u0002\f\"A\u00111\u0013\u0001!\u0002\u0013\ti\tC\u0005\u0002\u0016\u0002\u0011\r\u0011\"\u0003\u0002\u0018\"A\u0011Q\u0015\u0001!\u0002\u0013\tI\nC\u0005\u0002(\u0002\u0011\r\u0011\"\u0003\u0002*\"A\u0011Q\u0016\u0001!\u0002\u0013\tY\u000bC\u0005\u00020\u0002\u0001\r\u0011\"\u0003\u00022\"I\u0011q\u0018\u0001A\u0002\u0013%\u0011\u0011\u0019\u0005\t\u0003\u000b\u0004\u0001\u0015)\u0003\u00024\"A\u0011q\u001a\u0001\u0005Ri\n\t\u000eC\u0004\u0002h\u0002!I!!;\t\u000f\u0005U\b\u0001\"\u0003\u0002x\"9\u0011q \u0001\u0005\n\t\u0005\u0001b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u0011!\u0011)\u0005\u0001C\tu\t\u001d\u0003b\u0002B*\u0001\u0011%!Q\u000b\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011i\t\u0001C\u0005\u0005\u001fCqAa+\u0001\t\u0013\u0011i\u000bC\u0004\u0003<\u0002!IA!0\t\u000f\tE\u0007\u0001\"\u0003\u0003T\"9!q\u001b\u0001\u0005B\te\u0007b\u0002Bi\u0001\u0011E#1\u001c\u0005\u000e\u0005K\u0004\u0001\u0013aA\u0001\u0002\u0013%!q]>\b\u0013\t%((!A\t\u0002\t-h\u0001C\u001d;\u0003\u0003E\tA!<\t\ru4D\u0011\u0001B{\u0011%\u00119PNI\u0001\n\u0003\u0011IP\u0001\u0014DYV\u001cH/\u001a:MS:\\\u0007K]3qCJ,\u0007+\u001a8eS:<'+Z:u_J,W*\u001b:s_JT!a\u000f\u001f\u0002\t1Lgn\u001b\u0006\u0003{y\naa]3sm\u0016\u0014(\"A \u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0011\t\u0003\u0007\u001es!\u0001R#\u000e\u0003iJ!A\u0012\u001e\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\tA\u0015J\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u0002Gu\u0005)Ao\u001c9jGB\u0011A*\u0016\b\u0003\u001bN\u0003\"AT)\u000e\u0003=S!\u0001\u0015!\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+R\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u000b\u0016!D2mS\u0016tG/T1oC\u001e,'\u000f\u0005\u0002E5&\u00111L\u000f\u0002\u001d\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u0003)awnY1m\u0003\u0012l\u0017N\u001c\t\u0003\tzK!a\u0018\u001e\u0003+\rcWo\u001d;fe2Kgn\u001b\"bi\u000eD\u0017\tZ7j]\u0006Y!/Z7pi\u0016\fE-\\5o\u0003\u0011!\u0018.\\3\u0011\u0005\rlW\"\u00013\u000b\u0005\u00154\u0017!B;uS2\u001c(BA4i\u0003\u0019\u0019w.\\7p]*\u0011q(\u001b\u0006\u0003U.\fa!\u00199bG\",'\"\u00017\u0002\u0007=\u0014x-\u0003\u0002oI\n!A+[7f\u0013\t\tw)A\u0003rk>$\u0018\r\u0005\u0002sg6\tA(\u0003\u0002uy\t92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0005\u0003a\u001e\u000b!\"\u001b8uKJ4\u0018\r\\'t!\tA\u00180D\u0001R\u0013\tQ\u0018KA\u0002J]RL!\u0001`$\u0002#I,7o\u00195fIVdW\rR3mCfl5/\u0001\u0004=S:LGO\u0010\u000b\u0010\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\tI!a\u0003\u0002\u000eA\u0011A\t\u0001\u0005\u0006\u0015\"\u0001\ra\u0013\u0005\u00061\"\u0001\r!\u0017\u0005\u00069\"\u0001\r!\u0018\u0005\u0006A\"\u0001\r!\u0018\u0005\u0006C\"\u0001\rA\u0019\u0005\u0006a\"\u0001\r!\u001d\u0005\bm\"\u0001\n\u00111\u0001x\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\u0003'\u0001R\u0001TA\u000b\u00033I1!a\u0006X\u0005\r\u0019V\r\u001e\t\u0005\u00037\ti\"D\u0001g\u0013\r\tyB\u001a\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u00039\u0001\u0018M\u001d;ji&|gn]0%KF$B!!\n\u0002,A\u0019\u00010a\n\n\u0007\u0005%\u0012K\u0001\u0003V]&$\b\"CA\u0017\u0015\u0005\u0005\t\u0019AA\n\u0003\rAH%M\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b%A\u0007sK6|G/\u001a+pa&\u001c\u0017\nZ\u000b\u0003\u0003k\u0001B!a\u0007\u00028%\u0019\u0011\u0011\b4\u0003\tU+\u0018\u000eZ\u0001\u0012e\u0016lw\u000e^3U_BL7-\u00133`I\u0015\fH\u0003BA\u0013\u0003\u007fA\u0011\"!\f\u000e\u0003\u0003\u0005\r!!\u000e\u0002\u001dI,Wn\u001c;f)>\u0004\u0018nY%eA\u0005\u00192m\\7qY\u0016$X\r\u001a)beRLG/[8ogV\u0011\u0011q\t\t\u0007\u0003\u0013\n\u0019&!\u0007\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\nq!\\;uC\ndWMC\u0002\u0002RE\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9\"a\u0013\u0002)\r|W\u000e\u001d7fi\u0016$\u0007+\u0019:uSRLwN\\:!\u0003uIg.\u001b;jC2$Um]2sS\n,Gk\u001c9jG\u000eCWmY6E_:,WCAA.!\rA\u0018QL\u0005\u0004\u0003?\n&a\u0002\"p_2,\u0017M\\\u0001\"S:LG/[1m\t\u0016\u001c8M]5cKR{\u0007/[2DQ\u0016\u001c7\u000eR8oK~#S-\u001d\u000b\u0005\u0003K\t)\u0007C\u0005\u0002.I\t\t\u00111\u0001\u0002\\\u0005q\u0012N\\5uS\u0006dG)Z:de&\u0014W\rV8qS\u000e\u001c\u0005.Z2l\t>tW\rI\u0001\u001cM&t\u0017\r\u001c#fg\u000e\u0014\u0018NY3U_BL7m\u00115fG.$uN\\3\u0002?\u0019Lg.\u00197EKN\u001c'/\u001b2f)>\u0004\u0018nY\"iK\u000e\\Gi\u001c8f?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005=\u0004\"CA\u0017+\u0005\u0005\t\u0019AA.\u0003q1\u0017N\\1m\t\u0016\u001c8M]5cKR{\u0007/[2DQ\u0016\u001c7\u000eR8oK\u0002\nAC]3n_R,wJ\u001a4tKR\u001ch)\u001a;dQ\u0016$\u0017\u0001\u0007:f[>$Xm\u00144gg\u0016$8OR3uG\",Gm\u0018\u0013fcR!\u0011QEA=\u0011%\ti\u0003GA\u0001\u0002\u0004\tY&A\u000bsK6|G/Z(gMN,Go\u001d$fi\u000eDW\r\u001a\u0011\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ,\"!!!\u0011\u0007\u0011\u000b\u0019)C\u0002\u0002\u0006j\u0012!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f\u0001#\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002/\u0015D8-Z:tSZ,Gj\\4hS:<\u0007*\u00198eY\u0016\u0014XCAAG!\r!\u0015qR\u0005\u0004\u0003#S$aF#yG\u0016\u001c8/\u001b<f\u0019><w-\u001b8h\u0011\u0006tG\r\\3s\u0003a)\u0007pY3tg&4X\rT8hO&tw\rS1oI2,'\u000fI\u0001\u0013a\u0006\u0014H/\u001b;j_:\u001cHk\\(gMN,G/\u0006\u0002\u0002\u001aBA\u0011\u0011JAN\u00033\ty*\u0003\u0003\u0002\u001e\u0006-#aA'baB\u0019\u00010!)\n\u0007\u0005\r\u0016K\u0001\u0003M_:<\u0017a\u00059beRLG/[8ogR{wJ\u001a4tKR\u0004\u0013!\u00059beRLG/[8ogR{W\t]8dQV\u0011\u00111\u0016\t\b\u0003\u0013\nY*!\u0007x\u0003I\u0001\u0018M\u001d;ji&|gn\u001d+p\u000bB|7\r\u001b\u0011\u0002\u0011Q\f7o\u001b#fg\u000e,\"!a-\u0011\u000ba\f),!/\n\u0007\u0005]\u0016K\u0001\u0004PaRLwN\u001c\t\u0004\t\u0006m\u0016bAA_u\tyA+Y:l\t\u0016\u001c8M]5qi&|g.\u0001\u0007uCN\\G)Z:d?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005\r\u0007\"CA\u0017G\u0005\u0005\t\u0019AAZ\u0003%!\u0018m]6EKN\u001c\u0007\u0005K\u0002%\u0003\u0013\u00042\u0001_Af\u0013\r\ti-\u0015\u0002\tm>d\u0017\r^5mK\u0006\u0019!/\u001e8\u0015\u0005\u0005M\u0007\u0003BAk\u0003Gt1!a6F\u001d\u0011\tI.!9\u000f\t\u0005m\u0017q\u001c\b\u0004\u001d\u0006u\u0017\"A \n\u0005ur\u0014BA\u001e=\u0013\r\t)/\u0013\u0002\u000b)\u0006\u001c8NU3tk2$\u0018A\u0003;sC:\u001c\u0018\u000e^5p]R!\u00111[Av\u0011\u001d\tiO\na\u0001\u0003_\f1\u0002^1tW\u000e{g\u000e^3yiB!\u0011Q[Ay\u0013\r\t\u00190\u0013\u0002\f)\u0006\u001c8nQ8oi\u0016DH/A\neKN\u001c'/\u001b2f'>,(oY3U_BL7\r\u0006\u0004\u0002T\u0006e\u00181 \u0005\b\u0003[<\u0003\u0019AAx\u0011\u001d\tip\na\u0001\u00037\nA\"\u001b8ji&\fGn\u00115fG.\fq\u0004[1oI2,G)Z:de&\u0014WmU8ve\u000e,Gk\u001c9jGJ+7/\u001e7u)!\t\u0019Na\u0001\u0003\u0006\t\u001d\u0001bBAwQ\u0001\u0007\u0011q\u001e\u0005\b\u0003{D\u0003\u0019AA.\u0011\u001d\u0011I\u0001\u000ba\u0001\u0005\u0017\t1\u0002^8qS\u000e\u0014Vm];miB9!Q\u0002B\f\u0017\neQB\u0001B\b\u0015\u0011\u0011\tBa\u0005\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005+\tAA[1wC&!\u0011Q\u0014B\b!\u0019\tYBa\u0007\u0003 %\u0019!Q\u00044\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0005\u0005C\u0011Y#\u0004\u0002\u0003$)!!Q\u0005B\u0014\u0003\u0015\tG-\\5o\u0015\r\u0011I\u0003[\u0001\bG2LWM\u001c;t\u0013\u0011\u0011iCa\t\u0003!Q{\u0007/[2EKN\u001c'/\u001b9uS>t\u0017a\u00044bS2l\u0015N\u001d:peR{\u0007/[2\u0015\t\u0005M'1\u0007\u0005\b\u0003[L\u0003\u0019AAx\u0003YA\u0017M\u001c3mK\u001a\u000b\u0017\u000e\\'jeJ|'OU3tk2$HCBAj\u0005s\u0011Y\u0004C\u0004\u0002n*\u0002\r!a<\t\u000f\tu\"\u00061\u0001\u0003@\u00051!/Z:vYR\u0004BA!\t\u0003B%!!1\tB\u0012\u0005I\tE\u000e^3s\u001b&\u0014(o\u001c:t%\u0016\u001cX\u000f\u001c;\u0002)\u001d,G\u000fU1si&$\u0018n\u001c8U_>3gm]3u+\t\u0011I\u0005\u0005\u0005\u0003L\tE\u0013\u0011DAP\u001b\t\u0011iE\u0003\u0003\u0003P\u0005=\u0013!C5n[V$\u0018M\u00197f\u0013\u0011\tiJ!\u0014\u00029=4gm]3ug\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3tiR\u0011!q\u000b\t\u0007\u0005\u001b\u0011IF!\u0018\n\t\tm#q\u0002\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003\u0002B0\u0005{rAA!\u0019\u0003x9!!1\rB:\u001d\u0011\u0011)G!\u001d\u000f\t\t\u001d$q\u000e\b\u0005\u0005S\u0012iGD\u0002O\u0005WJ\u0011\u0001\\\u0005\u0003U.L!aP5\n\u0005\u001dD\u0017b\u0001B;M\u00069Q.Z:tC\u001e,\u0017\u0002\u0002B=\u0005w\nqd\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$H)\u0019;b\u0015\r\u0011)HZ\u0005\u0005\u0005\u007f\u0012\tI\u0001\u000bPM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s)>\u0004\u0018n\u0019\u0006\u0005\u0005s\u0012Y(A\u000bpM\u001a\u001cX\r^:G_JdU-\u00193fe\u0016\u0003xn\u00195\u0015\r\u0005M'q\u0011BE\u0011\u001d\ti/\fa\u0001\u0003_DqAa#.\u0001\u0004\u00119&A\u0006sKF,Xm\u001d;ECR\f\u0017!\t5b]\u0012dWm\u00144gg\u0016$8OR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3tk2$HCBAj\u0005#\u0013\u0019\nC\u0004\u0002n:\u0002\r!a<\t\u000f\tUe\u00061\u0001\u0003\u0018\u0006QQM\u001c3PM\u001a\u001cX\r^:\u0011\u0011\t5!qCA\r\u00053\u0003b!a\u0007\u0003\u001c\tm\u0005\u0003\u0002BO\u0005KsAAa(\u0003\"6\u0011!1P\u0005\u0005\u0005G\u0013Y(\u0001\u0011PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3ECR\f\u0017\u0002\u0002BT\u0005S\u0013a\"\u00129pG\",e\u000eZ(gMN,GO\u0003\u0003\u0003$\nm\u0014!H2p]Z,'\u000f\u001e+p!\u0016tG-\u001b8h%\u0016\u001cHo\u001c:f\u001b&\u0014(o\u001c:\u0015\r\u0005M'q\u0016BY\u0011\u001d\tio\fa\u0001\u0003_DqAa-0\u0001\u0004\u0011),\u0001\nnSJ\u0014xN]*uCJ$xJ\u001a4tKR\u001c\bC\u0002B&\u0005o\u000by*\u0003\u0003\u0003:\n5#aA*fc\u0006I\u0003.\u00198eY\u0016\u001cuN\u001c<feR$v\u000eU3oI&twMU3ti>\u0014X-T5se>\u0014(+Z:vYR$b!a5\u0003@\n\u0005\u0007bBAwa\u0001\u0007\u0011q\u001e\u0005\b\u0005{\u0001\u0004\u0019\u0001Bb!\u0019\tYBa\u0007\u0003FB!!q\u0019Bg\u001b\t\u0011IM\u0003\u0003\u0003L\nM\u0011\u0001\u00027b]\u001eLAAa4\u0003J\n!ak\\5e\u00031ygnQ8na2,G/[8o)\u0011\t\u0019N!6\t\u000f\u00055\u0018\u00071\u0001\u0002p\u0006yA/Y:l\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0002\u00024R!\u0011Q\u0005Bo\u0011\u001d\u0011id\ra\u0001\u0005?\u00042a\u0011Bq\u0013\r\u0011\u0019/\u0013\u0002\u0014\u0007>l\u0007\u000f\\3uK\u0012$\u0016m]6SKN,H\u000e^\u0001\u0018gV\u0004XM\u001d\u0013sKN\u001c\u0007.\u001a3vY\u0016$U\r\\1z\u001bN,\u0012a^\u0001'\u00072,8\u000f^3s\u0019&t7\u000e\u0015:fa\u0006\u0014X\rU3oI&twMU3ti>\u0014X-T5se>\u0014\bC\u0001#7'\r1$q\u001e\t\u0004q\nE\u0018b\u0001Bz#\n1\u0011I\\=SK\u001a$\"Aa;\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011YPK\u0002x\u0005{\\#Aa@\u0011\t\r\u000511B\u0007\u0003\u0007\u0007QAa!\u0002\u0004\b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u0013\t\u0016AC1o]>$\u0018\r^5p]&!1QBB\u0002\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ClusterLinkPreparePendingRestoreMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private scala.collection.immutable.Set<TopicPartition> partitions;
    private Uuid remoteTopicId;
    private final Set<TopicPartition> completedPartitions;
    private boolean initialDescribeTopicCheckDone;
    private boolean finalDescribeTopicCheckDone;
    private boolean remoteOffsetsFetched;
    private final ClusterLinkMetadataManager metadataManager;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private final scala.collection.mutable.Map<TopicPartition, Object> partitionsToOffset;
    private final scala.collection.mutable.Map<TopicPartition, Object> partitionsToEpoch;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$7() {
        return 5000;
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private scala.collection.immutable.Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(scala.collection.immutable.Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private Uuid remoteTopicId() {
        return this.remoteTopicId;
    }

    private void remoteTopicId_$eq(Uuid x$1) {
        this.remoteTopicId = x$1;
    }

    private Set<TopicPartition> completedPartitions() {
        return this.completedPartitions;
    }

    private boolean initialDescribeTopicCheckDone() {
        return this.initialDescribeTopicCheckDone;
    }

    private void initialDescribeTopicCheckDone_$eq(boolean x$1) {
        this.initialDescribeTopicCheckDone = x$1;
    }

    private boolean finalDescribeTopicCheckDone() {
        return this.finalDescribeTopicCheckDone;
    }

    private void finalDescribeTopicCheckDone_$eq(boolean x$1) {
        this.finalDescribeTopicCheckDone = x$1;
    }

    private boolean remoteOffsetsFetched() {
        return this.remoteOffsetsFetched;
    }

    private void remoteOffsetsFetched_$eq(boolean x$1) {
        this.remoteOffsetsFetched = x$1;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private scala.collection.mutable.Map<TopicPartition, Object> partitionsToOffset() {
        return this.partitionsToOffset;
    }

    private scala.collection.mutable.Map<TopicPartition, Object> partitionsToEpoch() {
        return this.partitionsToEpoch;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)Seq$.MODULE$.empty()));
        this.partitions_$eq(this.metadataManager().topicPartitions(this.topic));
        if (this.partitions().isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Cannot restore mirror topic '").append($this.topic).append("' since it is deleted - shutting down task.").toString());
            return this.onCompletion(taskContext);
        }
        Option mirrorState = this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).get((Object)this.topic);
        boolean bl = false;
        Some some = null;
        if (mirrorState instanceof Some) {
            bl = true;
            some = (Some)mirrorState;
            ClusterLinkTopicState clusterLinkTopicState = (ClusterLinkTopicState)some.value();
            if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingSetupForRestoreMirror) {
                ClusterLinkTopicState.PendingSetupForRestoreMirror pendingSetupForRestoreMirror = (ClusterLinkTopicState.PendingSetupForRestoreMirror)clusterLinkTopicState;
                Uuid sourceTopicId = pendingSetupForRestoreMirror.sourceTopicId();
                Seq<Object> epochs = pendingSetupForRestoreMirror.truncationEpochs();
                Seq<Object> offsets = pendingSetupForRestoreMirror.truncationOffsets();
                if (epochs == null || epochs.isEmpty()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(103).append("Mirror topic '").append($this.topic).append(" has invalid truncationEpochs', shutting down ClusterLinkPreparePendingRestoreMirror task").toString());
                    return this.onCompletion(taskContext);
                }
                if (offsets == null || offsets.isEmpty()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(104).append("Mirror topic '").append($this.topic).append(" has invalid truncationOffsets', shutting down ClusterLinkPreparePendingRestoreMirror task").toString());
                    return this.onCompletion(taskContext);
                }
                this.remoteTopicId_$eq(sourceTopicId);
                this.partitions().foreach((Function1 & Serializable)tp -> {
                    this.partitionsToEpoch().put(tp, epochs.apply(tp.partition()));
                    return this.partitionsToOffset().put(tp, offsets.apply(tp.partition()));
                });
                return this.transition(taskContext);
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("See mirror '").append(state).append("' for mirror topic '").append($this.topic).append("', shutting down ClusterLinkPreparePendingRestoreMirror task").toString());
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(mirrorState)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(94).append("No mirror state for mirror topic '").append($this.topic).append("', shutting down ClusterLinkPreparePendingRestoreMirror task").toString());
            return this.onCompletion(taskContext);
        }
        throw new MatchError((Object)mirrorState);
    }

    private ClusterLinkScheduler.TaskResult transition(ClusterLinkScheduler.TaskContext taskContext) {
        if (!this.initialDescribeTopicCheckDone()) {
            return this.describeSourceTopic(taskContext, true);
        }
        if (!this.remoteOffsetsFetched()) {
            return this.offsetsForLeaderEpoch(taskContext, this.offsetsForLeaderEpochRequest());
        }
        if (!this.finalDescribeTopicCheckDone()) {
            return this.describeSourceTopic(taskContext, false);
        }
        List mirrorStartOffsets = ((List)this.partitionsToOffset().toList().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ClusterLinkPreparePendingRestoreMirror.$anonfun$transition$1(x0$1)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)ClusterLinkPreparePendingRestoreMirror.$anonfun$transition$2(x0$2)));
        return this.convertToPendingRestoreMirror(taskContext, (scala.collection.immutable.Seq<Object>)mirrorStartOffsets);
    }

    private ClusterLinkScheduler.TaskResult describeSourceTopic(ClusterLinkScheduler.TaskContext taskContext, boolean initialCheck) {
        DescribeTopicsResult describeRemoteTopic = this.remoteAdmin.describeTopics(Collections.singletonList(this.topic));
        this.scheduleWhenComplete(describeRemoteTopic.allTopicNames(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleDescribeSourceTopicResult((ClusterLinkScheduler.TaskContext)tc, initialCheck, describeRemoteTopic.topicNameValues()), taskContext));
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleDescribeSourceTopicResult(ClusterLinkScheduler.TaskContext taskContext, boolean initialCheck, Map<String, KafkaFuture<TopicDescription>> topicResult) {
        try {
            Uuid topicId = ((TopicDescription)topicResult.get(this.topic).get()).topicId();
            if (!topicId.equals((Object)this.remoteTopicId())) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(84).append("Remote topic id ").append(topicId).append(" does not match the expected remote topic id ").append(this.remoteTopicId()).append(". Failing mirror topic ").append($this.topic).toString());
                this.failMirrorTopic(taskContext);
            } else if (initialCheck) {
                this.initialDescribeTopicCheckDone_$eq(true);
            } else {
                this.finalDescribeTopicCheckDone_$eq(true);
            }
            return this.transition(taskContext);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UnknownTopicOrPartitionException) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Topic ").append($this.topic).append(" was not found on remote cluster. Failing mirror topic").toString());
                return this.failMirrorTopic(taskContext);
            }
            String errorString = new StringBuilder(78).append("Failed to retrieve source topic information for topic ").append(this.topic).append(". Retrying the task in ").append(super.rescheduleDelayMs()).append(".").toString();
            ApiException ex = ClusterLinkUtils$.MODULE$.apiException(e, errorString);
            this.excessiveLoggingHandler().handle(ex, this, new StringBuilder(76).append("Encountered exception when trying to describe remote topic ").append(this.topic).append(". Will retry in ").append(super.rescheduleDelayMs()).append(".").toString());
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errorString, false, e), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
    }

    private ClusterLinkScheduler.TaskResult failMirrorTopic(ClusterLinkScheduler.TaskContext taskContext) {
        AlterMirrorsResult result = this.localAdmin.failMirror(this.topic, MirrorTopicError.SOURCE_TOPIC_ID_CHANGED);
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleFailMirrorResult((ClusterLinkScheduler.TaskContext)tc, result), taskContext));
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleFailMirrorResult(ClusterLinkScheduler.TaskContext taskContext, AlterMirrorsResult result) {
        try {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(83).append("Failing mirror topic ").append($this.topic).append(" due to issues encountered when trying to restore mirror topic").toString());
            result.all().get();
            return this.onCompletion(taskContext);
        }
        catch (ExecutionException e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(146).append("Unable to fail local mirror topic ").append($this.topic).append(", shutting down task. Please execute the failover command").append(" on the local mirror topic to make the topic writable: ").append(e).toString());
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(new StringBuilder(38).append("Failed to fail the local mirror topic ").append(this.topic).toString(), true, e), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
    }

    public scala.collection.immutable.Map<TopicPartition, Object> getPartitionToOffset() {
        return this.partitionsToOffset().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Collection<OffsetForLeaderEpochRequestData.OffsetForLeaderTopic> offsetsForLeaderEpochRequest() {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic offsetForLeaderTopic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic();
        ArrayList offsetsForLeaderPartitions = new ArrayList();
        ((scala.collection.immutable.Set)this.partitions().$minus$minus(this.completedPartitions())).foreach((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkPreparePendingRestoreMirror.$anonfun$offsetsForLeaderEpochRequest$1(this, offsetsForLeaderPartitions, tp)));
        offsetForLeaderTopic.setTopic(this.topic).setPartitions(offsetsForLeaderPartitions);
        return Collections.singletonList(offsetForLeaderTopic);
    }

    private ClusterLinkScheduler.TaskResult offsetsForLeaderEpoch(ClusterLinkScheduler.TaskContext taskContext, Collection<OffsetForLeaderEpochRequestData.OffsetForLeaderTopic> requestData) {
        OffsetForLeaderEpochResult offsetsForLeaderEpochResult = this.remoteAdmin.offsetsForLeaderEpoch(requestData, new OffsetForLeaderEpochOptions());
        this.scheduleWhenComplete(offsetsForLeaderEpochResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleOffsetsForLeaderEpochResult((ClusterLinkScheduler.TaskContext)tc, offsetsForLeaderEpochResult.endOffsets()), taskContext));
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleOffsetsForLeaderEpochResult(ClusterLinkScheduler.TaskContext taskContext, Map<TopicPartition, KafkaFuture<OffsetForLeaderEpochResponseData.EpochEndOffset>> endOffsets) {
        HashMap errorPartitions = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        CollectionConverters$.MODULE$.MapHasAsScala(endOffsets).asScala().foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset offset = (OffsetForLeaderEpochResponseData.EpochEndOffset)((KafkaFuture)x0$1._2()).get();
                    if (offset != null && offset.endOffset() != -1L) {
                        this.partitionsToOffset().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)offset.endOffset()));
                    }
                    return BoxesRunTime.boxToBoolean((boolean)this.completedPartitions().add((Object)tp));
                }
                catch (ExecutionException e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Error fetching offset for partition ").append(tp).append(": ").append(e).append(". Will retry this partition in ").append(this.super$rescheduleDelayMs()).append("ms.").toString());
                    return errorPartitions.put((Object)tp, (Object)ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(new StringBuilder(69).append("Failed to fetch the offsetsForLeaderEpochResults").append(" for topic partition ").append(tp).toString(), false, e));
                }
            }
            throw new MatchError(null);
        });
        if (errorPartitions.isEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Successfully fetched offsets for all partitions of topic ").append($this.topic).toString());
            this.remoteOffsetsFetched_$eq(true);
            return this.transition(taskContext);
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(84).append("Got errors when trying fetch offsets for the following partitions' ").append(errorPartitions.keySet().mkString(",")).append(". ").append("Will retry in ").append(this.super$rescheduleDelayMs()).append(".").toString());
        scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)errorPartitions.values().toSeq());
        return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult convertToPendingRestoreMirror(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Seq<Object> mirrorStartOffsets) {
        if (mirrorStartOffsets.size() != this.partitions().size()) {
            String errMsg = new StringBuilder(116).append("The number of truncation offsets for mirror topic ").append(this.topic).append(" differs from the number of the partitions. Retrying the task in ").append(super.rescheduleDelayMs()).append(".").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
            this.remoteOffsetsFetched_$eq(false);
            this.initialDescribeTopicCheckDone_$eq(false);
            this.finalDescribeTopicCheckDone_$eq(false);
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        KafkaFuture convertFuture = this.localAdmin.convertToPendingRestoreMirror(this.topic, mirrorStartOffsets).all();
        this.scheduleWhenComplete(convertFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleConvertToPendingRestoreMirrorResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Void>)convertFuture), taskContext));
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleConvertToPendingRestoreMirrorResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Void> result) {
        try {
            result.get();
            return this.onCompletion(taskContext);
        }
        catch (ExecutionException ex) {
            String errorString = new StringBuilder(105).append("Failed to convert to PendingRestoreMirror state for mirror topic ").append(this.topic).append(". Retrying the ").append("task to convert the state").toString();
            ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, errorString);
            this.excessiveLoggingHandler().handle(e, this, new StringBuilder(76).append("Encountered exception when trying to convert topic to PendingRestoreMirror ").append(this.topic).append(".").toString());
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(new StringBuilder(59).append("Failed to convert to PendingRestoreMirror for mirror topic ").append(this.topic).toString(), true, ex), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
    }

    private ClusterLinkScheduler.TaskResult onCompletion(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Shutting PreparePendingRestoreMirror task for ").append($this.topic).append(".").toString());
        this.shutdown();
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkPreparePendingRestoreMirrorsTaskType$.MODULE$, "convert to PendingRestoreMirror"));
    }

    public static final /* synthetic */ int $anonfun$transition$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((TopicPartition)x0$1._1()).partition();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$transition$2(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._2$mcJ$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$offsetsForLeaderEpochRequest$1(ClusterLinkPreparePendingRestoreMirror $this, java.util.List offsetsForLeaderPartitions$1, TopicPartition tp) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition offsetForLeaderPartition = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(tp.partition()).setLeaderEpoch(BoxesRunTime.unboxToInt((Object)$this.partitionsToEpoch().apply((Object)tp)));
        return offsetsForLeaderPartitions$1.add(offsetForLeaderPartition);
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkPreparePendingRestoreMirror(String topic, ClusterLinkDestClientManager clientManager, ClusterLinkBatchAdmin localAdmin, ClusterLinkBatchAdmin remoteAdmin, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        void apply_now;
        void apply_ttlMs;
        this.topic = topic;
        this.clientManager = clientManager;
        this.localAdmin = localAdmin;
        this.remoteAdmin = remoteAdmin;
        super(clientManager.scheduler(), "ClusterLinkPreparePendingRestoreMirror", intervalMs, time, quota);
        this.completedPartitions = new HashSet();
        this.initialDescribeTopicCheckDone = false;
        this.finalDescribeTopicCheckDone = false;
        this.remoteOffsetsFetched = false;
        this.metadataManager = clientManager.metadataManager();
        ExcessiveLoggingHandler$ apply$default$3_this = ExcessiveLoggingHandler$.MODULE$;
        Object var12_8 = null;
        Function0<Object> function0 = apply$default$3_this.nowDefault();
        long l = ExcessiveLoggingHandler$.MODULE$.ttlMsDefault();
        int apply_capacity = 1000;
        function0 = null;
        this.excessiveLoggingHandler = new ExcessiveLoggingHandler(apply_capacity, (long)apply_ttlMs, (Function0<Object>)apply_now);
        this.partitionsToOffset = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.partitionsToEpoch = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.taskDesc = None$.MODULE$;
    }
}

