/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import kafka.tier.fetcher.offsetcache.FetchOffsetCache;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;

class TierFetcherMetrics {
    private final Metrics metrics;
    private final String metricGroupName = "TierFetcher";
    private final String bytesFetchedPrefix = "BytesFetched";
    private final String fetchExceptionPrefix = "FetchException";
    private final String fetchCancellationPrefix = "FetchCancellation";
    private final String fetchOffsetForTimestampExceptionPrefix = "FetchOffsetForTimestampException";
    private final String fetchOffsetForTimestampCancellationPrefix = "FetchOffsetForTimestampCancellation";
    private final String fetchNonRetriableExceptionPrefix = "FetchNonRetriableException";
    private final String fetchTotalTimeMsPrefix = "FetchTotalTimeMs";
    private final String fetchOffsetForTimestampTotalTimeMsPrefix = "FetchOffsetForTimestampTotalTimeMs";
    private final String queuedTimeMsPrefix = "QueuedTotalTimeMs";
    private final String fetchPartitionCountPrefix = "FetchPartitionCount";
    private final Sensor bytesFetched;
    private final Sensor fetchException;
    private final Sensor fetchCancelled;
    private final Sensor fetchOffsetForTimestampException;
    private final Sensor fetchOffsetForTimestampCancelled;
    private final Sensor fetchNonRetriableException;
    private final Sensor fetchTotalTimeMs;
    private final Sensor fetchOffsetForTimestampTotalTimeMs;
    private final Sensor queuedTimeMs;
    private final Sensor fetchPartitionCount;
    private final String queueSizeName = "QueueSize";
    private final String offsetCacheHitName = "OffsetCacheHitRatio";
    private final String offsetCacheSizeName = "OffsetCacheSize";
    private final List<Sensor> sensors = new ArrayList<Sensor>();
    final MetricName queueSizeMetricName;
    final MetricName bytesFetchedRateMetricName;
    final MetricName bytesFetchedTotalMetricName;
    final MetricName offsetCacheHitMetricName;
    final MetricName offsetCacheSizeMetricName;
    final MetricName fetchExceptionRateMetricName;
    final MetricName fetchExceptionTotalMetricName;
    final MetricName fetchCancellationRateMetricName;
    final MetricName fetchCancellationTotalMetricName;
    final MetricName fetchOffsetForTimestampExceptionRateMetricName;
    final MetricName fetchOffsetForTimestampExceptionTotalMetricName;
    final MetricName fetchOffsetForTimestampCancellationRateMetricName;
    final MetricName fetchOffsetForTimestampCancellationTotalMetricName;
    final MetricName fetchNonRetriableExceptionRateMetricName;
    final MetricName fetchNonRetriableExceptionTotalMetricName;
    final MetricName fetchTotalTimeMs50PercentileMetricName;
    final MetricName fetchTotalTimeMs90PercentileMetricName;
    final MetricName fetchTotalTimeMs99PercentileMetricName;
    final MetricName fetchOffsetForTimestampTotalTimeMs50PercentileMetricName;
    final MetricName fetchOffsetForTimestampTotalTimeMs90PercentileMetricName;
    final MetricName fetchOffsetForTimestampTotalTimeMs99PercentileMetricName;
    final MetricName queuedTimeMs50PercentileMetricName;
    final MetricName queuedTimeMs90PercentileMetricName;
    final MetricName queuedTimeMs99PercentileMetricName;
    final MetricName fetchPartitionCount50PercentileMetricName;
    final MetricName fetchPartitionCount90PercentileMetricName;
    final MetricName fetchPartitionCount99PercentileMetricName;

    TierFetcherMetrics(Metrics metrics, final ThreadPoolExecutor executor, final FetchOffsetCache cache) {
        this.metrics = metrics;
        this.queueSizeMetricName = metrics.metricName("QueueSize", "TierFetcher", "The number of elements in the TierFetcher executor queue.", Collections.emptyMap());
        this.offsetCacheHitMetricName = metrics.metricName("OffsetCacheHitRatio", "TierFetcher", "TierFetcher offset cache hit ratio", Collections.emptyMap());
        this.offsetCacheSizeMetricName = metrics.metricName("OffsetCacheSize", "TierFetcher", "Number of entries in the TierFetcher offset cache", Collections.emptyMap());
        this.bytesFetched = this.sensor("BytesFetched", new Sensor[0]);
        this.bytesFetchedRateMetricName = metrics.metricName("BytesFetchedRate", "TierFetcher", "The number of bytes fetched per second from tiered storage", Collections.emptyMap());
        this.bytesFetchedTotalMetricName = metrics.metricName("BytesFetchedTotal", "TierFetcher", "The total number of bytes fetched from tiered storage", Collections.emptyMap());
        Meter bytesFetchedMeter = new Meter(this.bytesFetchedRateMetricName, this.bytesFetchedTotalMetricName);
        this.fetchException = this.sensor("FetchException", new Sensor[0]);
        this.fetchExceptionRateMetricName = metrics.metricName("FetchExceptionRate", "TierFetcher", "The number exceptional fetch requests per second from tiered storage", Collections.emptyMap());
        this.fetchExceptionTotalMetricName = metrics.metricName("FetchExceptionTotal", "TierFetcher", "The total number of exceptional fetch requests from tiered storage", Collections.emptyMap());
        Meter fetchObjectStoreExceptionMeter = new Meter(this.fetchExceptionRateMetricName, this.fetchExceptionTotalMetricName);
        this.fetchCancelled = this.sensor("FetchCancellation", new Sensor[0]);
        this.fetchCancellationRateMetricName = metrics.metricName("FetchCancellationRate", "TierFetcher", "The number of cancelled fetch requests per second from tiered storage", Collections.emptyMap());
        this.fetchCancellationTotalMetricName = metrics.metricName("FetchCancellationTotal", "TierFetcher", "The total number of cancelled fetch requests from tiered storage", Collections.emptyMap());
        Meter fetchCancelledMeter = new Meter(this.fetchCancellationRateMetricName, this.fetchCancellationTotalMetricName);
        this.fetchOffsetForTimestampCancelled = this.sensor("FetchOffsetForTimestampCancellation", new Sensor[0]);
        this.fetchOffsetForTimestampCancellationRateMetricName = metrics.metricName("FetchOffsetForTimestampCancellationRate", "TierFetcher", "The number of cancelled fetch offset for timestamps requests per second from tiered storage", Collections.emptyMap());
        this.fetchOffsetForTimestampCancellationTotalMetricName = metrics.metricName("FetchOffsetForTimestampCancellationTotal", "TierFetcher", "The total number of cancelled fetch offset for timestamps requests from tiered storage", Collections.emptyMap());
        Meter fetchTierTimestampAndOffsetCancelledMeter = new Meter(this.fetchOffsetForTimestampCancellationRateMetricName, this.fetchOffsetForTimestampCancellationTotalMetricName);
        this.fetchOffsetForTimestampException = this.sensor("FetchOffsetForTimestampException", new Sensor[0]);
        this.fetchOffsetForTimestampExceptionRateMetricName = metrics.metricName("FetchOffsetForTimestampExceptionRate", "TierFetcher", "The number of exceptional fetch offset for timestamps requests per second from tiered storage", Collections.emptyMap());
        this.fetchOffsetForTimestampExceptionTotalMetricName = metrics.metricName("FetchOffsetForTimestampExceptionTotal", "TierFetcher", "The total number of exceptional fetch offset for timestamps requests from tiered storage", Collections.emptyMap());
        Meter fetchTierTimestampAndOffsetExceptionMeter = new Meter(this.fetchOffsetForTimestampExceptionRateMetricName, this.fetchOffsetForTimestampExceptionTotalMetricName);
        this.fetchNonRetriableException = this.sensor("FetchNonRetriableException", new Sensor[0]);
        this.fetchNonRetriableExceptionRateMetricName = metrics.metricName("FetchNonRetriableExceptionRate", "TierFetcher", "The number of non-retriable exceptional fetch requests per second from tiered storage", Collections.emptyMap());
        this.fetchNonRetriableExceptionTotalMetricName = metrics.metricName("FetchNonRetriableExceptionTotal", "TierFetcher", "The total number of non-retriable exceptional fetch requests from tiered storage", Collections.emptyMap());
        Meter fetchObjectStoreNonRetriableExceptionMeter = new Meter(this.fetchNonRetriableExceptionRateMetricName, this.fetchNonRetriableExceptionTotalMetricName);
        this.fetchTotalTimeMs = this.sensor("FetchTotalTimeMs", new Sensor[0]);
        double maxTotalTimeMs = 30000.0;
        int totalBucketSizeInBytes = (int)maxTotalTimeMs * 4;
        this.fetchTotalTimeMs50PercentileMetricName = metrics.metricName("FetchTotalTimeMs50Percentile", "TierFetcher", "The 50-percentile total time for PendingFetch GET calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.fetchTotalTimeMs90PercentileMetricName = metrics.metricName("FetchTotalTimeMs90Percentile", "TierFetcher", "The 90-percentile total time for PendingFetch GET calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.fetchTotalTimeMs99PercentileMetricName = metrics.metricName("FetchTotalTimeMs99Percentile", "TierFetcher", "The 99-percentile total time for PendingFetch GET calls made to the object store by tiered storage in ms", Collections.emptyMap());
        Percentile fetchTotalTimeMs50Percentile = new Percentile(this.fetchTotalTimeMs50PercentileMetricName, 50.0);
        Percentile fetchTotalTimeMs90Percentile = new Percentile(this.fetchTotalTimeMs90PercentileMetricName, 90.0);
        Percentile fetchTotalTimeMs99Percentile = new Percentile(this.fetchTotalTimeMs99PercentileMetricName, 99.0);
        Percentiles fetchTotalTimeMsPercentiles = new Percentiles(totalBucketSizeInBytes, maxTotalTimeMs, Percentiles.BucketSizing.CONSTANT, new Percentile[]{fetchTotalTimeMs50Percentile, fetchTotalTimeMs90Percentile, fetchTotalTimeMs99Percentile});
        this.fetchOffsetForTimestampTotalTimeMs = this.sensor("FetchOffsetForTimestampTotalTimeMs", new Sensor[0]);
        this.fetchOffsetForTimestampTotalTimeMs50PercentileMetricName = metrics.metricName("FetchOffsetForTimestampTotalTimeMs50Percentile", "TierFetcher", "The 50-percentile total time for PendingOffsetForTimestamp GET calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.fetchOffsetForTimestampTotalTimeMs90PercentileMetricName = metrics.metricName("FetchOffsetForTimestampTotalTimeMs90Percentile", "TierFetcher", "The 90-percentile total time for PendingOffsetForTimestamp GET calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.fetchOffsetForTimestampTotalTimeMs99PercentileMetricName = metrics.metricName("FetchOffsetForTimestampTotalTimeMs99Percentile", "TierFetcher", "The 99-percentile total time for PendingOffsetForTimestamp GET calls made to the object store by tiered storage in ms", Collections.emptyMap());
        Percentile fetchOffsetForTimestampTotalTimeMs50Percentile = new Percentile(this.fetchOffsetForTimestampTotalTimeMs50PercentileMetricName, 50.0);
        Percentile fetchOffsetForTimestampTotalTimeMs90Percentile = new Percentile(this.fetchOffsetForTimestampTotalTimeMs90PercentileMetricName, 90.0);
        Percentile fetchOffsetForTimestampTotalTimeMs99Percentile = new Percentile(this.fetchOffsetForTimestampTotalTimeMs99PercentileMetricName, 99.0);
        Percentiles fetchOffsetForTimestampTotalTimeMsPercentiles = new Percentiles(totalBucketSizeInBytes, maxTotalTimeMs, Percentiles.BucketSizing.CONSTANT, new Percentile[]{fetchOffsetForTimestampTotalTimeMs50Percentile, fetchOffsetForTimestampTotalTimeMs90Percentile, fetchOffsetForTimestampTotalTimeMs99Percentile});
        this.queuedTimeMs = this.sensor("QueuedTotalTimeMs", new Sensor[0]);
        this.queuedTimeMs50PercentileMetricName = metrics.metricName("QueuedTotalTimeMs50Percentile", "TierFetcher", "The 50-percentile time for PendingFetch/PendingOffsetForTimestamp being queued in tier fetching thread pool in ms", Collections.emptyMap());
        this.queuedTimeMs90PercentileMetricName = metrics.metricName("QueuedTotalTimeMs90Percentile", "TierFetcher", "The 90-percentile time for PendingFetch/PendingOffsetForTimestamp being queued in tier fetching thread pool in ms", Collections.emptyMap());
        this.queuedTimeMs99PercentileMetricName = metrics.metricName("QueuedTotalTimeMs99Percentile", "TierFetcher", "The 99-percentile time for PendingFetch/PendingOffsetForTimestamp being queued in tier fetching thread pool in ms", Collections.emptyMap());
        Percentile queuedTimeMs50Percentile = new Percentile(this.queuedTimeMs50PercentileMetricName, 50.0);
        Percentile queuedTimeMs90Percentile = new Percentile(this.queuedTimeMs90PercentileMetricName, 90.0);
        Percentile queuedTimeMs99Percentile = new Percentile(this.queuedTimeMs99PercentileMetricName, 99.0);
        Percentiles queuedTimeMsPercentiles = new Percentiles(totalBucketSizeInBytes, maxTotalTimeMs, Percentiles.BucketSizing.CONSTANT, new Percentile[]{queuedTimeMs50Percentile, queuedTimeMs90Percentile, queuedTimeMs99Percentile});
        this.fetchPartitionCount = this.sensor("FetchPartitionCount", new Sensor[0]);
        this.fetchPartitionCount50PercentileMetricName = metrics.metricName("FetchPartitionCount50Percentile", "TierFetcher", "The 50-percentile number of tiered partitions to fetch in a request", Collections.emptyMap());
        this.fetchPartitionCount90PercentileMetricName = metrics.metricName("FetchPartitionCount90Percentile", "TierFetcher", "The 90-percentile number of tiered partitions to fetch in a request", Collections.emptyMap());
        this.fetchPartitionCount99PercentileMetricName = metrics.metricName("FetchPartitionCount99Percentile", "TierFetcher", "The 99-percentile number of tiered partitions to fetch in a request", Collections.emptyMap());
        Percentile fetchPartitionCount50Percentile = new Percentile(this.fetchPartitionCount50PercentileMetricName, 50.0);
        Percentile fetchPartitionCount90Percentile = new Percentile(this.fetchPartitionCount90PercentileMetricName, 90.0);
        Percentile fetchPartitionCount99Percentile = new Percentile(this.fetchPartitionCount99PercentileMetricName, 99.0);
        Percentiles fetchPartitionCountPercentiles = new Percentiles(totalBucketSizeInBytes, maxTotalTimeMs, Percentiles.BucketSizing.CONSTANT, new Percentile[]{fetchPartitionCount50Percentile, fetchPartitionCount90Percentile, fetchPartitionCount99Percentile});
        Gauge<Integer> queueSizeGauge = new Gauge<Integer>(){

            public Integer value(MetricConfig config, long now) {
                return executor.getQueue().size();
            }
        };
        metrics.addMetric(this.queueSizeMetricName, (MetricValueProvider)queueSizeGauge);
        Gauge<Long> offsetCacheSize = new Gauge<Long>(){

            public Long value(MetricConfig config, long now) {
                return cache.size();
            }
        };
        metrics.addMetric(this.offsetCacheSizeMetricName, (MetricValueProvider)offsetCacheSize);
        Gauge<Double> offsetCacheHitGauge = new Gauge<Double>(){

            public Double value(MetricConfig config, long now) {
                return cache.hitRatio();
            }
        };
        metrics.addMetric(this.offsetCacheHitMetricName, (MetricValueProvider)offsetCacheHitGauge);
        this.bytesFetched.add((CompoundStat)bytesFetchedMeter);
        this.fetchException.add((CompoundStat)fetchObjectStoreExceptionMeter);
        this.fetchCancelled.add((CompoundStat)fetchCancelledMeter);
        this.fetchOffsetForTimestampException.add((CompoundStat)fetchTierTimestampAndOffsetExceptionMeter);
        this.fetchOffsetForTimestampCancelled.add((CompoundStat)fetchTierTimestampAndOffsetCancelledMeter);
        this.fetchNonRetriableException.add((CompoundStat)fetchObjectStoreNonRetriableExceptionMeter);
        this.fetchTotalTimeMs.add((CompoundStat)fetchTotalTimeMsPercentiles);
        this.fetchOffsetForTimestampTotalTimeMs.add((CompoundStat)fetchOffsetForTimestampTotalTimeMsPercentiles);
        this.queuedTimeMs.add((CompoundStat)queuedTimeMsPercentiles);
        this.fetchPartitionCount.add((CompoundStat)fetchPartitionCountPercentiles);
    }

    private Sensor sensor(String name, Sensor ... parents) {
        Sensor sensor = this.metrics.sensor(name, parents);
        this.sensors.add(sensor);
        return sensor;
    }

    public void close() {
        for (Sensor sensor : this.sensors) {
            this.metrics.removeSensor(sensor.name());
        }
        this.metrics.removeMetric(this.queueSizeMetricName);
    }

    public Sensor bytesFetched() {
        return this.bytesFetched;
    }

    public Sensor fetchException() {
        return this.fetchException;
    }

    public Sensor fetchCancelled() {
        return this.fetchCancelled;
    }

    public Sensor fetchOffsetForTimestampCancelled() {
        return this.fetchOffsetForTimestampCancelled;
    }

    public Sensor fetchOffsetForTimestampException() {
        return this.fetchOffsetForTimestampException;
    }

    public Sensor fetchNonRetriableException() {
        return this.fetchNonRetriableException;
    }

    public Sensor fetchTotalTimeMs() {
        return this.fetchTotalTimeMs;
    }

    public Sensor fetchOffsetForTimestampTotalTimeMs() {
        return this.fetchOffsetForTimestampTotalTimeMs;
    }

    public Sensor queuedTimeMs() {
        return this.queuedTimeMs;
    }

    public Sensor fetchPartitionCount() {
        return this.fetchPartitionCount;
    }
}

