/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.TierTask;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%h!\u0002\u0010 \u0003\u00031\u0003\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011C\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\u0006)\u0002!\t!\u0016\u0005\u0006M\u0002!\te\u001a\u0005\bA\u0001\u0001\r\u0011\"\u0003t\u0011\u001da\b\u00011A\u0005\nuDq!a\u0002\u0001A\u0003&A\u000fC\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u00111\u0007\u0001!\u0002\u0013\t)\u0002C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u0011q\u0007\u0001!\u0002\u0013\t)\u0002\u0003\u0005\u0002:\u0001\u0001\r\u0011\"\u0003t\u0011%\tY\u0004\u0001a\u0001\n\u0013\ti\u0004C\u0004\u0002B\u0001\u0001\u000b\u0015\u0002;\t\u0011\u0005\r\u0003\u0001\"\u0005 \u0003\u000bB\u0001\"a\u0012\u0001\r#y\u0012\u0011\n\u0005\t\u0003?\u0002a\u0011C\u0010\u0002b!A\u0011\u0011\u000f\u0001\u0007\u0012}\t\u0019\bC\u0004\u0002\u0004\u0002!\t!!\"\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\tY\u000b\u0001C\u0001\u0003[Cq!a4\u0001\t\u0003\t\t\u000eC\u0004\u0002T\u0002!\t%!6\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\"9\u0011Q\u001c\u0001\u0005\n\u0005}'!\u0004+jKJ$\u0016m]6Rk\u0016,XM\u0003\u0002!C\u0005)A/Y:lg*\u0011!eI\u0001\u0005i&,'OC\u0001%\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"a\n.\u0014\t\u0001Ac\u0006\u000e\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\u001a\u0013!B;uS2\u001c\u0018BA\u001a1\u0005\u001daunZ4j]\u001e\u0004\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\t1\fgn\u001a\u0006\u0002s\u0005!!.\u0019<b\u0013\tYdGA\u0007BkR|7\t\\8tK\u0006\u0014G.Z\u0001\u0004GRD\bC\u0001 B\u001b\u0005y$B\u0001!\"\u0003\u001d1W\r^2iKJL!AQ \u0003'\r\u000bgnY3mY\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u00115\f\u0007\u0010V1tWN\u0004\"!K#\n\u0005\u0019S#aA%oi\u0006!A/[7f!\tI%+D\u0001K\u0015\t\t4J\u0003\u0002M\u001b\u000611m\\7n_:T!\u0001\n(\u000b\u0005=\u0003\u0016AB1qC\u000eDWMC\u0001R\u0003\ry'oZ\u0005\u0003'*\u0013A\u0001V5nK\u00061A(\u001b8jiz\"BAV2eKB\u0019q\u000b\u0001-\u000e\u0003}\u0001\"!\u0017.\r\u0001\u0011)1\f\u0001b\u00019\n\tA+\u0005\u0002^AB\u0011\u0011FX\u0005\u0003?*\u0012qAT8uQ&tw\rE\u0002XCbK!AY\u0010\u0003\u0011QKWM\u001d+bg.DQ\u0001\u0010\u0003A\u0002uBQa\u0011\u0003A\u0002\u0011CQa\u0012\u0003A\u0002!\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\u0005A\u0007CA5q\u001d\tQg\u000e\u0005\u0002lU5\tAN\u0003\u0002nK\u00051AH]8pizJ!a\u001c\u0016\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_**\u0012\u0001\u001e\t\u0004kjDV\"\u0001<\u000b\u0005]D\u0018!C5n[V$\u0018M\u00197f\u0015\tI(&\u0001\u0006d_2dWm\u0019;j_:L!a\u001f<\u0003\u000f1K7\u000f^*fi\u0006IA/Y:lg~#S-\u001d\u000b\u0004}\u0006\r\u0001CA\u0015\u0000\u0013\r\t\tA\u000b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0006\u001d\t\t\u00111\u0001u\u0003\rAH%M\u0001\u0007i\u0006\u001c8n\u001d\u0011)\u0007!\tY\u0001E\u0002*\u0003\u001bI1!a\u0004+\u0005!1x\u000e\\1uS2,\u0017!\u00059beRLG/[8og&sWI\u001d:peV\u0011\u0011Q\u0003\t\t\u0003/\t\t#!\n\u0002.5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\b9\u0003\u0011)H/\u001b7\n\t\u0005\r\u0012\u0011\u0004\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003BA\u0014\u0003Si\u0011!I\u0005\u0004\u0003W\t#\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o!\rI\u0013qF\u0005\u0004\u0003cQ#\u0001\u0002'p]\u001e\f!\u0003]1si&$\u0018n\u001c8t\u0013:,%O]8sA\u0005i\u0002/\u0019:uSRLwN\\:XSRD'+\u001a;sS\u0006\u0014G.Z#se>\u00148/\u0001\u0010qCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5SKR\u0014\u0018.\u00192mK\u0016\u0013(o\u001c:tA\u0005Q\u0001O]8dKN\u001c\u0018N\\4\u0002\u001dA\u0014xnY3tg&twm\u0018\u0013fcR\u0019a0a\u0010\t\u0011\u0005\u0015a\"!AA\u0002Q\f1\u0002\u001d:pG\u0016\u001c8/\u001b8hA\u0005\u0019RM\u001d:peB\u000b'\u000f^5uS>t7i\\;oiR\tA)A\u0005t_J$H+Y:lgR!\u00111JA/!\u0015\ti%a\u0016Y\u001d\u0011\ty%a\u0015\u000f\u0007-\f\t&C\u0001,\u0013\r\t)FK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI&a\u0017\u0003\t1K7\u000f\u001e\u0006\u0004\u0003+R\u0003B\u0002\u0011\u0012\u0001\u0004\tY%A\u0004oK^$\u0016m]6\u0015\u000ba\u000b\u0019'a\u001a\t\u000f\u0005\u0015$\u00031\u0001\u0002&\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003S\u0012\u0002\u0019AA6\u0003!iW\r^1eCR\f\u0007cA,\u0002n%\u0019\u0011qN\u0010\u0003'M#\u0018M\u001d;DQ\u0006tw-Z'fi\u0006$\u0017\r^1\u0002\u00155\f\u0017\u0010\u0015:pG\u0016\u001c8\u000f\u0006\u0003\u0002v\u0005m\u0004cA\u0015\u0002x%\u0019\u0011\u0011\u0010\u0016\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011N\nA\u0002\u0005u\u0004cA,\u0002\u0000%\u0019\u0011\u0011Q\u0010\u0003\u001d\rC\u0017M\\4f\u001b\u0016$\u0018\rZ1uC\u0006aQ.Y=cK\u0006#G\rV1tWR\u0019a0a\"\t\u000f\u0005%D\u00031\u0001\u0002l\u0005yQ.Y=cKJ+Wn\u001c<f)\u0006\u001c8\u000eF\u0002\u007f\u0003\u001bCq!!\u001b\u0016\u0001\u0004\ty\tE\u0002X\u0003#K1!a% \u0005I\u0019Fo\u001c9DQ\u0006tw-Z'fi\u0006$\u0017\r^1\u0002\tA|G\u000e\u001c\u000b\u0003\u00033\u0003R!KAN\u0003\u0017J1!!(+\u0005\u0019y\u0005\u000f^5p]\u0006!Am\u001c8f)\rq\u00181\u0015\u0005\u0007\u0003K;\u0002\u0019\u0001-\u0002\tQ\f7o[\u0001\ni\u0006\u001c8nQ8v]R,\u0012\u0001R\u0001\ro&$\b.\u00117m)\u0006\u001c8n]\u000b\u0005\u0003_\u000b\u0019\f\u0006\u0003\u00022\u0006}\u0006cA-\u00024\u00129\u0011QW\rC\u0002\u0005]&!A+\u0012\u0007u\u000bI\fE\u0002*\u0003wK1!!0+\u0005\r\te.\u001f\u0005\b\u0003\u0003L\u0002\u0019AAb\u0003\t1g\u000eE\u0004*\u0003\u000b\fI-!-\n\u0007\u0005\u001d'FA\u0005Gk:\u001cG/[8ocA!\u0011.a3Y\u0013\r\tiM\u001d\u0002\u0004'\u0016$\u0018!B2m_N,G#\u0001@\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001[\u0001\u0007e\u0016lwN^3\u0015\u0007y\fY\u000eC\u0004\u0002fq\u0001\r!!\n\u0002\u0011\u0019Lg\u000e\u001a+bg.$b!!9\u0002d\u0006\u0015\b\u0003B\u0015\u0002\u001cbCq!!\u001a\u001e\u0001\u0004\t)\u0003\u0003\u0004\u0002hv\u0001\r\u0001^\u0001\u0006cV,W/\u001a")
public abstract class TierTaskQueue<T extends TierTask<T>>
implements Logging,
AutoCloseable {
    private final CancellationContext ctx;
    private final int maxTasks;
    private final Time time;
    private volatile ListSet<T> tasks;
    private final ConcurrentHashMap<TopicIdPartition, Object> partitionsInError;
    private final ConcurrentHashMap<TopicIdPartition, Object> partitionsWithRetriableErrors;
    private ListSet<T> processing;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return this.getClass().getName();
    }

    private ListSet<T> tasks() {
        return this.tasks;
    }

    private void tasks_$eq(ListSet<T> x$1) {
        this.tasks = x$1;
    }

    private ConcurrentHashMap<TopicIdPartition, Object> partitionsInError() {
        return this.partitionsInError;
    }

    private ConcurrentHashMap<TopicIdPartition, Object> partitionsWithRetriableErrors() {
        return this.partitionsWithRetriableErrors;
    }

    private ListSet<T> processing() {
        return this.processing;
    }

    private void processing_$eq(ListSet<T> x$1) {
        this.processing = x$1;
    }

    public int errorPartitionCount() {
        return this.partitionsInError().size() + this.partitionsWithRetriableErrors().size();
    }

    public abstract List<T> sortTasks(List<T> var1);

    public abstract T newTask(TopicIdPartition var1, StartChangeMetadata var2);

    public abstract boolean mayProcess(ChangeMetadata var1);

    public void maybeAddTask(StartChangeMetadata metadata) {
        if (this.mayProcess(metadata)) {
            this.remove(metadata.topicIdPartition());
            this.tasks_$eq((ListSet)this.tasks().$plus(this.newTask(metadata.topicIdPartition(), metadata)));
            return;
        }
    }

    public void maybeRemoveTask(StopChangeMetadata metadata) {
        if (this.mayProcess(metadata)) {
            this.remove(metadata.topicIdPartition());
            return;
        }
    }

    public synchronized Option<List<T>> poll() {
        Instant now = Instant.ofEpochMilli(this.time.hiResClockMs());
        int processingSpace = this.maxTasks - this.processing().size();
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("space: ").append(processingSpace).append(" maxTasks: ").append($this.maxTasks).append(" processing: ").append(processingSpace - $this.maxTasks).append(" tasks: ").append(this.tasks().size()).toString());
        if (processingSpace > 0) {
            List<T> sorted;
            List eligibleTasks = this.tasks().toList().filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)TierTaskQueue.$anonfun$poll$2(this, now, task)));
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("eligibleTasks: ").append(eligibleTasks.size()).append(" partitionsInError: ").append(this.partitionsInError().size()).toString());
            if (eligibleTasks.nonEmpty() && (sorted = this.sortTasks(eligibleTasks)).nonEmpty()) {
                List tasks = sorted.take(processingSpace);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Adding sorted: ").append(tasks.mkString(",")).append(" \n Total tasks: ").append(tasks.mkString(",")).toString());
                this.processing_$eq((ListSet)this.processing().$plus$plus((IterableOnce)tasks));
                return new Some((Object)tasks);
            }
        }
        return None$.MODULE$;
    }

    public void done(T task) {
        synchronized (this) {
            if (!this.tasks().contains(task)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Done task ").append(task).append(" is already removed").toString());
            } else {
                if (!this.processing().contains(task)) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("done task ").append(task).append(" not found in processing set").toString());
                }
                this.processing_$eq((ListSet)this.processing().$minus(task));
                if (((TierTask)task).ctx().isCancelled()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("removing done task ").append(task).append(" from the task set since task is cancelled").toString());
                    this.tasks_$eq((ListSet)this.tasks().$minus(task));
                    if (((TierTask)task).isErrorState()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("adding done/cancelled task ").append(task).append(" to partitionsInError").toString());
                        this.partitionsInError().put(((TierTask)task).topicIdPartition(), BoxesRunTime.boxToLong((long)this.time.milliseconds()));
                        this.partitionsWithRetriableErrors().remove(((TierTask)task).topicIdPartition());
                    }
                } else if (((TierTask)task).isErrorState()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("adding done (non-cancelled) task ").append(task).append(" to partitionsWithRetriableErrors").toString());
                    this.partitionsWithRetriableErrors().put(((TierTask)task).topicIdPartition(), BoxesRunTime.boxToLong((long)this.time.milliseconds()));
                } else {
                    this.partitionsWithRetriableErrors().remove(((TierTask)task).topicIdPartition());
                }
            }
            return;
        }
    }

    public int taskCount() {
        return this.tasks().size();
    }

    public <U> U withAllTasks(Function1<Set<T>, U> fn) {
        return (U)fn.apply(this.tasks());
    }

    @Override
    public void close() {
        this.ctx.cancel();
    }

    public String toString() {
        return new StringBuilder(18).append("tasks=").append(this.tasks()).append(" processing=").append(this.processing()).toString();
    }

    private synchronized void remove(TopicIdPartition topicIdPartition) {
        this.findTask(topicIdPartition, this.tasks()).foreach((Function1 & Serializable)task -> BoxesRunTime.boxToLong((long)TierTaskQueue.$anonfun$remove$1(this, topicIdPartition, task)));
    }

    private Option<T> findTask(TopicIdPartition topicIdPartition, ListSet<T> queue) {
        return queue.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TierTaskQueue.$anonfun$findTask$1(topicIdPartition, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$poll$2(TierTaskQueue $this, Instant now$1, TierTask task) {
        return !$this.processing().apply((Object)task) && task.pausedUntil().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)now$1.isAfter(x$1))) && !$this.partitionsInError().containsKey(task.topicIdPartition());
    }

    public static final /* synthetic */ long $anonfun$remove$1(TierTaskQueue $this, TopicIdPartition topicIdPartition$1, TierTask task) {
        task.ctx().cancel();
        $this.tasks_$eq((ListSet)$this.tasks().$minus((Object)task));
        $this.processing_$eq((ListSet)$this.processing().$minus((Object)task));
        $this.partitionsInError().remove(topicIdPartition$1);
        return BoxesRunTime.unboxToLong((Object)$this.partitionsWithRetriableErrors().remove(topicIdPartition$1));
    }

    public static final /* synthetic */ boolean $anonfun$findTask$1(TopicIdPartition topicIdPartition$2, TierTask x$2) {
        TopicIdPartition topicIdPartition = x$2.topicIdPartition();
        return !(topicIdPartition != null ? !((Object)topicIdPartition).equals(topicIdPartition$2) : topicIdPartition$2 != null);
    }

    public TierTaskQueue(CancellationContext ctx, int maxTasks, Time time) {
        this.ctx = ctx;
        this.maxTasks = maxTasks;
        this.time = time;
        this.tasks = (ListSet)ListSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionsInError = new ConcurrentHashMap();
        this.partitionsWithRetriableErrors = new ConcurrentHashMap();
        this.processing = (ListSet)ListSet$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

