/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.ChecksumUtils;
import kafka.tier.state.Header;
import kafka.tier.state.PathAndHeader;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreFunctionUtils;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.FileTierPartitionStateRecoveryUploadMetadata;
import kafka.tier.tools.PartitionUploadInfo;
import kafka.tier.tools.SelectFileTierPartitionStatePolicy;
import kafka.tier.tools.SelectFileTierPartitionStatePolicyUtils;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import kafka.tier.topic.recovery.SelectRemoteFileTierPartitionStateOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectRemoteFurthestFileTierPartitionStatePolicy
implements SelectFileTierPartitionStatePolicy {
    private static final Logger log = LoggerFactory.getLogger(SelectRemoteFurthestFileTierPartitionStatePolicy.class);
    private final String remoteRecoveryDir;
    private final String tierConfigFile;
    private final String adminConfigFile;
    private final String bootstrapServers;
    private final boolean skipReplicationFactorCheck;
    private final int replicationFactorOverride;
    private final String outputDir;

    public SelectRemoteFurthestFileTierPartitionStatePolicy(String remoteRecoveryDir, String tierConfigFile, String adminConfigFile, String bootstrapServers, boolean skipReplicationFactorCheck, int replicationFactorOverride, String outputDir) {
        this.remoteRecoveryDir = remoteRecoveryDir;
        this.tierConfigFile = tierConfigFile;
        this.adminConfigFile = adminConfigFile;
        this.bootstrapServers = bootstrapServers;
        this.skipReplicationFactorCheck = skipReplicationFactorCheck;
        this.replicationFactorOverride = replicationFactorOverride;
        this.outputDir = outputDir;
    }

    public static Optional<PathAndHeader> getFurthestFTPSForTopicPartition(TierObjectStore objectStore, List<PartitionUploadInfo> ftpsList, TopicIdPartition topicPartition) throws IOException, InterruptedException {
        ArrayList<PathAndHeader> furthestFTPSs = new ArrayList<PathAndHeader>(Collections.emptyList());
        ArrayList<String> leaders = new ArrayList<String>();
        for (PartitionUploadInfo ftps : ftpsList) {
            if (ftps.isLeader) {
                leaders.add(ftps.objectStorePath);
            }
            FileTierPartitionStateRecoveryUploadMetadata ftpsRecoveryUploadMetadata = FileTierPartitionStateRecoveryUploadMetadata.fromPath(ftps.objectStorePath);
            TierObjectStoreResponse response = TierObjectStoreFunctionUtils.getObjectStoreFragment(() -> false, objectStore, ftpsRecoveryUploadMetadata, FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD);
            InputStream stream = response.getInputStream();
            Throwable throwable = null;
            try {
                Optional<Header> header = ChecksumUtils.readRemoteHeader(ftpsRecoveryUploadMetadata.uploadObject().checksumAlgorithm(), stream);
                furthestFTPSs.add(new PathAndHeader(ftps.objectStorePath, header));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        if (leaders.size() > 1) {
            log.warn("Found more than 1 leader for topicPartition {}. List of leader FTPSs object store paths {}", (Object)topicPartition, (Object)String.join((CharSequence)", ", leaders));
        }
        return ChecksumUtils.furthestTierStateHeader(furthestFTPSs);
    }

    @Override
    public void run(Set<TopicIdPartition> topicPartitions) throws Exception {
        TierObjectStore objectStore;
        File dir = new File(this.outputDir);
        if (dir.mkdirs()) {
            log.info("Created output directory: {}", (Object)this.outputDir);
        }
        if (!dir.exists()) {
            throw new IOException("Failed to create output directory: " + this.outputDir);
        }
        if (topicPartitions.isEmpty()) {
            throw new IllegalArgumentException("No affected topic partitions found. Exiting... Please check the input and try again");
        }
        log.info("Running SelectRemoteFurthestFileTierPartitionStatePolicy tool on the topicPartitions: {}", topicPartitions);
        try {
            objectStore = TierObjectStoreUtils.objectStore(this.tierConfigFile);
        }
        catch (IOException e) {
            log.error("Failed to create object store instance with config: {}", (Object)this.tierConfigFile);
            throw new UncheckedIOException(e);
        }
        HashMap<TopicIdPartition, String> furthestFTPSs = new HashMap<TopicIdPartition, String>();
        String identifier = TierMetadataRecoveryUtils.getIdentifierFromRecoveryDir(this.remoteRecoveryDir);
        Map<TopicIdPartition, List<PartitionUploadInfo>> metadataList = SelectFileTierPartitionStatePolicyUtils.getRecoveryMetadata(objectStore, identifier, this.adminConfigFile, this.bootstrapServers);
        int numPartitions = topicPartitions.size();
        ArrayList<TopicIdPartition> failedPartitions = new ArrayList<TopicIdPartition>();
        for (TopicIdPartition topicPartition : topicPartitions) {
            try {
                List<PartitionUploadInfo> ftpsList = metadataList.getOrDefault(topicPartition, Collections.emptyList());
                SelectFileTierPartitionStatePolicyUtils.validateNumOfFTPSObjects(this.skipReplicationFactorCheck, this.replicationFactorOverride, ftpsList);
                Optional<PathAndHeader> furthestFTPS = SelectRemoteFurthestFileTierPartitionStatePolicy.getFurthestFTPSForTopicPartition(objectStore, ftpsList, topicPartition);
                if (furthestFTPS.isPresent()) {
                    furthestFTPSs.put(topicPartition, furthestFTPS.get().path());
                    continue;
                }
                failedPartitions.add(topicPartition);
                log.error("Failed to get the furthest FTPS for topicPartition: {}", (Object)topicPartition);
            }
            catch (Exception e) {
                failedPartitions.add(topicPartition);
                log.error("Failed to get the furthest FTPS for topicPartition {}", (Object)topicPartition, (Object)e);
            }
        }
        SelectRemoteFileTierPartitionStateOutput output = new SelectRemoteFileTierPartitionStateOutput(1, furthestFTPSs);
        SelectFileTierPartitionStatePolicyUtils.writeSelectRemoteFTPSOutputToFile(output, numPartitions, failedPartitions, this.outputDir);
    }
}

