/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.coordinator.quota.QuotaStateManager$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.tools.DumpLogSegments$;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.message.ConsumerProtocolAssignmentJsonConverter;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.message.ConsumerProtocolSubscriptionJsonConverter;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.CoordinatorRecordSerde;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValueJsonConverter;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValueJsonConverter;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.api.Decoder;
import org.apache.kafka.tools.api.StringDecoder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0011Eq!\u00020`\u0011\u0003!g!\u00024`\u0011\u00039\u0007\"\u00028\u0002\t\u0003y\u0007\u0002\u00039\u0002\u0005\u0004%\taX9\t\ri\f\u0001\u0015!\u0003s\u0011\u0015Y\u0018\u0001\"\u0001}\u0011\u001d\ty\"\u0001C\u0005\u0003CAq!a\r\u0002\t\u0013\t)\u0004C\u0004\u0002:\u0005!I!a\u000f\t\u0011\u0005}\u0012\u0001\"\u0001`\u0003\u0003B\u0001\"a$\u0002\t\u0003y\u0016\u0011\u0013\u0004\u000b\u0003S\f\u0001\u0013aI\u0001C\u0006-\bbBAx\u0017\u0019\u0005\u0011\u0011\u001f\u0004\u0007\u0005k\tAAa\u000e\t\u0015\t\u0015SB!A!\u0002\u0013\u00119\u0005\u0003\u0006\u0003V5\u0011\t\u0011)A\u0005\u0005/BaA\\\u0007\u0005\u0002\te\u0003bBAx\u001b\u0011\u0005#\u0011\r\u0005\b\u0005W\nA\u0011\u0002B7\u0011\u001d\u0011I*\u0001C\u0005\u000573a!!)\u0002\u0001\u0005\r\u0006B\u00028\u0015\t\u0003\t)\u000bC\u0005\u0002(R\u0011\r\u0011\"\u0001\u0002*\"A\u00111\u0017\u000b!\u0002\u0013\tY\u000bC\u0005\u00026R\u0011\r\u0011\"\u0001\u0002*\"A\u0011q\u0017\u000b!\u0002\u0013\tY\u000bC\u0005\u0002:R\u0011\r\u0011\"\u0001\u0002*\"A\u00111\u0018\u000b!\u0002\u0013\tY\u000bC\u0004\u0002>R!\t!a0\t\u000f\u0005-G\u0003\"\u0001\u0002N\"9\u0011q\u001b\u000b\u0005\u0002\u0005e\u0007bBAs)\u0011\u0005\u0011q\u001d\u0004\u0007\u0005g\u000b\u0001A!.\t\r9\u0004C\u0011\u0001B]\u0011%\u0011i\f\tb\u0001\n\u0013\u0011y\f\u0003\u0005\u0003R\u0002\u0002\u000b\u0011\u0002Ba\u0011\u001d\u0011\u0019\u000e\tC\u0005\u0005+DqA!=!\t\u0013\u0011\u0019\u0010C\u0004\u0004\u001e\u0001\"Iaa\b\t\u000f\u0005=\b\u0005\"\u0011\u0004&\u001911QF\u0001\u0005\u0007_AaA\u001c\u0015\u0005\u0002\rE\u0002bBAxQ\u0011\u00053Q\u0007\u0004\u0007\u0007s\tAaa\u000f\t\r9\\C\u0011AB\u001f\u0011\u001d\tyo\u000bC!\u0007\u00032aa!\u0012\u0002\t\r\u001d\u0003B\u00028/\t\u0003\u0019I\u0005C\u0005\u0004N9\u0012\r\u0011\"\u0003\u0004P!A1Q\f\u0018!\u0002\u0013\u0019\t\u0006C\u0004\u0002p:\"\tea\u0018\u0007\r\r\r\u0014\u0001BB3\u0011)\t\u0019a\rB\u0001B\u0003%\u0011Q\u0001\u0005\u0007]N\"\taa\u001e\t\u0013\ru4G1A\u0005\n\r}\u0004\u0002CBGg\u0001\u0006Ia!!\t\u0013\r=5G1A\u0005\n\r}\u0004\u0002CBIg\u0001\u0006Ia!!\t\u0013\rM5G1A\u0005\n\r}\u0004\u0002CBKg\u0001\u0006Ia!!\t\u0013\r]5G1A\u0005\n\re\u0005\u0002CBQg\u0001\u0006Iaa'\t\u0013\r\r6G1A\u0005\n\r\u0015\u0006\u0002CBXg\u0001\u0006Iaa*\t\u0013\rE6G1A\u0005\n\r\u0015\u0006\u0002CBZg\u0001\u0006Iaa*\t\u0013\rU6G1A\u0005\n\r}\u0004\u0002CB\\g\u0001\u0006Ia!!\t\u0013\re6G1A\u0005\n\rm\u0006\u0002CB`g\u0001\u0006Ia!0\t\u0013\r\u00057G1A\u0005\n\rm\u0006\u0002CBbg\u0001\u0006Ia!0\t\u0013\r\u00157G1A\u0005\n\r}\u0004\u0002CBdg\u0001\u0006Ia!!\t\u0013\r%7G1A\u0005\n\r}\u0004\u0002CBfg\u0001\u0006Ia!!\t\u0013\r57G1A\u0005\n\r}\u0004\u0002CBhg\u0001\u0006Ia!!\t\u0013\rE7G1A\u0005\n\r}\u0004\u0002CBjg\u0001\u0006Ia!!\t\u0013\rU7G1A\u0005\u0002\r}\u0004\u0002CBlg\u0001\u0006Ia!!\t\u000f\re7\u0007\"\u0001\u0004\\\"Q1Q^\u001a\t\u0006\u0004%\taa<\t\u0015\tM5\u0007#b\u0001\n\u0003\u0019y\u000f\u0003\u0006\u0003|MB)\u0019!C\u0001\u0007_D!\"!\u00154\u0011\u000b\u0007I\u0011ABx\u0011)\t9e\rEC\u0002\u0013\u00051q\u001e\u0005\u000b\u0007c\u001c\u0004R1A\u0005\u0002\rM\bBCADg!\u0015\r\u0011\"\u0001\u0004v\"Q!qS\u001a\t\u0006\u0004%\ta!>\t\u000f\r]8\u0007\"\u0001\u0002h\"A1\u0011`\u0001\u0005\u0002}\u001bY\u0010\u0003\u0005\u0005\f\u0005!\ta\u0018C\u0007\u0003=!U/\u001c9M_\u001e\u001cVmZ7f]R\u001c(B\u00011b\u0003\u0015!xn\u001c7t\u0015\u0005\u0011\u0017!B6bM.\f7\u0001\u0001\t\u0003K\u0006i\u0011a\u0018\u0002\u0010\tVl\u0007\u000fT8h'\u0016<W.\u001a8ugN\u0011\u0011\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0002W\u0006)1oY1mC&\u0011QN\u001b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0017\u0001\u0004*fG>\u0014H-\u00138eK:$X#\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018\u0001\u00027b]\u001eT\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002zi\n11\u000b\u001e:j]\u001e\fQBU3d_J$\u0017J\u001c3f]R\u0004\u0013\u0001B7bS:$2!`A\u0001!\tIg0\u0003\u0002\u0000U\n!QK\\5u\u0011\u001d\t\u0019!\u0002a\u0001\u0003\u000b\tA!\u0019:hgB)\u0011.a\u0002\u0002\f%\u0019\u0011\u0011\u00026\u0003\u000b\u0005\u0013(/Y=\u0011\t\u00055\u00111\u0004\b\u0005\u0003\u001f\t9\u0002E\u0002\u0002\u0012)l!!a\u0005\u000b\u0007\u0005U1-\u0001\u0004=e>|GOP\u0005\u0004\u00033Q\u0017A\u0002)sK\u0012,g-C\u0002z\u0003;Q1!!\u0007k\u00035!W/\u001c9US\u0016\u00148\u000b^1uKR\u0019Q0a\t\t\u000f\u0005\u0015b\u00011\u0001\u0002(\u0005!a-\u001b7f!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017m\u0006\u0011\u0011n\\\u0005\u0005\u0003c\tYC\u0001\u0003GS2,\u0017\u0001\u00043v[B$\u0006P\\%oI\u0016DHcA?\u00028!9\u0011QE\u0004A\u0002\u0005\u001d\u0012A\u00063v[B\u0004&o\u001c3vG\u0016\u0014\u0018\nZ*oCB\u001c\bn\u001c;\u0015\u0007u\fi\u0004C\u0004\u0002&!\u0001\r!a\n\u0002\u0013\u0011,X\u000e]%oI\u0016DHcC?\u0002D\u0005\u0015\u0013qJA*\u0003\u000bCq!!\n\n\u0001\u0004\t9\u0003C\u0004\u0002H%\u0001\r!!\u0013\u0002\u001f%tG-\u001a=TC:LG/_(oYf\u00042![A&\u0013\r\tiE\u001b\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t&\u0003a\u0001\u0003\u0013\n!B^3sS\u001aLxJ\u001c7z\u0011\u001d\t)&\u0003a\u0001\u0003/\n!$\\5t\u001b\u0006$8\r[3t\r>\u0014\u0018J\u001c3fq\u001aKG.Z:NCB\u0004\u0002\"!\u0017\u0002d\u0005-\u0011qM\u0007\u0003\u00037RA!!\u0018\u0002`\u00059Q.\u001e;bE2,'bAA1U\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u00141\f\u0002\u0004\u001b\u0006\u0004\bCBA5\u0003g\nIH\u0004\u0003\u0002l\u0005=d\u0002BA\t\u0003[J\u0011a[\u0005\u0004\u0003cR\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003k\n9H\u0001\u0003MSN$(bAA9UB9\u0011.a\u001f\u0002\u0000\u0005}\u0014bAA?U\n1A+\u001e9mKJ\u00022![AA\u0013\r\t\u0019I\u001b\u0002\u0005\u0019>tw\rC\u0004\u0002\b&\u0001\r!!#\u0002\u001d5\f\u00070T3tg\u0006<WmU5{KB\u0019\u0011.a#\n\u0007\u00055%NA\u0002J]R\fQ\u0002Z;naRKW.Z%oI\u0016DH#C?\u0002\u0014\u0006U\u0015qSAM\u0011\u001d\t)C\u0003a\u0001\u0003OAq!a\u0012\u000b\u0001\u0004\tI\u0005C\u0004\u0002R)\u0001\r!!\u0013\t\u000f\u0005m%\u00021\u0001\u0002\u001e\u0006\u0019B/[7f\u0013:$W\r\u001f#v[B,%O]8sgB\u0019\u0011q\u0014\u000b\u000e\u0003\u0005\u00111\u0003V5nK&sG-\u001a=Ek6\u0004XI\u001d:peN\u001c\"\u0001\u00065\u0015\u0005\u0005u\u0015AH7jg6\u000bGo\u00195fg\u001a{'\u000fV5nK&sG-\u001a=GS2,7/T1q+\t\tY\u000b\u0005\u0005\u0002Z\u0005\r\u00141BAW!\u0019\tI&a,\u0002z%!\u0011\u0011WA.\u0005-\t%O]1z\u0005V4g-\u001a:\u0002?5L7/T1uG\",7OR8s)&lW-\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004\b%A\npkR|em\u0014:eKJ$\u0016.\\3ti\u0006l\u0007/\u0001\u000bpkR|em\u0014:eKJ$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u0016g\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8e\u0003Y\u0019\b.\u00197m_^|eMZ:fi:{GOR8v]\u0012\u0004\u0013a\u0006:fG>\u0014H-T5t[\u0006$8\r\u001b+j[\u0016Le\u000eZ3y)\u001di\u0018\u0011YAb\u0003\u000fDq!!\n\u001d\u0001\u0004\t9\u0003C\u0004\u0002Fr\u0001\r!a \u0002\u001d%tG-\u001a=US6,7\u000f^1na\"9\u0011\u0011\u001a\u000fA\u0002\u0005}\u0014\u0001\u00047pORKW.Z:uC6\u0004\u0018A\b:fG>\u0014HmT;u\u001f\u001a|%\u000fZ3s\u0013:$W\r\u001f+j[\u0016\u001cH/Y7q)\u001di\u0018qZAi\u0003'Dq!!\n\u001e\u0001\u0004\t9\u0003C\u0004\u0002Fv\u0001\r!a \t\u000f\u0005UW\u00041\u0001\u0002\u0000\u0005\u0011\u0002O]3w\u0013:$W\r\u001f+j[\u0016\u001cH/Y7q\u0003m\u0011XmY8sINC\u0017\r\u001c7po>3gm]3u\u001d>$hi\\;oIR9Q0a7\u0002^\u0006\u0005\bbBA\u0013=\u0001\u0007\u0011q\u0005\u0005\b\u0003?t\u0002\u0019AA@\u0003-Ig\u000eZ3y\u001f\u001a47/\u001a;\t\u000f\u0005\rh\u00041\u0001\u0002\u0000\u0005IAn\\4PM\u001a\u001cX\r^\u0001\faJLg\u000e^#se>\u00148\u000fF\u0001~\u00055iUm]:bO\u0016\u0004\u0016M]:feV1\u0011Q^A\u0000\u0005+\u0019\"a\u00035\u0002\u000bA\f'o]3\u0015\t\u0005M(\u0011\u0004\t\bS\u0006m\u0014Q\u001fB\t!\u0015I\u0017q_A~\u0013\r\tIP\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005u\u0018q \u0007\u0001\t\u001d\u0011\ta\u0003b\u0001\u0005\u0007\u0011\u0011aS\t\u0005\u0005\u000b\u0011Y\u0001E\u0002j\u0005\u000fI1A!\u0003k\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!\u001bB\u0007\u0013\r\u0011yA\u001b\u0002\u0004\u0003:L\b#B5\u0002x\nM\u0001\u0003BA\u007f\u0005+!qAa\u0006\f\u0005\u0004\u0011\u0019AA\u0001W\u0011\u001d\u0011Y\u0002\u0004a\u0001\u0005;\taA]3d_J$\u0007\u0003\u0002B\u0010\u0005ci!A!\t\u000b\t\tm!1\u0005\u0006\u0005\u0005K\u00119#\u0001\u0004d_6lwN\u001c\u0006\u0004E\n%\"\u0002\u0002B\u0016\u0005[\ta!\u00199bG\",'B\u0001B\u0018\u0003\ry'oZ\u0005\u0005\u0005g\u0011\tC\u0001\u0004SK\u000e|'\u000f\u001a\u0002\u0015\t\u0016\u001cw\u000eZ3s\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0016\r\te\"q\bB\"'\u0011i\u0001Na\u000f\u0011\u000f\u0005}5B!\u0010\u0003BA!\u0011Q B \t\u001d\u0011\t!\u0004b\u0001\u0005\u0007\u0001B!!@\u0003D\u00119!qC\u0007C\u0002\t\r\u0011AC6fs\u0012+7m\u001c3feB1!\u0011\nB)\u0005{i!Aa\u0013\u000b\t\t5#qJ\u0001\u0004CBL'b\u00011\u0003(%!!1\u000bB&\u0005\u001d!UmY8eKJ\fAB^1mk\u0016$UmY8eKJ\u0004bA!\u0013\u0003R\t\u0005CC\u0002B.\u0005;\u0012y\u0006E\u0004\u0002 6\u0011iD!\u0011\t\u000f\t\u0015\u0003\u00031\u0001\u0003H!9!Q\u000b\tA\u0002\t]C\u0003\u0002B2\u0005S\u0002r![A>\u0005K\u00129\u0007E\u0003j\u0003o\u0014i\u0004E\u0003j\u0003o\u0014\t\u0005C\u0004\u0003\u001cE\u0001\rA!\b\u0002\u000f\u0011,X\u000e\u001d'pORyQPa\u001c\u0003r\tU$\u0011\u0010B?\u0005#\u0013)\nC\u0004\u0002&I\u0001\r!a\n\t\u000f\tM$\u00031\u0001\u0002J\u0005i\u0001O]5oi\u000e{g\u000e^3oiNDqAa\u001e\u0013\u0001\u0004\t9&A\u0011o_:\u001cuN\\:fGV$\u0018N^3QC&\u00148OR8s\u0019><g)\u001b7fg6\u000b\u0007\u000fC\u0004\u0003|I\u0001\r!!\u0013\u0002\u001f%\u001cH)Z3q\u0013R,'/\u0019;j_:DqAa \u0013\u0001\u0004\u0011\t)\u0001\u0004qCJ\u001cXM\u001d\u0019\u0007\u0005\u0007\u00139I!$\u0011\u000f\u0005}5B!\"\u0003\fB!\u0011Q BD\t1\u0011II! \u0002\u0002\u0003\u0005)\u0011\u0001B\u0002\u0005\ryF%\r\t\u0005\u0003{\u0014i\t\u0002\u0007\u0003\u0010\nu\u0014\u0011!A\u0001\u0006\u0003\u0011\u0019AA\u0002`IIBqAa%\u0013\u0001\u0004\tI%\u0001\ntW&\u0004(+Z2pe\u0012lU\r^1eCR\f\u0007b\u0002BL%\u0001\u0007\u0011\u0011R\u0001\t[\u0006D()\u001f;fg\u0006y\u0001O]5oi\n\u000bGo\u00195MKZ,G\u000eF\u0003~\u0005;\u0013y\u000bC\u0004\u0003 N\u0001\rA!)\u0002\u000b\t\fGo\u00195\u0011\t\t\r&\u0011\u0016\b\u0005\u0005?\u0011)+\u0003\u0003\u0003(\n\u0005\u0012A\u0005$jY\u0016dunZ%oaV$8\u000b\u001e:fC6LAAa+\u0003.\n1b)\u001b7f\u0007\"\fgN\\3m%\u0016\u001cwN\u001d3CCR\u001c\u0007N\u0003\u0003\u0003(\n\u0005\u0002b\u0002BY'\u0001\u0007\u0011qP\u0001\u0012C\u000e\u001cW/\\;mCRLg/\u001a\"zi\u0016\u001c(\u0001F(gMN,Go]'fgN\fw-\u001a)beN,'o\u0005\u0003!Q\n]\u0006cBAP\u0017\u0005-\u00111\u0002\u000b\u0003\u0005w\u00032!a(!\u0003\u0015\u0019XM\u001d3f+\t\u0011\t\r\u0005\u0003\u0003D\n5WB\u0001Bc\u0015\u0011\u00119M!3\u0002\u000b\u001d\u0014x.\u001e9\u000b\t\t-'qE\u0001\fG>|'\u000fZ5oCR|'/\u0003\u0003\u0003P\n\u0015'AF\"p_J$\u0017N\\1u_J\u0014VmY8sIN+'\u000fZ3\u0002\rM,'\u000fZ3!\u0003)\u0001(/\u001a9be\u0016\\U-\u001f\u000b\u0007\u0003\u0017\u00119Na:\t\u000f\teG\u00051\u0001\u0003\\\u00069Q.Z:tC\u001e,\u0007\u0003\u0002Bo\u0005Gl!Aa8\u000b\t\t\u0005(1E\u0001\taJ|Go\\2pY&!!Q\u001dBp\u0005\u001diUm]:bO\u0016DqA!;%\u0001\u0004\u0011Y/A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0007%\u0014i/C\u0002\u0003p*\u0014Qa\u00155peR\f\u0011\u0004\u001d:fa\u0006\u0014Xm\u0012:pkBlU\r^1eCR\fg+\u00197vKR1!Q_B\u0007\u00077\u0001BAa>\u0004\n5\u0011!\u0011 \u0006\u0005\u0005w\u0014i0\u0001\u0005eCR\f'-\u001b8e\u0015\u0011\u0011yp!\u0001\u0002\u000f)\f7m[:p]*!11AB\u0003\u0003%1\u0017m\u001d;feblGN\u0003\u0002\u0004\b\u0005\u00191m\\7\n\t\r-!\u0011 \u0002\t\u0015N|gNT8eK\"9!\u0011\\\u0013A\u0002\r=\u0001\u0003BB\t\u0007/i!aa\u0005\u000b\t\rU!QY\u0001\nO\u0016tWM]1uK\u0012LAa!\u0007\u0004\u0014\t\u0011rI]8va6+G/\u00193bi\u00064\u0016\r\\;f\u0011\u001d\u0011I/\na\u0001\u0005W\fA\u0002\u001d:fa\u0006\u0014XMV1mk\u0016$b!a\u0003\u0004\"\r\r\u0002b\u0002BmM\u0001\u0007!1\u001c\u0005\b\u0005S4\u0003\u0019\u0001Bv)\u0011\u00199ca\u000b\u0011\u000f%\fYh!\u000b\u0004*A)\u0011.a>\u0002\f!9!1D\u0014A\u0002\tu!a\u0007+sC:\u001c\u0018m\u0019;j_:dunZ'fgN\fw-\u001a)beN,'o\u0005\u0003)Q\n]FCAB\u001a!\r\ty\n\u000b\u000b\u0005\u0007O\u00199\u0004C\u0004\u0003\u001c)\u0002\rA!\b\u0003'E+x\u000e^1t\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0014\t-B'q\u0017\u000b\u0003\u0007\u007f\u00012!a(,)\u0011\u00199ca\u0011\t\u000f\tmQ\u00061\u0001\u0003\u001e\ty2\t\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018\rT8h\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0014\t9B'q\u0017\u000b\u0003\u0007\u0017\u00022!a(/\u0003MiW\r^1eCR\f'+Z2pe\u0012\u001cVM\u001d3f+\t\u0019\t\u0006\u0005\u0003\u0004T\reSBAB+\u0015\u0011\u00199Fa\n\u0002\u00115,G/\u00193bi\u0006LAaa\u0017\u0004V\t\u0019R*\u001a;bI\u0006$\u0018MU3d_J$7+\u001a:eK\u0006!R.\u001a;bI\u0006$\u0018MU3d_J$7+\u001a:eK\u0002\"Baa\n\u0004b!9!1\u0004\u001aA\u0002\tu!A\u0006#v[BdunZ*fO6,g\u000e^:PaRLwN\\:\u0014\u0007M\u001a9\u0007\u0005\u0003\u0004j\rMTBAB6\u0015\u0011\u0019iga\u001c\u0002\tU$\u0018\u000e\u001c\u0006\u0005\u0007c\u00129#\u0001\u0004tKJ4XM]\u0005\u0005\u0007k\u001aYGA\u000bD_6l\u0017M\u001c3EK\u001a\fW\u000f\u001c;PaRLwN\\:\u0015\t\re41\u0010\t\u0004\u0003?\u001b\u0004bBA\u0002k\u0001\u0007\u0011QA\u0001\taJLg\u000e^(qiV\u00111\u0011\u0011\t\u0005\u0007\u0007\u001bI)\u0004\u0002\u0004\u0006*\u00111qQ\u0001\u000bU>\u0004Ho]5na2,\u0017\u0002BBF\u0007\u000b\u0013\u0011c\u00149uS>t7\u000b]3d\u0005VLG\u000eZ3s\u0003%\u0001(/\u001b8u\u001fB$\b%A\u0005wKJLg-_(qi\u0006Qa/\u001a:jMf|\u0005\u000f\u001e\u0011\u0002\u001d%tG-\u001a=TC:LG/_(qi\u0006y\u0011N\u001c3fqN\u000bg.\u001b;z\u001fB$\b%\u0001\u0005gS2,7o\u00149u+\t\u0019Y\n\u0005\u0004\u0004\u0004\u000eu\u00151B\u0005\u0005\u0007?\u001b)IA\u000eBe\u001e,X.\u001a8u\u0003\u000e\u001cW\r\u001d;j]\u001e|\u0005\u000f^5p]N\u0003XmY\u0001\nM&dWm](qi\u0002\n\u0011#\\1y\u001b\u0016\u001c8/Y4f'&TXm\u00149u+\t\u00199\u000b\u0005\u0004\u0004\u0004\u000eu5\u0011\u0016\t\u0004g\u000e-\u0016bABWi\n9\u0011J\u001c;fO\u0016\u0014\u0018AE7bq6+7o]1hKNK'0Z(qi\u0002\n1\"\\1y\u0005f$Xm](qi\u0006aQ.\u0019=CsR,7o\u00149uA\u0005\u0001B-Z3q\u0013R,'/\u0019;j_:|\u0005\u000f^\u0001\u0012I\u0016,\u0007/\u0013;fe\u0006$\u0018n\u001c8PaR\u0004\u0013a\u0004<bYV,G)Z2pI\u0016\u0014x\n\u001d;\u0016\u0005\ru\u0006#BBB\u0007;\u0013\u0018\u0001\u0005<bYV,G)Z2pI\u0016\u0014x\n\u001d;!\u00035YW-\u001f#fG>$WM](qi\u0006q1.Z=EK\u000e|G-\u001a:PaR\u0004\u0013AC8gMN,Go](qi\u0006YqN\u001a4tKR\u001cx\n\u001d;!\u0003E!(/\u00198tC\u000e$\u0018n\u001c8M_\u001e|\u0005\u000f^\u0001\u0013iJ\fgn]1di&|g\u000eT8h\u001fB$\b%\u0001\ndYV\u001cH/\u001a:NKR\fG-\u0019;b\u001fB$\u0018aE2mkN$XM]'fi\u0006$\u0017\r^1PaR\u0004\u0013!F:lSB\u0014VmY8sI6+G/\u00193bi\u0006|\u0005\u000f^\u0001\u0017g.L\u0007OU3d_J$W*\u001a;bI\u0006$\u0018m\u00149uA\u0005I\u0011/^8uCN|\u0005\u000f^\u0001\u000bcV|G/Y:PaR\u0004\u0013!D7fgN\fw-\u001a)beN,'/\u0006\u0002\u0004^B21q\\Br\u0007S\u0004r!a(\f\u0007C\u001c9\u000f\u0005\u0003\u0002~\u000e\rHaCBs%\u0006\u0005\t\u0011!B\u0001\u0005\u0007\u00111a\u0018\u00134!\u0011\tip!;\u0005\u0017\r-(+!A\u0001\u0002\u000b\u0005!1\u0001\u0002\u0004?\u0012\"\u0014AE:i_VdG\r\u0015:j]R$\u0015\r^1M_\u001e,\"!!\u0013\u0002\u000b\u0019LG.Z:\u0016\u0005\u0005\u0015QCAAE\u0003%\u0019\u0007.Z2l\u0003J<7/\u0001\u0006oK^$UmY8eKJ$Ba!@\u0005\bA\"1q C\u0002!\u0019\u0011IE!\u0015\u0005\u0002A!\u0011Q C\u0002\t-!)\u0001XA\u0001\u0002\u0003\u0015\tAa\u0001\u0003\u0007}#S\u0007C\u0004\u0005\nq\u0003\r!a\u0003\u0002\u0013\rd\u0017m]:OC6,\u0017!H2p]Z,'\u000f\u001e#faJ,7-\u0019;fI\u0012+7m\u001c3fe\u000ec\u0017m]:\u0015\t\u0005-Aq\u0002\u0005\b\t\u0013i\u0006\u0019AA\u0006\u0001")
public final class DumpLogSegments {
    public static void main(String[] args) {
        DumpLogSegments$.MODULE$.main(args);
    }

    private static class ClusterMetadataLogMessageParser
    implements MessageParser<String, String> {
        private final MetadataRecordSerde metadataRecordSerde = new MetadataRecordSerde();

        private MetadataRecordSerde metadataRecordSerde() {
            return this.metadataRecordSerde;
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            String string;
            try {
                ApiMessageAndVersion messageAndVersion = this.metadataRecordSerde().read((Readable)new ByteBufferAccessor(record.value()), record.valueSize());
                ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
                MetadataRecordType metadataRecordType = MetadataRecordType.fromId((short)messageAndVersion.message().apiKey());
                if (metadataRecordType == null) {
                    throw null;
                }
                json.set("type", (JsonNode)new TextNode(metadataRecordType.name()));
                json.set("version", (JsonNode)new IntNode((int)messageAndVersion.version()));
                json.set("data", MetadataJsonConverters.writeJson((ApiMessage)messageAndVersion.message(), (short)messageAndVersion.version()));
                string = json.toString();
            }
            catch (Throwable e) {
                string = new StringBuilder(21).append("Error at ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString();
            }
            String output = string;
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)output));
        }
    }

    private static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            None$ key;
            Object object = key = record.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.key()))) : None$.MODULE$;
            if (!record.hasValue()) {
                return new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.value())));
            return new Tuple2((Object)key, (Object)payload);
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    private static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private boolean shouldPrintDataLog;
        private boolean skipRecordMetadata;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private int maxBytes;
        private OptionSpecBuilder printOpt;
        private OptionSpecBuilder verifyOpt;
        private OptionSpecBuilder indexSanityOpt;
        private final ArgumentAcceptingOptionSpec<String> filesOpt;
        private ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt;
        private ArgumentAcceptingOptionSpec<Integer> maxBytesOpt;
        private OptionSpecBuilder deepIterationOpt;
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt;
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt;
        private final OptionSpecBuilder offsetsOpt;
        private final OptionSpecBuilder transactionLogOpt;
        private final OptionSpecBuilder clusterMetadataOpt;
        private OptionSpecBuilder skipRecordMetadataOpt;
        private final OptionSpecBuilder quotasOpt;
        private volatile byte bitmap$0;

        private OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        private OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        private OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        private ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        private ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        private ArgumentAcceptingOptionSpec<Integer> maxBytesOpt() {
            return this.maxBytesOpt;
        }

        private OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        private ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        private ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        private OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        private OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        private OptionSpecBuilder clusterMetadataOpt() {
            return this.clusterMetadataOpt;
        }

        private OptionSpecBuilder skipRecordMetadataOpt() {
            return this.skipRecordMetadataOpt;
        }

        public OptionSpecBuilder quotasOpt() {
            return this.quotasOpt;
        }

        public MessageParser<?, ?> messageParser() {
            if (this.options.has((OptionSpec)this.offsetsOpt())) {
                return new OffsetsMessageParser();
            }
            if (this.options.has((OptionSpec)this.transactionLogOpt())) {
                return new TransactionLogMessageParser();
            }
            if (this.options.has((OptionSpec)this.clusterMetadataOpt())) {
                return new ClusterMetadataLogMessageParser();
            }
            if (this.options.has((OptionSpec)this.quotasOpt())) {
                return new QuotasMessageParser();
            }
            Decoder<?> valueDecoder = DumpLogSegments$.MODULE$.newDecoder((String)this.options.valueOf(this.valueDecoderOpt()));
            Decoder<?> keyDecoder = DumpLogSegments$.MODULE$.newDecoder((String)this.options.valueOf(this.keyDecoderOpt()));
            return new DecoderMessageParser(keyDecoder, valueDecoder);
        }

        private boolean shouldPrintDataLog$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options.has((OptionSpec)this.printOpt()) || this.options.has((OptionSpec)this.offsetsOpt()) || this.options.has((OptionSpec)this.transactionLogOpt()) || this.options.has((OptionSpec)this.clusterMetadataOpt()) || this.options.has((OptionSpec)this.quotasOpt()) || this.options.has(this.valueDecoderOpt()) || this.options.has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            this.printOpt = null;
            return this.shouldPrintDataLog;
        }

        public boolean shouldPrintDataLog() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.shouldPrintDataLog$lzycompute();
            }
            return this.shouldPrintDataLog;
        }

        private boolean skipRecordMetadata$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.skipRecordMetadata = this.options.has((OptionSpec)this.skipRecordMetadataOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            this.skipRecordMetadataOpt = null;
            return this.skipRecordMetadata;
        }

        public boolean skipRecordMetadata() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.skipRecordMetadata$lzycompute();
            }
            return this.skipRecordMetadata;
        }

        private boolean isDeepIteration$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.isDeepIteration = this.options.has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            this.deepIterationOpt = null;
            return this.isDeepIteration;
        }

        public boolean isDeepIteration() {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                return this.isDeepIteration$lzycompute();
            }
            return this.isDeepIteration;
        }

        private boolean verifyOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.verifyOnly = this.options.has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            this.verifyOpt = null;
            return this.verifyOnly;
        }

        public boolean verifyOnly() {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                return this.verifyOnly$lzycompute();
            }
            return this.verifyOnly;
        }

        private boolean indexSanityOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.indexSanityOnly = this.options.has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            this.indexSanityOpt = null;
            return this.indexSanityOnly;
        }

        public boolean indexSanityOnly() {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                return this.indexSanityOnly$lzycompute();
            }
            return this.indexSanityOnly;
        }

        private String[] files$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.files = ((String)this.options.valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.files;
        }

        public String[] files() {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                return this.files$lzycompute();
            }
            return this.files;
        }

        private int maxMessageSize$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x40) == 0) {
                    this.maxMessageSize = (Integer)this.options.valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
                }
            }
            this.maxMessageSizeOpt = null;
            return this.maxMessageSize;
        }

        public int maxMessageSize() {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                return this.maxMessageSize$lzycompute();
            }
            return this.maxMessageSize;
        }

        private int maxBytes$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x80) == 0) {
                    this.maxBytes = (Integer)this.options.valueOf(this.maxBytesOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
                }
            }
            this.maxBytesOpt = null;
            return this.maxBytes;
        }

        public int maxBytes() {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                return this.maxBytes$lzycompute();
            }
            return this.maxBytes;
        }

        public void checkArgs() {
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.filesOpt()});
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args);
            this.printOpt = this.parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
            this.verifyOpt = this.parser.accepts("verify-index-only", "if set, just verify the index log without printing its content.");
            this.indexSanityOpt = this.parser.accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
            this.filesOpt = this.parser.accepts("files", "REQUIRED: The comma separated list of files to be dumped. The supported file types include log files, index files, time index files, transaction index files, producer snapshots and tier state files.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
            this.maxMessageSizeOpt = this.parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
            this.maxBytesOpt = this.parser.accepts("max-bytes", "Limit the amount of total batches read in bytes avoiding reading the whole .log file(s).").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
            this.deepIterationOpt = this.parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
            this.valueDecoderOpt = this.parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement org.apache.kafka.tools.api.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)StringDecoder.class.getName(), (Object[])new String[0]);
            this.keyDecoderOpt = this.parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement org.apache.kafka.tools.api.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)StringDecoder.class.getName(), (Object[])new String[0]);
            this.offsetsOpt = this.parser.accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
            this.transactionLogOpt = this.parser.accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
            this.clusterMetadataOpt = this.parser.accepts("cluster-metadata-decoder", "if set, log data will be parsed as cluster metadata records.");
            this.skipRecordMetadataOpt = this.parser.accepts("skip-record-metadata", "whether to skip printing metadata for each record.");
            this.quotasOpt = this.parser.accepts("quotas-decoder", "if set, log data will be parsed as quotas data from the _confluent-quotas topic");
            this.options = this.parser.parse(args);
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    public static class OffsetsMessageParser
    implements MessageParser<String, String> {
        private final CoordinatorRecordSerde serde = new CoordinatorRecordSerde();

        private CoordinatorRecordSerde serde() {
            return this.serde;
        }

        private String prepareKey(Message message, short version) {
            JsonNode jsonNode;
            if (message instanceof OffsetCommitKey) {
                jsonNode = OffsetCommitKeyJsonConverter.write((OffsetCommitKey)((OffsetCommitKey)message), (short)version, (boolean)true);
            } else if (message instanceof GroupMetadataKey) {
                jsonNode = GroupMetadataKeyJsonConverter.write((GroupMetadataKey)((GroupMetadataKey)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupMetadataKey) {
                jsonNode = ConsumerGroupMetadataKeyJsonConverter.write((ConsumerGroupMetadataKey)((ConsumerGroupMetadataKey)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupPartitionMetadataKey) {
                jsonNode = ConsumerGroupPartitionMetadataKeyJsonConverter.write((ConsumerGroupPartitionMetadataKey)((ConsumerGroupPartitionMetadataKey)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupMemberMetadataKey) {
                jsonNode = ConsumerGroupMemberMetadataKeyJsonConverter.write((ConsumerGroupMemberMetadataKey)((ConsumerGroupMemberMetadataKey)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupTargetAssignmentMetadataKey) {
                jsonNode = ConsumerGroupTargetAssignmentMetadataKeyJsonConverter.write((ConsumerGroupTargetAssignmentMetadataKey)((ConsumerGroupTargetAssignmentMetadataKey)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupTargetAssignmentMemberKey) {
                jsonNode = ConsumerGroupTargetAssignmentMemberKeyJsonConverter.write((ConsumerGroupTargetAssignmentMemberKey)((ConsumerGroupTargetAssignmentMemberKey)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupCurrentMemberAssignmentKey) {
                jsonNode = ConsumerGroupCurrentMemberAssignmentKeyJsonConverter.write((ConsumerGroupCurrentMemberAssignmentKey)((ConsumerGroupCurrentMemberAssignmentKey)message), (short)version, (boolean)true);
            } else {
                throw new CoordinatorLoader.UnknownRecordTypeException(version);
            }
            JsonNode messageAsJson = jsonNode;
            ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
            json.set("type", (JsonNode)new TextNode(Short.toString(version)));
            json.set("data", messageAsJson);
            return json.toString();
        }

        private JsonNode prepareGroupMetadataValue(GroupMetadataValue message, short version) {
            JsonNode json = GroupMetadataValueJsonConverter.write((GroupMetadataValue)message, (short)version, (boolean)true);
            Option$.MODULE$.apply((Object)json.get("protocolType")).foreach((Function1 & Serializable)protocolTypeNode -> {
                OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$2(json, protocolTypeNode);
                return BoxedUnit.UNIT;
            });
            return json;
        }

        private String prepareValue(Message message, short version) {
            JsonNode jsonNode;
            if (message instanceof OffsetCommitValue) {
                jsonNode = OffsetCommitValueJsonConverter.write((OffsetCommitValue)((OffsetCommitValue)message), (short)version, (boolean)true);
            } else if (message instanceof GroupMetadataValue) {
                GroupMetadataValue groupMetadataValue = (GroupMetadataValue)message;
                jsonNode = this.prepareGroupMetadataValue(groupMetadataValue, version);
            } else if (message instanceof ConsumerGroupMetadataValue) {
                jsonNode = ConsumerGroupMetadataValueJsonConverter.write((ConsumerGroupMetadataValue)((ConsumerGroupMetadataValue)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupPartitionMetadataValue) {
                jsonNode = ConsumerGroupPartitionMetadataValueJsonConverter.write((ConsumerGroupPartitionMetadataValue)((ConsumerGroupPartitionMetadataValue)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupMemberMetadataValue) {
                jsonNode = ConsumerGroupMemberMetadataValueJsonConverter.write((ConsumerGroupMemberMetadataValue)((ConsumerGroupMemberMetadataValue)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupTargetAssignmentMetadataValue) {
                jsonNode = ConsumerGroupTargetAssignmentMetadataValueJsonConverter.write((ConsumerGroupTargetAssignmentMetadataValue)((ConsumerGroupTargetAssignmentMetadataValue)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupTargetAssignmentMemberValue) {
                jsonNode = ConsumerGroupTargetAssignmentMemberValueJsonConverter.write((ConsumerGroupTargetAssignmentMemberValue)((ConsumerGroupTargetAssignmentMemberValue)message), (short)version, (boolean)true);
            } else if (message instanceof ConsumerGroupCurrentMemberAssignmentValue) {
                jsonNode = ConsumerGroupCurrentMemberAssignmentValueJsonConverter.write((ConsumerGroupCurrentMemberAssignmentValue)((ConsumerGroupCurrentMemberAssignmentValue)message), (short)version, (boolean)true);
            } else {
                throw new IllegalStateException(new StringBuilder(32).append("Message value ").append(message.getClass().getSimpleName()).append(" is not supported.").toString());
            }
            JsonNode messageAsJson = jsonNode;
            ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
            json.set("version", (JsonNode)new TextNode(Short.toString(version)));
            json.set("data", messageAsJson);
            return json.toString();
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            if (!record.hasKey()) {
                throw new RuntimeException(new StringBuilder(90).append("Failed to decode message at offset ").append(record.offset()).append(" using offset ").append("topic decoder (message had a missing key)").toString());
            }
            try {
                CoordinatorRecord r = this.serde().deserialize(record.key(), record.value());
                return new Tuple2((Object)new Some((Object)this.prepareKey((Message)r.key().message(), r.key().version())), (Object)Option$.MODULE$.apply((Object)r.value()).map((Function1 & Serializable)v -> this.prepareValue((Message)v.message(), v.version())).orElse((Function0 & Serializable)() -> new Some((Object)"<DELETE>")));
            }
            catch (CoordinatorLoader.UnknownRecordTypeException e) {
                return new Tuple2((Object)new Some((Object)new StringBuilder(42).append("Unknown record type ").append(e.unknownType()).append(" at offset ").append(record.offset()).append(", skipping.").toString()), (Object)None$.MODULE$);
            }
            catch (Throwable e) {
                return new Tuple2((Object)new Some((Object)new StringBuilder(28).append("Error at offset ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString()), (Object)None$.MODULE$);
            }
        }

        private static final void replace$1(JsonNode node, String field, Function2 reader, Function2 writer) {
            Option$.MODULE$.apply((Object)node.get(field)).foreach((Function1 & Serializable)filedNode -> {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(filedNode.binaryValue());
                    ByteBufferAccessor accessor = new ByteBufferAccessor(buffer);
                    short version = accessor.readShort();
                    Object data = reader.apply((Object)accessor, (Object)BoxesRunTime.boxToShort((short)version));
                    return ((ObjectNode)node).replace(field, (JsonNode)writer.apply(data, (Object)BoxesRunTime.boxToShort((short)version)));
                }
                catch (RuntimeException runtimeException) {
                    return BoxedUnit.UNIT;
                }
            });
        }

        public static final /* synthetic */ ConsumerProtocolSubscription $anonfun$prepareGroupMetadataValue$5(Readable readable, short version) {
            return new ConsumerProtocolSubscription(readable, version);
        }

        public static final /* synthetic */ JsonNode $anonfun$prepareGroupMetadataValue$6(ConsumerProtocolSubscription x$1, short x$2) {
            return ConsumerProtocolSubscriptionJsonConverter.write((ConsumerProtocolSubscription)x$1, (short)x$2);
        }

        public static final /* synthetic */ ConsumerProtocolAssignment $anonfun$prepareGroupMetadataValue$7(Readable readable, short version) {
            return new ConsumerProtocolAssignment(readable, version);
        }

        public static final /* synthetic */ JsonNode $anonfun$prepareGroupMetadataValue$8(ConsumerProtocolAssignment x$1, short x$2) {
            return ConsumerProtocolAssignmentJsonConverter.write((ConsumerProtocolAssignment)x$1, (short)x$2);
        }

        public static final /* synthetic */ void $anonfun$prepareGroupMetadataValue$3(JsonNode membersNode) {
            if (membersNode.isArray()) {
                membersNode.forEach(memberNode -> {
                    void replace$1_writer;
                    void replace$1_reader;
                    void replace$1_writer2;
                    Function2 & Serializable intersect = (Function2 & Serializable)(x$1, x$2) -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$6(x$1, BoxesRunTime.unboxToShort((Object)x$2));
                    Function2 & Serializable replace$1_reader2 = (Function2 & Serializable)(readable, version) -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$5(readable, BoxesRunTime.unboxToShort((Object)version));
                    String replace$1_field = "subscription";
                    Option$.MODULE$.apply((Object)memberNode.get(replace$1_field)).foreach(arg_0 -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$1(replace$1_reader2, memberNode, replace$1_field, (Function2)replace$1_writer2, arg_0));
                    Object var1_3 = null;
                    Object var2_2 = null;
                    intersect = null;
                    Function2 & Serializable intersect2 = (Function2 & Serializable)(x$1, x$2) -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$8(x$1, BoxesRunTime.unboxToShort((Object)x$2));
                    Function2 & Serializable intersect3 = (Function2 & Serializable)(readable, version) -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$7(readable, BoxesRunTime.unboxToShort((Object)version));
                    String replace$1_field2 = "assignment";
                    Option$.MODULE$.apply((Object)memberNode.get(replace$1_field2)).foreach(arg_0 -> OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$1((Function2)replace$1_reader, memberNode, replace$1_field2, (Function2)replace$1_writer, arg_0));
                });
                return;
            }
        }

        public static final /* synthetic */ void $anonfun$prepareGroupMetadataValue$2(JsonNode json$1, JsonNode protocolTypeNode) {
            String string = protocolTypeNode.asText();
            String string2 = "consumer";
            if (string == null) {
                return;
            }
            if (string.equals(string2)) {
                Option$.MODULE$.apply((Object)json$1.get("members")).foreach((Function1 & Serializable)membersNode -> {
                    OffsetsMessageParser.$anonfun$prepareGroupMetadataValue$3(membersNode);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    private static class QuotasMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return QuotaStateManager$.MODULE$.formatRecordKeyAndValue(record);
        }
    }

    public static class TimeIndexDumpErrors {
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable)() -> new ArrayBuffer());
            if (misMatchesSeq.isEmpty()) {
                this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
            }
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable)() -> new ArrayBuffer());
            if (outOfOrderSeq.isEmpty()) {
                this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq);
            }
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable)() -> new ArrayBuffer());
            if (shallowOffsetNotFoundSeq.isEmpty()) {
                this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq);
            }
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1 & Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1 & Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1 & Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                String fileName = (String)x0$1._1();
                ArrayBuffer listOfMismatches = (ArrayBuffer)x0$1._2();
                System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
                listOfMismatches.foreach((Function1 & Serializable)m -> {
                    System.err.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            if (x0$2 != null) {
                String fileName = (String)x0$2._1();
                ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)x0$2._2();
                System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
                outOfOrderTimestamps.foreach((Function1 & Serializable)m -> {
                    System.err.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            if (x0$3 != null) {
                long indexedOffset = x0$3._1$mcJ$sp();
                long logOffset = x0$3._2$mcJ$sp();
                System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1 & Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return TransactionLog$.MODULE$.formatRecordKeyAndValue(record);
        }
    }
}

