/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security.authorizer;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class AuthorizerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizerUtils.class);
    private static final MetricName ACL_COUNT_METRIC_NAME = KafkaMetricsGroup.explicitMetricName((String)"kafka.security.authorizer", (String)"AclMetrics", (String)"AclCount", Collections.emptyMap());
    private static final KafkaMetricsGroup METRICS_GROUP = new KafkaMetricsGroup(AuthorizerUtils.class);

    public static Authorizer createAuthorizer(String className) throws ClassNotFoundException {
        return (Authorizer)Utils.newInstance((String)className, Authorizer.class);
    }

    public static Optional<Authorizer> configureAuthorizer(String className, Map<String, ?> configs) throws ClassNotFoundException {
        if (className == null || className.isEmpty()) {
            return Optional.empty();
        }
        Optional<Authorizer> authorizerOpt = Optional.of(AuthorizerUtils.createAuthorizer(className));
        authorizerOpt.ifPresent(authorizer -> {
            authorizer.configure(configs);
            METRICS_GROUP.newGauge(ACL_COUNT_METRIC_NAME, (Gauge)new Gauge<Integer>(){

                public Integer value() {
                    return authorizer.aclCount();
                }
            });
        });
        return authorizerOpt;
    }

    public static boolean isClusterResource(String name) {
        return name.endsWith("kafka-cluster");
    }

    public static void closeAuthorizer(Authorizer authorizer) {
        AtomicReference firstException = new AtomicReference();
        Utils.swallow((Logger)LOG, (Level)Level.WARN, (String)"Failed to close authorizer", () -> authorizer.close(), firstException);
        METRICS_GROUP.removeMetric(ACL_COUNT_METRIC_NAME);
    }

    public static AuthorizableRequestContext sessionToRequestContext(final Session session) {
        return new AuthorizableRequestContext(){

            public String clientId() {
                return "";
            }

            public int requestType() {
                return -1;
            }

            public String listenerName() {
                return "";
            }

            public InetAddress clientAddress() {
                return session.clientAddress;
            }

            public boolean isProxyModeLocal() {
                return false;
            }

            public KafkaPrincipal principal() {
                return session.principal;
            }

            public SecurityProtocol securityProtocol() {
                return null;
            }

            public int correlationId() {
                return -1;
            }

            public int requestVersion() {
                return -1;
            }
        };
    }
}

