/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.observers;

import io.confluent.shaded.io.reactivex.CompletableObserver;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;

public final class SubscriberCompletableObserver<T>
implements CompletableObserver,
Subscription {
    final Subscriber<? super T> subscriber;
    Disposable upstream;

    public SubscriberCompletableObserver(Subscriber<? super T> subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }

    @Override
    public void onError(Throwable e) {
        this.subscriber.onError(e);
    }

    @Override
    public void onSubscribe(Disposable d) {
        if (DisposableHelper.validate(this.upstream, d)) {
            this.upstream = d;
            this.subscriber.onSubscribe(this);
        }
    }

    @Override
    public void request(long n) {
    }

    @Override
    public void cancel() {
        this.upstream.dispose();
    }
}

