/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Completable;
import io.confluent.shaded.io.reactivex.CompletableObserver;
import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.fuseable.FuseToFlowable;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.FlowableIgnoreElements;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Subscription;

public final class FlowableIgnoreElementsCompletable<T>
extends Completable
implements FuseToFlowable<T> {
    final Flowable<T> source;

    public FlowableIgnoreElementsCompletable(Flowable<T> source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(CompletableObserver t) {
        this.source.subscribe(new IgnoreElementsSubscriber(t));
    }

    @Override
    public Flowable<T> fuseToFlowable() {
        return RxJavaPlugins.onAssembly(new FlowableIgnoreElements<T>(this.source));
    }

    static final class IgnoreElementsSubscriber<T>
    implements FlowableSubscriber<T>,
    Disposable {
        final CompletableObserver downstream;
        Subscription upstream;

        IgnoreElementsSubscriber(CompletableObserver downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
        }

        @Override
        public void onError(Throwable t) {
            this.upstream = SubscriptionHelper.CANCELLED;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.upstream = SubscriptionHelper.CANCELLED;
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELLED;
        }

        @Override
        public boolean isDisposed() {
            return this.upstream == SubscriptionHelper.CANCELLED;
        }
    }
}

