/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Consumer;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.fuseable.HasUpstreamObservableSource;
import io.confluent.shaded.io.reactivex.internal.operators.observable.ObservablePublishClassic;
import io.confluent.shaded.io.reactivex.internal.util.ExceptionHelper;
import io.confluent.shaded.io.reactivex.observables.ConnectableObservable;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservablePublish<T>
extends ConnectableObservable<T>
implements HasUpstreamObservableSource<T>,
ObservablePublishClassic<T> {
    final ObservableSource<T> source;
    final AtomicReference<PublishObserver<T>> current;
    final ObservableSource<T> onSubscribe;

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source) {
        AtomicReference curr = new AtomicReference();
        PublishSource onSubscribe = new PublishSource(curr);
        return RxJavaPlugins.onAssembly(new ObservablePublish(onSubscribe, source, curr));
    }

    private ObservablePublish(ObservableSource<T> onSubscribe, ObservableSource<T> source, AtomicReference<PublishObserver<T>> current) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
    }

    @Override
    public ObservableSource<T> source() {
        return this.source;
    }

    @Override
    public ObservableSource<T> publishSource() {
        return this.source;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.onSubscribe.subscribe(observer);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        PublishObserver<T> ps;
        while ((ps = this.current.get()) == null || ps.isDisposed()) {
            PublishObserver<T> u = new PublishObserver<T>(this.current);
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (doConnect) {
            this.source.subscribe(ps);
        }
    }

    static final class PublishSource<T>
    implements ObservableSource<T> {
        private final AtomicReference<PublishObserver<T>> curr;

        PublishSource(AtomicReference<PublishObserver<T>> curr) {
            this.curr = curr;
        }

        @Override
        public void subscribe(Observer<? super T> child) {
            PublishObserver<? super T> r;
            InnerDisposable<? super T> inner = new InnerDisposable<T>(child);
            child.onSubscribe(inner);
            while (true) {
                if ((r = this.curr.get()) == null || r.isDisposed()) {
                    PublishObserver<T> u = new PublishObserver<T>(this.curr);
                    if (!this.curr.compareAndSet(r, u)) continue;
                    r = u;
                }
                if (r.add(inner)) break;
            }
            inner.setParent(r);
        }
    }

    static final class InnerDisposable<T>
    extends AtomicReference<Object>
    implements Disposable {
        private static final long serialVersionUID = -1100270633763673112L;
        final Observer<? super T> child;

        InnerDisposable(Observer<? super T> child) {
            this.child = child;
        }

        @Override
        public boolean isDisposed() {
            return this.get() == this;
        }

        @Override
        public void dispose() {
            InnerDisposable o = this.getAndSet(this);
            if (o != null && o != this) {
                ((PublishObserver)((Object)o)).remove(this);
            }
        }

        void setParent(PublishObserver<T> p) {
            if (!this.compareAndSet(null, p)) {
                p.remove(this);
            }
        }
    }

    static final class PublishObserver<T>
    implements Observer<T>,
    Disposable {
        final AtomicReference<PublishObserver<T>> current;
        static final InnerDisposable[] EMPTY = new InnerDisposable[0];
        static final InnerDisposable[] TERMINATED = new InnerDisposable[0];
        final AtomicReference<InnerDisposable<T>[]> observers;
        final AtomicBoolean shouldConnect;
        final AtomicReference<Disposable> upstream = new AtomicReference();

        PublishObserver(AtomicReference<PublishObserver<T>> current) {
            this.observers = new AtomicReference<InnerDisposable[]>(EMPTY);
            this.current = current;
            this.shouldConnect = new AtomicBoolean();
        }

        @Override
        public void dispose() {
            InnerDisposable[] ps = this.observers.getAndSet(TERMINATED);
            if (ps != TERMINATED) {
                this.current.compareAndSet(this, null);
                DisposableHelper.dispose(this.upstream);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.observers.get() == TERMINATED;
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this.upstream, d);
        }

        @Override
        public void onNext(T t) {
            for (InnerDisposable<T> inner : this.observers.get()) {
                inner.child.onNext(t);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.current.compareAndSet(this, null);
            InnerDisposable[] a = this.observers.getAndSet(TERMINATED);
            if (a.length != 0) {
                for (InnerDisposable inner : a) {
                    inner.child.onError(e);
                }
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.current.compareAndSet(this, null);
            for (InnerDisposable inner : this.observers.getAndSet(TERMINATED)) {
                inner.child.onComplete();
            }
        }

        boolean add(InnerDisposable<T> producer) {
            InnerDisposable[] u;
            InnerDisposable<T>[] c;
            do {
                if ((c = this.observers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerDisposable[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.observers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerDisposable<T> producer) {
            InnerDisposable[] u;
            InnerDisposable<T>[] c;
            do {
                int len;
                if ((len = (c = this.observers.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                    continue;
                }
                u = new InnerDisposable[len - 1];
                System.arraycopy(c, 0, u, 0, j);
                System.arraycopy(c, j + 1, u, j, len - j - 1);
            } while (!this.observers.compareAndSet(c, u));
        }
    }
}

