/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import com.google.common.base.Strings;
import io.confluent.common.security.auth.CertificatePrincipal;
import io.confluent.common.security.auth.LeaderForwardChecker;
import io.confluent.common.security.auth.TokenProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtlsLeaderProxyFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MtlsLeaderProxyFilter.class);
    private final LeaderForwardChecker<HttpServletRequest> leaderForwardChecker;
    private final TokenProvider<String> tokenProvider;

    public MtlsLeaderProxyFilter(LeaderForwardChecker<HttpServletRequest> leaderForwardChecker, TokenProvider<String> tokenProvider) {
        this.leaderForwardChecker = leaderForwardChecker;
        this.tokenProvider = tokenProvider;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.leaderForwardChecker.shouldForwardToLeader(httpRequest) && Strings.isNullOrEmpty((String)httpRequest.getHeader("Authorization")) && httpRequest.getUserPrincipal() instanceof CertificatePrincipal) {
            String authenticatedUserName = httpRequest.getUserPrincipal().getName();
            log.debug("Getting impersonation token for certificate user: `" + authenticatedUserName + " calling: `" + httpRequest.getRequestURI() + "`.");
            String token = this.tokenProvider.get(authenticatedUserName);
            if (token != null) {
                MtlsImpersonationRequestWrapper forwardRequest = new MtlsImpersonationRequestWrapper((HttpServletRequest)request);
                forwardRequest.addAuthorizationHeader(token);
                filterChain.doFilter((ServletRequest)forwardRequest, response);
                return;
            }
            log.warn("Continuing without adding a token in request for certificate user: `" + authenticatedUserName + "` calling: `" + httpRequest.getRequestURI() + "`.");
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }

    public static class MtlsImpersonationRequestWrapper
    extends HttpServletRequestWrapper {
        private static final String AUTHORIZATION_KEY = "Authorization";
        private static final String BEARER_PREFIX = "Bearer ";
        private String authorizationValue;

        public MtlsImpersonationRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public void addAuthorizationHeader(String value) {
            this.authorizationValue = BEARER_PREFIX + value;
        }

        public String getHeader(String name) {
            if (AUTHORIZATION_KEY.equalsIgnoreCase(name) && this.authorizationValue != null) {
                return this.authorizationValue;
            }
            return super.getHeader(name);
        }

        public Enumeration<String> getHeaderNames() {
            ArrayList names = Collections.list(super.getHeaderNames());
            if (this.authorizationValue != null && !names.contains(AUTHORIZATION_KEY)) {
                names.add(AUTHORIZATION_KEY);
            }
            return Collections.enumeration(names);
        }

        public Enumeration<String> getHeaders(String name) {
            if (AUTHORIZATION_KEY.equalsIgnoreCase(name) && this.authorizationValue != null) {
                return Collections.enumeration(Collections.singleton(this.authorizationValue));
            }
            return super.getHeaders(name);
        }
    }
}

