/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import java.security.Principal;
import javax.security.auth.login.LoginException;
import javax.ws.rs.core.SecurityContext;

public final class RestSecurityContext
implements SecurityContext {
    private final Principal user;
    private final String authScheme;
    private static final InheritableThreadLocal<RestSecurityContext> currentSecurityContext = new InheritableThreadLocal();

    public RestSecurityContext(Principal user, String authScheme) throws LoginException {
        this.user = user;
        this.authScheme = authScheme;
        if (currentSecurityContext.get() != null) {
            throw new LoginException("Invalid attempt to set duplicate context.");
        }
        currentSecurityContext.set(this);
    }

    public Principal getUserPrincipal() {
        return this.user;
    }

    public boolean isUserInRole(String role) {
        return this.user != null;
    }

    public boolean isSecure() {
        return this.user != null;
    }

    public String getAuthenticationScheme() {
        return this.authScheme;
    }

    public static RestSecurityContext getCurrentSecurityContext() {
        return (RestSecurityContext)currentSecurityContext.get();
    }

    public static void clear() {
        currentSecurityContext.remove();
    }
}

