/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty.initializer;

import io.confluent.common.security.auth.AlwaysForwardToLeader;
import io.confluent.common.security.auth.ImpersonationTokenProvider;
import io.confluent.common.security.auth.MtlsLeaderProxyFilter;
import io.confluent.common.security.metrics.MetricsContainer;
import io.confluent.common.security.util.AuthUtils;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import io.confluent.security.auth.client.rest.RestClient;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.Filter;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationHandler
implements Consumer<ServletContextHandler>,
Configurable {
    private SecurityHandlerConfig config;
    private RestClient restClient;
    private MetricsContainer metricsContainer;
    private static final Logger log = LoggerFactory.getLogger(AuthenticationHandler.class);

    public void configure(Map<String, ?> originals) {
        this.config = new SecurityHandlerConfig(originals);
        this.restClient = this.createRestClient(originals);
    }

    @Override
    public void accept(ServletContextHandler context) {
        context.setSecurityHandler((SecurityHandler)this.createSecurityHandler());
        this.maybeAddMtlsProxyFilter(context);
    }

    private void maybeAddMtlsProxyFilter(ServletContextHandler context) {
        if (this.restClient != null) {
            log.debug("Adding MtlsProxyFilter for adding Authorization Header");
            AlwaysForwardToLeader leaderForwardChecker = new AlwaysForwardToLeader();
            ImpersonationTokenProvider tokenProvider = new ImpersonationTokenProvider(this.restClient);
            MtlsLeaderProxyFilter mtlsLeaderProxyFilter = new MtlsLeaderProxyFilter(leaderForwardChecker, tokenProvider);
            context.addFilter(new FilterHolder((Filter)mtlsLeaderProxyFilter), "/*", null);
            return;
        }
        log.debug("MtlsProxyFilter configuration skipped, as no metadata service url found");
    }

    protected ConstraintSecurityHandler createSecurityHandler() {
        if (this.config.getBoolean("rest.auth.jmx.enabled").booleanValue()) {
            this.metricsContainer = new MetricsContainer(this.config);
        }
        ConstraintSecurityHandler securityHandler = AuthUtils.getOAuthSecurityHandler(this.config);
        securityHandler.setAuthenticator((Authenticator)AuthUtils.createCompositeAuthenticator(this.config));
        securityHandler.setLoginService(AuthUtils.getCompositeLoginService(this.config, this.metricsContainer, log));
        AuthUtil.createUnsecuredConstraints((RestConfig)this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        return securityHandler;
    }

    protected RestClient createRestClient(Map<String, ?> configs) {
        try {
            return new RestClient(configs);
        }
        catch (ConfigException e) {
            log.debug("Not configuring RestClient", (Throwable)e);
            return null;
        }
    }

    public SecurityHandlerConfig getConfig() {
        return this.config;
    }

    public MetricsContainer getMetricsContainer() {
        return this.metricsContainer;
    }

    public static class SecurityHandlerConfig
    extends RestConfig {
        public static final String TOKEN_ISSUER_PROP = "token.issuer";
        public static final String TOKEN_ISSUER_DEFAULT = "Confluent";
        public static final String TOKEN_ISSUER_DOC = "An identifier for the token issuer.";
        public static final String TOKEN_PUBLIC_KEY_PATH_PROP = "public.key.path";
        public static final String TOKEN_PUBLIC_KEY_PATH_DOC = "Location of the PEM encoded public key to be used  by a loginService to verify Authentication Tokens. Since the token service only supports RS256 signatures  key pairs must be generated using the RSA algorithm.";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_PROP = "auth.ssl.principal.mapping.rules";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_DEFAULT = "DEFAULT";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_DOC = "Rules to execute the conversion from the certificate SN into principal name";
        public static final String ALLOW_ANONYMOUS_USER_PROP = "auth.allow.anonymous.user";
        public static final boolean ALLOW_ANONYMOUS_USER_DEFAULT = false;
        public static final String ALLOW_ANONYMOUS_USER_DOC = "Decide what to do when no credentials are provided. The default behaviour (false) is to request BASIC authorization.";
        public static final String EXPOSE_INTERNAL_CONNECT_ENDPOINTS_CONFIG = "expose.internal.connect.endpoints";
        public static final boolean EXPOSE_INTERNAL_CONNECT_ENDPOINTS_DEFAULT = false;
        private static final String OAUTHBEARER_CONFIG_PREFIX = "oauthbearer";
        public static final String OAUTHBEARER_JWKS_ENDPOINT_URL = "oauthbearer.jwks.endpoint.url";
        public static final String OAUTHBEARER_JWKS_ENDPOINT_URL_DOC = "The OAuth/OIDC provider URL from which the provider's <a href=\"https://datatracker.ietf.org/doc/html/rfc7517#section-5\">JWKS (JSON Web Key Set)</a> can be retrieved. The URL can be HTTP(S)-based. The fetched keys, will be cached on for incoming requests. If an authentication request is received for a JWT that includes a \"kid\" header claim value that isn't yet in the cache, the JWKS endpoint will be queried again on demand.";
        public static final String OAUTHBEARER_EXPECTED_ISSUER = "oauthbearer.expected.issuer";
        public static final String OAUTHBEARER_EXPECTED_ISSUER_DOC = "This is required to assure that the JWT was created by the expected issuer. The JWT will be inspected for the standard OAuth \"iss\" claim and if this value is set, Server will match it exactly against what is in the JWT's \"iss\" claim. If there's no match, the broker will reject the JWT and authentication will fail.";
        public static final String OAUTHBEARER_EXPECTED_AUDIENCE = "oauthbearer.expected.audience";
        public static final String OAUTHBEARER_EXPECTED_AUDIENCE_DOC = "The (optional) comma-delimited setting for to use to verify that the JWT was issued for one of the expected audiences. The JWT will be inspected for the standard OAuth \"aud\" claim and if this value is set, the broker will match the value from JWT's \"aud\" claim to see if there is an exact match. If there is no match, the broker will reject the JWT and authentication will fail.";
        public static final String OAUTHBEARER_SUB_CLAIM_NAME = "oauthbearer.sub.claim.name";
        public static final String OAUTHBEARER_SUB_CLAIM_NAME_DOC = "The OAuth claim for the subject is often named `sub` but this is optional. This optional setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for sub claim.";
        public static final String OAUTHBEARER_GROUPS_CLAIM_NAME = "oauthbearer.groups.claim.name";
        public static final String OAUTHBEARER_GROUPS_CLAIM_NAME_DOC = "This optional setting provides the name of claim to use for the groups in the JWT payload. If setting is not provided, groups of principal will be empty.";
        public static final String OAUTHBEARER_JTI_VALIDATION_ENABLED = "oauthbearer.jti.validation.enabled";
        public static final String OAUTHBEARER_JTI_VALIDATION_ENABLED_DOC = "This flag mandates the presence of field JTI (unique id in token) in the token. Setting this flag true, doesn't add any validation against the IDP server.";
        public static final String AUTH_JMX_ENABLED = "rest.auth.jmx.enabled";
        public static final String AUTH_JMX_ENABLED_DOC = "This property enables authentication metricsfor configured authentication mechanism in AuthenticationHandler class. This includesBasic, Oauth, mTLS and Kerberos";
        public static final boolean AUTH_JMX_ENABLED_DEFAULT = false;
        public static final String TOKEN_IMPERSONATION_VALIDATION = "token.impersonation.validation";
        public static final String TOKEN_IMPERSONATION_VALIDATION_DOC = "Indicates whether impersonation token validation should be enabled or not. If enabled, the handler will validate the incoming certificate subject with the cp_proxy claim in impersonation token.";
        public static final boolean TOKEN_IMPERSONATION_VALIDATION_DEFAULT = true;
        private static final ConfigDef CONFIG = SecurityHandlerConfig.baseConfigDef().define("public.key.path", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Location of the PEM encoded public key to be used  by a loginService to verify Authentication Tokens. Since the token service only supports RS256 signatures  key pairs must be generated using the RSA algorithm.").define("token.issuer", ConfigDef.Type.STRING, (Object)"Confluent", ConfigDef.Importance.HIGH, "An identifier for the token issuer.").define("auth.ssl.principal.mapping.rules", ConfigDef.Type.STRING, (Object)"DEFAULT", ConfigDef.Importance.MEDIUM, "Rules to execute the conversion from the certificate SN into principal name").define("auth.allow.anonymous.user", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Decide what to do when no credentials are provided. The default behaviour (false) is to request BASIC authorization.").defineInternal("expose.internal.connect.endpoints", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW).define("oauthbearer.jwks.endpoint.url", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "The OAuth/OIDC provider URL from which the provider's <a href=\"https://datatracker.ietf.org/doc/html/rfc7517#section-5\">JWKS (JSON Web Key Set)</a> can be retrieved. The URL can be HTTP(S)-based. The fetched keys, will be cached on for incoming requests. If an authentication request is received for a JWT that includes a \"kid\" header claim value that isn't yet in the cache, the JWKS endpoint will be queried again on demand.").define("oauthbearer.expected.issuer", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "This is required to assure that the JWT was created by the expected issuer. The JWT will be inspected for the standard OAuth \"iss\" claim and if this value is set, Server will match it exactly against what is in the JWT's \"iss\" claim. If there's no match, the broker will reject the JWT and authentication will fail.").define("oauthbearer.expected.audience", ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, "The (optional) comma-delimited setting for to use to verify that the JWT was issued for one of the expected audiences. The JWT will be inspected for the standard OAuth \"aud\" claim and if this value is set, the broker will match the value from JWT's \"aud\" claim to see if there is an exact match. If there is no match, the broker will reject the JWT and authentication will fail.").define("oauthbearer.sub.claim.name", ConfigDef.Type.STRING, (Object)"sub", ConfigDef.Importance.LOW, "The OAuth claim for the subject is often named `sub` but this is optional. This optional setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for sub claim.").define("oauthbearer.groups.claim.name", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "This optional setting provides the name of claim to use for the groups in the JWT payload. If setting is not provided, groups of principal will be empty.").define("oauthbearer.jti.validation.enabled", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "This flag mandates the presence of field JTI (unique id in token) in the token. Setting this flag true, doesn't add any validation against the IDP server.").define("rest.auth.jmx.enabled", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "This property enables authentication metricsfor configured authentication mechanism in AuthenticationHandler class. This includesBasic, Oauth, mTLS and Kerberos").define("token.impersonation.validation", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Indicates whether impersonation token validation should be enabled or not. If enabled, the handler will validate the incoming certificate subject with the cp_proxy claim in impersonation token.");

        public boolean allowAnonymousUser() {
            return this.getBoolean(ALLOW_ANONYMOUS_USER_PROP);
        }

        public boolean exposeInternalConnectEndpoints() {
            return this.getBoolean(EXPOSE_INTERNAL_CONNECT_ENDPOINTS_CONFIG);
        }

        public SecurityHandlerConfig(Map<String, ?> originals) {
            super(CONFIG, originals);
        }
    }
}

