/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.metrics;

import io.confluent.common.security.metrics.AbstractMetricContainer;
import io.confluent.common.security.metrics.BasicAuthSensor;
import io.confluent.common.security.metrics.MdsOAuthSensor;
import io.confluent.common.security.metrics.MtlsAuthSensor;
import io.confluent.common.security.metrics.OAuthSensor;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;

@Singleton
public class MetricsContainer
extends AbstractMetricContainer {
    private final Metrics metrics;
    private final Map<String, String> tags;
    private final MetricsContext metricsContext;
    private final BasicAuthSensor basicAuthSensor;
    private final OAuthSensor oauthAuthSensor;
    private final MtlsAuthSensor mtlsAuthSensor;
    private final MdsOAuthSensor mdsOauthSensor;

    public MetricsContainer(RestConfig config) {
        this.tags = Application.parseListToMap((List)config.getList("metrics.tag.map"));
        this.metricsContext = AbstractMetricContainer.buildMetricsContext(config);
        this.metrics = AbstractMetricContainer.buildMetrics(config, this.metricsContext);
        this.basicAuthSensor = new BasicAuthSensor(this.metrics, this.tags);
        this.oauthAuthSensor = new OAuthSensor(this.metrics, this.tags);
        this.mdsOauthSensor = new MdsOAuthSensor(this.metrics, this.tags);
        this.mtlsAuthSensor = new MtlsAuthSensor(this.metrics, this.tags);
    }

    public Sensor getBasicSuccessLoginLatency() {
        return this.basicAuthSensor.getBasicSuccessLatencySensor();
    }

    public Sensor getBasicFailedLoginLatency() {
        return this.basicAuthSensor.getBasicFailedLatencySensor();
    }

    public Sensor getBasicSuccessLoginCount() {
        return this.basicAuthSensor.getBasicSuccessCountSensor();
    }

    public Sensor getBasicFailedLoginCount() {
        return this.basicAuthSensor.getBasicFailedCountSensor();
    }

    public Sensor getOauthSuccessLoginLatency() {
        return this.oauthAuthSensor.getOauthSuccessLatencySensor();
    }

    public Sensor getOauthFailedLoginLatency() {
        return this.oauthAuthSensor.getOauthFailedLatencySensor();
    }

    public Sensor getOauthSuccessLoginCount() {
        return this.oauthAuthSensor.getOauthSuccessCountSensor();
    }

    public Sensor getOauthFailedLoginCount() {
        return this.oauthAuthSensor.getOauthFailedCountSensor();
    }

    public Sensor getMdsOauthSuccessLoginLatency() {
        return this.mdsOauthSensor.getMdsOauthSuccessLatencySensor();
    }

    public Sensor getMdsOauthFailedLoginLatency() {
        return this.mdsOauthSensor.getMdsOauthFailedLatencySensor();
    }

    public Sensor getMdsOauthSuccessLoginCount() {
        return this.mdsOauthSensor.getMdsOauthSuccessCountSensor();
    }

    public Sensor getMdsOauthFailedLoginCount() {
        return this.mdsOauthSensor.getMdsOauthFailedCountSensor();
    }

    public Sensor getMtlsSuccessLoginLatency() {
        return this.mtlsAuthSensor.getMtlsSuccessLatencySensor();
    }

    public Sensor getMtlsFailedLoginLatency() {
        return this.mtlsAuthSensor.getMtlsFailedLatencySensor();
    }

    public Sensor getMtlsSuccessLoginCount() {
        return this.mtlsAuthSensor.getMtlsSuccessCountSensor();
    }

    public Sensor getMtlsFailedLoginCount() {
        return this.mtlsAuthSensor.getMtlsFailedCountSensor();
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Map<String, String> getMetricsTags() {
        return this.tags;
    }

    public MetricsContext getMetricsContext() {
        return this.metricsContext;
    }
}

