/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push.buffer;

import io.confluent.kafka.replication.push.PushSession;
import io.confluent.kafka.replication.push.PushSessionEndReason;
import io.confluent.kafka.replication.push.ReplicationConfig;
import io.confluent.kafka.replication.push.buffer.BufferingPartitionDataBuilder;
import io.confluent.kafka.replication.push.buffer.PushReplicationEvent;
import io.confluent.kafka.replication.push.buffer.RefCountingMemoryTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.AppendRecordsRequestData;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.TopicIdPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferingAppendRecordsBuilder {
    private static final Logger log = LoggerFactory.getLogger(BufferingAppendRecordsBuilder.class);
    private static final long NO_RECORDS_ADDED_TIME_MS = -1L;
    private final int destinationBrokerId;
    private final long destinationBrokerEpoch;
    private final long maxRequestSizeBytes;
    private final long maxRequestPartitionSizeBytes;
    private final RefCountingMemoryTracker<MemoryRecords> tracker;
    private final Time time;
    private final long creationTimeMs;
    private final long lingerMs;
    private final long maxWaitMs;
    private final Map<Uuid, Map<Integer, BufferingPartitionDataBuilder>> topicData = new HashMap<Uuid, Map<Integer, BufferingPartitionDataBuilder>>();
    private long totalSizeInBytes = 0L;
    private long recordsAddedTimeMs = -1L;

    public BufferingAppendRecordsBuilder(int destinationBrokerId, long destinationBrokerEpoch, ReplicationConfig config, RefCountingMemoryTracker<MemoryRecords> tracker, Time time) {
        this.destinationBrokerId = destinationBrokerId;
        this.destinationBrokerEpoch = destinationBrokerEpoch;
        this.maxRequestSizeBytes = config.maxRequestSizeBytes();
        this.maxRequestPartitionSizeBytes = config.maxRequestPartitionSizeBytes();
        this.tracker = tracker;
        this.time = time;
        this.creationTimeMs = time.hiResClockMs();
        this.lingerMs = config.lingerMs();
        this.maxWaitMs = config.maxWaitMs();
    }

    public boolean processEvent(PushReplicationEvent<?> event, PushSession pushSession) {
        TopicIdPartition partition = event.topicIdPartition();
        BufferingPartitionDataBuilder bufferingPartitionDataBuilder = this.topicData.computeIfAbsent(partition.topicId(), tid -> new HashMap()).computeIfAbsent(partition.partitionId(), pid -> new BufferingPartitionDataBuilder(partition, pushSession, this.maxRequestPartitionSizeBytes));
        if (pushSession.replicaEpoch() != this.destinationBrokerEpoch) {
            log.warn("Received event {} for push session {} with incompatible replica epoch (different than {})", new Object[]{event, pushSession, this.destinationBrokerEpoch});
            return false;
        }
        switch (event.type()) {
            case HWM_UPDATE: {
                return bufferingPartitionDataBuilder.addHighWatermarkUpdate(pushSession, ((PushReplicationEvent.OffsetPayload)event.payload()).offset());
            }
            case LSO_UPDATE: {
                return bufferingPartitionDataBuilder.addLogStartOffsetUpdate(pushSession, ((PushReplicationEvent.OffsetPayload)event.payload()).offset());
            }
            case MEMORY_RECORDS: {
                boolean firstRecordsInRequest;
                PushReplicationEvent.RecordsPayload payload = (PushReplicationEvent.RecordsPayload)event.payload();
                MemoryRecords memoryRecords = (MemoryRecords)payload.records();
                long newTotalSizeInBytes = this.totalSizeInBytes + (long)memoryRecords.sizeInBytes();
                boolean bl = firstRecordsInRequest = !this.hasBufferedRecords();
                if (newTotalSizeInBytes > this.maxRequestSizeBytes && !firstRecordsInRequest) {
                    return false;
                }
                boolean processed = bufferingPartitionDataBuilder.addMemoryRecords(pushSession, memoryRecords, payload.appendOffset());
                if (processed) {
                    if (this.recordsAddedTimeMs == -1L) {
                        this.recordsAddedTimeMs = this.time.hiResClockMs();
                    }
                    this.totalSizeInBytes = newTotalSizeInBytes;
                }
                return processed;
            }
            case STOP_PUSH: {
                PushReplicationEvent<?> stopEvent = event;
                boolean sendEndSessionRequest = ((PushSessionEndReason)((Object)stopEvent.payload())).sendEndSessionRequest;
                List<AbstractRecords> evicted = bufferingPartitionDataBuilder.stopPushAndDiscardState(sendEndSessionRequest);
                this.handleEvictedRecords(evicted);
                if (!sendEndSessionRequest) {
                    this.removePartitionEntry(partition.topicId(), partition.partitionId());
                }
                return true;
            }
        }
        log.warn("{} events not expected to be handled here", (Object)event.type());
        return false;
    }

    public AppendRecordsRequestData build() {
        ArrayList<AppendRecordsRequestData.TopicData> topics = new ArrayList<AppendRecordsRequestData.TopicData>();
        for (Map.Entry<Uuid, Map<Integer, BufferingPartitionDataBuilder>> topicEntry : this.topicData.entrySet()) {
            AppendRecordsRequestData.TopicData topic = new AppendRecordsRequestData.TopicData();
            topic.setTopicId(topicEntry.getKey());
            ArrayList<AppendRecordsRequestData.PartitionData> partitions = new ArrayList<AppendRecordsRequestData.PartitionData>();
            Map<Integer, BufferingPartitionDataBuilder> builderData = topicEntry.getValue();
            for (BufferingPartitionDataBuilder partitionBuilder : builderData.values()) {
                partitions.add(partitionBuilder.build());
            }
            topic.setPartitions(partitions);
            topics.add(topic);
        }
        AppendRecordsRequestData requestData = new AppendRecordsRequestData();
        requestData.setReplicaEpoch(this.destinationBrokerEpoch);
        requestData.setTopics(topics);
        return requestData;
    }

    public void clear() {
        for (Map<Integer, BufferingPartitionDataBuilder> partitionData : this.topicData.values()) {
            for (BufferingPartitionDataBuilder partitionBuilder : partitionData.values()) {
                this.handleEvictedRecords(partitionBuilder.discardState());
            }
        }
    }

    public long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public long destinationBrokerEpoch() {
        return this.destinationBrokerEpoch;
    }

    public int destinationBrokerId() {
        return this.destinationBrokerId;
    }

    public boolean isRequestReady() {
        if (this.topicData.isEmpty()) {
            return false;
        }
        if (this.hasBufferedRecords()) {
            return this.time.hiResClockMs() - this.recordsAddedTimeMs >= this.lingerMs;
        }
        return this.time.hiResClockMs() - this.creationTimeMs >= this.maxWaitMs;
    }

    private void removePartitionEntry(Uuid topicId, int partition) {
        Map partitionData = this.topicData.getOrDefault(topicId, Collections.emptyMap());
        partitionData.remove(partition);
        if (partitionData.isEmpty()) {
            this.topicData.remove(topicId);
        }
    }

    private void handleEvictedRecords(List<AbstractRecords> evicted) {
        for (AbstractRecords records : evicted) {
            if (!(records instanceof MemoryRecords)) continue;
            MemoryRecords memoryRecords = (MemoryRecords)records;
            this.totalSizeInBytes -= (long)memoryRecords.sizeInBytes();
            this.tracker.countDown(memoryRecords);
        }
        if (!this.hasBufferedRecords()) {
            this.recordsAddedTimeMs = -1L;
        }
    }

    private boolean hasBufferedRecords() {
        return this.totalSizeInBytes > 0L;
    }
}

