/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push.metrics;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.replication.push.metrics.HdrHistogram;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MetricConfig;

public final class KafkaMetricHistogram
implements CompoundStat {
    private static final String COUNT_NAME = "Count";
    private static final String MAX_NAME = "Max";
    private static final String MEAN_NAME = "Mean";
    private static final String MIN_NAME = "Min";
    private static final String STDDEV_NAME = "StdDev";
    private static final Map<Double, String> PERCENTILE_NAMES = new ImmutableMap.Builder().put((Object)50.0, (Object)"50thPercentile").put((Object)75.0, (Object)"75thPercentile").put((Object)95.0, (Object)"95thPercentile").put((Object)98.0, (Object)"98thPercentile").put((Object)99.0, (Object)"99thPercentile").put((Object)99.9, (Object)"999thPercentile").build();
    private final Function<String, MetricName> metricNameFactory;
    private final HdrHistogram hdrHistogram;

    public static KafkaMetricHistogram newLatencyHistogram(Function<String, MetricName> metricNameFactory, long highestTrackableValue) {
        return new KafkaMetricHistogram(metricNameFactory, HdrHistogram.ThreadSafetyMode.CONCURRENT_READS_AND_WRITES, highestTrackableValue, 3);
    }

    private KafkaMetricHistogram(Function<String, MetricName> metricNameFactory, HdrHistogram.ThreadSafetyMode mode, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this.metricNameFactory = metricNameFactory;
        this.hdrHistogram = new HdrHistogram(mode, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public List<CompoundStat.NamedMeasurable> stats() {
        ArrayList<CompoundStat.NamedMeasurable> stats = new ArrayList<CompoundStat.NamedMeasurable>();
        stats.add(new CompoundStat.NamedMeasurable(this.metricNameFactory.apply(COUNT_NAME), (config, now) -> this.hdrHistogram.count(now)));
        stats.add(new CompoundStat.NamedMeasurable(this.metricNameFactory.apply(MAX_NAME), (config, now) -> this.hdrHistogram.max(now)));
        stats.add(new CompoundStat.NamedMeasurable(this.metricNameFactory.apply(MEAN_NAME), (config, now) -> this.hdrHistogram.mean(now)));
        stats.add(new CompoundStat.NamedMeasurable(this.metricNameFactory.apply(MIN_NAME), (config, now) -> this.hdrHistogram.min(now)));
        stats.add(new CompoundStat.NamedMeasurable(this.metricNameFactory.apply(STDDEV_NAME), (config, now) -> this.hdrHistogram.stdDeviation(now)));
        PERCENTILE_NAMES.entrySet().stream().map(e -> new CompoundStat.NamedMeasurable(this.metricNameFactory.apply((String)e.getValue()), (config, now) -> this.hdrHistogram.measurePercentile(now, (Double)e.getKey()))).forEachOrdered(stats::add);
        return stats;
    }

    public void record(MetricConfig config, double value, long timeMs) {
        this.hdrHistogram.record((long)value);
    }
}

