/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplicationConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(ReplicationConfig.class);
    public static final String CONFLUENT_REPLICATION_PREFIX = "confluent.replication.";
    public static final String PUSH_REPLICATION_FEATURE_ENABLE_PROP = "confluent.replication.push.feature.enable";
    public static final String PUSH_REPLICATION_FEATURE_ENABLE_DOC = "Feature flag that enables components related to push replication. This must be enabled before push replication mode can be enabled by using `REPLICATION_MODE_PROP` property.";
    public static final boolean PUSH_REPLICATION_FEATURE_ENABLE_DEFAULT = false;
    public static final String REPLICATION_MODE_PROP = "confluent.replication.mode";
    public static final String REPLICATION_MODE_DOC = "Determines the replication mode used by this broker both when acting as a leader and when acting as a follower. Can be PULL or PULL_PUSH, with PUSH to be added eventually.";
    public static final String REPLICATION_MODE_DEFAULT = Mode.PULL.name();
    public static final String MAX_PUSHERS_PROP = "confluent.replication.max.replica.pushers";
    public static final String MAX_PUSHERS_DOC = "The maximum number of pusher threads to be used for push replication.";
    public static final int MAX_PUSHERS_DEFAULT = 4;
    public static final String NUM_PUSHERS_PER_BROKER_PROP = "confluent.replication.num.pushers.per.broker";
    public static final String NUM_PUSHERS_PER_BROKER_DOC = "Determines the number of pushers replicating to a single peer broker. Can be between 1 and the maximum number of pusher threads.";
    public static final int NUM_PUSHERS_PER_BROKER_DEFAULT = 1;
    public static final String MAX_MEMORY_BUFFER_BYTES_PROP = "confluent.replication.max.memory.buffer.bytes";
    public static final String MAX_MEMORY_BUFFER_BYTES_DOC = "The maximum amount of memory used by replication for buffering. Currently used solely by the records buffer for push replication.";
    public static final long MAX_MEMORY_BUFFER_BYTES_DEFAULT = 0xC800000L;
    public static final String MAX_IN_FLIGHT_REQUESTS_PROP = "confluent.replication.max.in.flight.requests";
    public static final String MAX_IN_FLIGHT_REQUESTS_DOC = "The maximum number of replication requests that can be simultaneously in-flight.";
    public static final int MAX_IN_FLIGHT_REQUESTS_DEFAULT = 1;
    public static final String MAX_REQUEST_SIZE_BYTES_PROP = "confluent.replication.request.max.bytes";
    public static final String MAX_REQUEST_SIZE_BYTES_DOC = "The maximum size in bytes of a replication request, similar to the 'fetch.max.bytes' for Fetch requests.";
    public static final long MAX_REQUEST_SIZE_BYTES_DEFAULT = 0x3200000L;
    public static final String MAX_REQUEST_PARTITION_SIZE_BYTES_PROP = "confluent.replication.request.max.partition.bytes";
    public static final String MAX_REQUEST_PARTITION_SIZE_BYTES_DOC = "The maximum size in bytes for the data of a single partition in a replication request.";
    public static final long MAX_REQUEST_PARTITION_SIZE_BYTES_DEFAULT = 0x3200000L;
    public static final String LINGER_MS_PROP = "confluent.replication.linger.ms";
    public static final String LINGER_MS_DOC = "The amount of time to wait before attempting to send a replication request containing record data to a follower broker.";
    public static final int LINGER_MS_DEFAULT = 0;
    public static final String MAX_WAIT_MS_PROP = "confluent.replication.max.wait.ms";
    public static final String MAX_WAIT_MS_DOC = "The amount of time to wait before attempting to send a replication request containing only offset metadata to a follower broker.";
    public static final int MAX_WAIT_MS_DEFAULT = 500;
    private static final int MAX_WAIT_MS_MIN = 100;
    public static final String RETRY_TIMEOUT_MS_PROP = "confluent.replication.retry.timeout.ms";
    public static final String RETRY_TIMEOUT_MS_DOC = "The total timeout to wait on a leader for a response to a replication request (with retries on retriable errors not resetting the clock) before transitioning the corresponding partition replica(s) back to replication mode PULL.";
    public static final int RETRY_TIMEOUT_MS_DEFAULT = 10000;
    public static final String REQUEST_TIMEOUT_MS_PROP = "confluent.replication.request.timeout.ms";
    public static final int REQUEST_TIMEOUT_MS_DEFAULT = 5000;
    public static final String SOCKET_SEND_BUFFER_BYTES_PROP = "confluent.replication.socket.send.buffer.bytes";
    public static final int SOCKET_SEND_BUFFER_BYTES_DEFAULT = 0x100000;
    public static final String SOCKET_SEND_BUFFER_BYTES_DOC = "The socket send buffer for network requests to the follower for replicating data";
    public static final String INTERNAL_TOPICS_PUSH_REPLICATION_ENABLE_PROP = "confluent.replication.push.internal.topics.enable";
    public static final boolean INTERNAL_TOPICS_PUSH_REPLICATION_ENABLE_DEFAULT = false;
    public static final String INTERNAL_TOPICS_PUSH_REPLICATION_ENABLE_DOC = "Whether internal topics are allowed to transition to push mode";
    private static final ConfigDef CONFIGS = ReplicationConfig.defineReplicationConfigs();

    public static ConfigDef defineReplicationConfigs() {
        return new ConfigDef().defineInternal(REPLICATION_MODE_PROP, ConfigDef.Type.STRING, (Object)REPLICATION_MODE_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])Mode.stringValues()), ConfigDef.Importance.HIGH, REPLICATION_MODE_DOC).defineInternal(MAX_PUSHERS_PROP, ConfigDef.Type.INT, (Object)4, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, MAX_PUSHERS_DOC).defineInternal(NUM_PUSHERS_PER_BROKER_PROP, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, NUM_PUSHERS_PER_BROKER_DOC).defineInternal(MAX_MEMORY_BUFFER_BYTES_PROP, ConfigDef.Type.LONG, (Object)0xC800000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_MEMORY_BUFFER_BYTES_DOC).defineInternal(MAX_IN_FLIGHT_REQUESTS_PROP, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, MAX_IN_FLIGHT_REQUESTS_DOC).defineInternal(MAX_REQUEST_SIZE_BYTES_PROP, ConfigDef.Type.LONG, (Object)0x3200000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_REQUEST_SIZE_BYTES_DOC).defineInternal(MAX_REQUEST_PARTITION_SIZE_BYTES_PROP, ConfigDef.Type.LONG, (Object)0x3200000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, MAX_REQUEST_PARTITION_SIZE_BYTES_DOC).defineInternal(LINGER_MS_PROP, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, LINGER_MS_DOC).defineInternal(MAX_WAIT_MS_PROP, ConfigDef.Type.INT, (Object)500, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)100), ConfigDef.Importance.LOW, MAX_WAIT_MS_DOC).defineInternal(RETRY_TIMEOUT_MS_PROP, ConfigDef.Type.INT, (Object)10000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, RETRY_TIMEOUT_MS_DOC).defineInternal(REQUEST_TIMEOUT_MS_PROP, ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)TimeUnit.SECONDS.toMillis(1L)), ConfigDef.Importance.LOW, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").defineInternal(SOCKET_SEND_BUFFER_BYTES_PROP, ConfigDef.Type.INT, (Object)0x100000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1024), ConfigDef.Importance.LOW, SOCKET_SEND_BUFFER_BYTES_DOC).defineInternal(INTERNAL_TOPICS_PUSH_REPLICATION_ENABLE_PROP, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, INTERNAL_TOPICS_PUSH_REPLICATION_ENABLE_DOC);
    }

    public static boolean pushReplicationModeEnabled(Mode configuredMode) {
        return configuredMode != Mode.PULL;
    }

    public ReplicationConfig(Map<?, ?> properties) {
        super(CONFIGS, properties);
    }

    public Mode replicationMode() {
        String replicationModeString = this.getString(REPLICATION_MODE_PROP);
        return Mode.valueOf(replicationModeString);
    }

    public int maxPushers() {
        return this.getInt(MAX_PUSHERS_PROP);
    }

    public long maxMemoryBufferBytes() {
        return this.getLong(MAX_MEMORY_BUFFER_BYTES_PROP);
    }

    public int maxInFlightRequests() {
        return this.getInt(MAX_IN_FLIGHT_REQUESTS_PROP);
    }

    public long maxRequestSizeBytes() {
        return this.getLong(MAX_REQUEST_SIZE_BYTES_PROP);
    }

    public long maxRequestPartitionSizeBytes() {
        return this.getLong(MAX_REQUEST_PARTITION_SIZE_BYTES_PROP);
    }

    public int lingerMs() {
        return this.getInt(LINGER_MS_PROP);
    }

    public int maxWaitMs() {
        return this.getInt(MAX_WAIT_MS_PROP);
    }

    public int retryTimeoutMs() {
        return this.getInt(RETRY_TIMEOUT_MS_PROP);
    }

    public int requestTimeoutMs() {
        return this.getInt(REQUEST_TIMEOUT_MS_PROP);
    }

    public int socketSendBufferBytes() {
        return this.getInt(SOCKET_SEND_BUFFER_BYTES_PROP);
    }

    public int numPushersPerBroker() {
        return Math.min(this.maxPushers(), this.getInt(NUM_PUSHERS_PER_BROKER_PROP));
    }

    public boolean enablePushForInternalTopics() {
        return this.getBoolean(INTERNAL_TOPICS_PUSH_REPLICATION_ENABLE_PROP);
    }

    public static enum Mode {
        PULL,
        PULL_PUSH;


        public static String[] stringValues() {
            return (String[])Arrays.stream(Mode.values()).map(Enum::name).toArray(String[]::new);
        }
    }
}

