/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push.buffer;

import io.confluent.kafka.replication.push.PushSession;
import io.confluent.kafka.replication.push.PushSessionEndReason;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.common.TopicIdPartition;

public final class PushReplicationEvent<T> {
    private final TopicIdPartition topicIdPartition;
    private final int replicaId;
    private final T payload;
    private final Type type;
    private final long eventCreatedTimeMs;

    public static PushReplicationEvent<PushSession> forStartPush(TopicIdPartition topicIdPartition, PushSession pushSession, long eventCreatedTimeMs) {
        return new PushReplicationEvent<PushSession>(topicIdPartition, pushSession.replicaNode().id(), pushSession, Type.START_PUSH, eventCreatedTimeMs);
    }

    public static PushReplicationEvent<RecordsPayload> forRecords(TopicIdPartition topicIdPartition, int replicaId, AbstractRecords records, long appendOffset, long eventCreatedTimeMs) {
        if (!(records instanceof MemoryRecords)) {
            throw new IllegalStateException("Unexpected AbstractRecords type: " + records);
        }
        Type type = Type.MEMORY_RECORDS;
        return new PushReplicationEvent<RecordsPayload>(topicIdPartition, replicaId, new RecordsPayload(records, appendOffset), type, eventCreatedTimeMs);
    }

    public static PushReplicationEvent<OffsetPayload> forHighWatermarkUpdate(TopicIdPartition topicIdPartition, int replicaId, long updatedHighWatermark, long eventCreatedTimeMs) {
        return new PushReplicationEvent<OffsetPayload>(topicIdPartition, replicaId, new OffsetPayload(updatedHighWatermark), Type.HWM_UPDATE, eventCreatedTimeMs);
    }

    public static PushReplicationEvent<OffsetPayload> forLogStartOffsetUpdate(TopicIdPartition topicIdPartition, int replicaId, long updatedLogStartOffset, long eventCreatedTimeMs) {
        return new PushReplicationEvent<OffsetPayload>(topicIdPartition, replicaId, new OffsetPayload(updatedLogStartOffset), Type.LSO_UPDATE, eventCreatedTimeMs);
    }

    public static PushReplicationEvent<PushSessionEndReason> forStopPush(TopicIdPartition topicIdPartition, int replicaId, PushSessionEndReason pushSessionEndReason, long eventCreatedTimeMs) {
        return new PushReplicationEvent<PushSessionEndReason>(topicIdPartition, replicaId, pushSessionEndReason, Type.STOP_PUSH, eventCreatedTimeMs);
    }

    private PushReplicationEvent(TopicIdPartition topicIdPartition, int replicaId, T payload, Type type, long eventCreatedTimeMs) {
        this.topicIdPartition = topicIdPartition;
        this.replicaId = replicaId;
        this.payload = payload;
        this.type = type;
        this.eventCreatedTimeMs = eventCreatedTimeMs;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public T payload() {
        return this.payload;
    }

    public Type type() {
        return this.type;
    }

    public long eventCreatedTimeMs() {
        return this.eventCreatedTimeMs;
    }

    public String toString() {
        return "PushReplicationEvent{topicIdPartition=" + this.topicIdPartition + ", replicaId=" + this.replicaId + ", payload=" + this.payload + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static class RecordsPayload {
        private final AbstractRecords records;
        private final long appendOffset;

        public RecordsPayload(AbstractRecords records, long appendOffset) {
            this.records = records;
            this.appendOffset = appendOffset;
        }

        public AbstractRecords records() {
            return this.records;
        }

        public long appendOffset() {
            return this.appendOffset;
        }

        public String toString() {
            return "RecordsPayload{appendOffset=" + this.appendOffset + '}';
        }
    }

    public static final class OffsetPayload {
        private final long offset;

        public OffsetPayload(long offset) {
            this.offset = offset;
        }

        public long offset() {
            return this.offset;
        }

        public String toString() {
            return "OffsetPayload{offset=" + this.offset + '}';
        }
    }

    public static enum Type {
        START_PUSH(true),
        MEMORY_RECORDS(true),
        HWM_UPDATE(false),
        LSO_UPDATE(false),
        STOP_PUSH(true);

        private final boolean shouldWakeupPusherThread;

        private Type(boolean shouldWakeupPusherThread) {
            this.shouldWakeupPusherThread = shouldWakeupPusherThread;
        }

        public boolean shouldWakeupPusherThread() {
            return this.shouldWakeupPusherThread;
        }
    }
}

