/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push.metrics;

import java.util.concurrent.atomic.AtomicReference;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.HdrHistogram.SingleWriterRecorder;
import org.HdrHistogram.ValueRecorder;

public final class HdrHistogram {
    private static final long DEFAULT_MAX_SNAPSHOT_AGE_MS = 1000L;
    private final long maxSnapshotAgeMs;
    private final ThreadSafetyMode mode;
    private final ValueRecorder valueRecorder;
    private final AtomicReference<Timestamped<Histogram>> timestampedHistogramSnapshot;

    public HdrHistogram(ThreadSafetyMode mode, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1000L, mode, highestTrackableValue, numberOfSignificantValueDigits);
    }

    HdrHistogram(long maxSnapshotAgeMs, ThreadSafetyMode mode, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this.maxSnapshotAgeMs = maxSnapshotAgeMs;
        this.mode = mode;
        this.valueRecorder = mode == ThreadSafetyMode.UNSAFE ? new Histogram(highestTrackableValue, numberOfSignificantValueDigits) : (mode == ThreadSafetyMode.CONCURRENT_READS ? new SingleWriterRecorder(highestTrackableValue, numberOfSignificantValueDigits) : new Recorder(highestTrackableValue, numberOfSignificantValueDigits));
        this.timestampedHistogramSnapshot = new AtomicReference(new Timestamped(0L, null));
    }

    private Histogram latestHistogram(long now) {
        Timestamped<Histogram> latest = this.timestampedHistogramSnapshot.get();
        while (now - ((Timestamped)latest).timestamp > this.maxSnapshotAgeMs) {
            Histogram currentSnapshot;
            if (this.mode == ThreadSafetyMode.UNSAFE) {
                currentSnapshot = ((Histogram)this.valueRecorder).copy();
                this.valueRecorder.reset();
            } else {
                currentSnapshot = this.mode == ThreadSafetyMode.CONCURRENT_READS ? ((SingleWriterRecorder)this.valueRecorder).getIntervalHistogram() : ((Recorder)this.valueRecorder).getIntervalHistogram();
            }
            boolean updatedLatest = this.timestampedHistogramSnapshot.compareAndSet(latest, new Timestamped(now, currentSnapshot));
            latest = this.timestampedHistogramSnapshot.get();
            if (!updatedLatest) continue;
            break;
        }
        return (Histogram)((Timestamped)latest).value;
    }

    public void record(long value) {
        this.valueRecorder.recordValue(value);
    }

    public long count(long now) {
        return this.latestHistogram(now).getTotalCount();
    }

    public long max(long now) {
        return this.latestHistogram(now).getMaxValue();
    }

    public double mean(long now) {
        return this.latestHistogram(now).getMean();
    }

    public long min(long now) {
        return this.latestHistogram(now).getMinValue();
    }

    public double stdDeviation(long now) {
        return this.latestHistogram(now).getStdDeviation();
    }

    public double measurePercentile(long now, double percentile) {
        return this.latestHistogram(now).getValueAtPercentile(percentile);
    }

    private static final class Timestamped<T> {
        private final long timestamp;
        private final T value;

        private Timestamped(long timestamp, T value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }

    public static enum ThreadSafetyMode {
        UNSAFE,
        CONCURRENT_READS,
        CONCURRENT_READS_AND_WRITES;

    }
}

