/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Create kek request")
public class CreateKekRequest {
    private String name;
    private String kmsType;
    private String kmsKeyId;
    private Map<String, String> kmsProps;
    private String doc;
    private boolean shared;
    private boolean deleted;

    public static CreateKekRequest fromJson(String json) throws IOException {
        return (CreateKekRequest)JacksonMapper.INSTANCE.readValue(json, CreateKekRequest.class);
    }

    @Schema(description="Name of the kek")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="KMS type of the kek")
    @JsonProperty(value="kmsType")
    public String getKmsType() {
        return this.kmsType;
    }

    @JsonProperty(value="kmsType")
    public void setKmsType(String kmsType) {
        this.kmsType = kmsType;
    }

    @Schema(description="KMS key ID of the kek")
    @JsonProperty(value="kmsKeyId")
    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    @JsonProperty(value="kmsKeyId")
    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    @Schema(description="Properties of the kek")
    @JsonProperty(value="kmsProps")
    public Map<String, String> getKmsProps() {
        return this.kmsProps;
    }

    @JsonProperty(value="kmsProps")
    public void setKmsProps(Map<String, String> kmsProps) {
        this.kmsProps = kmsProps;
    }

    @Schema(description="Description of the kek")
    @JsonProperty(value="doc")
    public String getDoc() {
        return this.doc;
    }

    @JsonProperty(value="doc")
    public void setDoc(String doc) {
        this.doc = doc;
    }

    @Schema(description="Whether the kek is shared")
    @JsonProperty(value="shared")
    public boolean isShared() {
        return this.shared;
    }

    @JsonProperty(value="shared")
    public void setShared(boolean shared) {
        this.shared = shared;
    }

    @Schema(description="Whether the kek is deleted")
    @JsonProperty(value="deleted")
    public boolean isDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateKekRequest kek = (CreateKekRequest)o;
        return this.shared == kek.shared && this.deleted == kek.deleted && Objects.equals(this.name, kek.name) && Objects.equals(this.kmsType, kek.kmsType) && Objects.equals(this.kmsKeyId, kek.kmsKeyId) && Objects.equals(this.kmsProps, kek.kmsProps) && Objects.equals(this.doc, kek.doc);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.kmsType, this.kmsKeyId, this.kmsProps, this.doc, this.shared, this.deleted);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }
}

