/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.models;

import com.azure.core.util.CoreUtils;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;

public final class SignResult {
    private final byte[] signature;
    private final SignatureAlgorithm algorithm;
    private final String keyId;

    public SignResult(byte[] signature, SignatureAlgorithm algorithm, String keyId) {
        this.signature = CoreUtils.clone((byte[])signature);
        this.algorithm = algorithm;
        this.keyId = keyId;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public byte[] getSignature() {
        return CoreUtils.clone((byte[])this.signature);
    }

    public SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }
}

