/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.oauth;

import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private final Logger log = LoggerFactory.getLogger(OAuthBearerLoginCallbackHandler.class);
    private String authToken;
    private String logicalCluster;
    private boolean configured = false;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        JaasOptionsUtils.validateOAuthMechanismAndNonNullJaasConfig((String)saslMechanism, jaasConfigEntries);
        Map<String, ?> moduleOptions = Collections.unmodifiableMap(jaasConfigEntries.get(0).getOptions());
        this.authToken = (String)moduleOptions.get("token");
        if (this.authToken == null || this.authToken.isEmpty()) {
            this.log.error("No authentication token was provided in the JAAS config!");
            throw new ConfigException("Authentication token must be provided in the JAAS config.");
        }
        this.logicalCluster = (String)moduleOptions.get("cluster");
        if (this.logicalCluster == null || this.logicalCluster.isEmpty()) {
            this.log.error("No cluster extensions for the auth token was provided in the JAAS config!");
            throw new ConfigException("Cluster for token must be set in the JAAS config.");
        }
        this.configured = true;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.configured) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerTokenCallback) {
                this.attachAuthToken((OAuthBearerTokenCallback)callback);
                continue;
            }
            if (callback instanceof SaslExtensionsCallback) {
                this.attachTenantLogicalCluster((SaslExtensionsCallback)callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    public void close() {
    }

    private void attachTenantLogicalCluster(SaslExtensionsCallback callback) throws ConfigException {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", this.logicalCluster);
        callback.extensions(new SaslExtensions(extensions));
    }

    private void attachAuthToken(OAuthBearerTokenCallback callback) {
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had a token already");
        }
        callback.token((OAuthBearerToken)new OAuthBearerJwsToken(this.authToken, Collections.emptySet(), -1L, "", -1L));
    }
}

