/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.internal;

import com.google.crypto.tink.Key;
import com.google.crypto.tink.Parameters;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class MutableKeyCreationRegistry {
    private final Map<Class<? extends Parameters>, KeyCreator<? extends Parameters>> creators = new HashMap<Class<? extends Parameters>, KeyCreator<? extends Parameters>>();
    private static final MutableKeyCreationRegistry globalInstance = new MutableKeyCreationRegistry();

    public static MutableKeyCreationRegistry globalInstance() {
        return globalInstance;
    }

    public synchronized <ParametersT extends Parameters> void add(KeyCreator<ParametersT> creator, Class<ParametersT> parametersClass) throws GeneralSecurityException {
        KeyCreator<? extends Parameters> existingCreator = this.creators.get(parametersClass);
        if (existingCreator != null && !existingCreator.equals(creator)) {
            throw new GeneralSecurityException("Different key creator for parameters class " + parametersClass + " already inserted");
        }
        this.creators.put(parametersClass, creator);
    }

    public Key createKey(Parameters parameters, @Nullable Integer idRequirement) throws GeneralSecurityException {
        return this.createKeyTyped(parameters, idRequirement);
    }

    private synchronized <ParametersT extends Parameters> Key createKeyTyped(ParametersT parameters, @Nullable Integer idRequirement) throws GeneralSecurityException {
        Class<?> parametersClass = parameters.getClass();
        KeyCreator<? extends Parameters> creator = this.creators.get(parametersClass);
        if (creator == null) {
            throw new GeneralSecurityException("Cannot create a new key for parameters " + parameters + ": no key creator for this class was registered.");
        }
        KeyCreator<? extends Parameters> castCreator = creator;
        return castCreator.createKey(parameters, idRequirement);
    }

    public static interface KeyCreator<ParametersT extends Parameters> {
        public Key createKey(ParametersT var1, @Nullable Integer var2) throws GeneralSecurityException;
    }
}

