/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.mtls.CertIdentityPool;
import io.confluent.security.auth.store.data.CaCertificatesKey;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.rbac.RoleBinding;
import io.confluent.security.rbac.RoleBindingFilter;
import io.confluent.security.rbac.UserMetadata;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.RbacRoles;
import io.confluent.security.roledefinitions.ResourceType;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public interface AuthCache {
    public Set<KafkaPrincipal> groups(KafkaPrincipal var1);

    public Set<RoleBinding> rbacRoleBindings(Scope var1);

    public Set<RoleBinding> rbacRoleBindings(Set<Scope> var1);

    public Set<RoleBinding> rbacRoleBindings(RoleBindingFilter var1);

    public Set<RoleBinding> rbacRoleBindings(KafkaPrincipal var1);

    public Set<RoleBinding> rbacRoleBindings(KafkaPrincipal var1, Set<Scope> var2);

    public UserMetadata userMetadata(KafkaPrincipal var1);

    public Map<KafkaPrincipal, UserMetadata> users();

    public Set<Scope> knownScopes();

    public Scope rootScope();

    public RbacRoles rbacRoles();

    public Map<ResourcePattern, Set<AccessRule>> aclRules(Scope var1);

    public Collection<AclBinding> aclBindings(Scope var1, AclBindingFilter var2, Predicate<ResourcePattern> var3);

    public AuthorizeRule findRule(KafkaPrincipal var1, Set<KafkaPrincipal> var2, String var3, Action var4);

    public void addMatchingRules(ResourceAuthorizeRules var1, KafkaPrincipal var2, Set<KafkaPrincipal> var3, String var4, Operation var5, Scope var6, ResourceType var7);

    default public Collection<CertIdentityPool> findCertIdentityPools(X509Certificate cert, String organizationId, String providerId) {
        return Collections.emptyList();
    }

    default public Collection<CertIdentityPool> findCertIdentityPools(Map<String, String> parsedCertMetadata, String organizationId, String providerId) {
        return Collections.emptyList();
    }

    default public Collection<CaCertificatesKey> findCertIdentityProviders(Certificate[] certificates, String organizationId) {
        return Collections.emptyList();
    }

    default public boolean isRevoked(X509Certificate certificate, String organizationId, String providerId) {
        return false;
    }

    default public boolean isRevoked(Certificate[] certificates, String organizationId, String providerId) {
        return false;
    }

    public Result healthcheck();

    public static class Result {
        private static final Result HEALTHY = new Result(true, "");
        @JsonProperty(value="healthy")
        private final boolean healthy;
        @JsonProperty(value="message")
        private final String message;

        private Result(@JsonProperty(value="healthy") boolean healthy, @JsonProperty(value="message") String message) {
            this.healthy = healthy;
            this.message = message;
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        public String getMessage() {
            return this.message;
        }

        public static Result healthy() {
            return HEALTHY;
        }

        public static Result healthy(String message) {
            return new Result(true, message);
        }

        public static Result unhealthy(String message) {
            return new Result(false, message);
        }

        public String toString() {
            return "Result{healthy=" + this.healthy + ", message='" + this.message + '\'' + '}';
        }
    }
}

