/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import java.util.Objects;

public final class CertIdentityPoolKey
extends AuthKey {
    private final String poolId;
    private final String organizationId;

    public CertIdentityPoolKey(@JsonProperty(value="poolId") String poolId, @JsonProperty(value="organizationId") String organizationId) {
        this.poolId = Objects.requireNonNull(poolId, "Argument `poolId` must not be null");
        this.organizationId = Objects.requireNonNull(organizationId, "Argument `organizationId` must not be null");
    }

    @JsonProperty
    public String poolId() {
        return this.poolId;
    }

    @JsonProperty
    public String organizationId() {
        return this.organizationId;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.CERT_IDENTITY_POOL;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CertIdentityPoolKey) {
            CertIdentityPoolKey that = (CertIdentityPoolKey)o;
            return Objects.equals(this.poolId, that.poolId) && Objects.equals(this.organizationId, that.organizationId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.poolId, this.organizationId);
    }

    public String toString() {
        return String.format("CertIdentityPoolKey{\n\tpoolId=%s,\n\torganizationId=%s\n}", this.poolId, this.organizationId);
    }
}

