/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class UserValue
extends AuthValue {
    private final Set<KafkaPrincipal> groups;

    @JsonCreator
    public UserValue(@JsonProperty(value="groups") Collection<KafkaPrincipal> groups) {
        this.groups = groups == null ? Collections.emptySet() : new HashSet<KafkaPrincipal>(groups);
    }

    @JsonProperty
    public Set<KafkaPrincipal> groups() {
        return this.groups;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.USER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserValue that = (UserValue)o;
        return Objects.equals(this.groups, that.groups);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.groups);
    }

    public String toString() {
        return "UserValue(groups=" + this.groups + ')';
    }
}

