/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

public enum ChecksumAlgorithm {
    CRC32C(0),
    CRC64(1);

    private final byte value;

    private ChecksumAlgorithm(byte value) {
        this.value = value;
    }

    public static ChecksumAlgorithm fromValue(byte value) {
        for (ChecksumAlgorithm algorithm : ChecksumAlgorithm.values()) {
            if (algorithm.value() != value) continue;
            return algorithm;
        }
        throw new IllegalArgumentException("Invalid value for ChecksumAlgorithm: " + value);
    }

    public byte value() {
        return this.value;
    }
}

