/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class CheckedFileIOHeader
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static CheckedFileIOHeader getRootAsCheckedFileIOHeader(ByteBuffer _bb) {
        return CheckedFileIOHeader.getRootAsCheckedFileIOHeader(_bb, new CheckedFileIOHeader());
    }

    public static CheckedFileIOHeader getRootAsCheckedFileIOHeader(ByteBuffer _bb, CheckedFileIOHeader obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public CheckedFileIOHeader __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte version() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateVersion(byte version) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, version);
            return true;
        }
        return false;
    }

    public long checksum() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateChecksum(long checksum) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, checksum);
            return true;
        }
        return false;
    }

    public long endPosition() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateEndPosition(long end_position) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, end_position);
            return true;
        }
        return false;
    }

    public static int createCheckedFileIOHeader(FlatBufferBuilder builder, byte version, long checksum, long end_position) {
        builder.startTable(3);
        CheckedFileIOHeader.addEndPosition(builder, end_position);
        CheckedFileIOHeader.addChecksum(builder, checksum);
        CheckedFileIOHeader.addVersion(builder, version);
        return CheckedFileIOHeader.endCheckedFileIOHeader(builder);
    }

    public static void startCheckedFileIOHeader(FlatBufferBuilder builder) {
        builder.startTable(3);
    }

    public static void addVersion(FlatBufferBuilder builder, byte version) {
        builder.addByte(0, version, 0);
    }

    public static void addChecksum(FlatBufferBuilder builder, long checksum) {
        builder.addLong(1, checksum, 0L);
    }

    public static void addEndPosition(FlatBufferBuilder builder, long endPosition) {
        builder.addLong(2, endPosition, 0L);
    }

    public static int endCheckedFileIOHeader(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishCheckedFileIOHeaderBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedCheckedFileIOHeaderBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public CheckedFileIOHeader get(int j) {
            return this.get(new CheckedFileIOHeader(), j);
        }

        public CheckedFileIOHeader get(CheckedFileIOHeader obj, int j) {
            return obj.__assign(CheckedFileIOHeader.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

