/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.server.common.CheckpointFile;
import org.apache.kafka.server.common.CheckpointFileConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointFileWithFailureHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(CheckpointFileWithFailureHandler.class);
    public final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String logDir;
    private final CheckpointFile<T> checkpointFile;

    public CheckpointFileWithFailureHandler(File file, int version, CheckpointFileConfig config, CheckpointFile.EntryFormatter<T> formatter, LogDirFailureChannel logDirFailureChannel, String logDir) throws IOException {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
        this.logDir = logDir;
        this.checkpointFile = new CheckpointFile(file, version, config, formatter);
    }

    public void updateChecksumProtection(boolean enable) {
        this.checkpointFile.updateChecksumProtection(enable);
    }

    public void write(Collection<T> entries) {
        try {
            this.checkpointFile.write(entries);
        }
        catch (IOException e) {
            String msg = "Error while writing to checkpoint file " + this.file.getAbsolutePath();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public void writeIfDirExists(Collection<T> entries) {
        try {
            this.checkpointFile.write(entries);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.info("Failed to write to checkpoint file {}. This is ok if the topic/partition is being deleted", (Object)this.file.getAbsolutePath(), (Object)e);
        }
        catch (IOException e) {
            String msg = "Error while writing to checkpoint file " + this.file.getAbsolutePath();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public byte[] writeToByteArray(Collection<T> entries) {
        try {
            return this.checkpointFile.writeToByteArray(entries);
        }
        catch (IOException e) {
            String msg = "Error while writing to byte array";
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public List<T> read() {
        try {
            return this.checkpointFile.read();
        }
        catch (IOException e) {
            String msg = "Error while reading checkpoint file " + this.file.getAbsolutePath();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }
}

