/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java;

import com.api.jsonata4java.Binding;
import com.api.jsonata4java.BindingType;
import com.api.jsonata4java.expressions.EvaluateException;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.Expressions;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.FrameEnvironment;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;

public class Expression
implements Serializable {
    private static final long serialVersionUID = -292660522621832862L;
    Map<String, DeclaredFunction> _declaredFunctionMap = new HashMap<String, DeclaredFunction>();
    ExpressionsVisitor _eval = null;
    Expressions _expr = null;
    Map<String, MappingExpressionParser.ExprContext> _variableMap = new HashMap<String, MappingExpressionParser.ExprContext>();

    public static List<Binding> createBindings(JsonNode bindingObj) throws ParseException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Iterator it = bindingObj.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            JsonNode testObj = bindingObj.get(key);
            String expression = "";
            try {
                Binding binding;
                if (!testObj.isTextual()) {
                    expression = testObj.toString();
                    binding = new Binding(key, expression);
                    bindings.add(binding);
                    continue;
                }
                expression = objectMapper.writeValueAsString((Object)testObj).trim();
                while (expression.startsWith("\"") && expression.length() > 1) {
                    expression = expression.substring(1);
                }
                while (expression.endsWith("\"") && expression.length() > 1) {
                    expression = expression.substring(0, expression.length() - 1);
                }
                binding = null;
                binding = expression.startsWith("function") ? new Binding(key, expression) : new Binding(key, testObj);
                bindings.add(binding);
            }
            catch (Exception e) {
                Binding binding = new Binding(key, testObj);
                bindings.add(binding);
            }
        }
        return bindings;
    }

    public static Expression jsonata(String expression) throws ParseException, IOException {
        return new Expression(expression);
    }

    public static void main(String[] args) {
        try {
            String exprString = "$sum(example.value)";
            String inputString = "{\"example\": [{\"value\": 4}, {\"value\": 7}, {\"value\": 13}]}";
            System.out.println("Expression is " + exprString);
            System.out.println("Input is " + inputString);
            Expression expression = Expression.jsonata(exprString);
            JsonNode obj = new ObjectMapper().readTree(inputString);
            JsonNode result = expression.evaluate(obj);
            System.out.println("Result is " + result);
            expression = Expression.jsonata("$a +$b()");
            expression.assign("a", "4");
            expression.assign("$b", "function(){1}");
            result = expression.evaluate(obj);
            System.out.println("Input is \"$a + $b()\" with assignments \"a\":4, \"$b\":\"function(){1}\"");
            System.out.println("Result is " + result);
            JsonNode bindingObj = new ObjectMapper().readTree("{\"a\":4, \"b\":\"function(){78}\"}");
            System.out.println("Input is \"$a + $b()\" with binding object: " + bindingObj.toString());
            System.out.println("Result is " + Expression.jsonata("$a + $b()").evaluate(obj, bindingObj));
            bindingObj = new ObjectMapper().readTree("{\"a\":4, \"b\":\"function($c){$c+78}\",\"c\":7}");
            System.out.println("Input is \"$a + $b($c)\" with binding object: " + bindingObj.toString());
            System.out.println("Result is " + Expression.jsonata("$a + $b($c)").evaluate(obj, bindingObj));
            try {
                expression = Expression.jsonata("$notafunction()");
                result = expression.evaluate((JsonNode)JsonNodeFactory.instance.objectNode());
                throw new Exception("Expression " + expression + " should have generated an exception");
            }
            catch (EvaluateRuntimeException ere) {
                System.out.println("Result is we got the expected EvaluateRuntimeException for " + ere.getLocalizedMessage());
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Expression(String expression) throws ParseException, IOException {
        this._expr = Expressions.parse(expression);
        this._eval = this._expr.getExpr();
    }

    public void assign(Binding binding) {
        if (binding.getType() == BindingType.VARIABLE) {
            this._variableMap.put(binding.getVarName(), binding.getExpression());
        } else {
            this._declaredFunctionMap.put(binding.getVarName(), binding.getFunction());
        }
    }

    public void assign(String varname, String expression) throws ParseException, IOException {
        Binding binding = new Binding(varname, expression);
        this.assign(binding);
    }

    public void clear() {
        this._variableMap.clear();
        this._declaredFunctionMap.clear();
    }

    public JsonNode evaluate(JsonNode rootContext) throws ParseException {
        ExpressionsVisitor eval = new ExpressionsVisitor(rootContext, new FrameEnvironment(null));
        for (String key : this._variableMap.keySet()) {
            MappingExpressionParser.ExprContext ctx = this._variableMap.get(key);
            eval.setVariable(key, eval.visit((ParseTree)ctx));
        }
        for (String key : this._declaredFunctionMap.keySet()) {
            DeclaredFunction fct = this._declaredFunctionMap.get(key);
            eval.setDeclaredFunction(key, fct);
        }
        return eval.visit(this._expr.getTree());
    }

    public JsonNode evaluate(JsonNode rootContext, JsonNode bindingObj) throws ParseException, IOException {
        return this.evaluate(rootContext, Expression.createBindings(bindingObj));
    }

    public JsonNode evaluate(JsonNode rootContext, JsonNode bindingObj, long timeoutMS, int maxDepth) throws ParseException, IOException, EvaluateException {
        return this.evaluate(rootContext, Expression.createBindings(bindingObj), timeoutMS, maxDepth);
    }

    public JsonNode evaluate(JsonNode rootContext, List<Binding> bindings) throws ParseException {
        JsonNode result = null;
        for (Binding binding : bindings) {
            this.assign(binding);
        }
        result = this.evaluate(rootContext);
        return result;
    }

    public JsonNode evaluate(JsonNode rootContext, List<Binding> bindings, long timeoutMS, int maxDepth) throws ParseException, EvaluateException {
        JsonNode result = null;
        for (Binding binding : bindings) {
            this.assign(binding);
        }
        result = this.evaluate(rootContext, timeoutMS, maxDepth);
        return result;
    }

    public JsonNode evaluate(JsonNode rootContext, long timeoutMS, int maxDepth) throws EvaluateException {
        ExpressionsVisitor eval = new ExpressionsVisitor(rootContext, new FrameEnvironment(null));
        for (String key : this._variableMap.keySet()) {
            MappingExpressionParser.ExprContext ctx = this._variableMap.get(key);
            eval.setVariable(key, eval.visit((ParseTree)ctx));
        }
        for (String key : this._declaredFunctionMap.keySet()) {
            DeclaredFunction fct = this._declaredFunctionMap.get(key);
            eval.setDeclaredFunction(key, fct);
        }
        eval.timeboxExpression(timeoutMS, maxDepth);
        return eval.visit(this._expr.getTree());
    }

    public synchronized JsonNode evaluateSynced(JsonNode rootContext) throws ParseException {
        return this.evaluate(rootContext);
    }

    public synchronized JsonNode evaluateSynced(JsonNode rootContext, JsonNode bindingObj) throws ParseException, IOException {
        return this.evaluate(rootContext, bindingObj);
    }

    public synchronized JsonNode evaluateSynced(JsonNode rootContext, JsonNode bindingObj, long timeoutMS, int maxDepth) throws ParseException, IOException, EvaluateException {
        return this.evaluate(rootContext, Expression.createBindings(bindingObj), timeoutMS, maxDepth);
    }

    public synchronized JsonNode evaluateSynced(JsonNode rootContext, List<Binding> bindings) throws ParseException {
        return this.evaluate(rootContext, bindings);
    }

    public synchronized JsonNode evaluateSynced(JsonNode rootContext, List<Binding> bindings, long timeoutMS, int maxDepth) throws ParseException, EvaluateException {
        return this.evaluate(rootContext, bindings, timeoutMS, maxDepth);
    }

    public synchronized JsonNode evaluateSynced(JsonNode rootContext, long timeoutMS, int maxDepth) throws EvaluateException {
        return this.evaluate(rootContext, timeoutMS, maxDepth);
    }

    public void registerFunction(String fctName, String implementation) throws ParseException, IOException {
        Binding fctBinding = new Binding(fctName, implementation);
        this._declaredFunctionMap.put(fctBinding.getVarName(), fctBinding.getFunction());
    }
}

