/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.api.jsonata4java.expressions.utils.NumberUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class RoundFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$round");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$round");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$round");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$round");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ValueNode result = null;
        NullNode argNumber = JsonNodeFactory.instance.nullNode();
        NullNode argPrecision = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = RoundFunction.getArgumentCount(ctx);
        if (useContext) {
            argNumber = FunctionUtils.getContextVariable(expressionVisitor);
            if (argNumber != null && !argNumber.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 1 && argCount != 2) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG3BADTYPE);
        if (!useContext) {
            argNumber = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argNumber == null) {
            return null;
        }
        if (!argNumber.isNumber()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        BigDecimal bigDec = argNumber.decimalValue();
        int precision = 0;
        if (argCount == 2 && (argPrecision = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1)) != null) {
            if (!argPrecision.isIntegralNumber()) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            precision = argPrecision.intValue();
        }
        BigDecimal round = bigDec.setScale(precision, RoundingMode.HALF_EVEN);
        return NumberUtils.convertNumberToValueNode(round.toPlainString());
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<n-n?:n>";
    }
}

