/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.confluent.kafka.schemaregistry.json.SpecificationVersion;
import io.confluent.kafka.schemaregistry.utils.EnumRecommender;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class KafkaJsonSchemaSerializerConfig
extends AbstractKafkaSchemaSerDeConfig {
    public static final String FAIL_UNKNOWN_PROPERTIES = "json.fail.unknown.properties";
    public static final boolean FAIL_UNKNOWN_PROPERTIES_DEFAULT = true;
    public static final String FAIL_UNKNOWN_PROPERTIES_DOC = "Whether to fail serialization if unknown JSON properties are encountered";
    public static final String FAIL_INVALID_SCHEMA = "json.fail.invalid.schema";
    public static final boolean FAIL_INVALID_SCHEMA_DEFAULT = false;
    public static final String FAIL_INVALID_SCHEMA_DOC = "Whether to fail serialization if the payload does not match the schema";
    public static final String WRITE_DATES_AS_ISO8601 = "json.write.dates.iso8601";
    public static final boolean WRITE_DATES_AS_ISO8601_DEFAULT = false;
    public static final String WRITE_DATES_AS_ISO8601_DOC = "Whether to write dates as ISO 8601 strings";
    public static final String SCHEMA_SPEC_VERSION = "json.schema.spec.version";
    public static final String SCHEMA_SPEC_VERSION_DEFAULT = SpecificationVersion.DRAFT_7.name().toLowerCase(Locale.ROOT);
    public static final String SCHEMA_SPEC_VERSION_DOC = "The specification version to use for JSON schemas derived from objects, one of 'draft_4', 'draft_6', 'draft_7', or 'draft_2019_09'";
    public static final String ONEOF_FOR_NULLABLES = "json.oneof.for.nullables";
    public static final boolean ONEOF_FOR_NULLABLES_DEFAULT = true;
    public static final String ONEOF_FOR_NULLABLES_DOC = "Whether JSON schemas derived from objects will use oneOf for nullable fields";
    public static final String DEFAULT_PROPERTY_INCLUSION = "json.default.property.inclusion";
    public static final String DEFAULT_PROPERTY_INCLUSION_DOC = "Controls the inclusion of properties during serialization";
    public static final String JSON_INDENT_OUTPUT = "json.indent.output";
    public static final boolean JSON_INDENT_OUTPUT_DEFAULT = false;
    public static final String JSON_INDENT_OUTPUT_DOC = "Whether JSON output should be indented (\"pretty-printed\")";
    private static ConfigDef config = KafkaJsonSchemaSerializerConfig.baseConfigDef().define("json.fail.unknown.properties", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to fail serialization if unknown JSON properties are encountered").define("json.fail.invalid.schema", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Whether to fail serialization if the payload does not match the schema").define("json.write.dates.iso8601", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Whether to write dates as ISO 8601 strings").define("json.schema.spec.version", ConfigDef.Type.STRING, (Object)SCHEMA_SPEC_VERSION_DEFAULT, (ConfigDef.Validator)EnumRecommender.in((Object[])SpecificationVersion.values()), ConfigDef.Importance.MEDIUM, "The specification version to use for JSON schemas derived from objects, one of 'draft_4', 'draft_6', 'draft_7', or 'draft_2019_09'").define("json.oneof.for.nullables", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "Whether JSON schemas derived from objects will use oneOf for nullable fields").define("json.default.property.inclusion", ConfigDef.Type.STRING, null, (ConfigDef.Validator)EnumRecommender.in((Object[])JsonInclude.Include.values()), ConfigDef.Importance.MEDIUM, "Controls the inclusion of properties during serialization").define("json.indent.output", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether JSON output should be indented (\"pretty-printed\")");

    public KafkaJsonSchemaSerializerConfig(Map<?, ?> props) {
        super(config, props);
    }
}

