/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.AuditJobHandle;
import io.confluent.rest.AuditJobHandler;
import io.confluent.rest.BeginShutdownBrokerHandle;
import io.confluent.rest.KafkaRestorePartitionHandle;
import io.confluent.rest.RestoreHandler;
import io.confluent.rest.RollHandler;
import io.confluent.rest.TierMetadataRecoveryHandle;
import io.confluent.rest.TierMetadataRecoveryHandler;
import java.time.Duration;
import java.util.Objects;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalRestServer {
    private static final Logger log = LoggerFactory.getLogger(InternalRestServer.class);
    private final BeginShutdownBrokerHandle beginShutdownBrokerHandle;
    private final KafkaRestorePartitionHandle kafkaRestorePartitionHandle;
    private final AuditJobHandle auditJobHandle;
    private final TierMetadataRecoveryHandle tierMetadataRecoveryHandle;
    private final int port;
    private Server server;
    private static final long CONNECTION_IDLE_TIMEOUT_MS = Duration.ofMinutes(1L).toMillis();

    public InternalRestServer(int port, BeginShutdownBrokerHandle beginShutdownBrokerHandle, KafkaRestorePartitionHandle kafkaRestorePartitionHandle, AuditJobHandle auditJobHandle, TierMetadataRecoveryHandle tierMetadataRecoveryHandle) {
        this.port = port;
        this.beginShutdownBrokerHandle = Objects.requireNonNull(beginShutdownBrokerHandle, "null beginShutdownBrokerHandle");
        this.kafkaRestorePartitionHandle = Objects.requireNonNull(kafkaRestorePartitionHandle, "null kafkaRestorePartitionHandle");
        this.auditJobHandle = Objects.requireNonNull(auditJobHandle, "null auditJobHandle");
        this.tierMetadataRecoveryHandle = Objects.requireNonNull(tierMetadataRecoveryHandle, "null tierMetadataRecoveryHandle");
    }

    public synchronized void start() throws Exception {
        if (this.server != null) {
            throw new IllegalStateException("Server is already running.");
        }
        log.info("Binding to port " + this.port);
        this.server = new Server(this.port);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setIdleTimeout(60000L);
        ContextHandler rollContext = new ContextHandler("/v1/roll");
        rollContext.setContextPath("/v1/roll");
        rollContext.setHandler((Handler)new RollHandler(this.beginShutdownBrokerHandle));
        ContextHandler restoreContext = new ContextHandler("/v1/restore");
        restoreContext.setContextPath("/v1/restore");
        restoreContext.setHandler((Handler)new RestoreHandler(this.kafkaRestorePartitionHandle));
        ContextHandler auditJobContext = new ContextHandler("/v1/audit");
        auditJobContext.setContextPath("/v1/audit");
        auditJobContext.setHandler((Handler)new AuditJobHandler(this.auditJobHandle));
        ContextHandler tierMetadataRecoveryContext = new ContextHandler("/v1/tiermetadata");
        tierMetadataRecoveryContext.setContextPath("/v1/tiermetadata");
        tierMetadataRecoveryContext.setHandler((Handler)new TierMetadataRecoveryHandler(this.tierMetadataRecoveryHandle, (long)((double)CONNECTION_IDLE_TIMEOUT_MS * 0.75)));
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{rollContext, restoreContext, auditJobContext, tierMetadataRecoveryContext, new DefaultHandler()});
        this.server.setHandler((Handler)contexts);
        this.server.start();
    }

    public synchronized void stop() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server is not running.");
        }
        log.info("Stopping");
        this.server.stop();
        this.server.join();
        this.server = null;
    }
}

