/*
 * Decompiled with CFR 0.152.
 */
package kafka.availability;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.availability.BrokerHealthManager$;
import kafka.availability.BrokerHealthManagerConfig;
import kafka.availability.BrokerHealthManagerConfig$;
import kafka.availability.BrokerHealthStatus;
import kafka.availability.HealthSamplesWindow;
import kafka.availability.HealthStatusAggregationOperator;
import kafka.availability.HealthStatusAggregationOperator_And$;
import kafka.availability.HealthStatusAggregationOperator_Or$;
import kafka.availability.Healthy$;
import kafka.availability.Suspect$;
import kafka.availability.Unhealthy$;
import kafka.common.ControlledShutdownRequestReason;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.config.BrokerHealthCriteria;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.ShutdownableThread;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.WeakHashMap;
import scala.collection.mutable.WeakHashMap$;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tUh\u0001B!C\u0001\u001dC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tm\u0002\u0011\t\u0011)A\u0005o\"AQ\u0010\u0001B\u0001B\u0003%a\u0010\u0003\u0006\u0002\n\u0001\u0011\t\u0011)A\u0005\u0003\u0017Aq!a\u0005\u0001\t\u0003\t)\u0002C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002$!A\u0011\u0011\u0007\u0001!\u0002\u0013\t)\u0003C\u0005\u00024\u0001\u0001\r\u0011\"\u0001\u00026!I\u0011q\u0007\u0001A\u0002\u0013\u0005\u0011\u0011\b\u0005\b\u0003\u007f\u0001\u0001\u0015)\u0003q\u0011%\tI\u0005\u0001a\u0001\n\u0003\tY\u0005C\u0005\u0002T\u0001\u0001\r\u0011\"\u0001\u0002V!A\u0011\u0011\f\u0001!B\u0013\ti\u0005C\u0005\u0002^\u0001\u0001\r\u0011\"\u0001\u0002`!I\u0011\u0011\r\u0001A\u0002\u0013\u0005\u00111\r\u0005\t\u0003O\u0002\u0001\u0015)\u0003\u0002\u0004!I\u00111\u000e\u0001A\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003_\u0002\u0001\u0019!C\u0001\u0003cB\u0001\"!\u001e\u0001A\u0003&\u00111\u0002\u0005\n\u0003s\u0002\u0001\u0019!C\u0001\u0003wB\u0011\"!-\u0001\u0001\u0004%\t!a-\t\u0011\u0005]\u0006\u0001)Q\u0005\u0003{B\u0011\"!/\u0001\u0001\u0004%I!!\u000e\t\u0013\u0005m\u0006\u00011A\u0005\n\u0005u\u0006bBAa\u0001\u0001\u0006K\u0001\u001d\u0005\n\u0003\u0007\u0004\u0001\u0019!C\u0005\u0003\u000bD\u0011\"!4\u0001\u0001\u0004%I!a4\t\u0011\u0005M\u0007\u0001)Q\u0005\u0003\u000fD\u0011\"!6\u0001\u0001\u0004%I!!2\t\u0013\u0005]\u0007\u00011A\u0005\n\u0005e\u0007\u0002CAo\u0001\u0001\u0006K!a2\t\u0013\u0005}\u0007A1A\u0005\n\u0005\u0005\b\u0002\u0003B\u0010\u0001\u0001\u0006I!a9\t\u0013\t\u0005\u0002A1A\u0005\n\t\r\u0002\u0002\u0003B\u0016\u0001\u0001\u0006IA!\n\t\u0013\t5\u0002\u00011A\u0005\n\u0005\u0015\u0007\"\u0003B\u0018\u0001\u0001\u0007I\u0011\u0002B\u0019\u0011!\u0011)\u0004\u0001Q!\n\u0005\u001d\u0007\"\u0003B\u001c\u0001\u0001\u0007I\u0011BAc\u0011%\u0011I\u0004\u0001a\u0001\n\u0013\u0011Y\u0004\u0003\u0005\u0003@\u0001\u0001\u000b\u0015BAd\u0011%\u0011\t\u0005\u0001a\u0001\n\u0013\t)\rC\u0005\u0003D\u0001\u0001\r\u0011\"\u0003\u0003F!A!\u0011\n\u0001!B\u0013\t9\rC\u0004\u0003L\u0001!\t!a\u0018\t\u000f\t5\u0003\u0001\"\u0001\u0003P!9!\u0011\u000b\u0001\u0005B\t=\u0003\"\u0003B*\u0001\t\u0007I\u0011\u0002B+\u0011!\u0011i\u0006\u0001Q\u0001\n\t]\u0003b\u0002B0\u0001\u0011\u0005!\u0011\r\u0005\b\u0005W\u0002A\u0011\u0001B(\u0011\u001d\u0011i\u0007\u0001C\u0001\u0003?BqAa\u001c\u0001\t\u0003\u0012y\u0005C\u0004\u0003r\u0001!\tAa\u001d\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\"9!Q\u0014\u0001\u0005B\t=\u0003b\u0002BP\u0001\u0011\u0005#\u0011\u0015\u0005\b\u0005w\u0003A\u0011\tB_\u0011\u001d\u0011I\r\u0001C!\u0005\u0017<qAa5C\u0011\u0003\u0011)N\u0002\u0004B\u0005\"\u0005!q\u001b\u0005\b\u0003'iD\u0011\u0001Bp\u0011%\u0011\t/\u0010b\u0001\n\u0003\u0011\u0019\u000f\u0003\u0005\u0003tv\u0002\u000b\u0011\u0002Bs\u0005M\u0011%o\\6fe\"+\u0017\r\u001c;i\u001b\u0006t\u0017mZ3s\u0015\t\u0019E)\u0001\u0007bm\u0006LG.\u00192jY&$\u0018PC\u0001F\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001%V7B\u0011\u0011jU\u0007\u0002\u0015*\u00111\nT\u0001\u0005kRLGN\u0003\u0002N\u001d\u000611/\u001a:wKJT!!R(\u000b\u0005A\u000b\u0016AB1qC\u000eDWMC\u0001S\u0003\ry'oZ\u0005\u0003)*\u0013!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bIB\u0011a+W\u0007\u0002/*\u0011\u0001\fR\u0001\u0006kRLGn]\u0005\u00035^\u0013q\u0001T8hO&tw\r\u0005\u0002]=6\tQL\u0003\u0002N\t&\u0011q,\u0018\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0002-\r|g\u000e\u001e:pY2,Gm\u00155vi\u0012|wO\u001c%p_.\u0004RAY3h[Nl\u0011a\u0019\u0006\u0002I\u0006)1oY1mC&\u0011am\u0019\u0002\n\rVt7\r^5p]J\u0002\"\u0001[6\u000e\u0003%T!A\u001b#\u0002\r\r|W.\\8o\u0013\ta\u0017NA\u0010D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t'+Z9vKN$(+Z1t_:\u00042A\u00198q\u0013\ty7M\u0001\u0004PaRLwN\u001c\t\u0003EFL!A]2\u0003\t1{gn\u001a\t\u0003ERL!!^2\u0003\tUs\u0017\u000e^\u0001\tu.\u001cE.[3oiB\u0011\u0001p_\u0007\u0002s*\u0011!\u0010R\u0001\u0003u.L!\u0001`=\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003II7/Q2uSZ,7i\u001c8ue>dG.\u001a:\u0011\t\t|\u00181A\u0005\u0004\u0003\u0003\u0019'!\u0003$v]\u000e$\u0018n\u001c81!\r\u0011\u0017QA\u0005\u0004\u0003\u000f\u0019'a\u0002\"p_2,\u0017M\\\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\t\u00055\u0011qB\u0007\u0002\u0005&\u0019\u0011\u0011\u0003\"\u00033\t\u0013xn[3s\u0011\u0016\fG\u000e\u001e5NC:\fw-\u001a:D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005]\u0011\u0011DA\u000e\u0003;\ty\u0002E\u0002\u0002\u000e\u0001AQ\u0001Y\u0003A\u0002\u0005DQA^\u0003A\u0002]DQ!`\u0003A\u0002yDq!!\u0003\u0006\u0001\u0004\tY!\u0001\u0007nKR\u0014\u0018nY:He>,\b/\u0006\u0002\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,1\u000bq!\\3ue&\u001c7/\u0003\u0003\u00020\u0005%\"!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\nA\u0002^8uC2\u001c\u0016-\u001c9mKN,\u0012\u0001]\u0001\u0011i>$\u0018\r\\*b[BdWm]0%KF$2a]A\u001e\u0011!\ti$CA\u0001\u0002\u0004\u0001\u0018a\u0001=%c\u0005iAo\u001c;bYN\u000bW\u000e\u001d7fg\u0002B3ACA\"!\r\u0011\u0017QI\u0005\u0004\u0003\u000f\u001a'\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002%\t\u0014xn[3s\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo]\u000b\u0003\u0003\u001b\u0002B!!\u0004\u0002P%\u0019\u0011\u0011\u000b\"\u0003%\t\u0013xn[3s\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo]\u0001\u0017EJ|7.\u001a:IK\u0006dG\u000f[*uCR,8o\u0018\u0013fcR\u00191/a\u0016\t\u0013\u0005uB\"!AA\u0002\u00055\u0013a\u00052s_.,'\u000fS3bYRD7\u000b^1ukN\u0004\u0003fA\u0007\u0002D\u0005\u0019\u0012n]'ji&<\u0017\r^5p]\u0016s\u0017M\u00197fIV\u0011\u00111A\u0001\u0018SNl\u0015\u000e^5hCRLwN\\#oC\ndW\rZ0%KF$2a]A3\u0011%\tidDA\u0001\u0002\u0004\t\u0019!\u0001\u000bjg6KG/[4bi&|g.\u00128bE2,G\r\t\u0015\u0004!\u0005\r\u0013AB2p]\u001aLw-\u0006\u0002\u0002\f\u0005Q1m\u001c8gS\u001e|F%Z9\u0015\u0007M\f\u0019\bC\u0005\u0002>I\t\t\u00111\u0001\u0002\f\u000591m\u001c8gS\u001e\u0004\u0003fA\n\u0002D\u0005y\u0002O]3w)\"\u0014X-\u00193M_\u000e\fGnQ8v]R,'o]*oCB\u001c\bn\u001c;\u0016\u0005\u0005u\u0004\u0003CA@\u0003\u000f\u000bY)a&\u000e\u0005\u0005\u0005%bA&\u0002\u0004*\u0011\u0011QQ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\n\u0006\u0005%aA'baB!\u0011QRAJ\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006\r\u0015\u0001\u00027b]\u001eLA!!&\u0002\u0010\n1A\u000b\u001b:fC\u0012\u0004b!a \u0002\u001a\u0006u\u0015\u0002BAN\u0003\u0003\u0013A\u0001T5tiB!\u0011qTAW\u001b\t\t\tKC\u0002D\u0003GS1!RAS\u0015\u0011\t9+!+\u0002\u0013\r|gN\u001a7vK:$(BAAV\u0003\tIw.\u0003\u0003\u00020\u0006\u0005&a\u0005+ie\u0016\fG\rT8dC2\u001cu.\u001e8uKJ\u001c\u0018a\t9sKZ$\u0006N]3bI2{7-\u00197D_VtG/\u001a:t':\f\u0007o\u001d5pi~#S-\u001d\u000b\u0004g\u0006U\u0006\"CA\u001f+\u0005\u0005\t\u0019AA?\u0003\u0001\u0002(/\u001a<UQJ,\u0017\r\u001a'pG\u0006d7i\\;oi\u0016\u00148o\u00158baNDw\u000e\u001e\u0011\u00025A\u0014XM\u001e(v[\u000e{W\u000e\u001d7fi\u0016$7\u000b^8sC\u001e,w\n]:\u0002=A\u0014XM\u001e(v[\u000e{W\u000e\u001d7fi\u0016$7\u000b^8sC\u001e,w\n]:`I\u0015\fHcA:\u0002@\"A\u0011Q\b\r\u0002\u0002\u0003\u0007\u0001/A\u000eqe\u00164h*^7D_6\u0004H.\u001a;fIN#xN]1hK>\u00038\u000fI\u0001\u001bG>tG/[4v_V\u001cXK\u001c5fC2$\b._*b[BdWm]\u000b\u0003\u0003\u000f\u00042AYAe\u0013\r\tYm\u0019\u0002\u0004\u0013:$\u0018AH2p]RLw-^8vgVs\u0007.Z1mi\"L8+Y7qY\u0016\u001cx\fJ3r)\r\u0019\u0018\u0011\u001b\u0005\n\u0003{Y\u0012\u0011!a\u0001\u0003\u000f\f1dY8oi&<Wo\\;t+:DW-\u00197uQf\u001c\u0016-\u001c9mKN\u0004\u0013\u0001G2p]RLw-^8vg\"+\u0017\r\u001c;isN\u000bW\u000e\u001d7fg\u0006a2m\u001c8uS\u001e,x.^:IK\u0006dG\u000f[=TC6\u0004H.Z:`I\u0015\fHcA:\u0002\\\"I\u0011Q\b\u0010\u0002\u0002\u0003\u0007\u0011qY\u0001\u001aG>tG/[4v_V\u001c\b*Z1mi\"L8+Y7qY\u0016\u001c\b%\u0001\u001auQJ,\u0017\rZ*uk\u000e\\7+Y7qY\u0016\u001c()_\"p[B|g.\u001a8u)f\u0004XMQ=UQJ,\u0017\rZ$s_V\u0004H+\u001f9f+\t\t\u0019\u000f\u0005\u0005\u0002f\u0006=\u0018\u0011\u001fB\u000b\u001b\t\t9O\u0003\u0003\u0002j\u0006-\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003[\u001c\u0017AC2pY2,7\r^5p]&!\u0011\u0011RAt!\u0011\t\u0019Pa\u0004\u000f\t\u0005U(1\u0002\b\u0005\u0003o\u0014IA\u0004\u0003\u0002z\n\u001da\u0002BA~\u0005\u000bqA!!@\u0003\u00045\u0011\u0011q \u0006\u0004\u0005\u00031\u0015A\u0002\u001fs_>$h(\u0003\u0002\u0002,&!\u0011qUAU\u0013\r)\u0015QU\u0005\u0004\u0007\u0006\r\u0016\u0002\u0002B\u0007\u0003C\u000b1\u0003\u00165sK\u0006$Gj\\2bY\u000e{WO\u001c;feNLAA!\u0005\u0003\u0014\tyA\u000b\u001b:fC\u0012<%o\\;q)f\u0004XM\u0003\u0003\u0003\u000e\u0005\u0005\u0006\u0003CAs\u0003_\u00149B!\b\u0011\t\u0005M(\u0011D\u0005\u0005\u00057\u0011\u0019BA\nNKR\u0014\u0018nY\"p[B|g.\u001a8u)f\u0004X\rE\u0004\u0002f\u0006=\u00181\u00129\u0002gQD'/Z1e'R,8m[*b[BdWm\u001d\"z\u0007>l\u0007o\u001c8f]R$\u0016\u0010]3CsRC'/Z1e\u000fJ|W\u000f\u001d+za\u0016\u0004\u0013\u0001H;oQ\u0016\fG\u000e\u001e5z'R|'/Y4f'\u0006l\u0007\u000f\\3XS:$wn^\u000b\u0003\u0005K\u0001B!!\u0004\u0003(%\u0019!\u0011\u0006\"\u0003'!+\u0017\r\u001c;i'\u0006l\u0007\u000f\\3t/&tGm\\<\u0002;Ut\u0007.Z1mi\"L8\u000b^8sC\u001e,7+Y7qY\u0016<\u0016N\u001c3po\u0002\n\u0001fY8oi&<Wo\\;t'\u0006l\u0007\u000f\\3t\u000b:<\u0017N\\3UQJ,\u0017\rZ$s_V\u00048o\u0015;vG.\fAfY8oi&<Wo\\;t'\u0006l\u0007\u000f\\3t\u000b:<\u0017N\\3UQJ,\u0017\rZ$s_V\u00048o\u0015;vG.|F%Z9\u0015\u0007M\u0014\u0019\u0004C\u0005\u0002>\u0015\n\t\u00111\u0001\u0002H\u0006I3m\u001c8uS\u001e,x.^:TC6\u0004H.Z:F]\u001eLg.\u001a+ie\u0016\fGm\u0012:pkB\u001c8\u000b^;dW\u0002\n\u0011fY8oi&<Wo\\;t'\u0006l\u0007\u000f\\3t'R|'/Y4f)\"\u0014X-\u00193He>,\bo]*uk\u000e\\\u0017!L2p]RLw-^8vgN\u000bW\u000e\u001d7fgN#xN]1hKRC'/Z1e\u000fJ|W\u000f]:TiV\u001c7n\u0018\u0013fcR\u00191O!\u0010\t\u0013\u0005u\u0002&!AA\u0002\u0005\u001d\u0017AK2p]RLw-^8vgN\u000bW\u000e\u001d7fgN#xN]1hKRC'/Z1e\u000fJ|W\u000f]:TiV\u001c7\u000eI\u0001/G>tG/[4v_V\u001c8+Y7qY\u0016\u001chj\\*u_J\fw-\u001a+ie\u0016\fG-T1lS:<\u0007K]8he\u0016\u001c8/\u0001\u001ad_:$\u0018nZ;pkN\u001c\u0016-\u001c9mKNtun\u0015;pe\u0006<W\r\u00165sK\u0006$W*Y6j]\u001e\u0004&o\\4sKN\u001cx\fJ3r)\r\u0019(q\t\u0005\n\u0003{Y\u0013\u0011!a\u0001\u0003\u000f\fqfY8oi&<Wo\\;t'\u0006l\u0007\u000f\\3t\u001d>\u001cFo\u001c:bO\u0016$\u0006N]3bI6\u000b7.\u001b8h!J|wM]3tg\u0002\n\u0011\"[:IK\u0006dG\u000f[=\u0002\u001bI,Wn\u001c<f\u001b\u0016$(/[2t)\u0005\u0019\u0018\u0001C:ikR$wn\u001e8\u0002+!\f'\u000fZ*ikR$wn\u001e8TG\",G-\u001e7feV\u0011!q\u000b\t\u0004\u0013\ne\u0013b\u0001B.\u0015\nq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\u0018A\u00065be\u0012\u001c\u0006.\u001e;e_^t7k\u00195fIVdWM\u001d\u0011\u0002\u000f%\u001c8\u000b^;dWR1\u00111\u0001B2\u0005OBqA!\u001a3\u0001\u0004\tY)\u0001\u0004uQJ,\u0017\r\u001a\u0005\b\u0005S\u0012\u0004\u0019AAO\u00031\u0019WO\u001d:D_VtG/\u001a:t\u0003=awnZ*uk\u000e\\G\u000b\u001b:fC\u0012\u001c\u0018!E5t\u0005J|7.\u001a:V]\",\u0017\r\u001c;is\u00061Am\\,pe.\f\u0001c\u001d;biV\u001cHK]1og&$\u0018n\u001c8\u0015\u000fM\u0014)H!\u001f\u0003~!9!q\u000f\u001cA\u0002\u00055\u0013aE2veJ,g\u000e\u001e%fC2$\bn\u0015;biV\u001c\bb\u0002B>m\u0001\u0007\u0011QJ\u0001\u0010]\u0016<\b*Z1mi\"\u001cF/\u0019;vg\"9!q\u0010\u001cA\u0002\t\u0005\u0015aB:b[BdWm\u001d\t\u0007\u0005\u0007\u0013i)a2\u000f\t\t\u0015%\u0011\u0012\b\u0005\u0003{\u00149)C\u0001e\u0013\r\u0011YiY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yI!%\u0003\u0011%#XM]1cY\u0016T1Aa#d\u0003mawn\u001a\"s_.,'\u000fS3bYRD7\u000b^1ukN\u001c\u0005.\u00198hKR91Oa&\u0003\u001a\nm\u0005b\u0002B<o\u0001\u0007\u0011Q\n\u0005\b\u0005w:\u0004\u0019AA'\u0011\u001d\u0011yh\u000ea\u0001\u0005\u0003\u000b1A];o\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"Aa)\u0011\r\t\u0015&q\u0015BV\u001b\t\tY/\u0003\u0003\u0003*\u0006-(aA*fiB!!Q\u0016B[\u001d\u0011\u0011yK!-\u0011\u0007\u0005u8-C\u0002\u00034\u000e\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B\\\u0005s\u0013aa\u0015;sS:<'b\u0001BZG\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0004g\n}\u0006b\u0002Bau\u0001\u0007!1Y\u0001\n]\u0016<8i\u001c8gS\u001e\u00042\u0001\u0018Bc\u0013\r\u00119-\u0018\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006sK\u000e|gNZ5hkJ,G#B:\u0003N\nE\u0007b\u0002Bhw\u0001\u0007!1Y\u0001\n_2$7i\u001c8gS\u001eDqA!1<\u0001\u0004\u0011\u0019-A\nCe>\\WM\u001d%fC2$\b.T1oC\u001e,'\u000fE\u0002\u0002\u000eu\u001a2!\u0010Bm!\r\u0011'1\\\u0005\u0004\u0005;\u001c'AB!osJ+g\r\u0006\u0002\u0003V\u0006)\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cXC\u0001Bs!\u0019\u00119O!<\u0003p6\u0011!\u0011\u001e\u0006\u0005\u0005W\fY/A\u0005j[6,H/\u00192mK&!!\u0011\u0016Bu!\u0011\tiI!=\n\t\t]\u0016qR\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0001")
public class BrokerHealthManager
extends ShutdownableThread
implements Logging,
BrokerReconfigurable {
    private final Function2<ControlledShutdownRequestReason, Option<Object>, BoxedUnit> controlledShutdownHook;
    private final KafkaZkClient zkClient;
    private final Function0<Object> isActiveController;
    private final KafkaMetricsGroup metricsGroup;
    private volatile long totalSamples;
    private volatile BrokerHealthStatus brokerHealthStatus;
    private volatile boolean isMitigationEnabled;
    private volatile BrokerHealthManagerConfig config;
    private Map<Thread, List<ThreadLocalCounters>> prevThreadLocalCountersSnapshot;
    private long prevNumCompletedStorageOps;
    private int contiguousUnhealthySamples;
    private int contiguousHealthySamples;
    private final scala.collection.mutable.Map<ThreadLocalCounters.ThreadGroupType, scala.collection.mutable.Map<ThreadLocalCounters.MetricComponentType, scala.collection.mutable.Map<Thread, Object>>> threadStuckSamplesByComponentTypeByThreadGroupType;
    private final HealthSamplesWindow unhealthyStorageSampleWindow;
    private int contiguousSamplesEngineThreadGroupsStuck;
    private int contiguousSamplesStorageThreadGroupsStuck;
    private int contiguousSamplesNoStorageThreadMakingProgress;
    private final KafkaScheduler hardShutdownScheduler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return BrokerHealthManager$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public long totalSamples() {
        return this.totalSamples;
    }

    public void totalSamples_$eq(long x$1) {
        this.totalSamples = x$1;
    }

    public BrokerHealthStatus brokerHealthStatus() {
        return this.brokerHealthStatus;
    }

    public void brokerHealthStatus_$eq(BrokerHealthStatus x$1) {
        this.brokerHealthStatus = x$1;
    }

    public boolean isMitigationEnabled() {
        return this.isMitigationEnabled;
    }

    public void isMitigationEnabled_$eq(boolean x$1) {
        this.isMitigationEnabled = x$1;
    }

    public BrokerHealthManagerConfig config() {
        return this.config;
    }

    public void config_$eq(BrokerHealthManagerConfig x$1) {
        this.config = x$1;
    }

    public Map<Thread, List<ThreadLocalCounters>> prevThreadLocalCountersSnapshot() {
        return this.prevThreadLocalCountersSnapshot;
    }

    public void prevThreadLocalCountersSnapshot_$eq(Map<Thread, List<ThreadLocalCounters>> x$1) {
        this.prevThreadLocalCountersSnapshot = x$1;
    }

    private long prevNumCompletedStorageOps() {
        return this.prevNumCompletedStorageOps;
    }

    private void prevNumCompletedStorageOps_$eq(long x$1) {
        this.prevNumCompletedStorageOps = x$1;
    }

    private int contiguousUnhealthySamples() {
        return this.contiguousUnhealthySamples;
    }

    private void contiguousUnhealthySamples_$eq(int x$1) {
        this.contiguousUnhealthySamples = x$1;
    }

    private int contiguousHealthySamples() {
        return this.contiguousHealthySamples;
    }

    private void contiguousHealthySamples_$eq(int x$1) {
        this.contiguousHealthySamples = x$1;
    }

    private scala.collection.mutable.Map<ThreadLocalCounters.ThreadGroupType, scala.collection.mutable.Map<ThreadLocalCounters.MetricComponentType, scala.collection.mutable.Map<Thread, Object>>> threadStuckSamplesByComponentTypeByThreadGroupType() {
        return this.threadStuckSamplesByComponentTypeByThreadGroupType;
    }

    private HealthSamplesWindow unhealthyStorageSampleWindow() {
        return this.unhealthyStorageSampleWindow;
    }

    private int contiguousSamplesEngineThreadGroupsStuck() {
        return this.contiguousSamplesEngineThreadGroupsStuck;
    }

    private void contiguousSamplesEngineThreadGroupsStuck_$eq(int x$1) {
        this.contiguousSamplesEngineThreadGroupsStuck = x$1;
    }

    private int contiguousSamplesStorageThreadGroupsStuck() {
        return this.contiguousSamplesStorageThreadGroupsStuck;
    }

    private void contiguousSamplesStorageThreadGroupsStuck_$eq(int x$1) {
        this.contiguousSamplesStorageThreadGroupsStuck = x$1;
    }

    private int contiguousSamplesNoStorageThreadMakingProgress() {
        return this.contiguousSamplesNoStorageThreadMakingProgress;
    }

    private void contiguousSamplesNoStorageThreadMakingProgress_$eq(int x$1) {
        this.contiguousSamplesNoStorageThreadMakingProgress = x$1;
    }

    public boolean isHealthy() {
        block3: {
            block2: {
                if (!this.isMitigationEnabled()) break block2;
                BrokerHealthStatus brokerHealthStatus = this.brokerHealthStatus();
                Healthy$ healthy$ = Healthy$.MODULE$;
                if (brokerHealthStatus == null || !brokerHealthStatus.equals(healthy$)) break block3;
            }
            return true;
        }
        return false;
    }

    public void removeMetrics() {
        this.metricsGroup().removeMetric("ContiguousUnhealthySamples");
        this.metricsGroup().removeMetric("ContiguousSamplesEngineThreadGroupsStuck");
        this.metricsGroup().removeMetric("ContiguousSamplesStorageThreadGroupsStuck");
        this.metricsGroup().removeMetric("ContiguousSamplesNoStorageThreadMakingProgress");
        this.metricsGroup().removeMetric("UnhealthinessCount");
        this.metricsGroup().removeMetric("StorageHealthStatus");
    }

    public void shutdown() {
        this.removeMetrics();
        super.shutdown();
    }

    private KafkaScheduler hardShutdownScheduler() {
        return this.hardShutdownScheduler;
    }

    public boolean isStuck(Thread thread, ThreadLocalCounters currCounters) {
        return this.isPrevCountersPresent$1() && this.isThreadStuck$1(thread, currCounters);
    }

    public void logStuckThreads() {
        this.threadStuckSamplesByComponentTypeByThreadGroupType().foreach((Function1 & Serializable)x0$1 -> {
            BrokerHealthManager.$anonfun$logStuckThreads$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isBrokerUnhealthy() {
        Map currentThreadLocalCounterSnapshotForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        LongRef currNumCompletedStorageOps = LongRef.create((long)0L);
        currentThreadLocalCounterSnapshotForAllThreads.forEach((thread, threadLocalCountersList) -> threadLocalCountersList.forEach(threadLocalCounters -> {
            boolean isThreadStuck = this.isStuck((Thread)thread, (ThreadLocalCounters)threadLocalCounters);
            ThreadLocalCounters.MetricComponentType metricComponentType = threadLocalCounters.metricComponentType;
            ThreadLocalCounters.MetricComponentType metricComponentType2 = ThreadLocalCounters.MetricComponentType.STORAGE;
            if (!(metricComponentType != null ? !metricComponentType.equals(metricComponentType2) : metricComponentType2 != null)) {
                currNumCompletedStorageOps$1.elem += threadLocalCounters.numSuccessOps + threadLocalCounters.numFailedOps;
            }
            scala.collection.mutable.Map threadToNumStuckSamplesMap = (scala.collection.mutable.Map)((scala.collection.mutable.Map)this.threadStuckSamplesByComponentTypeByThreadGroupType().getOrElseUpdate((Object)threadLocalCounters.threadGroupType, (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$))).getOrElseUpdate((Object)threadLocalCounters.metricComponentType, (Function0 & Serializable)() -> (WeakHashMap)WeakHashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
            long stuckCount = BoxesRunTime.unboxToLong((Object)threadToNumStuckSamplesMap.getOrElseUpdate(thread, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            if (isThreadStuck) {
                threadToNumStuckSamplesMap.update(thread, (Object)BoxesRunTime.boxToLong((long)(stuckCount + 1L)));
                return;
            }
            threadToNumStuckSamplesMap.update(thread, (Object)BoxesRunTime.boxToLong((long)0L));
        }));
        this.prevThreadLocalCountersSnapshot_$eq(currentThreadLocalCounterSnapshotForAllThreads);
        boolean engineThreadsStuck = this.isThreadGroupStuck$1(this.config().engineThreadStatusCriteria(), ThreadLocalCounters.MetricComponentType.ENGINE, HealthStatusAggregationOperator_Or$.MODULE$);
        boolean storageThreadsStuck = this.isThreadGroupStuck$1(this.config().storageThreadStatusCriteria(), ThreadLocalCounters.MetricComponentType.STORAGE, HealthStatusAggregationOperator_Or$.MODULE$);
        boolean noStorageThreadMakingProgress = this.prevNumCompletedStorageOps() == currNumCompletedStorageOps.elem;
        this.prevNumCompletedStorageOps_$eq(currNumCompletedStorageOps.elem);
        if (engineThreadsStuck) {
            this.contiguousSamplesEngineThreadGroupsStuck_$eq(this.contiguousSamplesEngineThreadGroupsStuck() + 1);
        } else {
            this.contiguousSamplesEngineThreadGroupsStuck_$eq(0);
        }
        if (storageThreadsStuck) {
            this.contiguousSamplesStorageThreadGroupsStuck_$eq(this.contiguousSamplesStorageThreadGroupsStuck() + 1);
        } else {
            this.contiguousSamplesStorageThreadGroupsStuck_$eq(0);
        }
        if (noStorageThreadMakingProgress) {
            this.contiguousSamplesNoStorageThreadMakingProgress_$eq(this.contiguousSamplesNoStorageThreadMakingProgress() + 1);
        } else {
            this.contiguousSamplesNoStorageThreadMakingProgress_$eq(0);
        }
        return engineThreadsStuck && storageThreadsStuck && noStorageThreadMakingProgress;
    }

    public void doWork() {
        this.pause(this.config().brokerHealthManagerSampleDurationMs(), TimeUnit.MILLISECONDS);
        this.totalSamples_$eq(this.totalSamples() + 1L);
        int isSampleUnhealthy = 0;
        if (this.isBrokerUnhealthy()) {
            isSampleUnhealthy = 1;
            this.contiguousUnhealthySamples_$eq(this.contiguousUnhealthySamples() + 1);
            this.contiguousHealthySamples_$eq(0);
        } else {
            this.contiguousUnhealthySamples_$eq(0);
            this.contiguousHealthySamples_$eq(this.contiguousHealthySamples() + 1);
        }
        BrokerHealthStatus brokerHealthStatus = this.brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        if (brokerHealthStatus != null && brokerHealthStatus.equals(healthy$)) {
            this.unhealthyStorageSampleWindow().addSample(isSampleUnhealthy);
            int numOfSamplesBeforeSuspect = this.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect();
            this.unhealthyStorageSampleWindow().maybeShrinkSampleWindow(numOfSamplesBeforeSuspect);
            if (this.unhealthyStorageSampleWindow().size() == numOfSamplesBeforeSuspect && this.unhealthyStorageSampleWindow().countedSamples() * 100 / this.unhealthyStorageSampleWindow().size() >= this.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition()) {
                this.statusTransition(Healthy$.MODULE$, Suspect$.MODULE$, (Iterable<Object>)this.unhealthyStorageSampleWindow().samples());
            }
        } else {
            BrokerHealthStatus brokerHealthStatus2 = this.brokerHealthStatus();
            Suspect$ suspect$ = Suspect$.MODULE$;
            if (brokerHealthStatus2 != null && brokerHealthStatus2.equals(suspect$)) {
                int numOfSampleBeforeUnhealthy = this.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy();
                this.unhealthyStorageSampleWindow().addSample(isSampleUnhealthy);
                this.unhealthyStorageSampleWindow().maybeShrinkSampleWindow(numOfSampleBeforeUnhealthy);
                int minUnhealthySamples = numOfSampleBeforeUnhealthy * this.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() / 100;
                int minHealthySamples = numOfSampleBeforeUnhealthy - minUnhealthySamples;
                if (this.unhealthyStorageSampleWindow().size() - this.unhealthyStorageSampleWindow().countedSamples() > minHealthySamples) {
                    this.statusTransition(Suspect$.MODULE$, Healthy$.MODULE$, (Iterable<Object>)this.unhealthyStorageSampleWindow().samples());
                } else if (this.unhealthyStorageSampleWindow().countedSamples() >= minUnhealthySamples) {
                    this.statusTransition(Suspect$.MODULE$, Unhealthy$.MODULE$, (Iterable<Object>)this.unhealthyStorageSampleWindow().samples());
                }
            }
        }
        BrokerHealthStatus brokerHealthStatus3 = this.brokerHealthStatus();
        Unhealthy$ unhealthy$ = Unhealthy$.MODULE$;
        if (brokerHealthStatus3 == null) {
            return;
        }
        if (brokerHealthStatus3.equals(unhealthy$)) {
            if (this.isMitigationEnabled()) {
                this.hardShutdownScheduler().startup();
                this.hardShutdownScheduler().scheduleOnce("Hard-Kill-Broker", () -> {
                    throw Exit$.MODULE$.halt(1, (Option<String>)None$.MODULE$);
                }, (long)this.config().brokerHealthManagerHardKillDurationMs());
                this.logStuckThreads();
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(205).append("[BrokerHealth] Broker has remained unhealthy for ").append(this.config().brokerHealthManagerSampleDurationMs() * this.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy()).append(" ms. ").append("(1) Calling controlled shutdown to move leadership away if not controller. (2) Killing the ZK Connection. (3) Then will exit. Is the node controller - ").append($this.isActiveController.apply$mcZ$sp()).toString());
                if (!this.isActiveController.apply$mcZ$sp()) {
                    this.controlledShutdownHook.apply((Object)ControlledShutdownRequestReason.UNHEALTHY, (Object)Option$.MODULE$.empty());
                }
                if (this.zkClient != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.zkClient.close(), this, Level.ERROR);
                }
                this.hardShutdownScheduler().shutdown();
                throw Exit$.MODULE$.halt(1, (Option<String>)None$.MODULE$);
            }
            if (this.contiguousHealthySamples() > this.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect()) {
                Queue healthySamples = (Queue)Queue$.MODULE$.fill(this.contiguousHealthySamples(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
                this.statusTransition(Unhealthy$.MODULE$, Healthy$.MODULE$, (Iterable<Object>)healthySamples);
                return;
            }
            return;
        }
    }

    public void statusTransition(BrokerHealthStatus currentHealthStatus, BrokerHealthStatus newHealthStatus, Iterable<Object> samples) {
        this.brokerHealthStatus_$eq(newHealthStatus);
        this.logBrokerHealthStatusChange(currentHealthStatus, newHealthStatus, samples);
        this.unhealthyStorageSampleWindow().reset();
    }

    public void logBrokerHealthStatusChange(BrokerHealthStatus currentHealthStatus, BrokerHealthStatus newHealthStatus, Iterable<Object> samples) {
        if (!this.isMitigationEnabled()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(109).append("[BrokerHealth] Broker health status changed. Previous Health Status: ").append(currentHealthStatus).append(" New Health Status: ").append(newHealthStatus).append(" Unhealthy Samples: ").append(samples).toString());
            this.logStuckThreads();
            return;
        }
    }

    public void run() {
        ThreadCountersManager.threadCountersManagerEnabled = true;
        super.run();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return BrokerHealthManager$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (OptionConverters$.MODULE$.toScala(BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.fromString((String)newConfig.confluentConfig().brokerHealthManagerEngineRequestHandlerThreadsStuckCriteria())).isEmpty()) {
            throw new ConfigException("Engine Request Handler Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (OptionConverters$.MODULE$.toScala(BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.fromString((String)newConfig.confluentConfig().brokerHealthManagerStorageRequestHandlerThreadsStuckCriteria())).isEmpty()) {
            throw new ConfigException("Storage Request Handler Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (OptionConverters$.MODULE$.toScala(BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.fromString((String)newConfig.confluentConfig().brokerHealthManagerStorageBackgroundThreadsStuckCriteria())).isEmpty()) {
            throw new ConfigException("Storage Background Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (OptionConverters$.MODULE$.toScala(BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.fromString((String)newConfig.confluentConfig().brokerHealthManagerStorageNetworkThreadsStuckCriteria())).isEmpty()) {
            throw new ConfigException("Storage Network Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(BrokerHealthManagerConfig$.MODULE$.apply(newConfig));
        this.isMitigationEnabled_$eq(this.config().isBrokerHealthManagerMitigationEnabled());
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$1() {
        return this.contiguousUnhealthySamples();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$2() {
        return this.contiguousSamplesEngineThreadGroupsStuck();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$3() {
        return this.contiguousSamplesStorageThreadGroupsStuck();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$4() {
        return this.contiguousSamplesNoStorageThreadMakingProgress();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$5() {
        return this.unhealthyStorageSampleWindow().countedSamples();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$6() {
        return this.brokerHealthStatus().id();
    }

    private final boolean isPrevCountersPresent$1() {
        return this.prevThreadLocalCountersSnapshot() != null;
    }

    private final boolean isThreadStuck$1(Thread thread$1, ThreadLocalCounters currCounters$1) {
        ObjectRef prevCounters = ObjectRef.create(null);
        ((java.lang.Iterable)this.prevThreadLocalCountersSnapshot().getOrDefault(thread$1, new ArrayList())).forEach(threadLocalCounters -> {
            block7: {
                block6: {
                    ThreadLocalCounters.MetricComponentType metricComponentType;
                    ThreadLocalCounters.MetricComponentType metricComponentType2;
                    block5: {
                        metricComponentType2 = threadLocalCounters.metricComponentType;
                        metricComponentType = currCounters$1.metricComponentType;
                        if (metricComponentType2 != null) break block5;
                        if (metricComponentType != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!metricComponentType2.equals(metricComponentType)) break block7;
                }
                prevCounters$1.elem = threadLocalCounters;
                return;
            }
        });
        if ((ThreadLocalCounters)prevCounters.elem != null) {
            return currCounters$1.numSuccessOps + currCounters$1.numFailedOps == ((ThreadLocalCounters)prevCounters.elem).numSuccessOps + ((ThreadLocalCounters)prevCounters.elem).numFailedOps && currCounters$1.numInProgressOps == ((ThreadLocalCounters)prevCounters.elem).numInProgressOps && currCounters$1.numInProgressOps >= 1L;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$3(BrokerHealthManager $this, ThreadLocalCounters.ThreadGroupType threadGroupType$1, ThreadLocalCounters.MetricComponentType metricComponentType$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            Thread thread = (Thread)x0$3._1();
            long numStuckSamples = x0$3._2$mcJ$sp();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(121).append("[BrokerHealthManager] Broker has stuck threads. Thread Group type stuck = ").append(threadGroupType$1).append(" Component type = ").append(metricComponentType$1).append(" Thread = ").append(thread.getName()).append(" num stuck samples ").append(numStuckSamples).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$2(BrokerHealthManager $this, ThreadLocalCounters.ThreadGroupType threadGroupType$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            ThreadLocalCounters.MetricComponentType metricComponentType = (ThreadLocalCounters.MetricComponentType)x0$2._1();
            ((scala.collection.mutable.Map)x0$2._2()).foreach((Function1 & Serializable)x0$3 -> {
                BrokerHealthManager.$anonfun$logStuckThreads$3($this, threadGroupType$1, metricComponentType, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$1(BrokerHealthManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ThreadLocalCounters.ThreadGroupType threadGroupType = (ThreadLocalCounters.ThreadGroupType)x0$1._1();
            ((scala.collection.mutable.Map)x0$1._2()).foreach((Function1 & Serializable)x0$2 -> {
                BrokerHealthManager.$anonfun$logStuckThreads$2($this, threadGroupType, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$8(BrokerHealthCriteria.ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, boolean x0$1, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$1), (Object)x1$1);
        if (x1$1 != null) {
            long numStuckSamples = x1$1._2$mcJ$sp();
            if (BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.AnyThreadStuck.equals(countersHealthStatusCriteria$1)) {
                return x0$1 || numStuckSamples > 0L;
            }
            if (BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.AllThreadsStuck.equals(countersHealthStatusCriteria$1)) {
                return x0$1 && numStuckSamples > 0L;
            }
            return x0$1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$7(boolean initialValue$1, BrokerHealthCriteria.ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, scala.collection.mutable.Map threadToNumStuckSamples) {
        return BoxesRunTime.unboxToBoolean((Object)threadToNumStuckSamples.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)initialValue$1), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$8(countersHealthStatusCriteria$1, BoxesRunTime.unboxToBoolean((Object)x0$1), x1$1))));
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$6(ThreadLocalCounters.MetricComponentType componentType$1, boolean initialValue$1, BrokerHealthCriteria.ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, scala.collection.mutable.Map threadGroup) {
        return threadGroup.get((Object)componentType$1).exists((Function1 & Serializable)threadToNumStuckSamples -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$7(initialValue$1, countersHealthStatusCriteria$1, threadToNumStuckSamples)));
    }

    private final boolean isThreadGroupStuckAccordingToCriteria$1(boolean initialValue, ThreadLocalCounters.ThreadGroupType threadGroupType, ThreadLocalCounters.MetricComponentType componentType, BrokerHealthCriteria.ThreadCountersHealthStatusCriteria countersHealthStatusCriteria) {
        return this.threadStuckSamplesByComponentTypeByThreadGroupType().get((Object)threadGroupType).exists((Function1 & Serializable)threadGroup -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$6(componentType, initialValue, countersHealthStatusCriteria, threadGroup)));
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$9(BrokerHealthManager $this, HealthStatusAggregationOperator healthStatusAggregationOperator$1, ThreadLocalCounters.MetricComponentType componentType$2, boolean x0$1, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$1), (Object)x1$1);
        if (x1$1 != null) {
            BrokerHealthCriteria.ThreadCountersHealthStatusCriteria criteria;
            ThreadLocalCounters.ThreadGroupType groupType = (ThreadLocalCounters.ThreadGroupType)x1$1._1();
            BrokerHealthCriteria.ThreadCountersHealthStatusCriteria threadCountersHealthStatusCriteria = criteria = (BrokerHealthCriteria.ThreadCountersHealthStatusCriteria)x1$1._2();
            BrokerHealthCriteria.ThreadCountersHealthStatusCriteria threadCountersHealthStatusCriteria2 = BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.AllThreadsStuck;
            boolean initialValue = !(threadCountersHealthStatusCriteria != null ? !threadCountersHealthStatusCriteria.equals(threadCountersHealthStatusCriteria2) : threadCountersHealthStatusCriteria2 != null);
            HealthStatusAggregationOperator healthStatusAggregationOperator = healthStatusAggregationOperator$1;
            HealthStatusAggregationOperator_And$ healthStatusAggregationOperator_And$ = HealthStatusAggregationOperator_And$.MODULE$;
            if (healthStatusAggregationOperator != null && healthStatusAggregationOperator.equals(healthStatusAggregationOperator_And$)) {
                return x0$1 && $this.isThreadGroupStuckAccordingToCriteria$1(initialValue, groupType, componentType$2, criteria);
            }
            HealthStatusAggregationOperator healthStatusAggregationOperator2 = healthStatusAggregationOperator$1;
            HealthStatusAggregationOperator_Or$ healthStatusAggregationOperator_Or$ = HealthStatusAggregationOperator_Or$.MODULE$;
            if (healthStatusAggregationOperator2 != null && healthStatusAggregationOperator2.equals(healthStatusAggregationOperator_Or$)) {
                return x0$1 || $this.isThreadGroupStuckAccordingToCriteria$1(initialValue, groupType, componentType$2, criteria);
            }
            return false;
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean isThreadGroupStuck$1(scala.collection.immutable.Map threadStatusCriteria, ThreadLocalCounters.MetricComponentType componentType, HealthStatusAggregationOperator healthStatusAggregationOperator) {
        boolean threadGroupStuckInitialValue;
        HealthStatusAggregationOperator healthStatusAggregationOperator2 = healthStatusAggregationOperator;
        HealthStatusAggregationOperator_And$ healthStatusAggregationOperator_And$ = HealthStatusAggregationOperator_And$.MODULE$;
        boolean bl = threadGroupStuckInitialValue = healthStatusAggregationOperator2 != null && healthStatusAggregationOperator2.equals(healthStatusAggregationOperator_And$);
        return threadStatusCriteria.nonEmpty() && BoxesRunTime.unboxToBoolean((Object)threadStatusCriteria.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)threadGroupStuckInitialValue), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$9(this, healthStatusAggregationOperator, componentType, BoxesRunTime.unboxToBoolean((Object)x0$1), x1$1))));
    }

    public BrokerHealthManager(Function2<ControlledShutdownRequestReason, Option<Object>, BoxedUnit> controlledShutdownHook, KafkaZkClient zkClient, Function0<Object> isActiveController, BrokerHealthManagerConfig initialConfig) {
        this.controlledShutdownHook = controlledShutdownHook;
        this.zkClient = zkClient;
        this.isActiveController = isActiveController;
        super("BrokerHealthManager", true);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.totalSamples = 0L;
        this.brokerHealthStatus = Healthy$.MODULE$;
        this.isMitigationEnabled = initialConfig.isBrokerHealthManagerMitigationEnabled();
        this.config = initialConfig;
        this.prevThreadLocalCountersSnapshot = null;
        this.prevNumCompletedStorageOps = 0L;
        this.contiguousUnhealthySamples = 0;
        this.contiguousHealthySamples = 0;
        this.threadStuckSamplesByComponentTypeByThreadGroupType = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.unhealthyStorageSampleWindow = new HealthSamplesWindow();
        this.contiguousSamplesEngineThreadGroupsStuck = 0;
        this.contiguousSamplesStorageThreadGroupsStuck = 0;
        this.contiguousSamplesNoStorageThreadMakingProgress = 0;
        this.metricsGroup().newGauge("ContiguousUnhealthySamples", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("ContiguousSamplesEngineThreadGroupsStuck", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("ContiguousSamplesStorageThreadGroupsStuck", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("ContiguousSamplesNoStorageThreadMakingProgress", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("UnhealthinessCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("StorageHealthStatus", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$6();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.hardShutdownScheduler = new KafkaScheduler(1);
    }
}

