/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0015u!B0a\u0011\u0003)g!B4a\u0011\u0003A\u0007\"B<\u0002\t\u0003Ah!B=\u0002\u0001\nT\bBCA\u001f\u0007\tU\r\u0011\"\u0001\u0002@!Q\u0011QJ\u0002\u0003\u0012\u0003\u0006I!!\u0011\t\u0015\u0005=3A!f\u0001\n\u0003\t\t\u0006\u0003\u0006\u0002Z\r\u0011\t\u0012)A\u0005\u0003'B!\"a\u0017\u0004\u0005+\u0007I\u0011AA/\u0011)\t\th\u0001B\tB\u0003%\u0011q\f\u0005\u000b\u0003g\u001a!Q3A\u0005\u0002\u0005U\u0004BCA<\u0007\tE\t\u0015!\u0003\u0002l!Q\u0011\u0011P\u0002\u0003\u0016\u0004%\t!a\u001f\t\u0015\u0005M5A!E!\u0002\u0013\ti\b\u0003\u0006\u0002\u0016\u000e\u0011)\u001a!C!\u0003/C!\"a,\u0004\u0005#\u0005\u000b\u0011BAM\u0011)\t\tl\u0001BK\u0002\u0013\u0005\u00131\u0017\u0005\u000b\u0003\u0003\u001c!\u0011#Q\u0001\n\u0005U\u0006BCAb\u0007\tU\r\u0011\"\u0011\u0002F\"Q\u0011\u0011[\u0002\u0003\u0012\u0003\u0006I!a2\t\u0015\u0005M7A!f\u0001\n\u0003\n)\u000e\u0003\u0006\u0002h\u000e\u0011\t\u0012)A\u0005\u0003/Daa^\u0002\u0005\u0002\u0005]\b\"\u0003B\f\u0007\u0005\u0005I\u0011\u0001B\r\u0011%\u0011icAI\u0001\n\u0003\u0011y\u0003C\u0005\u0003F\r\t\n\u0011\"\u0001\u0003H!I!1J\u0002\u0012\u0002\u0013\u0005!Q\n\u0005\n\u0005#\u001a\u0011\u0013!C\u0001\u0005'B\u0011Ba\u0016\u0004#\u0003%\tA!\u0017\t\u0013\tu3!%A\u0005\u0002\t}\u0003\"\u0003B2\u0007E\u0005I\u0011\u0001B3\u0011%\u0011IgAI\u0001\n\u0003\u0011Y\u0007C\u0005\u0003p\r\t\n\u0011\"\u0001\u0003r!I!\u0011Q\u0002\u0002\u0002\u0013\u0005#1\u0011\u0005\n\u0005\u000b\u001b\u0011\u0011!C\u0001\u0003#B\u0011Ba\"\u0004\u0003\u0003%\tA!#\t\u0013\t=5!!A\u0005B\tE\u0005\"\u0003BP\u0007\u0005\u0005I\u0011\u0001BQ\u0011%\u0011YkAA\u0001\n\u0003\u0012i\u000bC\u0005\u00032\u000e\t\t\u0011\"\u0011\u00034\"I!QW\u0002\u0002\u0002\u0013\u0005#q\u0017\u0005\n\u0005s\u001b\u0011\u0011!C!\u0005w;!Ba0\u0002\u0003\u0003E\tA\u0019Ba\r%I\u0018!!A\t\u0002\t\u0014\u0019\r\u0003\u0004xW\u0011\u0005!\u0011\u001c\u0005\n\u0005k[\u0013\u0011!C#\u0005oC\u0011Ba7,\u0003\u0003%\tI!8\t\u0013\te8&!A\u0005\u0002\nm\b\"CB\u000bW\u0005\u0005I\u0011BB\f\u0011\u001d\u0011Y.\u0001C\u0001\u00073AqAa7\u0002\t\u0003!i\u0003C\u0004\u0003\\\u0006!\t\u0001b\u000e\t\u000f\tm\u0017\u0001\"\u0001\u0005B!9A\u0011J\u0001\u0005\n\u0011-\u0003b\u0002C0\u0003\u0011\u0005A\u0011\r\u0005\n\u00057\f\u0011\u0011!CA\t[B\u0011B!?\u0002\u0003\u0003%\t\t\"\u001f\t\u0013\rU\u0011!!A\u0005\n\r]a!B4a\u0001\u000eu\u0001BCB\u0010u\tU\r\u0011\"\u0001\u0002R!Q1\u0011\u0005\u001e\u0003\u0012\u0003\u0006I!a\u0015\t\u0015\r\r\"H!f\u0001\n\u0003\u0019)\u0003\u0003\u0006\u00044i\u0012\t\u0012)A\u0005\u0007OA!b!\u000e;\u0005+\u0007I\u0011AB\u001c\u0011)\u0019YD\u000fB\tB\u0003%1\u0011\b\u0005\u000b\u0007{Q$Q3A\u0005\u0002\r}\u0002BCB*u\tE\t\u0015!\u0003\u0004B!Q1Q\u000b\u001e\u0003\u0016\u0004%\taa\u0016\t\u0015\ru#H!E!\u0002\u0013\u0019I\u0006\u0003\u0004xu\u0011\u00051q\f\u0005\n\u0007WR$\u0019!C\u0005\u0007[B\u0001b!\";A\u0003%1q\u000e\u0005\b\u0005kSD\u0011IBD\u0011\u00199(\b\"\u0001\u0004\n\"1qO\u000fC\u0001\u0007[Cqa!0;\t\u0003\u0019y\fC\u0004\u0004Jj\"\taa3\t\u000f\rE'\b\"\u0001\u0004T\"91q\u001b\u001e\u0005\u0002\re\u0007bBBou\u0011\u00051q\u001c\u0005\n\u0007sT\u0014\u0013!C\u0001\u0005KB\u0011Ba\u0006;\u0003\u0003%\taa?\t\u0013\t5\"(%A\u0005\u0002\t\u001d\u0003\"\u0003B#uE\u0005I\u0011\u0001C\u0004\u0011%\u0011YEOI\u0001\n\u0003!Y\u0001C\u0005\u0003Ri\n\n\u0011\"\u0001\u0005\u0010!I!q\u000b\u001e\u0012\u0002\u0013\u0005A1\u0003\u0005\n\u0005\u0003S\u0014\u0011!C!\u0005\u0007C\u0011B!\";\u0003\u0003%\t!!\u0015\t\u0013\t\u001d%(!A\u0005\u0002\u0011]\u0001\"\u0003BHu\u0005\u0005I\u0011\tBI\u0011%\u0011yJOA\u0001\n\u0003!Y\u0002C\u0005\u0003,j\n\t\u0011\"\u0011\u0005 !I!\u0011\u0017\u001e\u0002\u0002\u0013\u0005#1\u0017\u0005\n\u0005sS\u0014\u0011!C!\tG\taA\u0011:pW\u0016\u0014(BA1c\u0003\u001d\u0019G.^:uKJT\u0011aY\u0001\u0006W\u000647.Y\u0002\u0001!\t1\u0017!D\u0001a\u0005\u0019\u0011%o\\6feN\u0019\u0011![8\u0011\u0005)lW\"A6\u000b\u00031\fQa]2bY\u0006L!A\\6\u0003\r\u0005s\u0017PU3g!\t\u0001X/D\u0001r\u0015\t\u00118/\u0001\u0002j_*\tA/\u0001\u0003kCZ\f\u0017B\u0001<r\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tQM\u0001\u0006TKJ4XM]%oM>\u001c\u0002bA>\u0002\u0004\u0005\u0005\u0012q\u0005\t\u0003y~l\u0011! \u0006\u0003}N\fA\u0001\\1oO&\u0019\u0011\u0011A?\u0003\r=\u0013'.Z2u!\u0011\t)!!\b\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t\u0011\"\u001b8uKJt\u0017\r\\:\u000b\t\u00055\u0011qB\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(\u0002BA\t\u0003'\taa]3sm\u0016\u0014(bA2\u0002\u0016)!\u0011qCA\r\u0003\u0019\t\u0007/Y2iK*\u0011\u00111D\u0001\u0004_J<\u0017\u0002BA\u0010\u0003\u000f\u0011QdQ8oM2,XM\u001c;BkRDwN]5{KJ\u001cVM\u001d<fe&sgm\u001c\t\u0004U\u0006\r\u0012bAA\u0013W\n9\u0001K]8ek\u000e$\b\u0003BA\u0015\u0003sqA!a\u000b\u000269!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022\u0011\fa\u0001\u0010:p_Rt\u0014\"\u00017\n\u0007\u0005]2.A\u0004qC\u000e\\\u0017mZ3\n\u0007Y\fYDC\u0002\u00028-\fqb\u00197vgR,'OU3t_V\u00148-Z\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\n\u0019\"\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u0017\n)EA\bDYV\u001cH/\u001a:SKN|WO]2f\u0003A\u0019G.^:uKJ\u0014Vm]8ve\u000e,\u0007%\u0001\u0005ce>\\WM]%e+\t\t\u0019\u0006E\u0002k\u0003+J1!a\u0016l\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\n\u0011\"\u001a8ea>Lg\u000e^:\u0016\u0005\u0005}\u0003CBA1\u0003O\nY'\u0004\u0002\u0002d)\u0019\u0011QM:\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003S\n\u0019G\u0001\u0003MSN$\b\u0003BA\"\u0003[JA!a\u001c\u0002F\tAQI\u001c3q_&tG/\u0001\u0006f]\u0012\u0004x.\u001b8ug\u0002\n1#\u001b8uKJ\u0014%o\\6fe\u0016sG\r]8j]R,\"!a\u001b\u0002)%tG/\u001a:Ce>\\WM]#oIB|\u0017N\u001c;!\u0003M)\u0017M\u001d7z'R\f'\u000f\u001e'jgR,g.\u001a:t+\t\ti\b\u0005\u0004\u0002b\u0005}\u00141Q\u0005\u0005\u0003\u0003\u000b\u0019GA\u0002TKR\u0004B!!\"\u0002\u000e:!\u0011qQAE!\r\tic[\u0005\u0004\u0003\u0017[\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0010\u0006E%AB*ue&twMC\u0002\u0002\f.\fA#Z1sYf\u001cF/\u0019:u\u0019&\u001cH/\u001a8feN\u0004\u0013\u0001\u00055uiB\u001cVM\u001d<fe\nKg\u000eZ3s+\t\tI\n\u0005\u0003\u0002\u001c\u0006-VBAAO\u0015\u0011\t\t\"a(\u000b\t\u0005\u0005\u00161U\u0001\u0005QR$\bOC\u0002d\u0003KSA!a*\u0002*\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u0002e&!\u0011QVAO\u0005UY\u0015MZ6b\u0011R$\boU3sm\u0016\u0014()\u001b8eKJ\f\u0011\u0003\u001b;uaN+'O^3s\u0005&tG-\u001a:!\u0003A\tW\u000fZ5u\u0019><\u0007K]8wS\u0012,'/\u0006\u0002\u00026B!\u0011qWA_\u001b\t\tIL\u0003\u0003\u0002<\u0006=\u0011!B1vI&$\u0018\u0002BA`\u0003s\u0013\u0001#Q;eSRdun\u001a)s_ZLG-\u001a:\u0002#\u0005,H-\u001b;M_\u001e\u0004&o\u001c<jI\u0016\u0014\b%A\u0004nKR\u0014\u0018nY:\u0016\u0005\u0005\u001d\u0007\u0003BAe\u0003\u001bl!!a3\u000b\t\u0005\r\u0017QI\u0005\u0005\u0003\u001f\fYMA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nq#\u001b8uKJ\u0014%o\\6fe\u000ec\u0017.\u001a8u\u0007>tg-[4\u0016\u0005\u0005]\u0007\u0007BAm\u0003G\u0004\u0002\"!\u0019\u0002\\\u0006\r\u0015q\\\u0005\u0005\u0003;\f\u0019GA\u0002NCB\u0004B!!9\u0002d2\u0001AaCAs+\u0005\u0005\t\u0011!B\u0001\u0003S\u00141a\u0018\u00132\u0003aIg\u000e^3s\u0005J|7.\u001a:DY&,g\u000e^\"p]\u001aLw\rI\t\u0005\u0003W\f\t\u0010E\u0002k\u0003[L1!a<l\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A[Az\u0013\r\t)p\u001b\u0002\u0004\u0003:LH\u0003FA}\u0003{\fyP!\u0001\u0003\u0004\t\u0015!q\u0001B\u0005\u0005\u0017\u0011i\u0001E\u0002\u0002|\u000ei\u0011!\u0001\u0005\b\u0003{1\u0002\u0019AA!\u0011\u001d\tyE\u0006a\u0001\u0003'Bq!a\u0017\u0017\u0001\u0004\ty\u0006C\u0004\u0002tY\u0001\r!a\u001b\t\u000f\u0005ed\u00031\u0001\u0002~!9\u0011Q\u0013\fA\u0002\u0005e\u0005bBAY-\u0001\u0007\u0011Q\u0017\u0005\b\u0003\u00074\u0002\u0019AAd\u0011\u001d\t\u0019N\u0006a\u0001\u0005\u001f\u0001DA!\u0005\u0003\u0016AA\u0011\u0011MAn\u0003\u0007\u0013\u0019\u0002\u0005\u0003\u0002b\nUA\u0001DAs\u0005\u001b\t\t\u0011!A\u0003\u0002\u0005%\u0018\u0001B2paf$B#!?\u0003\u001c\tu!q\u0004B\u0011\u0005G\u0011)Ca\n\u0003*\t-\u0002\"CA\u001f/A\u0005\t\u0019AA!\u0011%\tye\u0006I\u0001\u0002\u0004\t\u0019\u0006C\u0005\u0002\\]\u0001\n\u00111\u0001\u0002`!I\u00111O\f\u0011\u0002\u0003\u0007\u00111\u000e\u0005\n\u0003s:\u0002\u0013!a\u0001\u0003{B\u0011\"!&\u0018!\u0003\u0005\r!!'\t\u0013\u0005Ev\u0003%AA\u0002\u0005U\u0006\"CAb/A\u0005\t\u0019AAd\u0011%\t\u0019n\u0006I\u0001\u0002\u0004\u0011y!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tE\"\u0006BA!\u0005gY#A!\u000e\u0011\t\t]\"\u0011I\u0007\u0003\u0005sQAAa\u000f\u0003>\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u007fY\u0017AC1o]>$\u0018\r^5p]&!!1\tB\u001d\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IE\u000b\u0003\u0002T\tM\u0012AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005\u001fRC!a\u0018\u00034\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B+U\u0011\tYGa\r\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\f\u0016\u0005\u0003{\u0012\u0019$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t\u0005$\u0006BAM\u0005g\tabY8qs\u0012\"WMZ1vYR$s'\u0006\u0002\u0003h)\"\u0011Q\u0017B\u001a\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa*\"A!\u001c+\t\u0005\u001d'1G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0011\u0019\b\r\u0003\u0003v\t}$\u0006\u0002B<\u0005g\u0001\u0002\"!\u0019\u0002\\\ne$Q\u0010\t\u0004y\nm\u0014bAAH{B!\u0011\u0011\u001dB@\t-\t)\u000fIA\u0001\u0002\u0003\u0015\t!!;\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I(\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005E(1\u0012\u0005\n\u0005\u001b\u001b\u0013\u0011!a\u0001\u0003'\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BJ!\u0019\u0011)Ja'\u0002r6\u0011!q\u0013\u0006\u0004\u00053[\u0017AC2pY2,7\r^5p]&!!Q\u0014BL\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\r&\u0011\u0016\t\u0004U\n\u0015\u0016b\u0001BTW\n9!i\\8mK\u0006t\u0007\"\u0003BGK\u0005\u0005\t\u0019AAy\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\te$q\u0016\u0005\n\u0005\u001b3\u0013\u0011!a\u0001\u0003'\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003'\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005s\na!Z9vC2\u001cH\u0003\u0002BR\u0005{C\u0011B!$*\u0003\u0003\u0005\r!!=\u0002\u0015M+'O^3s\u0013:4w\u000eE\u0002\u0002|.\u001aBa\u000bBc_BA\"q\u0019Bg\u0003\u0003\n\u0019&a\u0018\u0002l\u0005u\u0014\u0011TA[\u0003\u000f\u0014\t.!?\u000e\u0005\t%'b\u0001BfW\u00069!/\u001e8uS6,\u0017\u0002\u0002Bh\u0005\u0013\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c8:a\u0011\u0011\u0019Na6\u0011\u0011\u0005\u0005\u00141\\AB\u0005+\u0004B!!9\u0003X\u0012Y\u0011Q]\u0016\u0002\u0002\u0003\u0005)\u0011AAu)\t\u0011\t-A\u0003baBd\u0017\u0010\u0006\u000b\u0002z\n}'\u0011\u001dBr\u0005K\u00149O!;\u0003l\n5(q\u001e\u0005\b\u0003{q\u0003\u0019AA!\u0011\u001d\tyE\fa\u0001\u0003'Bq!a\u0017/\u0001\u0004\ty\u0006C\u0004\u0002t9\u0002\r!a\u001b\t\u000f\u0005ed\u00061\u0001\u0002~!9\u0011Q\u0013\u0018A\u0002\u0005e\u0005bBAY]\u0001\u0007\u0011Q\u0017\u0005\b\u0003\u0007t\u0003\u0019AAd\u0011\u001d\t\u0019N\fa\u0001\u0005c\u0004DAa=\u0003xBA\u0011\u0011MAn\u0003\u0007\u0013)\u0010\u0005\u0003\u0002b\n]H\u0001DAs\u0005_\f\t\u0011!A\u0003\u0002\u0005%\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0005{\u001c\t\u0002E\u0003k\u0005\u007f\u001c\u0019!C\u0002\u0004\u0002-\u0014aa\u00149uS>t\u0007#\u00066\u0004\u0006\u0005\u0005\u00131KA0\u0003W\ni(!'\u00026\u0006\u001d7\u0011B\u0005\u0004\u0007\u000fY'A\u0002+va2,\u0017\b\r\u0003\u0004\f\r=\u0001\u0003CA1\u00037\f\u0019i!\u0004\u0011\t\u0005\u00058q\u0002\u0003\f\u0003K|\u0013\u0011!A\u0001\u0006\u0003\tI\u000fC\u0005\u0004\u0014=\n\t\u00111\u0001\u0002z\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0003m$\u0002ba\u0007\u0005(\u0011%B1\u0006\t\u0003Mj\u001abAO5\u0002\"\u0005\u001d\u0012AA5e\u0003\rIG\rI\u0001\nK:$\u0007k\\5oiN,\"aa\n\u0011\r\tU5\u0011FB\u0017\u0013\u0011\u0019YCa&\u0003\u0007M+\u0017\u000fE\u0002g\u0007_I1a!\ra\u0005!)e\u000e\u001a)pS:$\u0018AC3oIB{\u0017N\u001c;tA\u0005!!/Y2l+\t\u0019I\u0004E\u0003k\u0005\u007f\f\u0019)A\u0003sC\u000e\\\u0007%\u0001\u0005gK\u0006$XO]3t+\t\u0019\t\u0005\u0005\u0004\u0004D\r%3QJ\u0007\u0003\u0007\u000bRAaa\u0012\u0002F\u00059a-Z1ukJ,\u0017\u0002BB&\u0007\u000b\u0012\u0001BR3biV\u0014Xm\u001d\t\u0005\u0007\u0007\u001ay%\u0003\u0003\u0004R\r\u0015#!F*vaB|'\u000f^3e-\u0016\u00148/[8o%\u0006tw-Z\u0001\nM\u0016\fG/\u001e:fg\u0002\nA\u0001^1hgV\u00111\u0011\f\t\t\u0003\u000b\u001bY&a!\u0002\u0004&!\u0011Q\\AI\u0003\u0015!\u0018mZ:!)1\u0019Yb!\u0019\u0004d\r\u00154qMB5\u0011\u001d\u0019y\"\u0012a\u0001\u0003'Bqaa\tF\u0001\u0004\u00199\u0003C\u0004\u00046\u0015\u0003\ra!\u000f\t\u000f\ruR\t1\u0001\u0004B!91QK#A\u0002\re\u0013\u0001D3oIB{\u0017N\u001c;t\u001b\u0006\u0004XCAB8!!\u0019\tha\u001e\u0004z\r5RBAB:\u0015\u0011\u0019)Ha&\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BAo\u0007g\u0002Baa\u001f\u0004\u00026\u00111Q\u0010\u0006\u0005\u0007\u007f\n)%A\u0004oKR<xN]6\n\t\r\r5Q\u0010\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u000eK:$\u0007k\\5oiNl\u0015\r\u001d\u0011\u0015\u0005\u0005\rE\u0003DB\u000e\u0007\u0017\u001bii!%\u0004\u0016\u000ee\u0005bBB\u0010\u0013\u0002\u0007\u00111\u000b\u0005\b\u0007\u001fK\u0005\u0019AAB\u0003\u0011Awn\u001d;\t\u000f\rM\u0015\n1\u0001\u0002T\u0005!\u0001o\u001c:u\u0011\u001d\u00199*\u0013a\u0001\u0007s\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016Dqaa'J\u0001\u0004\u0019i*\u0001\u0005qe>$xnY8m!\u0011\u0019yj!+\u000e\u0005\r\u0005&\u0002BBR\u0007K\u000bA!Y;uQ*!1qUA#\u0003!\u0019XmY;sSRL\u0018\u0002BBV\u0007C\u0013\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0015\u0011\rm1qVB]\u0007wCqa!-K\u0001\u0004\u0019\u0019,A\u0002cKB\u00042AZB[\u0013\r\u00199\f\u0019\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0011\u001d\u00199J\u0013a\u0001\u0007sBqaa'K\u0001\u0004\u0019i*\u0001\u0003o_\u0012,G\u0003BBa\u0007\u000f\u0004B!a\u0011\u0004D&!1QYA#\u0005\u0011qu\u000eZ3\t\u000f\r]5\n1\u0001\u0004z\u00059q-\u001a;O_\u0012,G\u0003BBg\u0007\u001f\u0004RA\u001bB\u0000\u0007\u0003Dqaa&M\u0001\u0004\u0019I(\u0001\bce>\\WM]#oIB{\u0017N\u001c;\u0015\t\rM6Q\u001b\u0005\b\u0007/k\u0005\u0019AB=\u0003!)g\u000e\u001a)pS:$H\u0003BB\u0017\u00077Dqaa&O\u0001\u0004\u0019I(\u0001\u0007u_N+'O^3s\u0013:4w\u000e\u0006\u0007\u0002\u0004\r\u00058Q]Bz\u0007k\u001c9\u0010C\u0004\u0004d>\u0003\r!a!\u0002\u0013\rdWo\u001d;fe&#\u0007bBBt\u001f\u0002\u00071\u0011^\u0001\u0007G>tg-[4\u0011\t\r-8q^\u0007\u0003\u0007[T1!!\u0005c\u0013\u0011\u0019\tp!<\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0003+{\u0005\u0019AAM\u0011%\t\tl\u0014I\u0001\u0002\u0004\t)\fC\u0004\u0002D>\u0003\r!a2\u0002-Q|7+\u001a:wKJLeNZ8%I\u00164\u0017-\u001e7uIQ\"Bba\u0007\u0004~\u000e}H\u0011\u0001C\u0002\t\u000bA\u0011ba\bR!\u0003\u0005\r!a\u0015\t\u0013\r\r\u0012\u000b%AA\u0002\r\u001d\u0002\"CB\u001b#B\u0005\t\u0019AB\u001d\u0011%\u0019i$\u0015I\u0001\u0002\u0004\u0019\t\u0005C\u0005\u0004VE\u0003\n\u00111\u0001\u0004ZU\u0011A\u0011\u0002\u0016\u0005\u0007O\u0011\u0019$\u0006\u0002\u0005\u000e)\"1\u0011\bB\u001a+\t!\tB\u000b\u0003\u0004B\tMRC\u0001C\u000bU\u0011\u0019IFa\r\u0015\t\u0005EH\u0011\u0004\u0005\n\u0005\u001bK\u0016\u0011!a\u0001\u0003'\"BAa)\u0005\u001e!I!QR.\u0002\u0002\u0003\u0007\u0011\u0011\u001f\u000b\u0005\u0005s\"\t\u0003C\u0005\u0003\u000er\u000b\t\u00111\u0001\u0002TQ!!1\u0015C\u0013\u0011%\u0011iIXA\u0001\u0002\u0004\t\t\u0010C\u0004\u0004 E\u0002\r!a\u0015\t\u000f\r\r\u0012\u00071\u0001\u0004(!91QG\u0019A\u0002\reBCCB\u000e\t_!\t\u0004b\r\u00056!91q\u0004\u001aA\u0002\u0005M\u0003bBB\u0012e\u0001\u00071q\u0005\u0005\b\u0007k\u0011\u0004\u0019AB\u001d\u0011\u001d\u0019iD\ra\u0001\u0007\u0003\"\"ba\u0007\u0005:\u0011mBQ\bC \u0011\u001d\u0019yb\ra\u0001\u0003'Bqaa\t4\u0001\u0004\u00199\u0003C\u0004\u00046M\u0002\ra!\u000f\t\u000f\rU3\u00071\u0001\u0004ZQA11\u0004C\"\t\u000b\"9\u0005C\u0004\u0004 Q\u0002\r!a\u0015\t\u000f\r]G\u00071\u0001\u0004.!91Q\u0007\u001bA\u0002\re\u0012!E:vaB|'\u000f^3e\r\u0016\fG/\u001e:fgR!AQ\nC(!!\t\t'a7\u0002\u0004\u000e5\u0003bBB\u001fk\u0001\u0007A\u0011\u000b\t\t\u0003C\nY.a!\u0005TA!AQ\u000bC.\u001b\t!9F\u0003\u0003\u0005Z\u0005M\u0011\u0001C7fi\u0006$\u0017\r^1\n\t\u0011uCq\u000b\u0002\r-\u0016\u00148/[8o%\u0006tw-Z\u0001\u0017MJ|WN\u0011:pW\u0016\u0014(+Z4jgR\u0014\u0018\r^5p]R!11\u0004C2\u0011\u001d!)G\u000ea\u0001\tO\nAB]3hSN$(/\u0019;j_:\u0004B\u0001\"\u0016\u0005j%!A1\u000eC,\u0005I\u0011%o\\6feJ+w-[:ue\u0006$\u0018n\u001c8\u0015\u0019\rmAq\u000eC9\tg\")\bb\u001e\t\u000f\r}q\u00071\u0001\u0002T!911E\u001cA\u0002\r\u001d\u0002bBB\u001bo\u0001\u00071\u0011\b\u0005\b\u0007{9\u0004\u0019AB!\u0011\u001d\u0019)f\u000ea\u0001\u00073\"B\u0001b\u001f\u0005\u0004B)!Na@\u0005~Ai!\u000eb \u0002T\r\u001d2\u0011HB!\u00073J1\u0001\"!l\u0005\u0019!V\u000f\u001d7fk!I11\u0003\u001d\u0002\u0002\u0003\u000711\u0004")
public class Broker
implements Product,
Serializable {
    private final int id;
    private final Seq<EndPoint> endPoints;
    private final Option<String> rack;
    private final Features<SupportedVersionRange> features;
    private final scala.collection.immutable.Map<String, String> tags;
    private final scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap;

    public static Option<Tuple5<Object, Seq<EndPoint>, Option<String>, Features<SupportedVersionRange>, scala.collection.immutable.Map<String, String>>> unapply(Broker x$0) {
        return Broker$.MODULE$.unapply(x$0);
    }

    public static Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        return new Broker(id, endPoints, rack, features, tags);
    }

    public static Broker fromBrokerRegistration(BrokerRegistration registration) {
        return Broker$.MODULE$.fromBrokerRegistration(registration);
    }

    public static Broker apply(int id, EndPoint endPoint, Option<String> rack) {
        return Broker$.MODULE$.apply(id, endPoint, rack);
    }

    public static Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack, scala.collection.immutable.Map<String, String> tags) {
        return Broker$.MODULE$.apply(id, endPoints, rack, tags);
    }

    public static Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features) {
        return Broker$.MODULE$.apply(id, endPoints, rack, features);
    }

    public static Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack) {
        return Broker$.MODULE$.apply(id, endPoints, rack);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public int id() {
        return this.id;
    }

    public Seq<EndPoint> endPoints() {
        return this.endPoints;
    }

    public Option<String> rack() {
        return this.rack;
    }

    public Features<SupportedVersionRange> features() {
        return this.features;
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap() {
        return this.endPointsMap;
    }

    public String toString() {
        return new StringBuilder(9).append(this.id()).append(" : ").append(this.endPointsMap().values().mkString("(", ",", ")")).append(" : ").append(this.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).append(" : ").append(this.features()).toString();
    }

    public Node node(ListenerName listenerName) {
        return (Node)this.getNode(listenerName).getOrElse((Function0 & Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found ").append("for broker ").append(this.id()).toString());
        });
    }

    public Option<Node> getNode(ListenerName listenerName) {
        return this.endPointsMap().get((Object)listenerName).map((Function1 & Serializable)endpoint -> new ConfluentNode(this.id(), endpoint.host(), endpoint.port(), (String)this.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava()));
    }

    public BrokerEndPoint brokerEndPoint(ListenerName listenerName) {
        EndPoint endpoint = this.endPoint(listenerName);
        return new BrokerEndPoint(this.id(), endpoint.host(), endpoint.port());
    }

    public EndPoint endPoint(ListenerName listenerName) {
        return (EndPoint)this.endPointsMap().getOrElse((Object)listenerName, (Function0 & Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found for broker ").append(this.id()).toString());
        });
    }

    public ConfluentAuthorizerServerInfo toServerInfo(String clusterId, KafkaConfig config, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
        ClusterResource clusterResource = new ClusterResource(clusterId);
        Endpoint interBrokerEndpoint = this.endPoint(config.interBrokerListenerName()).toJava();
        java.util.List brokerEndpoints = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.endPoints().toList().map((Function1 & Serializable)x$1 -> x$1.toJava())).asJava();
        Map interBrokerClientConfigs = ConfluentConfigs.clientConfigsForEndpoint(config.originals(), config.values(), (Endpoint)interBrokerEndpoint);
        return new ServerInfo(clusterResource, this.id(), brokerEndpoints, interBrokerEndpoint, CollectionConverters$.MODULE$.SetHasAsJava((Set)config.earlyStartListeners().map((Function1 & Serializable)x$2 -> x$2.value())).asJava(), httpServerBinder, auditLogProvider, metrics, interBrokerClientConfigs);
    }

    public AuditLogProvider toServerInfo$default$4() {
        return NoOpAuditLogProvider.INSTANCE;
    }

    public Broker copy(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        return new Broker(id, endPoints, rack, features, tags);
    }

    public int copy$default$1() {
        return this.id();
    }

    public Seq<EndPoint> copy$default$2() {
        return this.endPoints();
    }

    public Option<String> copy$default$3() {
        return this.rack();
    }

    public Features<SupportedVersionRange> copy$default$4() {
        return this.features();
    }

    public scala.collection.immutable.Map<String, String> copy$default$5() {
        return this.tags();
    }

    public String productPrefix() {
        return "Broker";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.id());
            }
            case 1: {
                return this.endPoints();
            }
            case 2: {
                return this.rack();
            }
            case 3: {
                return this.features();
            }
            case 4: {
                return this.tags();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Broker;
    }

    public String productElementName(int x$1) {
        switch (x$1) {
            case 0: {
                return "id";
            }
            case 1: {
                return "endPoints";
            }
            case 2: {
                return "rack";
            }
            case 3: {
                return "features";
            }
            case 4: {
                return "tags";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)this.id()), (int)Statics.anyHash(this.endPoints())), (int)Statics.anyHash(this.rack())), (int)Statics.anyHash(this.features())), (int)Statics.anyHash(this.tags())), (int)5);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof Broker)) break block3;
                Broker broker = (Broker)x$1;
                if (this.id() != broker.id()) break block3;
                Seq<EndPoint> seq = this.endPoints();
                Seq<EndPoint> seq2 = broker.endPoints();
                if (seq != null ? !seq.equals(seq2) : seq2 != null) break block3;
                Option<String> option = this.rack();
                Option<String> option2 = broker.rack();
                if (option != null ? !option.equals(option2) : option2 != null) break block3;
                Features<SupportedVersionRange> features = this.features();
                Features<SupportedVersionRange> features2 = broker.features();
                if (features != null ? !features.equals(features2) : features2 != null) break block3;
                scala.collection.immutable.Map<String, String> map = this.tags();
                scala.collection.immutable.Map<String, String> map2 = broker.tags();
                if ((map != null ? !map.equals(map2) : map2 != null) || !broker.canEqual(this)) break block3;
            }
            return true;
        }
        return false;
    }

    public Broker(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        this.id = id;
        this.endPoints = endPoints;
        this.rack = rack;
        this.features = features;
        this.tags = tags;
        Product.$init$((Product)this);
        this.endPointsMap = ((IterableOnceOps)endPoints.map((Function1 & Serializable)endPoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName()), endPoint))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (this.endPointsMap().size() != endPoints.size()) {
            throw new IllegalArgumentException(new StringBuilder(62).append("There is more than one end point with the same listener name: ").append(endPoints.mkString(",")).toString());
        }
    }

    public Broker(int id, String host, int port, ListenerName listenerName, SecurityProtocol protocol) {
        this(id, (Seq<EndPoint>)new .colon.colon((Object)new EndPoint(host, port, listenerName, protocol), (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, (Features<SupportedVersionRange>)Features.emptySupportedFeatures(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public Broker(BrokerEndPoint bep, ListenerName listenerName, SecurityProtocol protocol) {
        this(bep.id(), bep.host(), bep.port(), listenerName, protocol);
    }

    public static class ServerInfo
    implements ConfluentAuthorizerServerInfo,
    Product,
    Serializable {
        private final ClusterResource clusterResource;
        private final int brokerId;
        private final java.util.List<Endpoint> endpoints;
        private final Endpoint interBrokerEndpoint;
        private final java.util.Set<String> earlyStartListeners;
        private final KafkaHttpServerBinder httpServerBinder;
        private final AuditLogProvider auditLogProvider;
        private final Metrics metrics;
        private final Map<String, ?> interBrokerClientConfig;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public java.util.List<String> additionalRoleDefFiles() {
            return super.additionalRoleDefFiles();
        }

        public ClusterResource clusterResource() {
            return this.clusterResource;
        }

        public int brokerId() {
            return this.brokerId;
        }

        public java.util.List<Endpoint> endpoints() {
            return this.endpoints;
        }

        public Endpoint interBrokerEndpoint() {
            return this.interBrokerEndpoint;
        }

        public java.util.Set<String> earlyStartListeners() {
            return this.earlyStartListeners;
        }

        public KafkaHttpServerBinder httpServerBinder() {
            return this.httpServerBinder;
        }

        public AuditLogProvider auditLogProvider() {
            return this.auditLogProvider;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public Map<String, ?> interBrokerClientConfig() {
            return this.interBrokerClientConfig;
        }

        public ServerInfo copy(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, java.util.Set<String> earlyStartListeners, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics, Map<String, ?> interBrokerClientConfig) {
            return new ServerInfo(clusterResource, brokerId, endpoints, interBrokerEndpoint, earlyStartListeners, httpServerBinder, auditLogProvider, metrics, interBrokerClientConfig);
        }

        public ClusterResource copy$default$1() {
            return this.clusterResource();
        }

        public int copy$default$2() {
            return this.brokerId();
        }

        public java.util.List<Endpoint> copy$default$3() {
            return this.endpoints();
        }

        public Endpoint copy$default$4() {
            return this.interBrokerEndpoint();
        }

        public java.util.Set<String> copy$default$5() {
            return this.earlyStartListeners();
        }

        public KafkaHttpServerBinder copy$default$6() {
            return this.httpServerBinder();
        }

        public AuditLogProvider copy$default$7() {
            return this.auditLogProvider();
        }

        public Metrics copy$default$8() {
            return this.metrics();
        }

        public Map<String, ?> copy$default$9() {
            return this.interBrokerClientConfig();
        }

        public String productPrefix() {
            return "ServerInfo";
        }

        public int productArity() {
            return 9;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.clusterResource();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.brokerId());
                }
                case 2: {
                    return this.endpoints();
                }
                case 3: {
                    return this.interBrokerEndpoint();
                }
                case 4: {
                    return this.earlyStartListeners();
                }
                case 5: {
                    return this.httpServerBinder();
                }
                case 6: {
                    return this.auditLogProvider();
                }
                case 7: {
                    return this.metrics();
                }
                case 8: {
                    return this.interBrokerClientConfig();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServerInfo;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "clusterResource";
                }
                case 1: {
                    return "brokerId";
                }
                case 2: {
                    return "endpoints";
                }
                case 3: {
                    return "interBrokerEndpoint";
                }
                case 4: {
                    return "earlyStartListeners";
                }
                case 5: {
                    return "httpServerBinder";
                }
                case 6: {
                    return "auditLogProvider";
                }
                case 7: {
                    return "metrics";
                }
                case 8: {
                    return "interBrokerClientConfig";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.clusterResource())), (int)this.brokerId()), (int)Statics.anyHash((Object)this.endpoints())), (int)Statics.anyHash((Object)this.interBrokerEndpoint())), (int)Statics.anyHash((Object)this.earlyStartListeners())), (int)Statics.anyHash((Object)this.httpServerBinder())), (int)Statics.anyHash((Object)this.auditLogProvider())), (int)Statics.anyHash((Object)this.metrics())), (int)Statics.anyHash(this.interBrokerClientConfig())), (int)9);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ServerInfo)) break block3;
                    ServerInfo serverInfo = (ServerInfo)x$1;
                    if (this.brokerId() != serverInfo.brokerId()) break block3;
                    ClusterResource clusterResource = this.clusterResource();
                    ClusterResource clusterResource2 = serverInfo.clusterResource();
                    if (clusterResource != null ? !clusterResource.equals(clusterResource2) : clusterResource2 != null) break block3;
                    Collection collection = this.endpoints();
                    Collection collection2 = serverInfo.endpoints();
                    if (collection != null ? !((Object)collection).equals(collection2) : collection2 != null) break block3;
                    Endpoint endpoint = this.interBrokerEndpoint();
                    Endpoint endpoint2 = serverInfo.interBrokerEndpoint();
                    if (endpoint != null ? !endpoint.equals(endpoint2) : endpoint2 != null) break block3;
                    Collection collection3 = this.earlyStartListeners();
                    Collection collection4 = serverInfo.earlyStartListeners();
                    if (collection3 != null ? !((Object)collection3).equals(collection4) : collection4 != null) break block3;
                    KafkaHttpServerBinder kafkaHttpServerBinder = this.httpServerBinder();
                    KafkaHttpServerBinder kafkaHttpServerBinder2 = serverInfo.httpServerBinder();
                    if (kafkaHttpServerBinder != null ? !kafkaHttpServerBinder.equals(kafkaHttpServerBinder2) : kafkaHttpServerBinder2 != null) break block3;
                    AuditLogProvider auditLogProvider = this.auditLogProvider();
                    AuditLogProvider auditLogProvider2 = serverInfo.auditLogProvider();
                    if (auditLogProvider != null ? !auditLogProvider.equals(auditLogProvider2) : auditLogProvider2 != null) break block3;
                    Metrics metrics = this.metrics();
                    Metrics metrics2 = serverInfo.metrics();
                    if (metrics != null ? !metrics.equals(metrics2) : metrics2 != null) break block3;
                    Map<String, ?> map = this.interBrokerClientConfig();
                    Map<String, ?> map2 = serverInfo.interBrokerClientConfig();
                    if ((map != null ? !((Object)map).equals(map2) : map2 != null) || !serverInfo.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public ServerInfo(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, java.util.Set<String> earlyStartListeners, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics, Map<String, ?> interBrokerClientConfig) {
            this.clusterResource = clusterResource;
            this.brokerId = brokerId;
            this.endpoints = endpoints;
            this.interBrokerEndpoint = interBrokerEndpoint;
            this.earlyStartListeners = earlyStartListeners;
            this.httpServerBinder = httpServerBinder;
            this.auditLogProvider = auditLogProvider;
            this.metrics = metrics;
            this.interBrokerClientConfig = interBrokerClientConfig;
            Product.$init$((Product)this);
        }
    }
}

