/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kafka.common.TopicsMetadataSnapshot;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import scala.Option;

public class ClusterMetadataTopicsSnapshot
implements TopicsMetadataSnapshot {
    private final PartitionInfoSupplier partitionInfoSupplier;
    private final List<List<TopicsMetadataSnapshot.PartitionSnapshot>> partitionsByTopic;

    public ClusterMetadataTopicsSnapshot(Cluster clusterMetadata, PartitionInfoSupplier partitionInfoSupplier) {
        this.partitionInfoSupplier = partitionInfoSupplier;
        this.partitionsByTopic = clusterMetadata.topics().stream().map(topic -> {
            List snapshots = clusterMetadata.partitionsForTopic(topic).stream().map(x$0 -> new ClusterMetadataPartitionSnapshot((PartitionInfo)x$0)).collect(Collectors.toList());
            return snapshots;
        }).collect(Collectors.toList());
    }

    @Override
    public List<List<TopicsMetadataSnapshot.PartitionSnapshot>> partitionsByTopic() {
        return this.partitionsByTopic;
    }

    @Override
    public Optional<TopicsMetadataSnapshot.ReplicaInfo> partitionInfoSnapshot(TopicsMetadataSnapshot.PartitionSnapshot partitionSnapshot) {
        Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> option = this.partitionInfoSupplier.getPartitionInfo(partitionSnapshot.topic(), partitionSnapshot.partitionId());
        UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)option.getOrElse(() -> null);
        return Optional.ofNullable(state).map(x$0 -> new ClusterMetadataReplicaInfo((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$0));
    }

    public class ClusterMetadataReplicaInfo
    implements TopicsMetadataSnapshot.ReplicaInfo {
        private final List<Integer> inSyncReplicas;
        private final List<Integer> offlineReplicas;
        private final List<Integer> replicas;
        private final List<Integer> observers;

        public ClusterMetadataReplicaInfo(UpdateMetadataRequestData.UpdateMetadataPartitionState state) {
            this.inSyncReplicas = state.isr();
            this.offlineReplicas = state.offlineReplicas();
            this.replicas = state.replicas();
            this.observers = state.observers();
        }

        @Override
        public List<Integer> inSyncReplicas() {
            return this.inSyncReplicas;
        }

        @Override
        public List<Integer> offlineReplicas() {
            return this.offlineReplicas;
        }

        @Override
        public List<Integer> replicas() {
            return this.replicas;
        }

        @Override
        public List<Integer> observers() {
            return this.observers;
        }
    }

    public class ClusterMetadataPartitionSnapshot
    implements TopicsMetadataSnapshot.PartitionSnapshot {
        private final String topic;
        private final int partition;
        private final int numReplicas;

        public ClusterMetadataPartitionSnapshot(PartitionInfo partitionInfo) {
            this.topic = partitionInfo.topic();
            this.partition = partitionInfo.partition();
            this.numReplicas = partitionInfo.replicas().length;
        }

        @Override
        public String topic() {
            return this.topic;
        }

        @Override
        public int partitionId() {
            return this.partition;
        }

        @Override
        public int numReplicas() {
            return this.numReplicas;
        }
    }

    public static interface PartitionInfoSupplier {
        public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String var1, int var2);
    }
}

