/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.QuotaValue$;
import kafka.utils.CoreUtils$;
import kafka.utils.Pool;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001\u0002\f\u0018\u0001yA\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\tW\u0001\u0011\t\u0011)A\u0005O!AA\u0006\u0001BA\u0002\u0013\u0005Q\u0006\u0003\u00052\u0001\t\u0005\r\u0011\"\u00013\u0011!A\u0004A!A!B\u0013q\u0003\"B\u001f\u0001\t\u0003qT\u0001\u0002\"\u0001\u0001\rCq!\u0017\u0001C\u0002\u0013%!\f\u0003\u0004h\u0001\u0001\u0006Ia\u0017\u0005\bQ\u0002\u0011\r\u0011\"\u0001j\u0011\u0019)\b\u0001)A\u0005U\"9a\u000f\u0001b\u0001\n\u00039\bB\u0002?\u0001A\u0003%\u0001\u0010C\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003w\u0002A\u0011BA?\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!%\u0001\t\u0003\nyI\u0001\u0006Rk>$\u0018-\u00128uefT!\u0001G\r\u0002\u000bE,x\u000e^1\u000b\u0005iY\u0012aC2p_J$\u0017N\\1u_JT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\fcV|G/Y#oi&$\u00180F\u0001(!\tA\u0013&D\u0001\u0018\u0013\tQsCA\u0006Rk>$\u0018-\u00128uSRL\u0018\u0001D9v_R\fWI\u001c;jif\u0004\u0013\u0001\u00067bgR,\u0006\u000fZ1uK\u0012$\u0016.\\3ti\u0006l\u0007/F\u0001/!\t\u0001s&\u0003\u00021C\t!Aj\u001c8h\u0003aa\u0017m\u001d;Va\u0012\fG/\u001a3US6,7\u000f^1na~#S-\u001d\u000b\u0003gY\u0002\"\u0001\t\u001b\n\u0005U\n#\u0001B+oSRDqa\u000e\u0003\u0002\u0002\u0003\u0007a&A\u0002yIE\nQ\u0003\\1tiV\u0003H-\u0019;fIRKW.Z:uC6\u0004\b\u0005\u000b\u0002\u0006uA\u0011\u0001eO\u0005\u0003y\u0005\u0012\u0001B^8mCRLG.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007}\u0002\u0015\t\u0005\u0002)\u0001!)QE\u0002a\u0001O!)AF\u0002a\u0001]\ty\u0001+\u001a:Ce>\\WM])v_R\f7\u000f\u0005\u0003E\u0013.3V\"A#\u000b\u0005\u0019;\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u0011\u0006\n!bY8mY\u0016\u001cG/[8o\u0013\tQUIA\u0002NCB\u0004\"\u0001T*\u000f\u00055\u000b\u0006C\u0001(\"\u001b\u0005y%B\u0001)\u001e\u0003\u0019a$o\\8u}%\u0011!+I\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002SCA\u0011\u0001fV\u0005\u00031^\u0011!\"U;pi\u00064\u0016\r\\;f\u0003\u0011awnY6\u0016\u0003m\u0003\"\u0001X3\u000e\u0003uS!AX0\u0002\u000b1|7m[:\u000b\u0005\u0001\f\u0017AC2p]\u000e,(O]3oi*\u0011!mY\u0001\u0005kRLGNC\u0001e\u0003\u0011Q\u0017M^1\n\u0005\u0019l&!\u0004*fK:$(/\u00198u\u0019>\u001c7.A\u0003m_\u000e\\\u0007%\u0001\bd_6\u0004X\u000f^3e#V|G/Y:\u0016\u0003)\u0004Ba\u001b8qg6\tAN\u0003\u0002n7\u0005)Q\u000f^5mg&\u0011q\u000e\u001c\u0002\u0005!>|G\u000e\u0005\u0002!c&\u0011!/\t\u0002\u0004\u0013:$\bC\u0001;\b\u001b\u0005\u0001\u0011aD2p[B,H/\u001a3Rk>$\u0018m\u001d\u0011\u0002)1\f7\u000f\u001e*fG>l\u0007/\u001e;fIRKW.Z't+\u0005A\b\u0003B={\u0017:j\u0011aX\u0005\u0003w~\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q\u0003Ua\u0017m\u001d;SK\u000e|W\u000e];uK\u0012$\u0016.\\3Ng\u0002\na!\u001b8M_\u000e\\WcA@\u0002\u0006Q!\u0011\u0011AA\f!\u0011\t\u0019!!\u0002\r\u0001\u00119\u0011q\u0001\bC\u0002\u0005%!!\u0001+\u0012\t\u0005-\u0011\u0011\u0003\t\u0004A\u00055\u0011bAA\bC\t9aj\u001c;iS:<\u0007c\u0001\u0011\u0002\u0014%\u0019\u0011QC\u0011\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u001a9!\t\u0019AA\u000e\u0003\r1WO\u001c\t\u0006A\u0005u\u0011\u0011A\u0005\u0004\u0003?\t#\u0001\u0003\u001fcs:\fW.\u001a \u0002\u001bA,H/U;pi\u00064\u0016\r\\;f)\u001d\u0019\u0014QEA\u0015\u0003[Aa!a\n\u0010\u0001\u0004\u0001\u0018\u0001\u00032s_.,'/\u00133\t\r\u0005-r\u00021\u0001L\u0003%\tXo\u001c;b)f\u0004X\r\u0003\u0004\u00020=\u0001\rAV\u0001\u000bcV|G/\u0019,bYV,\u0017!D4fiF+x\u000e^1WC2,X\r\u0006\u0004\u00026\u0005m\u0012Q\b\t\u0005A\u0005]b+C\u0002\u0002:\u0005\u0012aa\u00149uS>t\u0007BBA\u0014!\u0001\u0007\u0001\u000f\u0003\u0004\u0002,A\u0001\raS\u0001$kB$\u0017\r^3D_:\u001cX/\u001c9uS>t\u0017I\u001c3SK\u000e|W\u000e];uKF+x\u000e^1t)M\u0019\u00141IA#\u0003\u001f\nI&!\u0018\u0002b\u0005\u0015\u0014\u0011NA7\u0011\u0019\t9#\u0005a\u0001a\"9\u0011qI\tA\u0002\u0005%\u0013aC2p]N,X\u000e\u001d;j_:\u00042\u0001KA&\u0013\r\tie\u0006\u0002\u0011#V|G/Y\"p]N,X\u000e\u001d;j_:Dq!!\u0015\u0012\u0001\u0004\t\u0019&\u0001\u0006u_R\fG.U;pi\u0006\u00042\u0001IA+\u0013\r\t9&\t\u0002\u0007\t>,(\r\\3\t\u000f\u0005m\u0013\u00031\u0001\u0002T\u0005qQ.\u0019=Ce>\\WM])v_R\f\u0007BBA0#\u0001\u0007a&A\u0007dkJ\u0014XM\u001c;US6,Wj\u001d\u0005\u0007\u0003G\n\u0002\u0019\u0001\u0018\u00027\r|gn];naRLwN\\#ya&\u0014\u0018\r^5p]RKW.Z't\u0011\u0019\t9'\u0005a\u0001]\u0005\u0019\"/Z2p[B,H/Z%oi\u0016\u0014h/\u00197Ng\"9\u00111N\tA\u0002\u0005M\u0013a\u00067buf,e/\u00197vCRLwN\u001c+ie\u0016\u001c\bn\u001c7e\u0011\u001d\ty'\u0005a\u0001\u0003'\nq\"^:bO\u0016\fEM[;ti6,g\u000e^\u0001\u0012kB$\u0017\r^3D_:\u001cX/\u001c9uS>tGcB\u001a\u0002v\u0005]\u0014\u0011\u0010\u0005\u0007\u0003O\u0011\u0002\u0019\u00019\t\u000f\u0005\u001d#\u00031\u0001\u0002J!1\u0011q\f\nA\u00029\nqB]3d_6\u0004X\u000f^3Rk>$\u0018m\u001d\u000b\u0010g\u0005}\u0014\u0011QAB\u0003\u000b\u000b9)!#\u0002\f\"1\u00111F\nA\u0002-Cq!!\u0015\u0014\u0001\u0004\t\u0019\u0006C\u0004\u0002\\M\u0001\r!a\u0015\t\r\u0005}3\u00031\u0001/\u0011\u0019\t\u0019g\u0005a\u0001]!9\u00111N\nA\u0002\u0005M\u0003bBA8'\u0001\u0007\u00111K\u0001\u0015G>l\u0007/\u001e;fIF+x\u000e^1t'R\u0014\u0018N\\4\u0015\u0003-\u000b\u0001\u0002^8TiJLgn\u001a\u0015\u0004\u0001\u0005U\u0005cA6\u0002\u0018&\u0019\u0011\u0011\u00147\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0001")
public class QuotaEntry {
    private final QuotaEntity quotaEntity;
    private volatile long lastUpdatedTimestamp;
    private final ReentrantLock lock;
    private final Pool<Object, Map<String, QuotaValue>> computedQuotas;
    private final ConcurrentHashMap<String, Object> lastRecomputedTimeMs;

    public QuotaEntity quotaEntity() {
        return this.quotaEntity;
    }

    public long lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public void lastUpdatedTimestamp_$eq(long x$1) {
        this.lastUpdatedTimestamp = x$1;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public Pool<Object, Map<String, QuotaValue>> computedQuotas() {
        return this.computedQuotas;
    }

    public ConcurrentHashMap<String, Object> lastRecomputedTimeMs() {
        return this.lastRecomputedTimeMs;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public void putQuotaValue(int brokerId, String quotaType, QuotaValue quotaValue) {
        ((scala.collection.mutable.MapOps)this.computedQuotas().getAndMaybePut(BoxesRunTime.boxToInteger((int)brokerId))).put((Object)quotaType, (Object)quotaValue);
    }

    public Option<QuotaValue> getQuotaValue(int brokerId, String quotaType) {
        return ((MapOps)this.computedQuotas().getAndMaybePut(BoxesRunTime.boxToInteger((int)brokerId))).get((Object)quotaType);
    }

    public void updateConsumptionAndRecomputeQuotas(int brokerId, QuotaConsumption consumption, double totalQuota, double maxBrokerQuota, long currentTimeMs, long consumptionExpirationTimeMs, long recomputeIntervalMs, double lazyEvaluationThreshold, double usageAdjustment) {
        this.lastUpdatedTimestamp_$eq(currentTimeMs);
        this.updateConsumption(brokerId, consumption, currentTimeMs);
        if (!this.lastRecomputedTimeMs().contains(consumption.quotaType()) || currentTimeMs - BoxesRunTime.unboxToLong((Object)this.lastRecomputedTimeMs().get(consumption.quotaType())) > recomputeIntervalMs) {
            this.recomputeQuotas(consumption.quotaType(), totalQuota, maxBrokerQuota, currentTimeMs, consumptionExpirationTimeMs, lazyEvaluationThreshold, usageAdjustment);
            return;
        }
    }

    public void updateConsumption(int brokerId, QuotaConsumption consumption, long currentTimeMs) {
        Option<QuotaValue> option = this.getQuotaValue(brokerId, consumption.quotaType());
        if (option instanceof Some) {
            ((QuotaValue)((Some)option).value()).updateConsumption(consumption, currentTimeMs);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            ((scala.collection.mutable.MapOps)this.computedQuotas().get(BoxesRunTime.boxToInteger((int)brokerId))).update((Object)consumption.quotaType(), (Object)QuotaValue$.MODULE$.valueFromConsumption(consumption, currentTimeMs));
            return;
        }
        throw new MatchError(option);
    }

    private void recomputeQuotas(String quotaType, double totalQuota, double maxBrokerQuota, long currentTimeMs, long consumptionExpirationTimeMs, double lazyEvaluationThreshold, double usageAdjustment) {
        double totalThrottleTimeMs = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)this.computedQuotas().values().map((Function1 & Serializable)perBrokerQuota -> BoxesRunTime.boxToDouble((double)QuotaEntry.$anonfun$recomputeQuotas$1(quotaType, currentTimeMs, consumptionExpirationTimeMs, perBrokerQuota)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        DoubleRef remainingQuota = DoubleRef.create((double)totalQuota);
        double totalUsage = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)this.computedQuotas().values().map((Function1 & Serializable)perBrokerQuota -> BoxesRunTime.boxToDouble((double)QuotaEntry.$anonfun$recomputeQuotas$2(quotaType, totalThrottleTimeMs, usageAdjustment, perBrokerQuota)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        if (totalUsage < lazyEvaluationThreshold * totalQuota) {
            this.computedQuotas().values().foreach((Function1 & Serializable)perBrokerQuotas -> {
                QuotaEntry.$anonfun$recomputeQuotas$3(quotaType, maxBrokerQuota, perBrokerQuotas);
                return BoxedUnit.UNIT;
            });
        } else {
            DoubleRef remainingUsage = DoubleRef.create((double)totalUsage);
            ((Seq)this.computedQuotas().toSeq().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)QuotaEntry.$anonfun$recomputeQuotas$5(quotaType, totalThrottleTimeMs, usageAdjustment, x0$1)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).foreach((Function1 & Serializable)x0$2 -> {
                QuotaEntry.$anonfun$recomputeQuotas$6(quotaType, remainingUsage, remainingQuota, maxBrokerQuota, totalThrottleTimeMs, usageAdjustment, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        this.lastRecomputedTimeMs().put(quotaType, BoxesRunTime.boxToLong((long)currentTimeMs));
    }

    public String computedQuotasString() {
        if (this.computedQuotas().isEmpty()) {
            return "";
        }
        scala.collection.mutable.StringBuilder res = new scala.collection.mutable.StringBuilder();
        this.computedQuotas().foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int broker = x0$1._1$mcI$sp();
                Map perBrokerQuotas = (Map)x0$1._2();
                return res.append(new StringBuilder(27).append("{broker=").append(broker).append(",perBrokerQuotas=").append(perBrokerQuotas).append("},").toString());
            }
            throw new MatchError(null);
        });
        res.deleteCharAt(res.length() - 1);
        return res.toString();
    }

    public String toString() {
        return new scala.collection.mutable.StringBuilder("QuotaEntry(").append("quotaEntity=").append(this.quotaEntity().entityTypes().toString()).append(", computedQuotas=(").append(this.computedQuotasString()).append(")").append(", lastUpdatedTimestamp=").append(this.lastUpdatedTimestamp()).append(")").toString();
    }

    public static final /* synthetic */ Map $anonfun$computedQuotas$1(int x$1) {
        return (Map)Map$.MODULE$.empty();
    }

    public static final /* synthetic */ double $anonfun$recomputeQuotas$1(String quotaType$1, long currentTimeMs$1, long consumptionExpirationTimeMs$1, Map perBrokerQuota) {
        Option option = perBrokerQuota.get((Object)quotaType$1);
        if (option instanceof Some) {
            QuotaValue quotaValue = (QuotaValue)((Some)option).value();
            if (quotaValue.lastUsageReportTimestamp() >= currentTimeMs$1 - consumptionExpirationTimeMs$1) {
                return quotaValue.throttledTimeMs();
            }
            perBrokerQuota.remove((Object)quotaType$1);
            return 0.0;
        }
        if (None$.MODULE$.equals(option)) {
            return 0.0;
        }
        throw new MatchError((Object)option);
    }

    private static final double adjustedUsage$1(QuotaValue quotaValue, double totalThrottleTimeMs$1, double usageAdjustment$1) {
        double adjustment = totalThrottleTimeMs$1 > 0.0 && quotaValue.throttledTimeMs() > 0.0 ? Math.max(0.2, usageAdjustment$1 * quotaValue.throttledTimeMs() / totalThrottleTimeMs$1) : 0.0;
        return quotaValue.usage() * (1.0 + adjustment);
    }

    public static final /* synthetic */ double $anonfun$recomputeQuotas$2(String quotaType$1, double totalThrottleTimeMs$1, double usageAdjustment$1, Map perBrokerQuota) {
        Option option = perBrokerQuota.get((Object)quotaType$1);
        if (option instanceof Some) {
            return QuotaEntry.adjustedUsage$1((QuotaValue)((Some)option).value(), totalThrottleTimeMs$1, usageAdjustment$1);
        }
        if (None$.MODULE$.equals(option)) {
            return 0.0;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$recomputeQuotas$3(String quotaType$1, double maxBrokerQuota$1, Map perBrokerQuotas) {
        perBrokerQuotas.get((Object)quotaType$1).foreach((Function1 & Serializable)quotaValue -> {
            quotaValue.quota_$eq(maxBrokerQuota$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ double $anonfun$recomputeQuotas$5(String quotaType$1, double totalThrottleTimeMs$1, double usageAdjustment$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Option option = ((Map)x0$1._2()).get((Object)quotaType$1);
            if (option instanceof Some) {
                QuotaValue quotaValue = (QuotaValue)((Some)option).value();
                return (double)-1 * QuotaEntry.adjustedUsage$1(quotaValue, totalThrottleTimeMs$1, usageAdjustment$1);
            }
            if (None$.MODULE$.equals(option)) {
                return 0.0;
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$recomputeQuotas$7(DoubleRef remainingUsage$1, DoubleRef remainingQuota$1, double maxBrokerQuota$1, double totalThrottleTimeMs$1, double usageAdjustment$1, QuotaValue quotaValue) {
        double currentUsage = QuotaEntry.adjustedUsage$1(quotaValue, totalThrottleTimeMs$1, usageAdjustment$1);
        quotaValue.quota_$eq(remainingUsage$1.elem > 0.0 ? remainingQuota$1.elem * (currentUsage / remainingUsage$1.elem) : 0.0);
        quotaValue.quota_$eq(package$.MODULE$.min(quotaValue.quota(), maxBrokerQuota$1));
        remainingQuota$1.elem -= quotaValue.quota();
        remainingUsage$1.elem -= currentUsage;
    }

    public static final /* synthetic */ void $anonfun$recomputeQuotas$6(String quotaType$1, DoubleRef remainingUsage$1, DoubleRef remainingQuota$1, double maxBrokerQuota$1, double totalThrottleTimeMs$1, double usageAdjustment$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            ((Map)x0$2._2()).get((Object)quotaType$1).foreach((Function1 & Serializable)quotaValue -> {
                QuotaEntry.$anonfun$recomputeQuotas$7(remainingUsage$1, remainingQuota$1, maxBrokerQuota$1, totalThrottleTimeMs$1, usageAdjustment$1, quotaValue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public QuotaEntry(QuotaEntity quotaEntity, long lastUpdatedTimestamp) {
        this.quotaEntity = quotaEntity;
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        this.lock = new ReentrantLock();
        this.computedQuotas = new Pool(new Some((Function1 & Serializable)x$1 -> QuotaEntry.$anonfun$computedQuotas$1(BoxesRunTime.unboxToInt((Object)x$1))));
        this.lastRecomputedTimeMs = new ConcurrentHashMap();
    }
}

