/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.util.UUID;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityStats;
import kafka.durability.audit.OffsetCount;
import kafka.durability.audit.SegmentOffsetMap;
import kafka.durability.audit.SegmentRange;
import kafka.durability.db.DataLossEntry;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001B\u0017/\u0001UB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\")Q\n\u0001C\u0005\u001d\"91\u000b\u0001b\u0001\n\u001b!\u0006B\u0002-\u0001A\u00035Q\u000bC\u0004Z\u0001\u0001\u0007I\u0011\u0002.\t\u000fy\u0003\u0001\u0019!C\u0005?\"1Q\r\u0001Q!\nmCqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004\u007f\u0001\u0001\u0006I\u0001\u001b\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011\u0011\u0002\u0001!\u0002\u0013\t\u0019\u0001\u0003\u0004\u0002\f\u0001!\ta\u001a\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!a\n\u0001\t\u0003\tI\u0003C\u0005\u0002\u001a\u0002\t\n\u0011\"\u0001\u0002\u001c\"I\u0011\u0011\u0017\u0001\u0012\u0002\u0013\u0005\u00111\u0017\u0005\b\u0003o\u0003A\u0011AA]\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fC\u0011\"!4\u0001#\u0003%\t!a4\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\bbBAx\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0003c\u0004A\u0011AAz\u0011\u001d\t)\u0010\u0001C\u0001\u0003oDq!!@\u0001\t\u0003\ty\u0010C\u0004\u0003\u0004\u0001!\tA!\u0002\t\u000f\t%\u0001\u0001\"\u0001\u0003\f!9!q\u0002\u0001\u0005\u0002\tE\u0001b\u0002B\u000b\u0001\u0011\u0005!q\u0003\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005GAqAa\n\u0001\t\u0003\u0011I\u0003C\u0004\u0003.\u0001!\tAa\f\t\u000f\tU\u0002\u0001\"\u0001\u00038!9!Q\b\u0001\u0005\u0002\t}\u0002b\u0002B#\u0001\u0011\u0005!q\t\u0005\b\u0005\u0017\u0002A\u0011\u0001B'\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#:qAa\u0016/\u0011\u0003\u0011IF\u0002\u0004.]!\u0005!1\f\u0005\u0007\u001b*\"\tA!\u0018\t\u000f\t}#\u0006\"\u0001\u0003b\ti\u0011)\u001e3jiJ+\u0007o\u001c:uKJT!a\f\u0019\u0002\u000b\u0005,H-\u001b;\u000b\u0005E\u0012\u0014A\u00033ve\u0006\u0014\u0017\u000e\\5us*\t1'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00011D\b\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004B]f\u0014VM\u001a\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fI\nQ!\u001e;jYNL!!\u0011 \u0003\u000f1{wmZ5oO\u0006iQ.\u001a;sS\u000el\u0015M\\1hKJ\u0004\"\u0001R#\u000e\u0003AJ!A\u0012\u0019\u00031\u0011+(/\u00192jY&$\u00180T3ue&\u001c7/T1oC\u001e,'/\u0001\u0002eEB\u0011\u0011jS\u0007\u0002\u0015*\u0011q\tM\u0005\u0003\u0019*\u0013A\u0002R;sC\nLG.\u001b;z\t\n\u000ba\u0001P5oSRtDcA(R%B\u0011\u0001\u000bA\u0007\u0002]!)!i\u0001a\u0001\u0007\")qi\u0001a\u0001\u0011\u0006)B-\u0019;b\u0019>\u001c8OU3uK:$\u0018n\u001c8J]6\u001bX#A+\u0011\u0005]2\u0016BA,9\u0005\u0011auN\\4\u0002-\u0011\fG/\u0019'pgN\u0014V\r^3oi&|g.\u00138Ng\u0002\nQA[8c\u0013\u0012,\u0012a\u0017\t\u0003oqK!!\u0018\u001d\u0003\u0007%sG/A\u0005k_\nLEm\u0018\u0013fcR\u0011\u0001m\u0019\t\u0003o\u0005L!A\u0019\u001d\u0003\tUs\u0017\u000e\u001e\u0005\bI\u001e\t\t\u00111\u0001\\\u0003\rAH%M\u0001\u0007U>\u0014\u0017\n\u001a\u0011\u0002\u0015M\u001cwN]5oO6\u000b\u0007/F\u0001i!\u0011Ig\u000e]>\u000e\u0003)T!a\u001b7\u0002\u000f5,H/\u00192mK*\u0011Q\u000eO\u0001\u000bG>dG.Z2uS>t\u0017BA8k\u0005\u001dA\u0015m\u001d5NCB\u0004\"!]=\u000e\u0003IT!a\u001d;\u0002\r\r|W.\\8o\u0015\t\u0019TO\u0003\u0002wo\u00061\u0011\r]1dQ\u0016T\u0011\u0001_\u0001\u0004_J<\u0017B\u0001>s\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"\u0001\u0015?\n\u0005ut#aC(gMN,GoQ8v]R\f1b]2pe&tw-T1qA\u0005\u00012/Z4nK:$xJ\u001a4tKRl\u0015\r]\u000b\u0003\u0003\u0007\u00012\u0001UA\u0003\u0013\r\t9A\f\u0002\u0011'\u0016<W.\u001a8u\u001f\u001a47/\u001a;NCB\f\u0011c]3h[\u0016tGo\u00144gg\u0016$X*\u00199!\u000359W\r^*d_JLgnZ'ba\u0006)r-\u001a;EkJ\f'-\u001b7jif\u001cu.\u001e8uKJ\u001cHcA>\u0002\u0012!1\u00111\u0003\bA\u0002A\f!!\u001b3\u0002\u001dU\u0004H-\u0019;f\t\u0006$\u0018\rT8tgR)\u0001-!\u0007\u0002\u001e!1\u00111D\bA\u0002A\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002 =\u0001\r!!\t\u0002\u001b\u0011\fG/\u0019'pgN,e\u000e\u001e:z!\rI\u00151E\u0005\u0004\u0003KQ%!\u0004#bi\u0006dun]:F]R\u0014\u00180A\u000bsKB|'\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3\u0015#\u0001\fY#!\f\u00022\u0005U\u0012QLA9\u0003w\ny\b\u0003\u0004\u0002\u001cA\u0001\r\u0001\u001d\u0005\u0007\u0003_\u0001\u0002\u0019A+\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\u0007\u0003g\u0001\u0002\u0019A+\u0002\u00131|7o]\"pk:$\bbBA\u001c!\u0001\u0007\u0011\u0011H\u0001\u0006Y\u0006\u00048/\u001a\t\u0005\u0003w\t9F\u0004\u0003\u0002>\u0005Ec\u0002BA \u0003\u001brA!!\u0011\u0002L9!\u00111IA%\u001b\t\t)EC\u0002\u0002HQ\na\u0001\u0010:p_Rt\u0014\"A\u001a\n\u0005E\u0012\u0014bAA(a\u0005yQ.\u0019;fe&\fG.\u001b>bi&|g.\u0003\u0003\u0002T\u0005U\u0013a\u0005#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3UsB,'bAA(a%!\u0011\u0011LA.\u0005M!UO]1cS2LG/\u001f'baN,G+\u001f9f\u0015\u0011\t\u0019&!\u0016\t\u000f\u0005}\u0003\u00031\u0001\u0002b\u0005\u0019Qn]4\u0011\t\u0005\r\u00141\u000e\b\u0005\u0003K\n9\u0007E\u0002\u0002DaJ1!!\u001b9\u0003\u0019\u0001&/\u001a3fM&!\u0011QNA8\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u000e\u001d\t\u000f\u0005M\u0004\u00031\u0001\u0002v\u0005)1oY8sKB\u0019q'a\u001e\n\u0007\u0005e\u0004HA\u0004C_>dW-\u00198\t\u0013\u0005u\u0004\u0003%AA\u0002\u0005U\u0014aD5t\u001f:$U-\\1oI\u0006+H-\u001b;\t\u0013\u0005\u0005\u0005\u0003%AA\u0002\u0005\r\u0015\u0001C8cU\u0016\u001cG/\u00133\u0011\u000b]\n))!#\n\u0007\u0005\u001d\u0005H\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0017\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003\u0011)H/\u001b7\u000b\u0005\u0005M\u0015\u0001\u00026bm\u0006LA!a&\u0002\u000e\n!Q+V%E\u0003}\u0011X\r]8si\u0012+(/\u00192jY&$\u0018\u0010T1qg\u0016$C-\u001a4bk2$HeN\u000b\u0003\u0003;SC!!\u001e\u0002 .\u0012\u0011\u0011\u0015\t\u0005\u0003G\u000bi+\u0004\u0002\u0002&*!\u0011qUAU\u0003%)hn\u00195fG.,GMC\u0002\u0002,b\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty+!*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0010sKB|'\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3%I\u00164\u0017-\u001e7uIa*\"!!.+\t\u0005\r\u0015qT\u0001\u0014e\u0016\u001cX\r\u001e+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\u0004A\u0006m\u0006BBA\u000e'\u0001\u0007\u0001/A\u000bsKB|'\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;\u0015\u0013\u0001\f\t-a1\u0002F\u0006%\u0007\"B-\u0015\u0001\u0004Y\u0006BBA\u000e)\u0001\u0007\u0001\u000f\u0003\u0004\u0002HR\u0001\r!V\u0001\ti>$\u0018\r\\'tO\"A\u00111\u001a\u000b\u0011\u0002\u0003\u0007Q+\u0001\u0006u_R\fG\u000eT1qg\u0016\fqD]3q_J$H)\u001e:bE&d\u0017\u000e^=Bk\u0012LG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t\tNK\u0002V\u0003?\u000b\u0011#\u001e9eCR,\u0007*Z1mi\"\u001c\u0005.Z2l)\u0015\u0001\u0017q[An\u0011\u001d\tIN\u0006a\u0001\u0003C\n\u0011B\u0019:pW\u0016\u00148K]2\t\r\u0005ug\u00031\u0001V\u0003%!\u0018.\\3Ti\u0006l\u0007/A\u0007ti\u0006\u0014H/Q;eSRTuN\u0019\u000b\u0003\u0003G\u0004B!!:\u0002l6\u0011\u0011q\u001d\u0006\u0005\u0003S\f\t*\u0001\u0003uS6,\u0017\u0002BAw\u0003O\u0014q!\u00138ti\u0006tG/A\fti\u0006\u0014H/Q;eSR\u001cu.\u001c9bGRLwN\u001c&pE\u0006ac-\u001a;dQ\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\u001c#bi\u00064\u0016\r\\5eCRLwN\\*lSB\u0004X\r\u001a\u000b\u0002+\u0006\u0011\u0012\r\u001a3US\u0016\u0014\u0018)\u001e3ji\u0016\u0013(o\u001c:t)\r\u0001\u0017\u0011 \u0005\u0007\u0003wT\u0002\u0019A+\u0002\u000b\r|WO\u001c;\u0002;\u0005$G\rV5fe\u0006+H-\u001b;V].twn\u001e8Fq\u000e,\u0007\u000f^5p]N$2\u0001\u0019B\u0001\u0011\u0019\tYp\u0007a\u0001+\u0006Y\u0012\r\u001a3US\u0016\u0014\u0018)\u001e3jiJ+GO]=Fq\u000e,\u0007\u000f^5p]N$2\u0001\u0019B\u0004\u0011\u0019\tY\u0010\ba\u0001+\u0006a\u0012\r\u001a3D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t7k[5qa\u0016$Gc\u00011\u0003\u000e!1\u00111`\u000fA\u0002U\u000b!&\u00193e\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|g\u000eR1uCZ\u000bG.\u001b3bi&|gnU6jaB,G\rF\u0002a\u0005'Aa!a?\u001f\u0001\u0004)\u0016AI1eI\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\u001c#bi\u00064\u0016\r\\5eCR,G\rF\u0002a\u00053Aa!a? \u0001\u0004)\u0016AF1eIRKWM]*fO6,g\u000e^:Bk\u0012LG/\u001a3\u0015\u0007\u0001\u0014y\u0002\u0003\u0004\u0002|\u0002\u0002\r!V\u0001\u001aC\u0012$7i\\7qC\u000e$X\r\u001a)beRLG/[8o\u0013\u0012dW\rF\u0002a\u0005KAa!a?\"\u0001\u0004)\u0016\u0001H1eI\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\\!vI&$X\r\u001a\u000b\u0004A\n-\u0002BBA~E\u0001\u0007Q+A\rbI\u0012\u0014\u0015\u0010^3t%\u0016\fGM\u0012:p[RKWM]*u_J,Gc\u00011\u00032!1!1G\u0012A\u0002U\u000bQAY=uKN\fA%\u001e9eCR,')\u001f;fgN\u000bg/\u001a3SK\u0006$\u0017N\\4Ge>lG+[3s'R|'/\u001a\u000b\u0004A\ne\u0002B\u0002B\u001eI\u0001\u0007Q+\u0001\u0006csR,7oU1wK\u0012\f\u0011#\u001e9eCR,\u0017)\u001e3ji\u0012\u00137+\u001b>f)\r\u0001'\u0011\t\u0005\u0007\u0005\u0007*\u0003\u0019A+\u0002\tML'0Z\u0001\u001eC\u0012$G)Q\"p]N,X.\u001a:Qe>\u001cWm]:fIJ+7m\u001c:egR\u0019\u0001M!\u0013\t\r\u0005mh\u00051\u0001V\u0003E\u0011Xm]3u\u0003V$\u0017\u000e^'fiJL7m\u001d\u000b\u0002A\u0006A!/Z:fi*{'\rF\u0002\\\u0005'BaA!\u0016)\u0001\u0004Y\u0016\u0001\u00038fo*{'-\u00133\u0002\u001b\u0005+H-\u001b;SKB|'\u000f^3s!\t\u0001&f\u0005\u0002+mQ\u0011!\u0011L\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u001f\n\r$Q\r\u0005\u0006\u00052\u0002\ra\u0011\u0005\u0006\u000f2\u0002\r\u0001\u0013")
public class AuditReporter
implements Logging {
    private final DurabilityMetricsManager metricManager;
    private final DurabilityDB db;
    private final long dataLossRetentionInMs;
    private int jobId;
    private final HashMap<TopicPartition, OffsetCount> scoringMap;
    private final SegmentOffsetMap segmentOffsetMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static AuditReporter apply(DurabilityMetricsManager metricManager, DurabilityDB db) {
        return new AuditReporter(metricManager, db);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private final long dataLossRetentionInMs() {
        return this.dataLossRetentionInMs;
    }

    private int jobId() {
        return this.jobId;
    }

    private void jobId_$eq(int x$1) {
        this.jobId = x$1;
    }

    private HashMap<TopicPartition, OffsetCount> scoringMap() {
        return this.scoringMap;
    }

    private SegmentOffsetMap segmentOffsetMap() {
        return this.segmentOffsetMap;
    }

    public HashMap<TopicPartition, OffsetCount> getScoringMap() {
        return this.scoringMap();
    }

    public OffsetCount getDurabilityCounters(TopicPartition id) {
        return (OffsetCount)this.scoringMap().getOrElse((Object)id, (Function0 & Serializable)() -> new OffsetCount(0L, 0L));
    }

    public void updateDataLoss(TopicPartition topicPartition, DataLossEntry dataLossEntry) {
        PartitionState state = (PartitionState)this.db.fetchPartitionState(topicPartition).getOrElse((Function0 & Serializable)() -> PartitionState$.MODULE$.apply(topicPartition.partition(), 0L));
        state.dataLoss_$eq((ListBuffer<DataLossEntry>)((ListBuffer)state.dataLoss().$plus$plus((IterableOnce)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataLossEntry[]{dataLossEntry})))));
        long maxTimeInMills = System.currentTimeMillis() - this.dataLossRetentionInMs();
        if (((DataLossEntry)state.dataLoss().head()).timeStamp() < maxTimeInMills) {
            ListBuffer updatedDataLoss = ListBuffer$.MODULE$.empty();
            state.dataLoss().foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1.timeStamp() > maxTimeInMills) {
                    return updatedDataLoss.$plus$eq(x0$1);
                }
                return None$.MODULE$;
            });
            state.dataLoss_$eq((ListBuffer<DataLossEntry>)updatedDataLoss);
        }
        if (state.dataLoss().size() > this.db.DURABILITY_LOSS_EVENT_PER_TOPIC_PARTITION()) {
            state.dataLoss().remove(0);
        }
        this.db.addDataLossInfo(topicPartition, state);
        this.db.checkpoint();
    }

    /*
     * WARNING - void declaration
     */
    public void reportDurabilityLapse(TopicPartition topicPartition, long startOffset, long lossCount, Enumeration.Value lapse, String msg, boolean score, boolean isOnDemandAudit, Option<UUID> objectId) {
        void var16_14;
        void var15_13;
        String customerFacing = score ? "Customer impacting" : "Non Customer impacting";
        String lapseMsg = new StringBuilder(13).append(customerFacing).append(" ").append(msg).append("\n").append("lapseType: ").append(lapse).toString();
        Enumeration.Value value = lapse;
        Enumeration.Value value2 = DurabilityLapseType$.MODULE$.ChecksumValidation();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.error((Function0<String>)(Function0 & Serializable)() -> lapseMsg);
            if (!isOnDemandAudit) {
                this.metricManager.reportDurabilityLoss(lapse, lossCount);
            }
            return;
        }
        Tuple2<Object, Object> tuple2 = this.segmentOffsetMap().insert(topicPartition, new SegmentRange(startOffset, startOffset + lossCount - 1L, this.jobId(), true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean reportAlert = tuple2._1$mcZ$sp();
        boolean reportLapse = tuple2._2$mcZ$sp();
        if (var15_13 != false) {
            if (score) {
                this.error((Function0<String>)(Function0 & Serializable)() -> lapseMsg);
            } else {
                this.warn((Function0<String>)(Function0 & Serializable)() -> lapseMsg);
            }
            if (!isOnDemandAudit) {
                this.metricManager.reportDurabilityLoss(lapse, lossCount);
            }
        }
        if (var16_14 != false) {
            if (var15_13 == false) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Duplicate ").append(lapseMsg).toString());
            }
            if (score) {
                if (this.scoringMap().contains((Object)topicPartition)) {
                    OffsetCount offsetCount = (OffsetCount)this.scoringMap().apply((Object)topicPartition);
                    this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(offsetCount.total(), offsetCount.loss() + lossCount));
                } else {
                    this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(0L, lossCount));
                }
            }
        }
        if (score && var15_13 != false && var16_14 != false) {
            this.updateDataLoss(topicPartition, new DataLossEntry(startOffset, (int)lossCount, (UUID)objectId.getOrElse((Function0 & Serializable)() -> new UUID(0L, 0L)), System.currentTimeMillis(), lapse.id()));
            return;
        }
    }

    public boolean reportDurabilityLapse$default$7() {
        return false;
    }

    public Option<UUID> reportDurabilityLapse$default$8() {
        return None$.MODULE$;
    }

    public void resetTopicPartition(TopicPartition topicPartition) {
        if (this.scoringMap().contains((Object)topicPartition)) {
            this.scoringMap().remove((Object)topicPartition);
        }
        this.segmentOffsetMap().remove(topicPartition);
    }

    public void reportDurabilityAudit(int jobId, TopicPartition topicPartition, long totalMsg, long totalLapse) {
        long l;
        if (this.scoringMap().contains((Object)topicPartition)) {
            OffsetCount offsetCount = (OffsetCount)this.scoringMap().apply((Object)topicPartition);
            this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(totalMsg, offsetCount.loss() + totalLapse));
            l = offsetCount.loss() + totalLapse;
        } else {
            this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(totalMsg, totalLapse));
            l = totalLapse;
        }
        long l2 = l;
        this.metricManager.updateStats(topicPartition, new DurabilityStats(totalMsg, l2));
    }

    public long reportDurabilityAudit$default$4() {
        return 0L;
    }

    public void updateHealthCheck(String brokerSrc, long timeStamp) {
        this.metricManager.updateHealthCheck(brokerSrc, timeStamp);
    }

    public Instant startAuditJob() {
        return this.metricManager.startAuditJob();
    }

    public Instant startAuditCompactionJob() {
        return this.metricManager.startAuditCompactionJob();
    }

    public long fetchCompactedPartitionDataValidationSkipped() {
        return this.metricManager.fetchCompactedPartitionDataValidationSkipped();
    }

    public void addTierAuditErrors(long count) {
        this.metricManager.addTierAuditError(count);
    }

    public void addTierAuditUnknownExceptions(long count) {
        this.metricManager.addTierAuditUnknownExceptions(count);
    }

    public void addTierAuditRetryExceptions(long count) {
        this.metricManager.addTierAuditRetryExceptions(count);
    }

    public void addCompactedPartitionSkipped(long count) {
        this.metricManager.addCompactedPartitionSkipped(count);
    }

    public void addCompactedPartitionDataValidationSkipped(long count) {
        this.metricManager.addCompactedPartitionDataValidationSkipped(count);
    }

    public void addCompactedPartitionDataValidated(long count) {
        this.metricManager.addCompactedPartitionDataValidated(count);
    }

    public void addTierSegmentsAudited(long count) {
        this.metricManager.addTierSegmentsAudited(count);
    }

    public void addCompactedPartitionIdle(long count) {
        this.metricManager.addCompactedPartitionIdle(count);
    }

    public void addCompactedPartitionAudited(long count) {
        this.metricManager.addCompactedPartitionAudited(count);
    }

    public void addBytesReadFromTierStore(long bytes) {
        this.metricManager.addBytesReadFromTierStore(bytes);
    }

    public void updateBytesSavedReadingFromTierStore(long bytesSaved) {
        this.metricManager.updateBytesSavedReadingFromTierStore(bytesSaved);
    }

    public void updateAuditDbSize(long size) {
        this.metricManager.updateDurabilityAuditDbSize(size);
    }

    public void addDAConsumerProcessedRecords(long count) {
        this.metricManager.addDAConsumerProcessedRecords(count);
    }

    public void resetAuditMetrics() {
        this.metricManager.resetAuditMetrics();
    }

    public int resetJob(int newJobId) {
        int old = this.jobId();
        this.jobId_$eq(newJobId);
        this.metricManager.resetDurabilityRunSpan(newJobId);
        this.scoringMap().clear();
        return old;
    }

    public AuditReporter(DurabilityMetricsManager metricManager, DurabilityDB db) {
        this.metricManager = metricManager;
        this.db = db;
        this.dataLossRetentionInMs = 604800000L;
        this.jobId = -1;
        this.scoringMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.segmentOffsetMap = new SegmentOffsetMap();
    }
}

