/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.tools;

import kafka.durability.tools.UpdateDB$;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public class UpdateDurabilityDb {
    public static final String TOPIC = "topic";
    public static final String TOPIC_DOC = "topic name";
    public static final String PARTITION = "partition";
    public static final String PARTITION_DOC = "partition number";
    public static final String EPOCH = "epoch";
    public static final String EPOCH_DOC = "epoch of event";
    public static final String HWM = "hwm";
    public static final String HWM_DOC = "high watermark";
    public static final String START_OFFSET = "start offset";
    public static final String START_OFFSET_DOC = "start offset of event";
    public static final String CONFIG = "config";
    public static final String CONFIG_DOC = "config of topic partition";

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)UpdateDurabilityDb.class.getName()).defaultHelp(true).description("Utility to update internal partition state of user partition in the durability audits database");
        Subparsers subParsers = parser.addSubparsers().dest("command").help("valid subcommands: delete, update");
        Subparser deleteParser = subParsers.addParser("delete").help("Delete the database entry for a topic partition");
        deleteParser.addArgument(new String[]{"--topic"}).help(TOPIC_DOC).dest(TOPIC).type(String.class).required(true);
        deleteParser.addArgument(new String[]{"--partition"}).help(PARTITION_DOC).dest(PARTITION).type(Integer.class).required(true);
        Subparser updateParser = subParsers.addParser("update").help("Update the database entry for a topic partition");
        updateParser.addArgument(new String[]{"--topic"}).help(TOPIC_DOC).dest(TOPIC).type(String.class).required(true);
        updateParser.addArgument(new String[]{"--partition"}).help(PARTITION_DOC).action((ArgumentAction)Arguments.store()).dest(PARTITION).required(true);
        updateParser.addArgument(new String[]{"--hwm"}).help(HWM_DOC).action((ArgumentAction)Arguments.store()).dest(HWM).required(false);
        updateParser.addArgument(new String[]{"--epoch"}).help(EPOCH_DOC).action((ArgumentAction)Arguments.store()).dest(EPOCH).required(false);
        updateParser.addArgument(new String[]{"--startOffset"}).help(START_OFFSET_DOC).action((ArgumentAction)Arguments.store()).dest(START_OFFSET).required(false);
        updateParser.addArgument(new String[]{"--config"}).help(CONFIG_DOC).action((ArgumentAction)Arguments.store()).dest(CONFIG).required(false);
        return parser;
    }

    public static void main(String[] args) throws ArgumentParserException {
        ArgumentParser parser = UpdateDurabilityDb.createArgParser();
        Namespace np = parser.parseArgs(args);
        switch (np.getString("command")) {
            case "delete": {
                String topic = np.getString(TOPIC);
                String partition = np.getString(PARTITION);
                UpdateDB$.MODULE$.deletePartition(topic, partition);
                break;
            }
            case "update": {
                String topic = np.getString(TOPIC);
                String partition = np.getString(PARTITION);
                String epoch = np.getString(EPOCH);
                String hwm = np.getString(HWM);
                String startOffset = np.getString(START_OFFSET);
                String config = np.getString(CONFIG);
                UpdateDB$.MODULE$.updatePartition(topic, partition, epoch, hwm, startOffset, config);
                break;
            }
        }
    }
}

