/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.CleanParams;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.LocalLog$;
import kafka.log.LocalLogSegmentReadAdapter;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogSegmentReadAdapter;
import kafka.log.ValidateLogResult$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.ExtendedOffsetMap;
import org.apache.kafka.storage.internals.log.LastRecord;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r}a\u0001\u0002\u0015*\u00019B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005{!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003D\u0011!\u0011\u0006A!A!\u0002\u0013i\u0004\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"Aa\r\u0001B\u0001B\u0003%q\r\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003s\u0011\u00151\b\u0001\"\u0001x\u0011\u001d\t)\u0001\u0001C)\u0003\u000fA\u0011\"a\b\u0001\u0001\u0004%I!!\t\t\u0013\u0005M\u0002\u00011A\u0005\n\u0005U\u0002\u0002CA\u001e\u0001\u0001\u0006K!a\t\t\u0013\u0005u\u0002\u00011A\u0005\n\u0005\u0005\u0002\"CA \u0001\u0001\u0007I\u0011BA!\u0011!\t)\u0005\u0001Q!\n\u0005\r\u0002\"CA$\u0001\t\u0007I\u0011BA%\u0011!\t\t\u0006\u0001Q\u0001\n\u0005-\u0003bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\t\u0003g\u0002A\u0011A\u0015\u0002v!A\u0011Q\u0010\u0001\u0005\u0002%\ny\bC\u0004\u00028\u0002!\t!!/\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u0014\u0001\u0011%!\u0011\u0006\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0013B\u0001Ba\u0013\u0001\t\u0003I#Q\n\u0005\b\u0005k\u0002A\u0011\u0002B<\u0011\u001d\u0011\t\t\u0001C\u0001\u0005\u0007CqA!!\u0001\t\u0013\u0011\u0019\nC\u0004\u0003$\u0002!IA!*\t\u000f\tm\u0006\u0001\"\u0001\u0003>\"9!q\u001d\u0001\u0005\n\t%\bb\u0002B\u0000\u0001\u0011\u00051\u0011\u0001\u0005\b\u0007\u001b\u0001A\u0011AB\b\u0005\u001d\u0019E.Z1oKJT!AK\u0016\u0002\u00071|wMC\u0001-\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00186!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fMB\u0011a'O\u0007\u0002o)\u0011\u0001hK\u0001\u0006kRLGn]\u0005\u0003u]\u0012q\u0001T8hO&tw-\u0001\u0002jIV\tQ\b\u0005\u00021}%\u0011q(\r\u0002\u0004\u0013:$\u0018aA5eA\u0005IqN\u001a4tKRl\u0015\r]\u000b\u0002\u0007B\u0011AiT\u0007\u0002\u000b*\u0011!F\u0012\u0006\u0003\u000f\"\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005%S\u0015aB:u_J\fw-\u001a\u0006\u0003Y-S!\u0001T'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0015aA8sO&\u0011\u0001+\u0012\u0002\n\u001f\u001a47/\u001a;NCB\f!b\u001c4gg\u0016$X*\u00199!\u00031IwNQ;gM\u0016\u00148+\u001b>f\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0017a\u00053va\n+hMZ3s\u0019>\fGMR1di>\u0014\bC\u0001\u0019W\u0013\t9\u0016G\u0001\u0004E_V\u0014G.Z\u0001\ni\"\u0014x\u000e\u001e;mKJ\u0004\"A\u0017/\u000e\u0003mS!\u0001\u000f$\n\u0005u[&!\u0003+ie>$H\u000f\\3s\u0003\u0011!\u0018.\\3\u0011\u0005\u0001$W\"A1\u000b\u0005a\u0012'BA2K\u0003\u0019\u0019w.\\7p]&\u0011Q-\u0019\u0002\u0005)&lW-A\u0005dQ\u0016\u001c7\u000eR8oKB!\u0001\u0007\u001b6o\u0013\tI\u0017GA\u0005Gk:\u001cG/[8ocA\u00111\u000e\\\u0007\u0002E&\u0011QN\u0019\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\t\u0001t.\u0003\u0002qc\t!QK\\5u\u00039\u0019G.Z1oKJlU\r\u001e:jGN\u0004\"a\u001d;\u000e\u0003%J!!^\u0015\u0003#1{wm\u00117fC:,'/T3ue&\u001c7/\u0001\u0004=S:LGO\u0010\u000b\rqfT8\u0010`?\u007f\u007f\u0006\u0005\u00111\u0001\t\u0003g\u0002AQa\u000f\u0007A\u0002uBQ!\u0011\u0007A\u0002\rCQA\u0015\u0007A\u0002uBQa\u0015\u0007A\u0002uBQ\u0001\u0016\u0007A\u0002UCQ\u0001\u0017\u0007A\u0002eCQA\u0018\u0007A\u0002}CQA\u001a\u0007A\u0002\u001dDQ!\u001d\u0007A\u0002I\f!\u0002\\8hO\u0016\u0014h*Y7f+\t\tI\u0001\u0005\u0003\u0002\f\u0005ea\u0002BA\u0007\u0003+\u00012!a\u00042\u001b\t\t\tBC\u0002\u0002\u00145\na\u0001\u0010:p_Rt\u0014bAA\fc\u00051\u0001K]3eK\u001aLA!a\u0007\u0002\u001e\t11\u000b\u001e:j]\u001eT1!a\u00062\u0003)\u0011X-\u00193Ck\u001a4WM]\u000b\u0003\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0002oS>T!!!\f\u0002\t)\fg/Y\u0005\u0005\u0003c\t9C\u0001\u0006CsR,')\u001e4gKJ\faB]3bI\n+hMZ3s?\u0012*\u0017\u000fF\u0002o\u0003oA\u0011\"!\u000f\u0010\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'A\u0006sK\u0006$')\u001e4gKJ\u0004\u0013aC<sSR,')\u001e4gKJ\fqb\u001e:ji\u0016\u0014UO\u001a4fe~#S-\u001d\u000b\u0004]\u0006\r\u0003\"CA\u001d%\u0005\u0005\t\u0019AA\u0012\u000319(/\u001b;f\u0005V4g-\u001a:!\u0003m!WmY8naJ,7o]5p]\n+hMZ3s'V\u0004\b\u000f\\5feV\u0011\u00111\n\t\u0004A\u00065\u0013bAA(C\nq!)\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001\b3fG>l\u0007O]3tg&|gNQ;gM\u0016\u00148+\u001e9qY&,'\u000fI\u0001\u0006G2,\u0017M\u001c\u000b\u0005\u0003/\nI\u0007E\u00041\u00033\ni&a\u0019\n\u0007\u0005m\u0013G\u0001\u0004UkBdWM\r\t\u0004a\u0005}\u0013bAA1c\t!Aj\u001c8h!\r\u0019\u0018QM\u0005\u0004\u0003OJ#\u0001D\"mK\u0006tWM]*uCR\u001c\bbBA6-\u0001\u0007\u0011QN\u0001\nG2,\u0017M\\1cY\u0016\u00042a]A8\u0013\r\t\t(\u000b\u0002\f\u00072,\u0017M\u001c)be\u0006l7/A\u0004e_\u000ecW-\u00198\u0015\r\u0005]\u0013qOA=\u0011\u001d\tYg\u0006a\u0001\u0003[Bq!a\u001f\u0018\u0001\u0004\ti&A\u0006dkJ\u0014XM\u001c;US6,\u0017!D2mK\u0006t7+Z4nK:$8\u000fF\bo\u0003\u0003\u000bI)a(\u0002$\u0006\u0015\u0016\u0011VAZ\u0011\u0019Q\u0003\u00041\u0001\u0002\u0004B\u00191/!\"\n\u0007\u0005\u001d\u0015FA\u0006BEN$(/Y2u\u0019><\u0007bBAF1\u0001\u0007\u0011QR\u0001\tg\u0016<W.\u001a8ugB1\u0011qRAK\u00033k!!!%\u000b\u0007\u0005M\u0015'\u0001\u0006d_2dWm\u0019;j_:LA!a&\u0002\u0012\n\u00191+Z9\u0011\u0007\u0011\u000bY*C\u0002\u0002\u001e\u0016\u0013!\u0002T8h'\u0016<W.\u001a8u\u0011\u0019\t\t\u000b\u0007a\u0001\u0007\u0006\u0019Q.\u00199\t\u000f\u0005m\u0004\u00041\u0001\u0002^!9\u0011q\u0015\rA\u0002\u0005\r\u0014!B:uCR\u001c\bbBAV1\u0001\u0007\u0011QV\u0001\u0014iJ\fgn]1di&|g.T3uC\u0012\fG/\u0019\t\u0004g\u0006=\u0016bAAYS\tQ2\t\\3b]\u0016$GK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\"9\u0011Q\u0017\rA\u0002\u0005u\u0013!\u00067fO\u0006\u001c\u0017\u0010R3mKR,\u0007j\u001c:ju>tWj]\u0001\nG2,\u0017M\\%oi>$\u0012D\\A^\u0003\u007f\u000bI-!4\u0002P\u0006e\u0017Q\\Aq\u0003G\f\u00190!>\u0002x\"1\u0011QX\rA\u0002)\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002Bf\u0001\r!a1\u0002\rM|WO]2f!\r\u0019\u0018QY\u0005\u0004\u0003\u000fL#!\u0006'pON+w-\\3oiJ+\u0017\rZ!eCB$XM\u001d\u0005\b\u0003\u0017L\u0002\u0019AAM\u0003\u0011!Wm\u001d;\t\r\u0005\u0005\u0016\u00041\u0001D\u0011\u001d\t\t.\u0007a\u0001\u0003'\f\u0001E]3uC&tG*Z4bGf$U\r\\3uKN\fe\u000e\u001a+y]6\u000b'o[3sgB\u0019\u0001'!6\n\u0007\u0005]\u0017GA\u0004C_>dW-\u00198\t\u000f\u0005m\u0017\u00041\u0001\u0002^\u0005\tB-\u001a7fi\u0016\u0014V\r^3oi&|g.T:\t\r\u0005}\u0017\u00041\u0001>\u0003Ei\u0017\r\u001f'pO6+7o]1hKNK'0\u001a\u0005\b\u0003WK\u0002\u0019AAW\u0011\u001d\t)/\u0007a\u0001\u0003O\fA\u0004\\1tiJ+7m\u001c:eg>3\u0017i\u0019;jm\u0016\u0004&o\u001c3vG\u0016\u00148\u000f\u0005\u0005\u0002\u0010\u0006%\u0018QLAw\u0013\u0011\tY/!%\u0003\u00075\u000b\u0007\u000fE\u0002E\u0003_L1!!=F\u0005)a\u0015m\u001d;SK\u000e|'\u000f\u001a\u0005\b\u0003OK\u0002\u0019AA2\u0011\u001d\tY(\u0007a\u0001\u0003;Bq!!?\u001a\u0001\u0004\t\u0019.\u0001\rwC2LG-\u0019;f'>,(oY3US6,7\u000f^1naN\f\u0011c\u001a:po\n+hMZ3sg>\u0013h)Y5m)%q\u0017q B\u0001\u0005\u000b\u00119\u0001C\u0004\u0002Bj\u0001\r!a1\t\r\t\r!\u00041\u0001>\u0003!\u0001xn]5uS>t\u0007BBAp5\u0001\u0007Q\bC\u0004\u0003\ni\u0001\rAa\u0003\u0002\u001b5,Wn\u001c:z%\u0016\u001cwN\u001d3t!\u0011\u0011iAa\u0005\u000e\u0005\t=!b\u0001B\tE\u00061!/Z2pe\u0012LAA!\u0006\u0003\u0010\tiQ*Z7pef\u0014VmY8sIN\f!c\u001d5pk2$G)[:dCJ$')\u0019;dQR1\u00111\u001bB\u000e\u0005KAqA!\b\u001c\u0001\u0004\u0011y\"A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0003\u000e\t\u0005\u0012\u0002\u0002B\u0012\u0005\u001f\u00111BU3d_J$')\u0019;dQ\"9\u00111V\u000eA\u0002\u00055\u0016AE:i_VdGMU3uC&t'+Z2pe\u0012$\u0002#a5\u0003,\t5\"\u0011\u0007B\u001a\u0005w\u0011iDa\u0010\t\r\u0005\u0005F\u00041\u0001D\u0011\u001d\u0011y\u0003\ba\u0001\u0003'\fQD]3uC&tG)\u001a7fi\u0016\u001chi\u001c:MK\u001e\f7-\u001f*fG>\u0014Hm\u001d\u0005\b\u0005;a\u0002\u0019\u0001B\u0010\u0011\u001d\u0011\t\u0002\ba\u0001\u0005k\u0001BA!\u0004\u00038%!!\u0011\bB\b\u0005\u0019\u0011VmY8sI\"9\u0011q\u0015\u000fA\u0002\u0005\r\u0004bBA>9\u0001\u0007\u0011Q\f\u0005\b\u00037d\u0002\u0019AA/\u0003-9'o\\<Ck\u001a4WM]:\u0015\u00079\u0014)\u0005\u0003\u0004\u0002`v\u0001\r!P\u0001\u000fe\u0016\u001cHo\u001c:f\u0005V4g-\u001a:t)\u0005q\u0017aE4s_V\u00048+Z4nK:$8OQ=TSj,GC\u0003B(\u0005C\u0012IG!\u001c\u0003rA1!\u0011\u000bB.\u0003\u001bsAAa\u0015\u0003X9!\u0011q\u0002B+\u0013\u0005\u0011\u0014b\u0001B-c\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B/\u0005?\u0012A\u0001T5ti*\u0019!\u0011L\u0019\t\u000f\u0005-u\u00041\u0001\u0003dA1\u0011q\u0012B3\u00033KAAa\u001a\u0002\u0012\nA\u0011\n^3sC\ndW\r\u0003\u0004\u0003l}\u0001\r!P\u0001\b[\u0006D8+\u001b>f\u0011\u0019\u0011yg\ba\u0001{\u0005aQ.\u0019=J]\u0012,\u0007pU5{K\"9!1O\u0010A\u0002\u0005u\u0013A\u00064jeN$XK\\2mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;\u000231\f7\u000f^(gMN,GOR8s\r&\u00148\u000f^*fO6,g\u000e\u001e\u000b\u0007\u0003;\u0012IHa \t\u000f\tm\u0004\u00051\u0001\u0003~\u0005!1/Z4t!\u0019\u0011\tFa\u0017\u0002\u001a\"9!1\u000f\u0011A\u0002\u0005u\u0013A\u00042vS2$wJ\u001a4tKRl\u0015\r\u001d\u000b\r\u0003'\u0014)Ia\"\u0003\f\n=%\u0011\u0013\u0005\u0007U\u0005\u0002\r!a!\t\u000f\t%\u0015\u00051\u0001\u0002^\u0005)1\u000f^1si\"9!QR\u0011A\u0002\u0005u\u0013aA3oI\"1\u0011\u0011U\u0011A\u0002\rCq!a*\"\u0001\u0004\t\u0019\u0007\u0006\b\u0002T\nU%q\u0013BN\u0005;\u0013yJ!)\t\r)\u0012\u0003\u0019AAB\u0011\u001d\tYI\ta\u0001\u00053\u0003b!a$\u0003f\u0005\r\u0007b\u0002BEE\u0001\u0007\u0011Q\f\u0005\b\u0005\u001b\u0013\u0003\u0019AA/\u0011\u0019\t\tK\ta\u0001\u0007\"9\u0011q\u0015\u0012A\u0002\u0005\r\u0014\u0001\u00072vS2$wJ\u001a4tKRl\u0015\r\u001d$peN+w-\\3oiR\u0011\u00121\u001bBT\u0005S\u0013YK!,\u00032\nU&q\u0017B]\u0011\u0019\til\ta\u0001U\"9\u0011\u0011Y\u0012A\u0002\u0005\r\u0007BBAQG\u0001\u00071\tC\u0004\u00030\u000e\u0002\r!!\u0018\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0005g\u001b\u0003\u0019AA/\u0003A)\b\u000f]3s\u0005>,h\u000eZ(gMN,G\u000f\u0003\u0004\u0002`\u000e\u0002\r!\u0010\u0005\b\u0003W\u001b\u0003\u0019AAW\u0011\u001d\t9k\ta\u0001\u0003G\n1B^1mS\u0012\fG/\u001a'pORa!q\u0018Bk\u0005/\u0014INa7\u0003fB!!\u0011\u0019Bh\u001d\u0011\u0011\u0019Ma3\u000f\t\t\u0015'\u0011\u001a\b\u0005\u0003\u001f\u00119-C\u0001-\u0013\tQ3&C\u0002\u0003N&\n\u0011CV1mS\u0012\fG/\u001a'pOJ+7/\u001e7u\u0013\u0011\u0011\tNa5\u0003#Y\u000bG.\u001b3bi\u0016dun\u001a*fgVdGOC\u0002\u0003N&BaA\u000b\u0013A\u0002\u0005\r\u0005b\u0002BEI\u0001\u0007\u0011Q\f\u0005\b\u0005\u001b#\u0003\u0019AA/\u0011\u001d\u0011i\u000e\na\u0001\u0005?\fQBY1tK>3gm]3u\u001b\u0006\u0004\bc\u0001#\u0003b&\u0019!1]#\u0003#\u0015CH/\u001a8eK\u0012|eMZ:fi6\u000b\u0007\u000fC\u0004\u0002(\u0012\u0002\r!a\u0019\u0002%Y\fG.\u001b3bi\u0016dunZ*fO6,g\u000e\u001e\u000b\u0013\u0003;\u0012YO!<\u0003p\nM(q\u001fB}\u0005w\u0014i\u0010\u0003\u0004\u0002>\u0016\u0002\rA\u001b\u0005\b\u0003\u0003,\u0003\u0019AAb\u0011\u001d\u0011\t0\na\u0001\u0005?\fqAY1tK6\u000b\u0007\u000fC\u0004\u0003v\u0016\u0002\rAa8\u0002\u000f\u0011LgMZ'ba\"9!qV\u0013A\u0002\u0005u\u0003BBApK\u0001\u0007Q\bC\u0004\u0002,\u0016\u0002\r!!,\t\u000f\u0005\u001dV\u00051\u0001\u0002d\u0005YAn\\4TK\u001elWM\u001c;t)!\u0011Ija\u0001\u0004\u0006\r%\u0001B\u0002\u0016'\u0001\u0004\t\u0019\tC\u0004\u0004\b\u0019\u0002\r!!\u0018\u0002\t\u0019\u0014x.\u001c\u0005\b\u0007\u00171\u0003\u0019AA/\u0003\t!x.\u0001\u000ed_2dWm\u0019;BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7\u000f\u0006\u0005\u0004\u0012\re11DB\u000f!\u0019\u0011\tFa\u0017\u0004\u0014A\u0019Ai!\u0006\n\u0007\r]QI\u0001\u0006BE>\u0014H/\u001a3Uq:DaAK\u0014A\u0002\u0005\r\u0005b\u0002BEO\u0001\u0007\u0011Q\f\u0005\b\u0005\u001b;\u0003\u0019AA/\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private final LogCleanerMetrics cleanerMetrics;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, CleanerStats> clean(CleanParams cleanable) {
        void var3_3;
        void var5_4;
        if (cleanable.firstDirtyOffset() >= cleanable.firstUncleanableOffset()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(103).append("Skip cleaning for log ").append(cleanable.log().name()).append(" because dirty range is not cleanable. ").append("firstDirtyOffset=").append(cleanable.firstDirtyOffset()).append(", firstUncleanableOffset=").append(cleanable.firstUncleanableOffset()).toString());
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)cleanable.firstDirtyOffset()), (Object)new CleanerStats(this.time, this.cleanerMetrics));
        }
        Tuple2<Object, CleanerStats> tuple2 = this.doClean(cleanable, this.time.milliseconds());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        CleanerStats cleanerStats = (CleanerStats)tuple2._2();
        double bytesShrinkageRatio = 1.0 - (double)var5_4.bytesWritten() / (double)var5_4.bytesRead();
        cleanable.log().updateLastShrinkageRatio(bytesShrinkageRatio);
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)var3_3), (Object)var5_4);
    }

    public Tuple2<Object, CleanerStats> doClean(CleanParams cleanable, long currentTime) {
        long l;
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Beginning cleaning of log %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Option option = CollectionConverters$.MODULE$.CollectionHasAsScala(cleanable.log().localLogSegments(0L, cleanable.firstDirtyOffset())).asScala().lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - cleanable.log().config().deleteRetentionMs;
        } else {
            throw new MatchError((Object)option);
        }
        long legacyDeleteHorizonMs = l;
        AbstractLog log = cleanable.log();
        CleanerStats stats = new CleanerStats(this.time, this.cleanerMetrics);
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Building offset map for %s..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        boolean isOffsetMapFull = this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone(isOffsetMapFull);
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments(0L, cleanable.firstUncleanableOffset())).asScala().lastOption().map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(legacyDeleteHorizonMs)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        this.groupSegmentsBySize((Iterable<LogSegment>)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments(cleanable.startOffset(), endOffset)).asScala(), log.config().segmentSize, log.config().maxIndexSize, cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), currentTime, stats, transactionMetadata, legacyDeleteHorizonMs);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    /*
     * WARNING - void declaration
     */
    public void cleanSegments(AbstractLog log, Seq<LogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs) {
        void createNewCleanedSegment_baseOffset;
        void createNewCleanedSegment_logConfig;
        long l = ((LogSegment)segments.head()).baseOffset();
        LogConfig logConfig = log.config();
        File createNewCleanedSegment_dir = log.dir();
        Object var28_10 = null;
        logConfig = null;
        LogSegment cleaned = LocalLog$.MODULE$.createNewCleanedSegment(createNewCleanedSegment_dir, (LogConfig)createNewCleanedSegment_logConfig, (long)createNewCleanedSegment_baseOffset, false, ChecksumParams.EMPTY);
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToLong((long)x$21.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> currentSegment.readNextOffset()));
                List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainLegacyDeletesAndTxnMarkers = currentSegment.lastModified() > legacyDeleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(120).append("Cleaning ").append(currentSegment).append(" in log ").append(log.name()).append(" into ").append(cleaned.baseOffset()).append(" ").append("with an upper bound deletion horizon ").append(legacyDeleteHorizonMs).append(" computed from ").append("the segment last modified time of ").append(currentSegment.lastModified()).append(",").append((Object)(retainLegacyDeletesAndTxnMarkers ? "retaining" : "discarding")).append(" deletes.").toString());
                try {
                    LocalLogSegmentReadAdapter segmentAdapter = new LocalLogSegmentReadAdapter(log, currentSegment);
                    this.cleanInto(log.topicPartition(), segmentAdapter, cleaned, map, retainLegacyDeletesAndTxnMarkers, log.config().deleteRetentionMs, log.config().maxMessageSize(), transactionMetadata, lastOffsetOfActiveProducers, stats, currentTime, log.config().confluentLogConfig().logCleanerTimestampValidationEnable);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.setLastModified(modified);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments);
            return;
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            catch (Throwable throwable) {
                throw e;
            }
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, LogSegmentReadAdapter source, LogSegment dest, OffsetMap map, boolean retainLegacyDeletesAndTxnMarkers, long deleteRetentionMs, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers, CleanerStats stats, long currentTime, boolean validateSourceTimestamps) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, currentTime, deleteRetentionMs, transactionMetadata, lastRecordsOfActiveProducers, map, retainLegacyDeletesAndTxnMarkers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final OffsetMap map$1;
            private final boolean retainLegacyDeletesAndTxnMarkers$2;
            private final CleanerStats stats$3;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                boolean canDiscardBatch = this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2);
                if (batch.isControlBatch()) {
                    if (batch.deleteHorizonMs().isPresent()) {
                        this.discardBatchRecords_$eq(canDiscardBatch && batch.deleteHorizonMs().getAsLong() <= this.currentTime);
                    } else {
                        this.discardBatchRecords_$eq(canDiscardBatch && this.deleteRetentionMs == 0L);
                    }
                } else {
                    this.discardBatchRecords_$eq(canDiscardBatch);
                }
                MemoryRecords.RecordFilter.BatchRetention batchRetention = batch.hasProducerId() && this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch.producerId())).exists((Function1 & Serializable)lastRecord -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$checkBatchRetention$1(batch, lastRecord))) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
                return new MemoryRecords.RecordFilter.BatchRetentionResult(batchRetention, canDiscardBatch && batch.isControlBatch());
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                if (this.discardBatchRecords()) {
                    return false;
                }
                if (batch.isControlBatch()) {
                    return true;
                }
                return this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$1, this.retainLegacyDeletesAndTxnMarkers$2, batch, record, this.stats$3, this.currentTime, this.deleteRetentionMs);
            }

            public void onBatchRetained(RecordBatch batch) {
                this.transactionMetadata$2.onBatchRetained(batch);
            }

            public static final /* synthetic */ boolean $anonfun$checkBatchRetention$1(RecordBatch batch$1, LastRecord lastRecord) {
                if (lastRecord.lastDataOffset.isPresent()) {
                    return batch$1.lastOffset() == lastRecord.lastDataOffset.getAsLong();
                }
                return batch$1.isControlBatch() && batch$1.producerEpoch() == lastRecord.producerEpoch && batch$1.maxTimestamp() >= lastRecord.lastTimestampMs;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.map$1 = map$1;
                this.retainLegacyDeletesAndTxnMarkers$2 = retainLegacyDeletesAndTxnMarkers$2;
                this.stats$3 = stats$3;
                super(currentTime$2, deleteRetentionMs$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkBatchRetention$1$adapted(org.apache.kafka.common.record.RecordBatch org.apache.kafka.storage.internals.log.LastRecord )}, serializedLambda);
            }
        };
        int position = source.startPosition();
        while (position < source.endPosition()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            source.readBytes(this.readBuffer(), position);
            ByteBuffer readableRecords_buffer = this.readBuffer();
            Object var21_19 = null;
            MemoryRecords records = new MemoryRecords(readableRecords_buffer);
            stats.recordThrottledTime(this.throttler.maybeThrottle((double)records.sizeInBytes()));
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier(), validateSourceTimestamps);
            stats.readMessages(result.messagesRead(), result.bytesRead(), result.keyBytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = new MemoryRecords(outputBuffer);
                dest.append(result.maxOffset(), retained);
                stats.recordThrottledTime(this.throttler.maybeThrottle((double)outputBuffer.limit()));
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(source, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(LogSegmentReadAdapter source, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(13).append(source).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            int bytesLeft = source.endPosition() - position;
            if (Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata) {
        if (batch.isControlBatch()) {
            return transactionMetadata.onControlBatchRead(batch);
        }
        return transactionMetadata.onBatchRead(batch);
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletesForLegacyRecords, RecordBatch batch, Record record, CleanerStats stats, long currentTime, long deleteRetentionMs) {
        if (record.offset() > map.latestOffset()) {
            return true;
        }
        if (record.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record.offset() >= foundOffset;
            boolean legacyRecord = batch.magic() < 2;
            boolean bl = isRetainedValue = record.hasValue() || Cleaner.shouldRetainDeletes$1(legacyRecord, deleteRetentionMs, batch, currentTime, retainDeletesForLegacyRecords);
            return latestOffsetForKey && isRetainedValue;
        }
        stats.invalidMessage();
        return false;
    }

    private void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    private void restoreBuffers() {
        if (this.readBuffer().capacity() > this.ioBufferSize) {
            this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
            return;
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && (((LogSegment)segs.head()).size() == 0 || this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE)) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        if (segs.size() > 1) {
            return ((LogSegment)segs.apply(1)).baseOffset() - 1L;
        }
        return firstUncleanableOffset - 1L;
    }

    public boolean buildOffsetMap(AbstractLog log, long start, long end, OffsetMap map, CleanerStats stats) {
        Iterable<LogSegmentReadAdapter> dirty = this.logSegments(log, start, end);
        return this.buildOffsetMap(log, dirty, start, end, map, stats);
    }

    private boolean buildOffsetMap(AbstractLog log, Iterable<LogSegmentReadAdapter> segments, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = segments.toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableOnceOps)dirty.tail()).foreach((Function1 & Serializable)nextSegment -> (ListBuffer)nextSegmentStartOffsets.append((Object)BoxesRunTime.boxToLong((long)nextSegment.baseOffset())));
            nextSegmentStartOffsets.append((Object)BoxesRunTime.boxToLong((long)end));
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d)."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        IntRef mappedSegmentCount = IntRef.create((int)0);
        ((IterableOps)dirty.zip((IterableOnce)nextSegmentStartOffsets)).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$3(check$ifrefutable$1))).withFilter((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$4(full, x$23))).foreach((Function1 & Serializable)x$24 -> {
            Cleaner.$anonfun$buildOffsetMap$5(this, log, mappedSegmentCount, dirty, full, map, start, transactionMetadata, stats, x$24);
            return BoxedUnit.UNIT;
        });
        return full.elem;
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegmentReadAdapter source, OffsetMap map, long startOffset, long upperBoundOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int position = source.startPosition();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < source.endPosition() && map.latestOffset() < upperBoundOffset - 1L) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                source.readBytes(this.readBuffer(), position);
                ByteBuffer readableRecords_buffer = this.readBuffer();
                Object var22_18 = null;
                MemoryRecords records = new MemoryRecords(readableRecords_buffer);
                stats.recordThrottledTime(this.throttler.maybeThrottle((double)records.sizeInBytes()));
                int startPosition = position;
                java.util.Iterator batchIter = records.batches().iterator();
                while (batchIter.hasNext() && map.latestOffset() < upperBoundOffset - 1L) {
                    MutableRecordBatch batch = (MutableRecordBatch)batchIter.next();
                    if (batch.isControlBatch()) {
                        transactionMetadata.onControlBatchRead((RecordBatch)batch);
                        stats.indexMessagesRead(1);
                    } else if (transactionMetadata.onBatchRead((RecordBatch)batch)) {
                        stats.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                    } else {
                        try (CloseableIterator recordsIterator = batch.streamingIterator(this.decompressionBufferSupplier());){
                            CollectionConverters$.MODULE$.IteratorHasAsScala((java.util.Iterator)recordsIterator).asScala().foreach((Function1 & Serializable)record -> {
                                Cleaner.$anonfun$buildOffsetMapForSegment$1(startOffset, map, maxDesiredMapSize, object, stats, record);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }
                    if (batch.lastOffset() < startOffset) continue;
                    map.updateLatestOffset(batch.lastOffset());
                }
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(source, position, maxLogMessageSize, records);
            }
            map.updateLatestOffset(upperBoundOffset - 1L);
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public Enumeration.Value validateLog(AbstractLog log, long start, long end, ExtendedOffsetMap baseOffsetMap, CleanerStats stats) {
        this.offsetMap().clear();
        ExtendedOffsetMap diffOffsetMap = new ExtendedOffsetMap(this.offsetMap());
        Iterable<LogSegmentReadAdapter> segments = this.logSegments(log, start, end);
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        LongRef totalValidatedCount = LongRef.create((long)0L);
        LongRef validatedCount = LongRef.create((long)0L);
        segments.withFilter((Function1 & Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$validateLog$1(validatedCount, segment))).foreach((Function1 & Serializable)segment -> {
            Cleaner.$anonfun$validateLog$2(this, validatedCount, log, baseOffsetMap, diffOffsetMap, start, transactionMetadata, stats, totalValidatedCount, segment);
            return BoxedUnit.UNIT;
        });
        if (validatedCount.elem < 0L) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(166).append(log.topicPartition()).append(": log validation terminated prematurely because diff offset map is full.").append("baseOffsetMap.size: ").append(baseOffsetMap.size()).append(", diffOffsetMap.size=").append(diffOffsetMap.size()).append(", diffOffsetMap.tombstoneCount=").append(diffOffsetMap.tombstoneCount()).append(". ").append("found record count: ").append(totalValidatedCount$1.elem).toString());
            return ValidateLogResult$.MODULE$.Aborted();
        }
        if (totalValidatedCount.elem != (long)(baseOffsetMap.size() - baseOffsetMap.tombstoneCount()) || diffOffsetMap.size() != diffOffsetMap.tombstoneCount()) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(215).append(log.topicPartition()).append(": log validation failed. Log data in offset range [").append(start).append(", ").append(end).append(") is inconsistent with baseOffsetMap.").append("baseOffsetMap.size: ").append(baseOffsetMap.size()).append(", baseOffsetMap.tombstoneCount=").append(baseOffsetMap.tombstoneCount()).append(". ").append("diffOffsetMap.size=").append(diffOffsetMap.size()).append(", diffOffsetMap.tombstoneCount=").append(diffOffsetMap.tombstoneCount()).append(". ").append("found record count: ").append(totalValidatedCount$1.elem).toString());
            return ValidateLogResult$.MODULE$.Failed();
        }
        return ValidateLogResult$.MODULE$.Passed();
    }

    private long validateLogSegment(TopicPartition topicPartition, LogSegmentReadAdapter source, ExtendedOffsetMap baseMap, ExtendedOffsetMap diffMap, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int diffMapMaxSize = (int)((double)diffMap.slots() * this.dupBufferLoadFactor);
            IntRef validatedRecordCount = IntRef.create((int)0);
            int position = source.startPosition();
            while (position < source.endPosition()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                source.readBytes(this.readBuffer(), position);
                ByteBuffer readableRecords_buffer = this.readBuffer();
                Object var18_16 = null;
                MemoryRecords records = new MemoryRecords(readableRecords_buffer);
                stats.recordThrottledTime(this.throttler.maybeThrottle((double)records.sizeInBytes()));
                int startPosition = position;
                CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    Cleaner.$anonfun$validateLogSegment$1(this, transactionMetadata, stats, startOffset, baseMap, diffMap, diffMapMaxSize, object, validatedRecordCount, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(source, position, maxLogMessageSize, records);
            }
            this.restoreBuffers();
            return validatedRecordCount.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcJ$sp();
            }
            throw ex;
        }
    }

    public Iterable<LogSegmentReadAdapter> logSegments(AbstractLog log, long from, long to) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localLogSegments(from, to)).asScala().map((Function1 & Serializable)x$25 -> new LocalLogSegmentReadAdapter(log, (LogSegment)x$25))).dropWhile((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$logSegments$2(from, x)));
    }

    public List<AbortedTxn> collectAbortedTransactions(AbstractLog log, long start, long end) {
        return log.collectAbortedTransactions(start, end, false);
    }

    private static final boolean shouldRetainDeletes$1(boolean legacyRecord$1, long deleteRetentionMs$2, RecordBatch batch$2, long currentTime$3, boolean retainDeletesForLegacyRecords$1) {
        if (!legacyRecord$1) {
            if (deleteRetentionMs$2 != 0L) {
                return !batch$2.deleteHorizonMs().isPresent() || currentTime$3 < batch$2.deleteHorizonMs().getAsLong();
            }
            return false;
        }
        return retainDeletesForLegacyRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$4(BooleanRef full$1, Tuple2 x$23) {
        if (x$23 != null) {
            return !full$1.elem;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$5(Cleaner $this, AbstractLog log$4, IntRef mappedSegmentCount$1, Buffer dirty$1, BooleanRef full$1, OffsetMap map$2, long start$1, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$4, Tuple2 x$24) {
        if (x$24 != null) {
            LogSegmentReadAdapter segment = (LogSegmentReadAdapter)x$24._1();
            long nextSegmentStartOffset = x$24._2$mcJ$sp();
            $this.checkDone.apply((Object)log$4.topicPartition());
            if (segment.endOffset() < log$4.logStartOffset() && segment.baseOffset() < log$4.logStartOffset()) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(111).append("End offset of segment: ").append(segment).append(" is smaller than log start offset ").append(log$4.logStartOffset()).append(". Abort current cleaning operation and will be retried").toString());
                throw new LogCleaningAbortedException();
            }
            ++mappedSegmentCount$1.elem;
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Building offset map for segment ").append(mappedSegmentCount$1.elem).append("/").append(dirty$1.size()).append(": ").append(segment).toString());
            full$1.elem = $this.buildOffsetMapForSegment(log$4.topicPartition(), segment, map$2, start$1, nextSegmentStartOffset, log$4.config().maxMessageSize(), transactionMetadata$3, stats$4);
            if (full$1.elem) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(mappedSegmentCount$1.elem - 1)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(long startOffset$1, OffsetMap map$3, int maxDesiredMapSize$1, Object nonLocalReturnKey2$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$1) {
            if (map$3.size() < maxDesiredMapSize$1) {
                map$3.put(record.key(), record.offset(), !record.hasValue());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ boolean $anonfun$validateLog$1(LongRef validatedCount$1, LogSegmentReadAdapter segment) {
        return validatedCount$1.elem >= 0L;
    }

    public static final /* synthetic */ void $anonfun$validateLog$2(Cleaner $this, LongRef validatedCount$1, AbstractLog log$5, ExtendedOffsetMap baseOffsetMap$1, ExtendedOffsetMap diffOffsetMap$1, long start$2, CleanedTransactionMetadata transactionMetadata$4, CleanerStats stats$6, LongRef totalValidatedCount$1, LogSegmentReadAdapter segment) {
        validatedCount$1.elem = $this.validateLogSegment(log$5.topicPartition(), segment, baseOffsetMap$1, diffOffsetMap$1, start$2, 0, transactionMetadata$4, stats$6);
        if (validatedCount$1.elem > 0L) {
            totalValidatedCount$1.elem += validatedCount$1.elem;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$validateLogSegment$2(long startOffset$2, ExtendedOffsetMap baseMap$1, ExtendedOffsetMap diffMap$1, int diffMapMaxSize$1, Object nonLocalReturnKey3$1, IntRef validatedRecordCount$1, CleanerStats stats$7, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$2) {
            long off = baseMap$1.get(record.key());
            if (off == -1L) {
                if (diffMap$1.size() >= diffMapMaxSize$1) throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey3$1, -1L);
                diffMap$1.put(record.key(), record.offset(), !record.hasValue());
            } else if (record.offset() >= off) {
                if (record.offset() == off) {
                    if (record.hasValue()) {
                        ++validatedRecordCount$1.elem;
                    }
                } else {
                    if (diffMap$1.size() >= diffMapMaxSize$1) throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey3$1, -1L);
                    diffMap$1.put(record.key(), record.offset(), !record.hasValue());
                }
            }
        }
        stats$7.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$validateLogSegment$1(Cleaner $this, CleanedTransactionMetadata transactionMetadata$5, CleanerStats stats$7, long startOffset$2, ExtendedOffsetMap baseMap$1, ExtendedOffsetMap diffMap$1, int diffMapMaxSize$1, Object nonLocalReturnKey3$1, IntRef validatedRecordCount$1, MutableRecordBatch batch) {
        if (batch.isControlBatch()) {
            transactionMetadata$5.onControlBatchRead((RecordBatch)batch);
            stats$7.indexMessagesRead(1);
            return;
        }
        if (transactionMetadata$5.onBatchRead((RecordBatch)batch)) {
            stats$7.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
            return;
        }
        try (CloseableIterator recordsIterator = batch.streamingIterator($this.decompressionBufferSupplier());){
            CollectionConverters$.MODULE$.IteratorHasAsScala((java.util.Iterator)recordsIterator).asScala().foreach((Function1 & Serializable)record -> {
                Cleaner.$anonfun$validateLogSegment$2(startOffset$2, baseMap$1, diffMap$1, diffMapMaxSize$1, nonLocalReturnKey3$1, validatedRecordCount$1, stats$7, record);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$logSegments$2(long from$1, LocalLogSegmentReadAdapter x) {
        return x.endOffset() < from$1;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone, LogCleanerMetrics cleanerMetrics) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.checkDone = checkDone;
        this.cleanerMetrics = cleanerMetrics;
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

