/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ThreadsCpuMeter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r-f\u0001\u0002+V\u0001iC\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\ty\u0002\u0011)\u0019!C\u0001{\"I\u0011\u0011\u0004\u0001\u0003\u0002\u0003\u0006IA \u0005\u000b\u00037\u0001!Q1A\u0005\u0002\u0005u\u0001BCA\u001d\u0001\t\u0005\t\u0015!\u0003\u0002 !Q\u00111\b\u0001\u0003\u0006\u0004%\t!!\u0010\t\u0015\u0005\u0015\u0003A!A!\u0002\u0013\ty\u0004\u0003\u0006\u0002H\u0001\u0011\t\u0011)A\u0005\u0003\u0013Bq!a\u0015\u0001\t\u0003\t)\u0006\u0003\u0006\u0002d\u0001\u0011\r\u0011\"\u0001V\u0003KB\u0001\"!\u001e\u0001A\u0003%\u0011q\r\u0005\n\u0003o\u0002\u0001\u0019!C\u0005\u0003sB\u0011\"a\u001f\u0001\u0001\u0004%I!! \t\u000f\u0005%\u0005\u0001)Q\u0005]\"I\u00111\u0013\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003;\u0003\u0001\u0015!\u0003\u0002\u0018\"I\u0011q\u0014\u0001A\u0002\u0013%\u0011\u0011\u0015\u0005\n\u0003_\u0003\u0001\u0019!C\u0005\u0003cC\u0001\"!.\u0001A\u0003&\u00111\u0015\u0005\n\u0003o\u0003!\u0019!C\u0005\u0003sC\u0001\"!1\u0001A\u0003%\u00111\u0018\u0005\u000b\u0003\u0007\u0004!\u0019!C\u0001+\u0006\u0015\u0007\u0002CAi\u0001\u0001\u0006I!a2\t\u0015\u0005M\u0007A1A\u0005\u0002U\u000b)\u000e\u0003\u0005\u0003&\u0002\u0001\u000b\u0011BAl\u0011\u001d\u00119\u000b\u0001C\u0005\u0005SC\u0001Ba/\u0001\t\u0003)&Q\u0018\u0005\b\u0005\u007f\u0003A\u0011\u0001B.\u0011\u001d\u0011\t\r\u0001C\u0001\u00057BqAa1\u0001\t\u0003\u0011Y\u0006C\u0004\u0003F\u0002!\tEa2\t\u000f\t=\u0007\u0001\"\u0011\u0003R\"9!Q\u001c\u0001\u0005B\t}\u0007b\u0002Bt\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005[\u0004A\u0011\u0001Bx\u0011%\u0011Y\u0010AI\u0001\n\u0003\u0011i\u0010C\u0004\u0004\u0014\u0001!\ta!\u0006\t\u000f\r\u0005\u0002\u0001\"\u0001\u0004$!91\u0011\u0006\u0001\u0005\u0002\r-\u0002bBB\u001b\u0001\u0011\u00051q\u0007\u0005\b\u0007w\u0001A\u0011AB\u001f\u0011\u001d\u0019I\u0005\u0001C\u0001\u0007\u0017B\u0011b!\u0016\u0001#\u0003%\taa\u0016\t\u000f\rm\u0003\u0001\"\u0001\u0004^!A1q\r\u0001\u0005\u0002]\u000bI\b\u0003\u0005\u0004j\u0001!\t!\u0016B_\r\u001d\t9\u000f\u0001\u0001V\u0003SD!\"a>0\u0005\u0003\u0005\u000b\u0011BA}\u0011\u001d\t\u0019f\fC\u0001\u0003\u007fDqAa\u00010\t#\u0012)\u0001C\u0005\u0003\u001e=\u0012\r\u0011\"\u0001\u0003 !A!qE\u0018!\u0002\u0013\u0011\t\u0003C\u0005\u0003*=\u0002\r\u0011\"\u0001\u0003,!I!1G\u0018A\u0002\u0013\u0005!Q\u0007\u0005\t\u0005sy\u0003\u0015)\u0003\u0003.!I!QH\u0018A\u0002\u0013\u0005!q\b\u0005\n\u0005\u000fz\u0003\u0019!C\u0001\u0005\u0013B\u0001B!\u00140A\u0003&!\u0011\t\u0005\b\u0005#zC\u0011\u0002B*\u0011\u001d\u0011If\fC!\u00057BqA!\u00180\t\u0013\u0011y\u0006C\u0004\u0003h=\"IAa\u0018\t\u000f\tet\u0006\"\u0003\u0003|!9!qQ\u0018\u0005\n\t%uaBB6+\"\u00051Q\u000e\u0004\u0007)VC\taa\u001c\t\u000f\u0005M#\t\"\u0001\u0004r!I11\u000f\"C\u0002\u0013\u0005!q\u0019\u0005\t\u0007k\u0012\u0005\u0015!\u0003\u0003J\"91q\u000f\"\u0005\u0002\re\u0004\"CB?\u0005\n\u0007I\u0011BB@\u0011!\u0019YI\u0011Q\u0001\n\r\u0005\u0005\"CBG\u0005\n\u0007I\u0011BB@\u0011!\u0019yI\u0011Q\u0001\n\r\u0005\u0005\"CBI\u0005\n\u0007I\u0011BB@\u0011!\u0019\u0019J\u0011Q\u0001\n\r\u0005\u0005\"CBK\u0005\n\u0007I\u0011BB@\u0011!\u00199J\u0011Q\u0001\n\r\u0005\u0005\"CBM\u0005\n\u0007I\u0011BB@\u0011!\u0019YJ\u0011Q\u0001\n\r\u0005\u0005BCBO\u0005\n\u0007I\u0011A+\u0004 \"A11\u0015\"!\u0002\u0013\u0019\t\u000bC\u0005\u0004&\n\u000b\n\u0011\"\u0001\u0004(\nQAj\\4DY\u0016\fg.\u001a:\u000b\u0005Y;\u0016a\u00017pO*\t\u0001,A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Y\u0016m\u001a\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t,W\"A2\u000b\u0005\u0011<\u0016!B;uS2\u001c\u0018B\u00014d\u0005\u001daunZ4j]\u001e\u0004\"\u0001[6\u000e\u0003%T!A[,\u0002\rM,'O^3s\u0013\ta\u0017N\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u0005=TX\"\u00019\u000b\u0005Y\u000b(B\u0001:t\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002uk\u000691\u000f^8sC\u001e,'B\u0001-w\u0015\t9\b0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0006\u0019qN]4\n\u0005m\u0004(!D\"mK\u0006tWM]\"p]\u001aLw-A\u0004m_\u001e$\u0015N]:\u0016\u0003y\u0004Ra`A\u0003\u0003\u0013i!!!\u0001\u000b\u0007\u0005\rQ,\u0001\u0006d_2dWm\u0019;j_:LA!a\u0002\u0002\u0002\t\u00191+Z9\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005\u0011\u0011n\u001c\u0006\u0003\u0003'\tAA[1wC&!\u0011qCA\u0007\u0005\u00111\u0015\u000e\\3\u0002\u00111|w\rR5sg\u0002\nA\u0001\\8hgV\u0011\u0011q\u0004\t\bE\u0006\u0005\u0012QEA\u0019\u0013\r\t\u0019c\u0019\u0002\u0005!>|G\u000e\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tY#^\u0001\u0007G>lWn\u001c8\n\t\u0005=\u0012\u0011\u0006\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0011\t\u0019$!\u000e\u000e\u0003UK1!a\u000eV\u0005-\t%m\u001d;sC\u000e$Hj\\4\u0002\u000b1|wm\u001d\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\t\ty\u0004E\u0002p\u0003\u0003J1!a\u0011q\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0013\u0001\u0002;j[\u0016\u0004B!a\u0013\u0002P5\u0011\u0011Q\n\u0006\u0004I\u0006%\u0012\u0002BA)\u0003\u001b\u0012A\u0001V5nK\u00061A(\u001b8jiz\"B\"a\u0016\u0002Z\u0005m\u0013QLA0\u0003C\u00022!a\r\u0001\u0011\u0015i\u0017\u00021\u0001o\u0011\u0015a\u0018\u00021\u0001\u007f\u0011\u001d\tY\"\u0003a\u0001\u0003?Aq!a\u000f\n\u0001\u0004\ty\u0004C\u0005\u0002H%\u0001\n\u00111\u0001\u0002J\u0005aQ.\u001a;sS\u000e\u001cxI]8vaV\u0011\u0011q\r\t\u0005\u0003S\n\t(\u0004\u0002\u0002l)!\u0011QNA8\u0003\u001diW\r\u001e:jGNT!A[;\n\t\u0005M\u00141\u000e\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018!D7fiJL7m]$s_V\u0004\b%\u0001\u0004d_:4\u0017nZ\u000b\u0002]\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\t\u0005}\u0014Q\u0011\t\u00049\u0006\u0005\u0015bAAB;\n!QK\\5u\u0011!\t9)DA\u0001\u0002\u0004q\u0017a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0003f\u0001\b\u0002\u000eB\u0019A,a$\n\u0007\u0005EUL\u0001\u0005w_2\fG/\u001b7f\u00039\u0019G.Z1oKJl\u0015M\\1hKJ,\"!a&\u0011\t\u0005M\u0012\u0011T\u0005\u0004\u00037+&!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe\u0006y1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\b%\u0001\nd_6\u0004\u0018m\u0019;j_:\u001c\u0005/^'fi\u0016\u0014XCAAR!\u0015a\u0016QUAU\u0013\r\t9+\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\t\fY+C\u0002\u0002.\u000e\u0014q\u0002\u00165sK\u0006$7o\u00119v\u001b\u0016$XM]\u0001\u0017G>l\u0007/Y2uS>t7\t];NKR,'o\u0018\u0013fcR!\u0011qPAZ\u0011%\t9IEA\u0001\u0002\u0004\t\u0019+A\nd_6\u0004\u0018m\u0019;j_:\u001c\u0005/^'fi\u0016\u0014\b%\u0001\bdY\u0016\fg.\u001a:NKR\u0014\u0018nY:\u0016\u0005\u0005m\u0006\u0003BA\u001a\u0003{K1!a0V\u0005EaunZ\"mK\u0006tWM]'fiJL7m]\u0001\u0010G2,\u0017M\\3s\u001b\u0016$(/[2tA\u0005IA\u000f\u001b:piRdWM]\u000b\u0003\u0003\u000f\u0004B!!3\u0002N6\u0011\u00111\u001a\u0006\u0003IFLA!a4\u0002L\nIA\u000b\u001b:piRdWM]\u0001\u000bi\"\u0014x\u000e\u001e;mKJ\u0004\u0013\u0001C2mK\u0006tWM]:\u0016\u0005\u0005]\u0007CBAm\u0003?\f\u0019/\u0004\u0002\u0002\\*!\u0011Q\\A\u0001\u0003\u001diW\u000f^1cY\u0016LA!!9\u0002\\\nY\u0011I\u001d:bs\n+hMZ3s!\r\t)oL\u0007\u0002\u0001\ti1\t\\3b]\u0016\u0014H\u000b\u001b:fC\u0012\u001cBaLAvCB!\u0011Q^Az\u001b\t\tyO\u0003\u0003\u0002r\u0006=\u0014\u0001B;uS2LA!!>\u0002p\n\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0003!!\bN]3bI&#\u0007c\u0001/\u0002|&\u0019\u0011Q`/\u0003\u0007%sG\u000f\u0006\u0003\u0002d\n\u0005\u0001bBA|c\u0001\u0007\u0011\u0011`\u0001\u000bY><w-\u001a:OC6,WC\u0001B\u0004!\u0011\u0011IAa\u0006\u000f\t\t-!1\u0003\t\u0004\u0005\u001biVB\u0001B\b\u0015\r\u0011\t\"W\u0001\u0007yI|w\u000e\u001e \n\u0007\tUQ,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00053\u0011YB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005+i\u0016aB2mK\u0006tWM]\u000b\u0003\u0005C\u0001B!a\r\u0003$%\u0019!QE+\u0003\u000f\rcW-\u00198fe\u0006A1\r\\3b]\u0016\u0014\b%A\u0005mCN$8\u000b^1ugV\u0011!Q\u0006\t\u0005\u0003g\u0011y#C\u0002\u00032U\u0013Ab\u00117fC:,'o\u0015;biN\fQ\u0002\\1tiN#\u0018\r^:`I\u0015\fH\u0003BA@\u0005oA\u0011\"a\"7\u0003\u0003\u0005\rA!\f\u0002\u00151\f7\u000f^*uCR\u001c\b\u0005K\u00028\u0003\u001b\u000b\u0011\u0003\\1tiB\u0013Xm\u00117fC:\u001cF/\u0019;t+\t\u0011\t\u0005\u0005\u0003\u00024\t\r\u0013b\u0001B#+\ni\u0001K]3DY\u0016\fgn\u0015;biN\fQ\u0003\\1tiB\u0013Xm\u00117fC:\u001cF/\u0019;t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\t-\u0003\"CADs\u0005\u0005\t\u0019\u0001B!\u0003Ia\u0017m\u001d;Qe\u0016\u001cE.Z1o'R\fGo\u001d\u0011)\u0007i\ni)A\u0005dQ\u0016\u001c7\u000eR8oKR!\u0011q\u0010B+\u0011\u001d\u00119f\u000fa\u0001\u0003K\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003\u007f\nA\u0003\u001e:z\u00072,\u0017M\u001c$jYRD\u0017.Z:u\u0019><GC\u0001B1!\ra&1M\u0005\u0004\u0005Kj&a\u0002\"p_2,\u0017M\\\u0001\u0012G2,\u0017M\u001c$jYRD\u0017.Z:u\u0019><\u0007&\u0002 \u0003l\t]\u0004#\u0002/\u0003n\tE\u0014b\u0001B8;\n1A\u000f\u001b:poN\u0004B!a\r\u0003t%\u0019!QO+\u0003)1{wm\u00117fC:LgnZ#yG\u0016\u0004H/[8oG\t\u0011\t(\u0001\u0005dY\u0016\fg\u000eT8h)\u0011\tyH! \t\u000f\t}t\b1\u0001\u0003\u0002\u0006I1\r\\3b]\u0006\u0014G.\u001a\t\u0005\u0003g\u0011\u0019)C\u0002\u0003\u0006V\u0013!\u0002T8h)>\u001cE.Z1o\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\u0005}$1\u0012BH\u0005'\u0013iJ!)\t\u000f\t5\u0005\t1\u0001\u0002z\u0006\u0011\u0011\u000e\u001a\u0005\b\u0005#\u0003\u0005\u0019\u0001B\u0004\u0003\u0011q\u0017-\\3\t\u000f\tU\u0005\t1\u0001\u0003\u0018\u0006!aM]8n!\ra&\u0011T\u0005\u0004\u00057k&\u0001\u0002'p]\u001eDqAa(A\u0001\u0004\u00119*\u0001\u0002u_\"9!1\u0015!A\u0002\t5\u0012!B:uCR\u001c\u0018!C2mK\u0006tWM]:!\u0003Ui\u0017\r_(wKJ\u001cE.Z1oKJ$\u0006N]3bIN$B!!?\u0003,\"9!Q\u0016\u000eA\u0002\t=\u0016!\u00014\u0011\u000fq\u0013\t,a9\u00036&\u0019!1W/\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001/\u00038&\u0019!\u0011X/\u0003\r\u0011{WO\u00197f\u0003=!W-\u00193UQJ,\u0017\rZ\"pk:$XCAA}\u0003\u001d\u0019H/\u0019:ukB\f\u0001b\u001d5vi\u0012|wO\\\u0001\u000ee\u0016lwN^3NKR\u0014\u0018nY:\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011!\u0011\u001a\t\u0006\u007f\n-'qA\u0005\u0005\u0005\u001b\f\tAA\u0002TKR\fqC^1mS\u0012\fG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u0005}$1\u001b\u0005\b\u0005+\u0004\u0003\u0019\u0001Bl\u0003%qWm^\"p]\u001aLw\rE\u0002i\u00053L1Aa7j\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0007\u0003\u007f\u0012\tO!:\t\u000f\t\r\u0018\u00051\u0001\u0003X\u0006Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\b\u0005+\f\u0003\u0019\u0001Bl\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011q\u0010Bv\u0011\u001d\u00119F\ta\u0001\u0003K\t\u0011#\u001e9eCR,7\t[3dWB|\u0017N\u001c;t)\u0019\tyH!=\u0003v\"9!1_\u0012A\u0002\u0005%\u0011a\u00023bi\u0006$\u0015N\u001d\u0005\n\u0005o\u001c\u0003\u0013!a\u0001\u0005s\f\u0011\u0003]1si&$\u0018n\u001c8U_J+Wn\u001c<f!\u0015a\u0016QUA\u0013\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q \u0016\u0005\u0005s\u001c\ta\u000b\u0002\u0004\u0004A!1QAB\b\u001b\t\u00199A\u0003\u0003\u0004\n\r-\u0011!C;oG\",7m[3e\u0015\r\u0019i!X\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\t\u0007\u000f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\tG\u000e^3s\u0007\",7m\u001b9pS:$H)\u001b:\u0015\u0011\u0005}4qCB\r\u0007;AqAa\u0016&\u0001\u0004\t)\u0003C\u0004\u0004\u001c\u0015\u0002\r!!\u0003\u0002\u0019M|WO]2f\u0019><G)\u001b:\t\u000f\r}Q\u00051\u0001\u0002\n\u0005QA-Z:u\u0019><G)\u001b:\u0002'!\fg\u000e\u001a7f\u0019><G)\u001b:GC&dWO]3\u0015\t\u0005}4Q\u0005\u0005\b\u0007O1\u0003\u0019\u0001B\u0004\u0003\r!\u0017N]\u0001\u0018[\u0006L(-\u001a+sk:\u001c\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$\u0002\"a \u0004.\r=2\u0011\u0007\u0005\b\u0005g<\u0003\u0019AA\u0005\u0011\u001d\u00119f\na\u0001\u0003KAqaa\r(\u0001\u0004\u00119*\u0001\u0004pM\u001a\u001cX\r^\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\u0011\tyh!\u000f\t\u000f\t]\u0003\u00061\u0001\u0002&\u0005q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BA@\u0007\u007fAqa!\u0011*\u0001\u0004\u0019\u0019%A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0015y8QIA\u0013\u0013\u0011\u00199%!\u0001\u0003\u0011%#XM]1cY\u0016\fA\"Y<bSR\u001cE.Z1oK\u0012$\u0002B!\u0019\u0004N\r=3\u0011\u000b\u0005\b\u0005/R\u0003\u0019AA\u0013\u0011\u001d\u0019\u0019D\u000ba\u0001\u0005/C\u0011ba\u0015+!\u0003\u0005\rAa&\u0002\u00135\f\u0007pV1ji6\u001b\u0018AF1xC&$8\t\\3b]\u0016$G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\re#\u0006\u0002BL\u0007\u0003\ta\u0005]1vg\u0016\u001cE.Z1oS:<gi\u001c:O_:\u001cu.\u001c9bGR,G\rU1si&$\u0018n\u001c8t)\t\u0019y\u0006E\u0003\u0000\u0007\u000b\u001a\t\u0007E\u0004]\u0007G\n)#!\r\n\u0007\r\u0015TL\u0001\u0004UkBdWMM\u0001\u000eGV\u0014(/\u001a8u\u0007>tg-[4\u0002\u0019\rdW-\u00198fe\u000e{WO\u001c;\u0002\u00151{wm\u00117fC:,'\u000fE\u0002\u00024\t\u001b\"AQ.\u0015\u0005\r5\u0014!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005i1\r\\3b]\u0016\u00148i\u001c8gS\u001e$2A\\B>\u0011\u001d\t9H\u0012a\u0001\u0005/\fQ%T1y\u0005V4g-\u001a:Vi&d\u0017N_1uS>t\u0007+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\r\u0005\u0005\u0003BBB\u0007\u0013k!a!\"\u000b\t\r\u001d\u0015\u0011C\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u001a\r\u0015\u0015AJ'bq\n+hMZ3s+RLG.\u001b>bi&|g\u000eU3sG\u0016tG/T3ue&\u001cg*Y7fA\u0005q2\t\\3b]\u0016\u0014(+Z2paf\u0004VM]2f]RlU\r\u001e:jG:\u000bW.Z\u0001 \u00072,\u0017M\\3s%\u0016\u001cw\u000e]=QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013AF'bq\u000ecW-\u00198US6,W*\u001a;sS\u000et\u0015-\\3\u0002/5\u000b\u0007p\u00117fC:$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!H'bq\u000e{W\u000e]1di&|g\u000eR3mCflU\r\u001e:jGNt\u0015-\\3\u0002=5\u000b\u0007pQ8na\u0006\u001cG/[8o\t\u0016d\u0017-_'fiJL7m\u001d(b[\u0016\u0004\u0013!\u0007#fC\u0012$\u0006N]3bI\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\f!\u0004R3bIRC'/Z1e\u0007>,h\u000e^'fiJL7MT1nK\u0002\n1\"T3ue&\u001cg*Y7fgV\u00111\u0011\u0015\t\u0006\u007f\n-7\u0011Q\u0001\r\u001b\u0016$(/[2OC6,7\u000fI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r%&\u0006BA%\u0007\u0003\u0001")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private Option<ThreadsCpuMeter> compactionCpuMeter;
    private final LogCleanerMetrics kafka$log$LogCleaner$$cleanerMetrics;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    public static CleanerConfig cleanerConfig(KafkaConfig config) {
        return LogCleaner$.MODULE$.cleanerConfig(config);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    private Option<ThreadsCpuMeter> compactionCpuMeter() {
        return this.compactionCpuMeter;
    }

    private void compactionCpuMeter_$eq(Option<ThreadsCpuMeter> x$1) {
        this.compactionCpuMeter = x$1;
    }

    public LogCleanerMetrics kafka$log$LogCleaner$$cleanerMetrics() {
        return this.kafka$log$LogCleaner$$cleanerMetrics;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
        this.compactionCpuMeter_$eq((Option<ThreadsCpuMeter>)new Some((Object)new ThreadsCpuMeter((scala.collection.immutable.Seq<Object>)((IterableOnceOps)this.cleaners().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.getId()))).toSeq())));
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down the log cleaner.");
        try {
            this.cleaners().foreach((Function1 & Serializable)x$15 -> {
                x$15.shutdown();
                return BoxedUnit.UNIT;
            });
            this.cleaners().clear();
        }
        finally {
            this.removeMetrics();
        }
    }

    public void removeMetrics() {
        LogCleaner$.MODULE$.MetricNames().foreach((Function1 & Serializable)x$1 -> {
            LogCleaner.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.cleanerManager().removeMetrics();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (long)((int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))))) / 1000L;
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$3() {
        return this.cleanerManager().cleanBytesLast().get();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$4() {
        return this.cleanerManager().cleanableBytesLast().get();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$5() {
        return this.cleanerManager().uncleanableBytesLast().get();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$6() {
        return (int)((double)100 * this.cleanerManager().dirtiestLogCleanableRatio());
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$2) {
        return x$2.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$2));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) * 100;
    }

    public final /* synthetic */ double kafka$log$LogCleaner$$$anonfun$new$9() {
        return BoxesRunTime.unboxToDouble((Object)this.compactionCpuMeter().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.computeCpuUtilizationPercent())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) * (double)100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$12() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable)x$4 -> x$4.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$17(CleanerThread x$7) {
        return x$7.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$16() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$7 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$17(x$7));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) * 100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$18() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable)x$8 -> x$8.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$23(CleanerThread x$11) {
        return x$11.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$22() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$11 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$23(x$11));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public static final /* synthetic */ double $anonfun$new$25(CleanerThread x$12) {
        return x$12.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$24() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$12 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$25(x$12));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) / 1000;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$26() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleaner $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable)x$16 -> x$16 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.compactionCpuMeter = None$.MODULE$;
        this.kafka$log$LogCleaner$$cleanerMetrics = new LogCleanerMetrics((Option<String>)None$.MODULE$);
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxCompactionDelayGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsCleanBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsCleanableBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsUncleanableBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxDirtyPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$6();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxBufferUtilizationPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCompactionCpuUtilizationPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final double value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanerRecopyPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$12();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxBufferUtilizationPercentMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$16();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$CleanerRecopyPercentMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$18();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCleanTimeMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$22();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCompactionDelayMetricsName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$24();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$DeadThreadCountMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                LogCleaner logCleaner = this.$outer;
                if (logCleaner == null) {
                    throw null;
                }
                return logCleaner.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, AbstractLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                this.maybeDeleteOldSegments$1(deletable);
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable)x$17 -> (TopicPartition)x$17._1())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        private void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tAverage key size for records observed during this compaction run is %.2f bytes"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.keyBytesRead() / (double)stats.messagesRead()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tOffset Map is Full: %b"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)stats.offsetMapFull())}))).toString();
            this.info((Function0<String>)(Function0 & Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ void $anonfun$cleanFilthiestLog$1(CleanerThread $this, IntRef total$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                AbstractLog log = (AbstractLog)x0$1._2();
                if (total$1.elem >= $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Log cleanup reached the limit of maximum segments that can be deleted limit ").append($this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun).append(", ").append(total$1.elem).append(" files deleted").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (log.isFrozenLogStartOffsetState()) {
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Log cleanup blocked for ").append(log).append(" as it is in frozen start offset state").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Garbage collecting '").append(log.name()).append("'").toString());
                try {
                    int limit = $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun - total$1.elem;
                    total$1.elem += log.deleteOldSegments(limit);
                    return;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private final void maybeDeleteOldSegments$1(Iterable deletableLogs) {
            Object object = new Object();
            try {
                IntRef total = IntRef.create((int)0);
                deletableLogs.foreach((Function1 & Serializable)x0$1 -> {
                    CleanerThread.$anonfun$cleanFilthiestLog$1(this, total, object, x0$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    ex.value$mcV$sp();
                    return;
                }
                throw ex;
            }
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            }, LogCleaner.this.kafka$log$LogCleaner$$cleanerMetrics());
            this.lastStats = new CleanerStats(LogCleaner.this.kafka$log$LogCleaner$$time, LogCleaner.this.kafka$log$LogCleaner$$cleanerMetrics());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

