/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore;

import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreConfig.class);
    private static RestoreConfig instance;
    public static boolean dryRun;
    public static boolean localMode;
    private static final String KAFKA_PROPERTY_FILE = "/mnt/config/shared/server-common.properties";
    private static final String RESTORE_PROPERTY_FILE = "/mnt/config/restore/restore.properties";
    private static final String KAFKA_PROPERTY_FILE_TMP = "/mnt/kafka/kafka.properties";
    private static final String DEFAULT_PARTITION_FILE = "/tmp/restoreTopicPartitions.yaml";
    public static final String BUCKET_NAME = "restore.bucket.name";
    public static final String CLOUD_PROVIDER = "restore.cloud.provider";
    public static final String PARTITION_FILE_CONFIG = "partition-file";
    public static final String ZOOKEEPER_CONFIG = "zookeeper.connect";
    public static final String CLUSTER_ID_CONFIG = "clusterid";
    public static final int RESTORE_REST_SERVER_PORT = 9090;
    public static final String KAFKA_INTERNAL_REST_SERVER_PORT_CONFIG = "internal-rest-port";
    public static int kafkaInternalRestServerPort;
    public static final String KAFKA_BOOTSTRAP_PORT_CONFIG = "kafka-bootstrap-port";
    public static int kafkaBootstrapPort;
    private static final int DEFAULT_PARTITION_RESTORE_PARALLELISM = 10;
    public static final String RESTORE_PARALLELISM = "RESTORE_PARALLELISM";
    public static final int MAX_KAFKA_CONNECTION_POOL_SIZE = 20;
    public static final int OBJECT_STORE_POOL_SIZE_MULTIPLIER = 10;
    private static String[] requiredProperties;
    private Properties config = new Properties();
    private KafkaConfig kafkaConfig;

    public static synchronized RestoreConfig getInstance() {
        if (instance == null) {
            instance = new RestoreConfig();
        }
        return instance;
    }

    public static KafkaConfig kafkaConfig() {
        return RestoreConfig.getInstance().kafkaConfig;
    }

    public void loadAdditionalProps(Properties props) {
        this.config.putAll((Map<?, ?>)props);
        this.kafkaConfig = KafkaConfig.fromProps(this.config, false);
    }

    private RestoreConfig() {
        try {
            File restorePropertyFile;
            File kafkaPropertiesFile;
            this.config.setProperty(PARTITION_FILE_CONFIG, DEFAULT_PARTITION_FILE);
            this.config.setProperty(RESTORE_PARALLELISM, String.valueOf(10));
            this.config.setProperty(ZOOKEEPER_CONFIG, "not-specified");
            File kafkaPropertiesFileTmp = new File(KAFKA_PROPERTY_FILE_TMP);
            if (kafkaPropertiesFileTmp.exists()) {
                FileInputStream kafkaProp = new FileInputStream(KAFKA_PROPERTY_FILE_TMP);
                this.config.load(kafkaProp);
            }
            if ((kafkaPropertiesFile = new File(KAFKA_PROPERTY_FILE)).exists()) {
                FileInputStream kafkaProp = new FileInputStream(KAFKA_PROPERTY_FILE);
                this.config.load(kafkaProp);
            }
            if ((restorePropertyFile = new File(RESTORE_PROPERTY_FILE)).exists()) {
                FileInputStream restoreProp = new FileInputStream(RESTORE_PROPERTY_FILE);
                this.config.load(restoreProp);
            }
            if (System.getenv().containsKey(RESTORE_PARALLELISM)) {
                this.config.setProperty(RESTORE_PARALLELISM, System.getenv(RESTORE_PARALLELISM));
            }
            this.config.remove("inter.broker.listener.name");
            this.config.remove("create.topic.policy.class.name");
            this.config.remove("alter.config.policy.class.name");
            this.config.remove("confluent.topic.replica.assignor.builder.class");
            this.config.remove("listener.name.external.broker.interceptor.class");
            this.config.remove("listener.name.external.principal.builder.class");
            this.config.remove("client.quota.callback.class");
            this.config.remove("multitenant.metadata.class");
            this.config.remove("confluent.schema.validator.interceptor.class");
            this.config.remove("listener.name.external.oauthbearer.sasl.server.callback.handler.class");
            this.config.remove("listener.name.external.oauthbearer.sasl.login.callback.handler.class");
            this.config.remove("authorizer.class.name");
            this.config.remove("confluent.telemetry.exporter.cloud.producer.sasl.login.callback.handler.class");
            this.config.remove("confluent.telemetry.exporter.cloud.producer.sasl.client.callback.handler.class");
            this.config.remove("confluent.security.event.logger.exporter.kafka.sasl.login.callback.handler.class");
            this.config.remove("confluent.security.event.logger.exporter.kafka.sasl.client.callback.handler.class");
            this.config.remove("create.topic.policy.class.name");
            this.kafkaConfig = KafkaConfig.fromProps(this.config, false);
        }
        catch (Exception ex) {
            LOGGER.warn("load properties file error", (Throwable)ex);
        }
    }

    public Properties getProperties() {
        return this.config;
    }

    public static void setProperty(String key, String value) {
        RestoreConfig.getInstance().config.put(key, value);
    }

    public static String getProperty(String name) {
        return RestoreConfig.getInstance().config.getProperty(name);
    }

    public static void setDryRun(boolean dryRun) {
        RestoreConfig.dryRun = dryRun;
    }

    public static void setLocalMode(boolean localMode) {
        RestoreConfig.localMode = localMode;
    }

    public static void setKafkaInternalRestPort(int port) {
        kafkaInternalRestServerPort = port;
    }

    public static void setKafkaBootstrapPort(int port) {
        kafkaBootstrapPort = port;
    }

    private void validate() throws Exception {
        for (String r : requiredProperties) {
            if (this.config.getProperty(r) != null) continue;
            throw new Exception("missing required properties: " + r);
        }
    }

    static {
        dryRun = false;
        localMode = false;
        kafkaInternalRestServerPort = 9080;
        kafkaBootstrapPort = 9071;
        requiredProperties = new String[]{BUCKET_NAME, CLOUD_PROVIDER};
    }
}

