/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.messages;

import java.util.Date;
import org.apache.kafka.common.TopicPartition;

public class Message {
    private final int uuid;
    private final Date createTimestamp;
    private final String topic;
    private final int partition;

    public Message(int uuid, String topic, int partition) {
        this.uuid = uuid;
        this.createTimestamp = new Date();
        this.topic = topic;
        this.partition = partition;
    }

    public int getUuid() {
        return this.uuid;
    }

    public Date getCreateTimestamp() {
        return this.createTimestamp;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public String name() {
        return this.getClass().getSimpleName() + "(" + this.topic + "-" + this.partition + ")";
    }

    public TopicPartition getTopicPartition() {
        return new TopicPartition(this.topic, this.partition);
    }
}

