/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import kafka.restore.MessageEmitter;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransition
implements Transition<Event> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransition.class);
    protected MessageEmitter messageEmitter;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public AbstractTransition(MessageEmitter messageEmitter) {
        this.messageEmitter = messageEmitter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("transition: {name: ").append(this.getName()).append(", source: ").append(this.getSourceState()).append(", target: ").append(this.getTargetState()).append("}");
        return sb.toString();
    }

    public boolean shouldRestoreFromFtpsSnapshot(FiniteStateMachine fsm) {
        return fsm.getMetadata("ftps_for_restore") != null;
    }
}

