/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig$;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.TopicType;
import org.apache.kafka.metadata.placement.TopicPlacementReplicaPlacer;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.ClientMetricsConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001\u0002\t\u0012\u0001YA\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005Y!A\u0011\u0007\u0001BC\u0002\u0013\u0005!\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u00034\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u001dA\u0005A1A\u0005\u0002%Ca\u0001\u0015\u0001!\u0002\u0013Q\u0005\"B)\u0001\t\u0013\u0011\u0006\"\u00024\u0001\t\u00139\u0007\"B5\u0001\t\u0013Q\u0007\"\u0002;\u0001\t\u0013)\b\"B>\u0001\t\u0003b\b\"B>\u0001\t\u0003r\bbBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003g\u0001A\u0011BA\u001b\u0005\u0001\u001auN\u001c;s_2dWM]\"p]\u001aLw-\u001e:bi&|gNV1mS\u0012\fGo\u001c:\u000b\u0005I\u0019\u0012AB:feZ,'OC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\f !\tAR$D\u0001\u001a\u0015\tQ2$\u0001\u0003mC:<'\"\u0001\u000f\u0002\t)\fg/Y\u0005\u0003=e\u0011aa\u00142kK\u000e$\bC\u0001\u0011)\u001b\u0005\t#B\u0001\u0012$\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0003)\u0011R!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO&\u0011\u0011&\t\u0002\u0017\u0007>tg-[4ve\u0006$\u0018n\u001c8WC2LG-\u0019;pe\u0006Y1.\u00194lC\u000e{gNZ5h+\u0005a\u0003CA\u0017/\u001b\u0005\t\u0012BA\u0018\u0012\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0019-\fgm[1D_:4\u0017n\u001a\u0011\u0002\u001f5,G/\u00193bi\u00064VM]:j_:,\u0012a\r\t\u0004ieZT\"A\u001b\u000b\u0005Y:\u0014\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005aZ\u0012\u0001B;uS2L!AO\u001b\u0003\u0011M+\b\u000f\u001d7jKJ\u0004\"\u0001\u0010!\u000e\u0003uR!AP \u0002\r\r|W.\\8o\u0015\t\u00112%\u0003\u0002B{\tyQ*\u001a;bI\u0006$\u0018MV3sg&|g.\u0001\tnKR\fG-\u0019;b-\u0016\u00148/[8oA\u00051A(\u001b8jiz\"2!\u0012$H!\ti\u0003\u0001C\u0003+\u000b\u0001\u0007A\u0006C\u00032\u000b\u0001\u00071'\u0001\u0004m_\u001e<WM]\u000b\u0002\u0015B\u00111JT\u0007\u0002\u0019*\u0011QJJ\u0001\u0006g24GG[\u0005\u0003\u001f2\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0012m\u0006d\u0017\u000eZ1uKR{\u0007/[2OC6,GCA*Z!\t!v+D\u0001V\u0015\u00051\u0016!B:dC2\f\u0017B\u0001-V\u0005\u0011)f.\u001b;\t\u000biC\u0001\u0019A.\u0002\t9\fW.\u001a\t\u00039\u000et!!X1\u0011\u0005y+V\"A0\u000b\u0005\u0001,\u0012A\u0002\u001fs_>$h(\u0003\u0002c+\u00061\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011W+\u0001\nwC2LG-\u0019;f\u0005J|7.\u001a:OC6,GCA*i\u0011\u0015Q\u0016\u00021\u0001\\\u0003\u0011\"\bN]8x\u000bb\u001cW\r\u001d;j_:4uN]+oW:|wO\u001c*fg>,(oY3UsB,GCA*l\u0011\u0015a'\u00021\u0001n\u0003!\u0011Xm]8ve\u000e,\u0007C\u00018s\u001b\u0005y'B\u00019r\u0003\u0019\u0019wN\u001c4jO*\u0011ahI\u0005\u0003g>\u0014abQ8oM&<'+Z:pkJ\u001cW-A\u0013wC2LG-\u0019;f\u0005J|7.\u001a:TG\",W.\u0019,bY&$\u0017\r^5p]\u000e{gNZ5hgR\u00111K\u001e\u0005\u0006a.\u0001\ra\u001e\t\u0005qf\\6,D\u00018\u0013\tQxGA\u0002NCB\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0003'vDQ\u0001\u001c\u0007A\u00025$BaU@\u0002\u0002!)A.\u0004a\u0001[\")\u0001/\u0004a\u0001o\u0006Ib/\u00197jI\u0006$X\rV8qS\u000e\u001cuN\u001c4jO\u000eC\u0017M\\4f)%\u0019\u0016qAA\u0006\u0003\u001f\tI\u0003\u0003\u0004\u0002\n9\u0001\ra^\u0001\u0013aJ,gOU3t_24X\rZ\"p]\u001aLw\r\u0003\u0004\u0002\u000e9\u0001\ra^\u0001\u0012]\u0016<(+Z:pYZ,GmQ8oM&<\u0007bBA\t\u001d\u0001\u0007\u00111C\u0001\bEJ|7.\u001a:t!\u0015A\u0018QCA\r\u0013\r\t9b\u000e\u0002\t\u0013R,'/\u0019;peB!\u00111DA\u0013\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012!\u00039mC\u000e,W.\u001a8u\u0015\r\t\u0019cI\u0001\t[\u0016$\u0018\rZ1uC&!\u0011qEA\u000f\u00051)6/\u00192mK\n\u0013xn[3s\u0011\u001d\tYC\u0004a\u0001\u0003[\t\u0011$[:U_BL7\r\u00157bG\u0016lWM\u001c;TkB\u0004xN\u001d;fIB\u0019A+a\f\n\u0007\u0005ERKA\u0004C_>dW-\u00198\u0002SY\fG.\u001b3bi\u0016$v\u000e]5d!2\f7-Z7f]R\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u000eC\u0017M\\4f)%\u0019\u0016qGA%\u0003\u001b\ny\u0005C\u0004\u0002:=\u0001\r!a\u000f\u0002%A\u0014XM\u001e+pa&\u001c\u0007\u000b\\1dK6,g\u000e\u001e\t\u0006q\u0006u\u0012\u0011I\u0005\u0004\u0003\u007f9$\u0001C(qi&|g.\u00197\u0011\t\u0005\r\u0013QI\u0007\u0003\u0003CIA!a\u0012\u0002\"\tqAk\u001c9jGBc\u0017mY3nK:$\bbBA&\u001f\u0001\u0007\u00111H\u0001\u0012]\u0016<Hk\u001c9jGBc\u0017mY3nK:$\bbBA\t\u001f\u0001\u0007\u00111\u0003\u0005\b\u0003Wy\u0001\u0019AA\u0017\u0001")
public class ControllerConfigurationValidator
implements ConfigurationValidator {
    private final KafkaConfig kafkaConfig;
    private final Supplier<MetadataVersion> metadataVersion;
    private final Logger logger;

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public Supplier<MetadataVersion> metadataVersion() {
        return this.metadataVersion;
    }

    public Logger logger() {
        return this.logger;
    }

    private void validateTopicName(String name) {
        if (name.isEmpty()) {
            throw new InvalidRequestException("Default topic resources are not allowed.");
        }
        Topic.validate((String)name);
    }

    private void validateBrokerName(String name) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name))) {
            Integer n;
            try {
                n = Integer.valueOf(name);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidRequestException("Unable to parse broker name as a base 10 number.");
            }
            Integer brokerId = n;
            if (Predef$.MODULE$.Integer2int(brokerId) < 0) {
                throw new InvalidRequestException("Invalid negative broker ID.");
            }
            return;
        }
    }

    private void throwExceptionForUnknownResourceType(ConfigResource resource) {
        throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.type()).toString());
    }

    private void validateBrokerSchemaValidationConfigs(Map<String, String> config) {
        HashMap<String, Object> allConfigs = new HashMap<String, Object>(this.kafkaConfig().originals());
        allConfigs.putAll(config);
        try {
            LogConfig.createSchemaValidationInterceptorIfNeeded(allConfigs, (Logger)this.logger()).ifPresent(x$1 -> x$1.close());
            return;
        }
        catch (Exception e) {
            this.logger().error("Error closing schema validation interceptor", (Throwable)e);
            return;
        }
    }

    public void validate(ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validate(ConfigResource resource, Map<String, String> config) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullTopicConfigs = new ArrayBuffer();
            config.forEach((key, value) -> {
                if (value == null) {
                    nullTopicConfigs.$plus$eq(key);
                    return;
                }
                properties.setProperty((String)key, (String)value);
            });
            if (nullTopicConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(44).append("Null value not supported for topic configs: ").append(nullTopicConfigs.mkString(",")).toString());
            }
            if (this.kafkaConfig().remoteLogManagerConfig() == null) {
                throw null;
            }
            LogConfig.validate((Properties)properties, this.kafkaConfig().extractLogConfigMap(), (boolean)false, (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().isVirtualTopicCreationEnabled()));
            this.validateBrokerSchemaValidationConfigs(config);
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
            ClusterLinkConfig$.MODULE$.create(config, (Option<KafkaConfig>)new Some((Object)this.kafkaConfig()), true);
            return;
        }
        if (ConfigResource.Type.CLIENT_METRICS.equals(type)) {
            Properties properties = new Properties();
            config.forEach((key, value) -> properties.setProperty((String)key, (String)value));
            ClientMetricsConfigs.validate((String)resource.name(), (Properties)properties);
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validateTopicConfigChange(Map<String, String> prevResolvedConfig, Map<String, String> newResolvedConfig, Iterator<UsableBroker> brokers, boolean isTopicPlacementSupported) {
        LogConfig nextLogConfig;
        LogConfig curLogConfig = LogConfig.fromProps(prevResolvedConfig, (Properties)new Properties());
        if (!curLogConfig.equals((Object)(nextLogConfig = LogConfig.fromProps(newResolvedConfig, (Properties)new Properties()))) && curLogConfig.topicType().equals((Object)TopicType.VIRTUAL)) {
            throw new InvalidConfigurationException("Altering configs for VIRTUAL topics is not supported.");
        }
        LogConfig.validateChange((LogConfig)curLogConfig, (LogConfig)nextLogConfig, (MetadataVersion)this.metadataVersion().get(), (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().confluentConfig().tierFeature()), (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().confluentConfig().tierCleanerFeatureEnable()));
        this.validateBrokerSchemaValidationConfigs(newResolvedConfig);
        this.validateTopicPlacementConfigurationChange(curLogConfig.confluentLogConfig().topicPlacementConstraints, nextLogConfig.confluentLogConfig().topicPlacementConstraints, brokers, isTopicPlacementSupported);
    }

    private void validateTopicPlacementConfigurationChange(Optional<TopicPlacement> prevTopicPlacement, Optional<TopicPlacement> newTopicPlacement, Iterator<UsableBroker> brokers, boolean isTopicPlacementSupported) {
        if (!Objects.equals(prevTopicPlacement, newTopicPlacement)) {
            newTopicPlacement.ifPresent(topicPlacement -> {
                if (!isTopicPlacementSupported) {
                    throw new InvalidConfigurationException("Topic placement is not supported.");
                }
                TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)topicPlacement, (Iterator)brokers, (Logger)this.logger(), x$2 -> DirectoryId.MIGRATING);
            });
            return;
        }
    }

    public ControllerConfigurationValidator(KafkaConfig kafkaConfig, Supplier<MetadataVersion> metadataVersion) {
        this.kafkaConfig = kafkaConfig;
        this.metadataVersion = metadataVersion;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

