/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Accepted$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Effective$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$None$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Queued$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001da\u0001\u00029r\u0001YD\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\u000b\u0003'\u0001!\u0011!Q\u0001\n\u0005U\u0001BCA\u000e\u0001\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u00111\u0005\u0001\u0003\u0002\u0003\u0006I!!\n\t\u0015\u0005-\u0002A!A!\u0002\u0013\ti\u0003\u0003\u0006\u0002H\u0001\u0011\t\u0011)A\u0005\u0003\u0013B!\"a\u0014\u0001\u0005\u0003\u0005\u000b\u0011BA)\u0011)\t9\u0006\u0001B\u0001B\u0003%\u0011\u0011\f\u0005\u000b\u0003?\u0002!\u0011!Q\u0001\n\u0005\u0005\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\u000b\u0003\u000b\u0003!\u0019!C\u0001c\u0006\u001d\u0005\u0002CB\u001f\u0001\u0001\u0006I!!#\t\u000f\r}\u0002\u0001\"\u0015\u0004B!91\u0011\n\u0001\u0005R\r-\u0003bBB+\u0001\u0011E3q\u000b\u0005\b\u00077\u0002A\u0011KB/\u0011\u001d\u0019i\u0007\u0001C!\u0007_Bqa!'\u0001\t\u0003\u001aY\nC\u0004\u0002^\u0002!Iaa-\t\u0011\re\u0006\u0001\"\u0001r\u0007wCqaa1\u0001\t\u0013\u0019)\rC\u0004\u0004Z\u0002!\tea7\t\u0013\r%\bA1A\u0005R\u0005U\b\u0002CBv\u0001\u0001\u0006I!a>\t\u000f\r5\b\u0001\"\u0011\u0004p\"91Q \u0001\u0005R\r}xaBAYc\"\u0005\u00111\u0017\u0004\u0007aFD\t!!.\t\u000f\u00055D\u0004\"\u0001\u0002@\u001a1\u0011\u0011\u0019\u000fA\u0003\u0007D!\"!8\u001f\u0005+\u0007I\u0011AAp\u0011)\u0011)J\bB\tB\u0003%\u0011\u0011\u001d\u0005\u000b\u0005/s\"Q3A\u0005\u0002\te\u0005B\u0003BT=\tE\t\u0015!\u0003\u0003\u001c\"Q!\u0011\u0016\u0010\u0003\u0016\u0004%\tA!'\t\u0015\t-fD!E!\u0002\u0013\u0011Y\nC\u0004\u0002ny!\tA!,\t\u000f\t]f\u0004\"\u0001\u0003:\"I!q\u0018\u0010\u0002\u0002\u0013\u0005!\u0011\u0019\u0005\n\u0005\u0013t\u0012\u0013!C\u0001\u0005\u0017D\u0011B!9\u001f#\u0003%\tAa9\t\u0013\t\u001dh$%A\u0005\u0002\t\r\b\"\u0003B\n=\u0005\u0005I\u0011\tB\u000b\u0011%\u0011\tCHA\u0001\n\u0003\u0011\u0019\u0003C\u0005\u0003,y\t\t\u0011\"\u0001\u0003j\"I!\u0011\b\u0010\u0002\u0002\u0013\u0005#1\b\u0005\n\u0005\u0013r\u0012\u0011!C\u0001\u0005[D\u0011B!=\u001f\u0003\u0003%\tEa=\t\u0013\t=c$!A\u0005B\tE\u0003\"\u0003B*=\u0005\u0005I\u0011\tB+\u0011%\u00119PHA\u0001\n\u0003\u0012IpB\u0005\u0003~r\t\t\u0011#\u0001\u0003\u0000\u001aI\u0011\u0011\u0019\u000f\u0002\u0002#\u00051\u0011\u0001\u0005\b\u0003[*D\u0011AB\r\u0011%\u0011\u0019&NA\u0001\n\u000b\u0012)\u0006C\u0005\u0004\u001cU\n\t\u0011\"!\u0004\u001e!I1QE\u001b\u0002\u0002\u0013\u00055q\u0005\u0005\n\u0005/*\u0014\u0011!C\u0005\u000532\u0011\"!:\u001d!\u0003\r\t#a:\t\u000f\u0005%8\b\"\u0001\u0002l\"9\u00111_\u001e\u0005\u0002\u0005UxaBB\u001b9!\u0005!Q\u0001\u0004\b\u0003Kd\u0002\u0012\u0001B\u0001\u0011\u001d\tig\u0010C\u0001\u0005\u00079qAa\u0002@\u0011\u0003\u0013IAB\u0004\u0003\u000e}B\tIa\u0004\t\u000f\u00055$\t\"\u0001\u0003\u0012!I!1\u0003\"\u0002\u0002\u0013\u0005#Q\u0003\u0005\n\u0005C\u0011\u0015\u0011!C\u0001\u0005GA\u0011Ba\u000bC\u0003\u0003%\tA!\f\t\u0013\te\")!A\u0005B\tm\u0002\"\u0003B%\u0005\u0006\u0005I\u0011\u0001B&\u0011%\u0011yEQA\u0001\n\u0003\u0012\t\u0006C\u0005\u0003T\t\u000b\t\u0011\"\u0011\u0003V!I!q\u000b\"\u0002\u0002\u0013%!\u0011L\u0004\b\u0005Cz\u0004\u0012\u0011B2\r\u001d\u0011)g\u0010EA\u0005OBq!!\u001cN\t\u0003\u0011I\u0007C\u0004\u0002t6#\t%!>\t\u0013\tMQ*!A\u0005B\tU\u0001\"\u0003B\u0011\u001b\u0006\u0005I\u0011\u0001B\u0012\u0011%\u0011Y#TA\u0001\n\u0003\u0011Y\u0007C\u0005\u0003:5\u000b\t\u0011\"\u0011\u0003<!I!\u0011J'\u0002\u0002\u0013\u0005!q\u000e\u0005\n\u0005\u001fj\u0015\u0011!C!\u0005#B\u0011Ba\u0015N\u0003\u0003%\tE!\u0016\t\u0013\t]S*!A\u0005\n\tesa\u0002B:\u007f!\u0005%Q\u000f\u0004\b\u0003\u007f|\u0004\u0012\u0011BE\u0011\u001d\ti'\u0017C\u0001\u0005\u0017Cq!a=Z\t\u0003\n)\u0010C\u0005\u0003\u0014e\u000b\t\u0011\"\u0011\u0003\u0016!I!\u0011E-\u0002\u0002\u0013\u0005!1\u0005\u0005\n\u0005WI\u0016\u0011!C\u0001\u0005\u001bC\u0011B!\u000fZ\u0003\u0003%\tEa\u000f\t\u0013\t%\u0013,!A\u0005\u0002\tE\u0005\"\u0003B(3\u0006\u0005I\u0011\tB)\u0011%\u0011\u0019&WA\u0001\n\u0003\u0012)\u0006C\u0005\u0003Xe\u000b\t\u0011\"\u0003\u0003Z\u001d9!qO \t\u0002\neda\u0002B>\u007f!\u0005%Q\u0010\u0005\b\u0003[*G\u0011\u0001B@\u0011%\u0011\u0019\"ZA\u0001\n\u0003\u0012)\u0002C\u0005\u0003\"\u0015\f\t\u0011\"\u0001\u0003$!I!1F3\u0002\u0002\u0013\u0005!\u0011\u0011\u0005\n\u0005s)\u0017\u0011!C!\u0005wA\u0011B!\u0013f\u0003\u0003%\tA!\"\t\u0013\t=S-!A\u0005B\tE\u0003\"\u0003B*K\u0006\u0005I\u0011\tB+\u0011%\u00119&ZA\u0001\n\u0013\u0011I\u0006C\u0005\u00048q\t\n\u0011\"\u0001\u0004:\tI\"+\u001a9mS\u000e\f\u0017\t\u001c;fe2{w\rR5sgRC'/Z1e\u0015\t\u00118/\u0001\u0004tKJ4XM\u001d\u0006\u0002i\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001x!\tA\u00180D\u0001r\u0013\tQ\u0018OA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\t9\fW.\u001a\t\u0004{\u00065ab\u0001@\u0002\nA\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002k\u00061AH]8pizR!!a\u0002\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005-\u0011QA\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0011\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005-\u0011QA\u0001\u0007Y\u0016\fG-\u001a:\u0011\u0007a\f9\"C\u0002\u0002\u001aE\u0014a\u0002T3bI\u0016\u0014XI\u001c3Q_&tG/\u0001\tgC&dW\r\u001a)beRLG/[8ogB\u0019\u00010a\b\n\u0007\u0005\u0005\u0012O\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006\u0001\u0002/Y;tK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004q\u0006\u001d\u0012bAA\u0015c\n\u0001\u0002+Y;tK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u0013Kb\u0004xN\\3oi&\fGNQ1dW>4g\r\u0005\u0003\u00020\u0005\rSBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u000bU$\u0018\u000e\\:\u000b\t\u0005]\u0012\u0011H\u0001\u0007G>lWn\u001c8\u000b\u0007Q\fYD\u0003\u0003\u0002>\u0005}\u0012AB1qC\u000eDWM\u0003\u0002\u0002B\u0005\u0019qN]4\n\t\u0005\u0015\u0013\u0011\u0007\u0002\u0013\u000bb\u0004xN\\3oi&\fGNQ1dW>4g-\u0001\u0006sKBd\u0017nY1NOJ\u00042\u0001_A&\u0013\r\ti%\u001d\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\rA\u00181K\u0005\u0004\u0003+\n(a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fE\u0002y\u00037J1!!\u0018r\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8/A\u000beSJ,7\r^8ss\u00163XM\u001c;IC:$G.\u001a:\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KRA!a\u000e\u0002h)\u0019!/!\u000f\n\t\u0005-\u0014Q\r\u0002\u0016\t&\u0014Xm\u0019;pef,e/\u001a8u\u0011\u0006tG\r\\3s\u0003\u0019a\u0014N\\5u}Q!\u0012\u0011OA:\u0003k\n9(!\u001f\u0002|\u0005u\u0014qPAA\u0003\u0007\u0003\"\u0001\u001f\u0001\t\u000bmT\u0001\u0019\u0001?\t\u000f\u0005M!\u00021\u0001\u0002\u0016!9\u00111\u0004\u0006A\u0002\u0005u\u0001bBA\u0012\u0015\u0001\u0007\u0011Q\u0005\u0005\b\u0003WQ\u0001\u0019AA\u0017\u0011\u001d\t9E\u0003a\u0001\u0003\u0013Bq!a\u0014\u000b\u0001\u0004\t\t\u0006C\u0004\u0002X)\u0001\r!!\u0017\t\u0013\u0005}#\u0002%AA\u0002\u0005\u0005\u0014a\u00049s_6|G/[8o'R\fG/Z:\u0016\u0005\u0005%\u0005\u0003CAF\u00033\u000bi*!*\u000e\u0005\u00055%\u0002BAH\u0003#\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\t\u0019*!&\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003/\u000bAA[1wC&!\u00111TAG\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003?\u000b\t+\u0004\u0002\u00026%!\u00111UA\u001b\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042!a*\u001f\u001d\r\tIk\u0007\b\u0005\u0003W\u000byKD\u0002\u0000\u0003[K\u0011\u0001^\u0005\u0003eN\f\u0011DU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bIB\u0011\u0001\u0010H\n\u00049\u0005]\u0006\u0003BA]\u0003wk!!!\u0002\n\t\u0005u\u0016Q\u0001\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005M&A\u0004)s_6|G/[8o'R\fG/Z\n\b=\u0005]\u0016QYAf!\u0011\tI,a2\n\t\u0005%\u0017Q\u0001\u0002\b!J|G-^2u!\u0011\ti-a6\u000f\t\u0005=\u00171\u001b\b\u0004\u007f\u0006E\u0017BAA\u0004\u0013\u0011\t).!\u0002\u0002\u000fA\f7m[1hK&!\u0011\u0011\\An\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\u0011\t).!\u0002\u0002#I,\u0017m]:jO:lWM\u001c;Ti\u0006$X-\u0006\u0002\u0002bB\u0019\u00111]\u001e\u000e\u0003q\u0011\u0011CU3bgNLwM\\7f]R\u001cF/\u0019;f'\rY\u0014qW\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0005\u00055\b\u0003BA]\u0003_LA!!=\u0002\u0006\t!QK\\5u\u0003ei\u0017-\u001f2f\u0013:\u001cwN\\:jgR,g\u000e^'fi\u0006$\u0017\r^1\u0016\u0005\u0005]\b\u0003BA]\u0003sLA!a?\u0002\u0006\t9!i\\8mK\u0006t\u0017&B\u001eZK\nk%\u0001C!dG\u0016\u0004H/\u001a3\u0014\u0007}\n9\f\u0006\u0002\u0003\u0006A\u0019\u00111] \u0002\t9{g.\u001a\t\u0004\u0005\u0017\u0011U\"A \u0003\t9{g.Z\n\n\u0005\u0006]\u0016\u0011]Ac\u0003\u0017$\"A!\u0003\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\u0002\u0005\u0003\u0003\u001a\t}QB\u0001B\u000e\u0015\u0011\u0011i\"!&\u0002\t1\fgnZ\u0005\u0005\u0003\u001f\u0011Y\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003&A!\u0011\u0011\u0018B\u0014\u0013\u0011\u0011I#!\u0002\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t=\"Q\u0007\t\u0005\u0003s\u0013\t$\u0003\u0003\u00034\u0005\u0015!aA!os\"I!q\u0007$\u0002\u0002\u0003\u0007!QE\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tu\u0002C\u0002B \u0005\u000b\u0012y#\u0004\u0002\u0003B)!!1IA\u0003\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000f\u0012\tE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA|\u0005\u001bB\u0011Ba\u000eI\u0003\u0003\u0005\rAa\f\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\n\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0006\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tm\u0003\u0003\u0002B\r\u0005;JAAa\u0018\u0003\u001c\t1qJ\u00196fGR\fa!U;fk\u0016$\u0007c\u0001B\u0006\u001b\n1\u0011+^3vK\u0012\u001c\u0012\"TA\\\u0003C\f)-a3\u0015\u0005\t\rD\u0003\u0002B\u0018\u0005[B\u0011Ba\u000eS\u0003\u0003\u0005\rA!\n\u0015\t\u0005](\u0011\u000f\u0005\n\u0005o!\u0016\u0011!a\u0001\u0005_\t\u0001\"Q2dKB$X\r\u001a\t\u0004\u0005\u0017I\u0016!C#gM\u0016\u001cG/\u001b<f!\r\u0011Y!\u001a\u0002\n\u000b\u001a4Wm\u0019;jm\u0016\u001c\u0012\"ZA\\\u0003C\f)-a3\u0015\u0005\teD\u0003\u0002B\u0018\u0005\u0007C\u0011Ba\u000ej\u0003\u0003\u0005\rA!\n\u0015\t\u0005](q\u0011\u0005\n\u0005oY\u0017\u0011!a\u0001\u0005_\u0019\u0012\"WA\\\u0003C\f)-a3\u0015\u0005\tUD\u0003\u0002B\u0018\u0005\u001fC\u0011Ba\u000e_\u0003\u0003\u0005\rA!\n\u0015\t\u0005](1\u0013\u0005\n\u0005o\u0001\u0017\u0011!a\u0001\u0005_\t!C]3bgNLwM\\7f]R\u001cF/\u0019;fA\u00059Ao\u001c9jG&#WC\u0001BN!\u0019\tIL!(\u0003\"&!!qTA\u0003\u0005\u0019y\u0005\u000f^5p]B!\u0011q\u0014BR\u0013\u0011\u0011)+!\u000e\u0003\tU+\u0018\u000eZ\u0001\ti>\u0004\u0018nY%eA\u0005Q1-\u001e:sK:$H)\u001b:\u0002\u0017\r,(O]3oi\u0012K'\u000f\t\u000b\t\u0005_\u0013\tLa-\u00036B\u0019\u00111\u001d\u0010\t\u000f\u0005uW\u00051\u0001\u0002b\"9!qS\u0013A\u0002\tm\u0005b\u0002BUK\u0001\u0007!1T\u0001\u000fo&$\b.Q:tS\u001etW.\u001a8u)\u0011\u0011yKa/\t\u000f\tuf\u00051\u0001\u0002b\u00069b.Z<ESJ\u0014V-Y:tS\u001etW.\u001a8u'R\fG/Z\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u00030\n\r'Q\u0019Bd\u0011%\tin\nI\u0001\u0002\u0004\t\t\u000fC\u0005\u0003\u0018\u001e\u0002\n\u00111\u0001\u0003\u001c\"I!\u0011V\u0014\u0011\u0002\u0003\u0007!1T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iM\u000b\u0003\u0002b\n=7F\u0001Bi!\u0011\u0011\u0019N!8\u000e\u0005\tU'\u0002\u0002Bl\u00053\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\tm\u0017QA\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bp\u0005+\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!:+\t\tm%qZ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134)\u0011\u0011yCa;\t\u0013\t]R&!AA\u0002\t\u0015B\u0003BA|\u0005_D\u0011Ba\u000e0\u0003\u0003\u0005\rAa\f\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005/\u0011)\u0010C\u0005\u00038A\n\t\u00111\u0001\u0003&\u00051Q-];bYN$B!a>\u0003|\"I!qG\u001a\u0002\u0002\u0003\u0007!qF\u0001\u000f!J|Wn\u001c;j_:\u001cF/\u0019;f!\r\t\u0019/N\n\u0006k\r\r1q\u0002\t\r\u0007\u000b\u0019Y!!9\u0003\u001c\nm%qV\u0007\u0003\u0007\u000fQAa!\u0003\u0002\u0006\u00059!/\u001e8uS6,\u0017\u0002BB\u0007\u0007\u000f\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u0019\tba\u0006\u000e\u0005\rM!\u0002BB\u000b\u0003+\u000b!![8\n\t\u0005e71\u0003\u000b\u0003\u0005\u007f\fQ!\u00199qYf$\u0002Ba,\u0004 \r\u000521\u0005\u0005\b\u0003;D\u0004\u0019AAq\u0011\u001d\u00119\n\u000fa\u0001\u00057CqA!+9\u0001\u0004\u0011Y*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r%2\u0011\u0007\t\u0007\u0003s\u0013ija\u000b\u0011\u0015\u0005e6QFAq\u00057\u0013Y*\u0003\u0003\u00040\u0005\u0015!A\u0002+va2,7\u0007C\u0005\u00044e\n\t\u00111\u0001\u00030\u0006\u0019\u0001\u0010\n\u0019\u0002#I+\u0017m]:jO:lWM\u001c;Ti\u0006$X-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%O\u000b\u0003\u0007wQC!!\u0019\u0003P\u0006\u0001\u0002O]8n_RLwN\\*uCR,7\u000fI\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007\u000e\u0006\u0003\u0004D\r\u0015\u0003CBA]\u0005;\u0013)\u0003C\u0004\u0004H5\u0001\r!!(\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0003BB'\u0007'\u0002B!!/\u0004P%!1\u0011KA\u0003\u0005\u0011auN\\4\t\u000f\r\u001dc\u00021\u0001\u0002\u001e\u0006aAn\\4F]\u0012|eMZ:fiR!1QJB-\u0011\u001d\u00199e\u0004a\u0001\u0003;\u000b\u0011#\u001a8e\u001f\u001a47/\u001a;G_J,\u0005o\\2i)\u0019\u0019yfa\u001a\u0004jA1\u0011\u0011\u0018BO\u0007C\u0002B!a\u0019\u0004d%!1QMA3\u00059yeMZ:fi\u0006sG-\u00129pG\"Dqaa\u0012\u0011\u0001\u0004\ti\nC\u0004\u0004lA\u0001\rA!\n\u0002\u000b\u0015\u0004xn\u00195\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)!\u0019\tha\"\u0004\n\u000e5\u0005CBA]\u0005;\u001b\u0019\b\u0005\u0003\u0004v\r\rUBAB<\u0015\u0011\u0019Iha\u001f\u0002\u00071|wM\u0003\u0003\u0004~\r}\u0014!C5oi\u0016\u0014h.\u00197t\u0015\u0011\u0019\t)!\u000f\u0002\u000fM$xN]1hK&!1QQB<\u00055aunZ!qa\u0016tG-\u00138g_\"91qI\tA\u0002\u0005u\u0005bBBF#\u0001\u00071QJ\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u0004\u0010F\u0001\ra!%\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\u0019\u0019j!&\u000e\u0003\u0001I1aa&z\u0005%1U\r^2i\t\u0006$\u0018-\u0001\tsK6|g/\u001a)beRLG/[8ogR!1QTBU!!\u0011yda(\u0002\u001e\u000e\r\u0016\u0002BBQ\u0005\u0003\u00121!T1q!\rA8QU\u0005\u0004\u0007O\u000b(a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0007bBBV%\u0001\u00071QV\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB1!qHBX\u0003;KAa!-\u0003B\t\u00191+\u001a;\u0015\t\rU6q\u0017\t\u0004\u0003O[\u0004bBB$'\u0001\u0007\u0011QT\u0001\u0018kB$\u0017\r^3SK\u0006\u001c8/[4o[\u0016tGo\u0015;bi\u0016$b!!<\u0004>\u000e}\u0006bBB$)\u0001\u0007\u0011Q\u0014\u0005\b\u0007\u0003$\u0002\u0019AB[\u0003\u0015\u0019H/\u0019;f\u0003ei\u0017-\u001f2f!J|Wn\u001c;f\rV$XO]3SKBd\u0017nY1\u0015\r\t=2qYBe\u0011\u001d\u00199%\u0006a\u0001\u0003;Cqaa3\u0016\u0001\u0004\u0019i-A\u0005qCJ$\u0018\u000e^5p]B!1qZBk\u001b\t\u0019\tNC\u0002\u0004TN\fqa\u00197vgR,'/\u0003\u0003\u0004X\u000eE'!\u0003)beRLG/[8o\u00035\tG\r\u001a)beRLG/[8ogR!1QVBo\u0011\u001d\u0019yN\u0006a\u0001\u0007C\f!#\u001b8ji&\fGNR3uG\"\u001cF/\u0019;fgBA!qHBP\u0003;\u001b\u0019\u000fE\u0002y\u0007KL1aa:r\u0005EIe.\u001b;jC24U\r^2i'R\fG/Z\u0001 SN|eMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQN+\b\u000f]8si\u0016$\u0017\u0001I5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fI\u0002\n\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0007\u0003o\u001c\tpa=\t\u000f\r\u001d\u0013\u00041\u0001\u0002\u001e\"91Q_\rA\u0002\r]\u0018a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u0007a\u001cI0C\u0002\u0004|F\u0014Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR1\u0011Q\u001eC\u0001\t\u0007Aqaa\u0012\u001b\u0001\u0004\ti\nC\u0004\u0005\u0006i\u0001\ra!\u0014\u0002\r=4gm]3u\u0001")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final DirectoryEventHandler directoryEventHandler;
    private final ConcurrentHashMap<TopicPartition, PromotionState> promotionStates;
    private final boolean isOffsetForLeaderEpochSupported;

    public static DirectoryEventHandler $lessinit$greater$default$9() {
        return DirectoryEventHandler.NOOP;
    }

    public ConcurrentHashMap<TopicPartition, PromotionState> promotionStates() {
        return this.promotionStates;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        DirectoryEventHandler directoryEventHandler = this.directoryEventHandler;
        DirectoryEventHandler directoryEventHandler2 = DirectoryEventHandler.NOOP;
        if (!(directoryEventHandler2 != null ? !directoryEventHandler2.equals(directoryEventHandler) : directoryEventHandler != null)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
        } else {
            this.maybePromoteFutureReplica(topicPartition, partition);
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
            if (this.promotionStates().containsKey(topicPartition)) {
                void var3_3;
                void var4_4;
                void var5_5;
                PromotionState promotionState = this.promotionStates().get(topicPartition);
                if (promotionState == null) {
                    throw new MatchError(null);
                }
                ReassignmentState reassignmentState = promotionState.reassignmentState();
                Option<Uuid> topicId = promotionState.topicId();
                Option<Uuid> originalDir = promotionState.currentDir();
                if (var5_5.isDefined() && var4_4.isDefined() && var3_3.maybeInconsistentMetadata()) {
                    $this.directoryEventHandler.handleAssignment(new TopicIdPartition((Uuid)var4_4.get(), topicPartition.partition()), (Uuid)var5_5.get(), "Reverting reassignment for canceled future replica", () -> {});
                }
                return this.promotionStates().remove(topicPartition);
            }
            return BoxedUnit.UNIT;
        });
        return super.removePartitions(topicPartitions);
    }

    private ReassignmentState reassignmentState(TopicPartition topicPartition) {
        return this.promotionStates().get(topicPartition).reassignmentState();
    }

    public void updateReassignmentState(TopicPartition topicPartition, ReassignmentState state) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Updating future replica ").append(topicPartition).append(" reassignment state to ").append(state).toString());
        this.promotionStates().put(topicPartition, this.promotionStates().get(topicPartition).withAssignment(state));
    }

    private Object maybePromoteFutureReplica(TopicPartition topicPartition, Partition partition) {
        Option<Uuid> topicId = partition.topicId();
        if (topicId.isEmpty()) {
            throw new IllegalStateException(new StringBuilder(27).append("Topic ").append(topicPartition.topic()).append(" does not have an ID.").toString());
        }
        ReassignmentState reassignmentState = this.reassignmentState(topicPartition);
        if (ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$.equals(reassignmentState)) {
            return BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1<AbstractLog, BoxedUnit>)(Function1 & Serializable)x$2 -> {
                ReplicaAlterLogDirsThread.$anonfun$maybePromoteFutureReplica$1(this, partition, topicId, topicPartition, x$2);
                return BoxedUnit.UNIT;
            }));
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$.equals(reassignmentState)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.updateReassignmentState(topicPartition, ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$);
                return this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$.equals(reassignmentState)) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Waiting for AssignReplicasToDirsRequest to succeed before promoting the future replica.");
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$.equals(reassignmentState)) {
            throw new IllegalStateException("BUG: trying to promote a future replica twice");
        }
        throw new MatchError((Object)reassignmentState);
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            filteredFetchStates.foreach((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$2._1();
                    Option<Uuid> topicId = ((InitialFetchState)x0$2._2()).topicId();
                    Option<Uuid> currentDirectoryId = $this.replicaMgr.getPartitionOrException(topicPartition).logDirectoryId();
                    PromotionState promotionState = new PromotionState(ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$, topicId, currentDirectoryId);
                    return this.promotionStates().put(topicPartition, promotionState);
                }
                throw new MatchError(null);
            });
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, true, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$maybePromoteFutureReplica$1(ReplicaAlterLogDirsThread $this, Partition partition$1, Option topicId$1, TopicPartition topicPartition$2, AbstractLog x$2) {
        Uuid targetDir = (Uuid)partition$1.futureReplicaDirectoryId().get();
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)topicId$1.get(), topicPartition$2.partition());
        $this.directoryEventHandler.handleAssignment(topicIdPartition, targetDir, "Future replica promotion", () -> $this.updateReassignmentState(topicPartition$2, ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$));
        $this.updateReassignmentState(topicPartition$2, ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(null);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats, DirectoryEventHandler directoryEventHandler) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.directoryEventHandler = directoryEventHandler;
        TierStateMachine x$4 = new TierStateMachine(leader, replicaMgr, false);
        Map x$10 = (Map)Map$.MODULE$.empty();
        super(name, name, leader, failedPartitions, pausedPartitions, exponentialBackoff, x$4, false, brokerTopicStats, (Map<String, String>)x$10);
        this.promotionStates = new ConcurrentHashMap();
        this.isOffsetForLeaderEpochSupported = true;
    }

    public static class PromotionState
    implements Product,
    Serializable {
        private final ReassignmentState reassignmentState;
        private final Option<Uuid> topicId;
        private final Option<Uuid> currentDir;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ReassignmentState reassignmentState() {
            return this.reassignmentState;
        }

        public Option<Uuid> topicId() {
            return this.topicId;
        }

        public Option<Uuid> currentDir() {
            return this.currentDir;
        }

        public PromotionState withAssignment(ReassignmentState newDirReassignmentState) {
            return new PromotionState(newDirReassignmentState, this.topicId(), this.currentDir());
        }

        public PromotionState copy(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            return new PromotionState(reassignmentState, topicId, currentDir);
        }

        public ReassignmentState copy$default$1() {
            return this.reassignmentState();
        }

        public Option<Uuid> copy$default$2() {
            return this.topicId();
        }

        public Option<Uuid> copy$default$3() {
            return this.currentDir();
        }

        public String productPrefix() {
            return "PromotionState";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.reassignmentState();
                }
                case 1: {
                    return this.topicId();
                }
                case 2: {
                    return this.currentDir();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PromotionState;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "reassignmentState";
                }
                case 1: {
                    return "topicId";
                }
                case 2: {
                    return "currentDir";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof PromotionState)) break block3;
                    PromotionState promotionState = (PromotionState)x$1;
                    ReassignmentState reassignmentState = this.reassignmentState();
                    ReassignmentState reassignmentState2 = promotionState.reassignmentState();
                    if (reassignmentState != null ? !reassignmentState.equals(reassignmentState2) : reassignmentState2 != null) break block3;
                    Option<Uuid> option = this.topicId();
                    Option<Uuid> option2 = promotionState.topicId();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<Uuid> option3 = this.currentDir();
                    Option<Uuid> option4 = promotionState.currentDir();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !promotionState.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public PromotionState(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            this.reassignmentState = reassignmentState;
            this.topicId = topicId;
            this.currentDir = currentDir;
            Product.$init$((Product)this);
        }
    }

    public static interface ReassignmentState {
        public static /* synthetic */ boolean maybeInconsistentMetadata$(ReassignmentState $this) {
            return $this.maybeInconsistentMetadata();
        }

        default public boolean maybeInconsistentMetadata() {
            return false;
        }

        public static void $init$(ReassignmentState $this) {
        }
    }
}

