/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.CoreV1Api;
import io.confluent.flink.apiserver.client.SqlV1Api;
import io.confluent.flink.apiserver.client.model.SqlV1DatabaseSpec;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.server.DataFlowPolicy;
import kafka.server.RegionalLkcMetadata;
import kafka.server.RegionalMetadataClient;
import kafka.server.RegionalNetworkMetadata;
import kafka.server.RmRegionalMetadataClient$;
import kafka.server.RmRegionalMetadataWatcher;
import kafka.server.RmRegionalMetadataWatcher$;
import kafka.server.Subscription;
import kafka.server.Watch;
import kafka.utils.Logging;
import okhttp3.OkHttpClient;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.ThreadUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t=t!\u0002\u0012$\u0011\u0003Ac!\u0002\u0016$\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004b\u0002\u001b\u0002\u0005\u0004%I!\u000e\u0005\u0007s\u0005\u0001\u000b\u0011\u0002\u001c\t\u0011i\n!\u0019!C\u0001GmBaAT\u0001!\u0002\u0013a\u0004\"B(\u0002\t\u0013\u0001f\u0001\u0002\u0016$\u0005\u0005DQA\r\u0005\u0005\u0002MDq!\u001e\u0005C\u0002\u0013%a\u000f\u0003\u0004{\u0011\u0001\u0006Ia\u001e\u0005\tw\"\u0011\r\u0011\"\u0001$y\"9\u0011\u0011\u0001\u0005!\u0002\u0013i\bBCA\u0002\u0011\t\u0007I\u0011A\u0012\u0002\u0006!A\u0011Q\u0002\u0005!\u0002\u0013\t9\u0001C\u0006\u0002\u0010!\u0001\r\u00111A\u0005\n\u0005E\u0001bCA\u0012\u0011\u0001\u0007\t\u0019!C\u0005\u0003KA1\"!\r\t\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0014!Q\u00111\u0007\u0005A\u0002\u0013\u00051%!\u000e\t\u0015\u0005=\u0003\u00021A\u0005\u0002\r\n\t\u0006\u0003\u0005\u0002V!\u0001\u000b\u0015BA\u001c\u0011-\t9\u0006\u0003a\u0001\u0002\u0004%I!!\u0017\t\u0017\u0005\u0005\u0004\u00021AA\u0002\u0013%\u00111\r\u0005\f\u0003OB\u0001\u0019!A!B\u0013\tY\u0006C\u0004\u0002j!!\t%a\u001b\t\u000f\u0005m\u0005\u0002\"\u0011\u0002\u001e\"9\u0011Q\u0017\u0005\u0005B\u0005]\u0006bBAd\u0011\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003\u0017DA\u0011IAg\u0011\u001d\t\u0019\u0010\u0003C\u0005\u0003kD\u0001\"a=\t\t\u0003\u0019#Q\u0003\u0005\b\u0003gDA\u0011\u0002B\u0019\u0011\u001d\u0011i\u0005\u0003C!\u0005\u001f\n\u0001DU7SK\u001eLwN\\1m\u001b\u0016$\u0018\rZ1uC\u000ec\u0017.\u001a8u\u0015\t!S%\u0001\u0004tKJ4XM\u001d\u0006\u0002M\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0015\u0002\u001b\u0005\u0019#\u0001\u0007*n%\u0016<\u0017n\u001c8bY6+G/\u00193bi\u0006\u001cE.[3oiN\u0011\u0011\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0013AC7bqJ+GO]5fgV\ta\u0007\u0005\u0002.o%\u0011\u0001H\f\u0002\u0004\u0013:$\u0018aC7bqJ+GO]5fg\u0002\naC]3uef|enQ8o]\u0016\u001cG/[8o\u000bJ\u0014xN]\u000b\u0002yA!Q&P L\u0013\tqdFA\u0005Gk:\u001cG/[8ocA\u0011\u0001\t\u0013\b\u0003\u0003\u001as!AQ#\u000e\u0003\rS!\u0001R\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0013BA$/\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\u0013QC'o\\<bE2,'BA$/!\tiC*\u0003\u0002N]\t9!i\\8mK\u0006t\u0017a\u0006:fiJLxJ\\\"p]:,7\r^5p]\u0016\u0013(o\u001c:!\u0003UI7oQ8o]\u0016\u001cG/[8o\u000bb\u001cW\r\u001d;j_:$\"aS)\t\u000bI;\u0001\u0019A*\u0002\u0003\u0015\u0004\"\u0001V0\u000e\u0003US!AV,\u0002\r\rd\u0017.\u001a8u\u0015\tA\u0016,A\u0005ba&\u001cXM\u001d<fe*\u0011!lW\u0001\u0006M2Lgn\u001b\u0006\u00039v\u000b\u0011bY8oM2,XM\u001c;\u000b\u0003y\u000b!![8\n\u0005\u0001,&\u0001D!qS\u0016C8-\u001a9uS>t7\u0003\u0002\u0005cU6\u0004\"a\u00195\u000e\u0003\u0011T!!\u001a4\u0002\t1\fgn\u001a\u0006\u0002O\u0006!!.\u0019<b\u0013\tIGM\u0001\u0004PE*,7\r\u001e\t\u0003S-L!\u0001\\\u0012\u0003-I+w-[8oC2lU\r^1eCR\f7\t\\5f]R\u0004\"A\\9\u000e\u0003=T!\u0001]\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005I|'a\u0002'pO\u001eLgn\u001a\u000b\u0002iB\u0011\u0011\u0006C\u0001\nCBL7\t\\5f]R,\u0012a\u001e\t\u0003)bL!!_+\u0003\u0013\u0005\u0003\u0018n\u00117jK:$\u0018AC1qS\u000ec\u0017.\u001a8uA\u00051An[2Ba&,\u0012! \t\u0003)zL!a`+\u0003\u0011M\u000bHNV\u0019Ba&\fq\u0001\\6d\u0003BL\u0007%A\u0004d_J,\u0017\t]5\u0016\u0005\u0005\u001d\u0001c\u0001+\u0002\n%\u0019\u00111B+\u0003\u0013\r{'/\u001a,2\u0003BL\u0017\u0001C2pe\u0016\f\u0005/\u001b\u0011\u0002\u001f\u0015DXmY;u_J\u001cVM\u001d<jG\u0016,\"!a\u0005\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005ua-\u0001\u0003vi&d\u0017\u0002BA\u0011\u0003/\u0011\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003M)\u00070Z2vi>\u00148+\u001a:wS\u000e,w\fJ3r)\u0011\t9#!\f\u0011\u00075\nI#C\u0002\u0002,9\u0012A!\u00168ji\"I\u0011qF\t\u0002\u0002\u0003\u0007\u00111C\u0001\u0004q\u0012\n\u0014\u0001E3yK\u000e,Ho\u001c:TKJ4\u0018nY3!\u0003I)\u0007\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0017j!!a\u000f\u000b\u0007A\fiD\u0003\u0003\u0002@\u0005\u0005\u0013AB2p[6|gNC\u0002'\u0003\u0007RA!!\u0012\u0002H\u00051\u0011\r]1dQ\u0016T!!!\u0013\u0002\u0007=\u0014x-\u0003\u0003\u0002N\u0005m\"AE#ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a\fa#\u001a=q_:,g\u000e^5bY\n\u000b7m[8gM~#S-\u001d\u000b\u0005\u0003O\t\u0019\u0006C\u0005\u00020Q\t\t\u00111\u0001\u00028\u0005\u0019R\r\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4gA\u00059q/\u0019;dQ\u0016\u0014XCAA.!\rI\u0013QL\u0005\u0004\u0003?\u001a#!\u0007*n%\u0016<\u0017n\u001c8bY6+G/\u00193bi\u0006<\u0016\r^2iKJ\f1b^1uG\",'o\u0018\u0013fcR!\u0011qEA3\u0011%\tycFA\u0001\u0002\u0004\tY&\u0001\u0005xCR\u001c\u0007.\u001a:!\u000399W\r\u001e'lG6+G/\u00193bi\u0006$\u0002\"!\u001c\u0002\u0000\u0005M\u0015q\u0013\t\u0007\u0003+\ty'a\u001d\n\t\u0005E\u0014q\u0003\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007#B\u0017\u0002v\u0005e\u0014bAA<]\t1q\n\u001d;j_:\u00042!KA>\u0013\r\tih\t\u0002\u0014%\u0016<\u0017n\u001c8bY2[7-T3uC\u0012\fG/\u0019\u0005\b\u0003\u0003K\u0002\u0019AAB\u0003\u0015y'oZ%e!\u0011\t))!$\u000f\t\u0005\u001d\u0015\u0011\u0012\t\u0003\u0005:J1!a#/\u0003\u0019\u0001&/\u001a3fM&!\u0011qRAI\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0012\u0018\t\u000f\u0005U\u0015\u00041\u0001\u0002\u0004\u0006)QM\u001c<JI\"9\u0011\u0011T\rA\u0002\u0005\r\u0015!C2mkN$XM]%e\u0003I9W\r\u001e(fi^|'o['fi\u0006$\u0017\r^1\u0015\u0011\u0005}\u0015\u0011VAW\u0003c\u0003b!!\u0006\u0002p\u0005\u0005\u0006#B\u0017\u0002v\u0005\r\u0006cA\u0015\u0002&&\u0019\u0011qU\u0012\u0003/I+w-[8oC2tU\r^<pe.lU\r^1eCR\f\u0007bBAV5\u0001\u0007\u00111Q\u0001\u000f_J<\u0017M\\5{CRLwN\\%e\u0011\u001d\tyK\u0007a\u0001\u0003\u0007\u000bQ\"\u001a8wSJ|g.\\3oi&#\u0007bBAZ5\u0001\u0007\u00111Q\u0001\n]\u0016$xo\u001c:l\u0013\u0012\f\u0011cZ3u\t\u0006$\u0018M\u00127poB{G.[2z)\u0019\tI,a1\u0002FB1\u0011QCA8\u0003w\u0003R!LA;\u0003{\u00032!KA`\u0013\r\t\tm\t\u0002\u000f\t\u0006$\u0018M\u00127poB{G.[2z\u0011\u001d\tYk\u0007a\u0001\u0003\u0007Cq!a,\u001c\u0001\u0004\t\u0019)A\u0003dY>\u001cX\r\u0006\u0002\u0002(\u0005I1m\u001c8gS\u001e,(/\u001a\u000b\u0005\u0003O\ty\rC\u0004\u0002Rv\u0001\r!a5\u0002\u000f\r|gNZ5hgB\"\u0011Q[Aq!!\t9.!7\u0002\u0004\u0006uWBAA\u000e\u0013\u0011\tY.a\u0007\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002`\u0006\u0005H\u0002\u0001\u0003\r\u0003G\fy-!A\u0001\u0002\u000b\u0005\u0011Q\u001d\u0002\u0004?\u0012\n\u0014\u0003BAt\u0003[\u00042!LAu\u0013\r\tYO\f\u0002\b\u001d>$\b.\u001b8h!\ri\u0013q^\u0005\u0004\u0003ct#aA!os\u0006\u0001R\r_3dkR,w+\u001b;i%\u0016$(/_\u000b\u0005\u0003o\fi\u0010\u0006\u0004\u0002z\n\u0005!\u0011\u0003\t\u0007\u0003+\ty'a?\u0011\t\u0005}\u0017Q \u0003\b\u0003\u007ft\"\u0019AAs\u0005\u0005!\u0006b\u0002B\u0002=\u0001\u0007!QA\u0001\tgV\u0004\b\u000f\\5feB1!q\u0001B\u0007\u0003wl!A!\u0003\u000b\t\t-\u00111D\u0001\tMVt7\r^5p]&!!q\u0002B\u0005\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\bB\u0002B\n=\u0001\u0007A(A\u0006tQ>,H\u000e\u001a*fiJLX\u0003\u0002B\f\u0005;!\"B!\u0007\u0003 \t\r\"Q\u0005B\u0014!\u0019\t)\"a\u001c\u0003\u001cA!\u0011q\u001cB\u000f\t\u001d\typ\bb\u0001\u0003KDqAa\u0001 \u0001\u0004\u0011\t\u0003\u0005\u0004\u0003\b\t5!1\u0004\u0005\u0007\u0005'y\u0002\u0019\u0001\u001f\t\u000bQz\u0002\u0019\u0001\u001c\t\u000f\t%r\u00041\u0001\u0003,\u0005!QO\\5u!\u0011\t)B!\f\n\t\t=\u0012q\u0003\u0002\t)&lW-\u00168jiV!!1\u0007B\u001e)9\t9C!\u000e\u0003>\t\r#Q\tB$\u0005\u0013BqAa\u0001!\u0001\u0004\u00119\u0004\u0005\u0004\u0003\b\t5!\u0011\b\t\u0005\u0003?\u0014Y\u0004B\u0004\u0002\u0000\u0002\u0012\r!!:\t\u000f\t}\u0002\u00051\u0001\u0003B\u00051a-\u001e;ve\u0016\u0004b!!\u0006\u0002p\te\u0002B\u0002B\nA\u0001\u0007A\bC\u00035A\u0001\u0007a\u0007C\u0004\u0003*\u0001\u0002\rAa\u000b\t\r\t-\u0003\u00051\u00017\u0003\u001d\tG\u000f^3naR\fQa^1uG\",BA!\u0015\u0003fQ1!1\u000bB-\u0005O\u00022a\u0019B+\u0013\r\u00119\u0006\u001a\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\t\u000f\tm\u0013\u00051\u0001\u0003^\u0005a1/\u001e2tGJL\u0007\u000f^5p]B)\u0011Fa\u0018\u0003d%\u0019!\u0011M\u0012\u0003\u0019M+(m]2sSB$\u0018n\u001c8\u0011\t\u0005}'Q\r\u0003\b\u0003\u007f\f#\u0019AAs\u0011\u001d\u0011i%\ta\u0001\u0005S\u0002R!\u000bB6\u0005GJ1A!\u001c$\u0005\u00159\u0016\r^2i\u0001")
public final class RmRegionalMetadataClient
implements RegionalMetadataClient,
Logging {
    private final ApiClient apiClient = new ApiClient();
    private final SqlV1Api lkcApi = new SqlV1Api(this.apiClient());
    private final CoreV1Api coreApi = new CoreV1Api(this.apiClient());
    private ScheduledExecutorService executorService;
    private ExponentialBackoff exponentialBackoff = new ExponentialBackoff(250L, 2, 5000L, 0.2);
    private RmRegionalMetadataWatcher watcher;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ApiClient apiClient() {
        return this.apiClient;
    }

    public SqlV1Api lkcApi() {
        return this.lkcApi;
    }

    public CoreV1Api coreApi() {
        return this.coreApi;
    }

    private ScheduledExecutorService executorService() {
        return this.executorService;
    }

    private void executorService_$eq(ScheduledExecutorService x$1) {
        this.executorService = x$1;
    }

    public ExponentialBackoff exponentialBackoff() {
        return this.exponentialBackoff;
    }

    public void exponentialBackoff_$eq(ExponentialBackoff x$1) {
        this.exponentialBackoff = x$1;
    }

    private RmRegionalMetadataWatcher watcher() {
        return this.watcher;
    }

    private void watcher_$eq(RmRegionalMetadataWatcher x$1) {
        this.watcher = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<Option<RegionalLkcMetadata>> getLkcMetadata(String orgId, String envId, String clusterId) {
        void executeWithRetry_executeWithRetry_unit;
        Supplier<Option> metadataSupplier = () -> {
            None$ none$;
            try {
                if (orgId != null && envId != null && clusterId != null) {
                    SqlV1DatabaseSpec lkcSpec = this.lkcApi().readSqlV1Database(envId, clusterId, orgId, null).getSpec();
                    return new Some((Object)new RegionalLkcMetadata(null, orgId, envId, lkcSpec){
                        private final String orgId$1;
                        private final String envId$1;
                        private final SqlV1DatabaseSpec lkcSpec$1;

                        public String organizationId() {
                            return this.orgId$1;
                        }

                        public String environmentId() {
                            return this.envId$1;
                        }

                        public String networkId() {
                            return this.lkcSpec$1.getNetworkId();
                        }

                        public String intranetFqdn() {
                            return this.lkcSpec$1.getInternalClusterUrl();
                        }

                        public boolean isActive() {
                            return true;
                        }

                        public boolean isMultiTenant() {
                            return true;
                        }
                        {
                            this.orgId$1 = orgId$1;
                            this.envId$1 = envId$1;
                            this.lkcSpec$1 = lkcSpec$1;
                        }
                    });
                }
                none$ = None$.MODULE$;
            }
            catch (ApiException e) {
                switch (e.getCode()) {
                    case 404: {
                        return None$.MODULE$;
                    }
                }
                throw e;
            }
            return none$;
        };
        Function1<Throwable, Object> executeWithRetry_shouldRetry = RmRegionalMetadataClient$.MODULE$.retryOnConnectionError();
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        int executeWithRetry_executeWithRetry_maxRetries = RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$maxRetries();
        CompletableFuture<Option<RegionalLkcMetadata>> executeWithRetry_executeWithRetry_future = new CompletableFuture<Option<RegionalLkcMetadata>>();
        Runnable executeWithRetry_executeWithRetry_runnable = () -> RmRegionalMetadataClient.$anonfun$executeWithRetry$1(this, metadataSupplier, executeWithRetry_executeWithRetry_future, executeWithRetry_shouldRetry, executeWithRetry_executeWithRetry_maxRetries, (TimeUnit)executeWithRetry_executeWithRetry_unit);
        this.executorService().schedule(executeWithRetry_executeWithRetry_runnable, 0L, (TimeUnit)executeWithRetry_executeWithRetry_unit);
        return executeWithRetry_executeWithRetry_future;
    }

    @Override
    public CompletableFuture<Option<RegionalNetworkMetadata>> getNetworkMetadata(String organizationId, String environmentId, String networkId) {
        return CompletableFuture.completedFuture(None$.MODULE$);
    }

    @Override
    public CompletableFuture<Option<DataFlowPolicy>> getDataFlowPolicy(String organizationId, String environmentId) {
        return CompletableFuture.completedFuture(None$.MODULE$);
    }

    @Override
    public void close() {
        OkHttpClient okClient;
        if (this.executorService() != null) {
            this.executorService().shutdownNow();
            this.executorService_$eq(null);
        }
        if ((okClient = this.apiClient().getHttpClient()) != null) {
            okClient.dispatcher().executorService().shutdownNow();
            okClient.connectionPool().evictAll();
        }
        if (this.watcher() != null) {
            this.watcher().close();
            this.watcher_$eq(null);
            return;
        }
    }

    public void configure(Map<String, ?> configs) {
        if (configs.get("confluent.regional.resource.manager.endpoint") == null) {
            throw new ConfigException("confluent.regional.resource.manager.endpoint", null, "Endpoint URL is not configured");
        }
        if (configs.get("confluent.regional.resource.manager.watch.endpoint") == null) {
            throw new ConfigException("confluent.regional.resource.manager.watch.endpoint", null, "Watch endpoint URL is not configured");
        }
        String endpointUrl = (String)configs.get("confluent.regional.resource.manager.endpoint");
        this.apiClient().setBasePath(endpointUrl);
        String watchEndpointUrl = (String)configs.get("confluent.regional.resource.manager.watch.endpoint");
        this.watcher_$eq(RmRegionalMetadataWatcher$.MODULE$.apply(watchEndpointUrl));
        int numSchedulerThreads = BoxesRunTime.unboxToInt(configs.get("confluent.regional.resource.manager.client.scheduler.threads"));
        this.executorService_$eq(Executors.newScheduledThreadPool(numSchedulerThreads, ThreadUtils.createThreadFactory((String)"rm-regional-metadata-client-thread-%d", (boolean)false)));
    }

    /*
     * WARNING - void declaration
     */
    private <T> CompletableFuture<T> executeWithRetry(Supplier<T> supplier, Function1<Throwable, Object> shouldRetry) {
        void executeWithRetry_unit;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        int executeWithRetry_maxRetries = RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$maxRetries();
        CompletableFuture executeWithRetry_future = new CompletableFuture();
        Runnable executeWithRetry_runnable = () -> RmRegionalMetadataClient.$anonfun$executeWithRetry$1(this, supplier, executeWithRetry_future, shouldRetry, executeWithRetry_maxRetries, (TimeUnit)executeWithRetry_unit);
        this.executorService().schedule(executeWithRetry_runnable, 0L, (TimeUnit)executeWithRetry_unit);
        return executeWithRetry_future;
    }

    public <T> CompletableFuture<T> executeWithRetry(Supplier<T> supplier, Function1<Throwable, Object> shouldRetry, int maxRetries, TimeUnit unit) {
        CompletableFuture future = new CompletableFuture();
        Runnable runnable = () -> this.executeWithRetry(supplier, future, shouldRetry, maxRetries, unit, 1);
        this.executorService().schedule(runnable, 0L, unit);
        return future;
    }

    private <T> void executeWithRetry(Supplier<T> supplier, CompletableFuture<T> future, Function1<Throwable, Object> shouldRetry, int maxRetries, TimeUnit unit, int attempt) {
        try {
            T result = supplier.get();
            future.complete(result);
            return;
        }
        catch (Throwable e) {
            if (BoxesRunTime.unboxToBoolean((Object)shouldRetry.apply((Object)e)) && attempt < maxRetries) {
                long backoffDelay = this.exponentialBackoff().backoff((long)attempt);
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = RmRegionalMetadataClient.$anonfun$executeWithRetry$2(attempt, backoffDelay);
                    Object var12_10 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), e);
                }
                Runnable runnable = () -> this.executeWithRetry(supplier, future, shouldRetry, maxRetries, unit, attempt + 1);
                this.executorService().schedule(runnable, backoffDelay, unit);
                return;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                String msgWithLogIdent_msg = "Failed to execute task";
                Object var13_12 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), e);
            }
            future.completeExceptionally(e);
            return;
        }
    }

    @Override
    public <T> AutoCloseable watch(Subscription<T> subscription, Watch<T> watch) {
        return this.watcher().watch(subscription, watch);
    }

    public static final /* synthetic */ String $anonfun$executeWithRetry$2(int attempt$1, long backoffDelay$1) {
        return new StringBuilder(48).append("Failed to execute task, retrying attempt:").append(attempt$1).append(" in ").append(backoffDelay$1).append(" ms").toString();
    }

    public static final /* synthetic */ Throwable $anonfun$executeWithRetry$3(Throwable e$1) {
        return e$1;
    }

    public static final /* synthetic */ String $anonfun$executeWithRetry$5() {
        return "Failed to execute task";
    }

    public static final /* synthetic */ Throwable $anonfun$executeWithRetry$6(Throwable e$1) {
        return e$1;
    }
}

